/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.properties;

import ca.infodata.ofys.data.middle.dataobjects.properties.IReportProperty;

public abstract class AbstractProperty<T>
implements IReportProperty<T> {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String displayName;
    private final boolean displayable;
    private T value;

    public AbstractProperty(String name) {
        this(name, null);
    }

    public AbstractProperty(String name, T value) {
        this(name, name, value, true);
    }

    public AbstractProperty(String name, String displayName, T value) {
        if (name == null) {
            throw new IllegalArgumentException("property name cant be null");
        }
        this.name = name;
        this.displayName = displayName;
        this.value = value;
        this.displayable = true;
    }

    public AbstractProperty(String name, String displayName, T value, boolean displayable) {
        if (name == null) {
            throw new IllegalArgumentException("property name cant be null");
        }
        this.name = name;
        this.displayName = displayName;
        this.value = value;
        this.displayable = displayable;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String displayName() {
        return this.displayName;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }

    @Override
    public T value() {
        return this.value;
    }

    @Override
    public boolean isDisplayable() {
        return this.displayable;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractProperty)) {
            return false;
        }
        AbstractProperty other = (AbstractProperty)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return this.name() + "=" + this.value();
    }

    @Override
    public AbstractProperty<T> clone() {
        try {
            return (AbstractProperty)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

