/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart;

import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XMeasurement;
import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.BMI_219;
import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.HC_WFL024;
import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.HFA_WFA219;
import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.LFA_WFA024;
import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.Language;
import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.Sex;
import ca.infodata.ofys.data.middle.dataobjects.pdf.PdfUtil;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MeasurementGraph {
    private static final Logger logger = Logger.getLogger(MeasurementGraph.class.getName());

    public static byte[] getGrowChart219Pdf(XPerson.Gender gender, XPatient pat, List<XMeasurement> measurementsForGraph, boolean blackAndWhite) {
        try {
            LocalDate birthdate = MeasurementGraph.getBirthdate(pat);
            if (gender != null && birthdate != null) {
                byte[] hfa_wfa219 = MeasurementGraph.renderHFA_WFA219(gender, pat, measurementsForGraph, blackAndWhite);
                byte[] bmi_219 = MeasurementGraph.renderBMI_219(gender, pat, measurementsForGraph, blackAndWhite);
                byte[] pdf = PdfUtil.joinPdfs(hfa_wfa219, bmi_219);
                return pdf;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to show growChart219", e);
        }
        return null;
    }

    public static byte[] getGrowChart219_024Pdf(XPerson.Gender gender, XPatient pat, int ageMois, List<XMeasurement> measurementsForGraph, boolean blackAndWhite) {
        try {
            LocalDate birthdate = MeasurementGraph.getBirthdate(pat);
            if (gender != null && birthdate != null) {
                byte[] pdf;
                byte[] hfa_wfa219 = MeasurementGraph.renderHFA_WFA219(gender, pat, measurementsForGraph, blackAndWhite);
                byte[] bmi_219 = MeasurementGraph.renderBMI_219(gender, pat, measurementsForGraph, blackAndWhite);
                byte[] lfa_WFA024Rendered = MeasurementGraph.renderLFA_WFA024(gender, pat, measurementsForGraph, blackAndWhite);
                byte[] hc_WFL024Rendered = MeasurementGraph.renderHC_WFL024(gender, pat, measurementsForGraph, blackAndWhite);
                if (ageMois < 60) {
                    byte[] fenton = MeasurementGraph.renderFenton_060(gender, pat, measurementsForGraph);
                    pdf = PdfUtil.joinPdfs(lfa_WFA024Rendered, hc_WFL024Rendered, fenton, hfa_wfa219, bmi_219);
                } else {
                    pdf = PdfUtil.joinPdfs(hfa_wfa219, bmi_219, lfa_WFA024Rendered, hc_WFL024Rendered);
                }
                return pdf;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to show growChart219", e);
        }
        return null;
    }

    private static LocalDate getBirthdate(XPatient pat) throws IllegalArgumentException {
        LocalDate birthDate = pat.getBirthDate();
        if (birthDate == null) {
            throw new IllegalArgumentException("Date de naissance inconnue. Il vous faut renseigner la Date de naissance du patient et R\u00e9ouvrir l'\u00e9diteur des rencontres.");
        }
        return birthDate;
    }

    private static byte[] renderHFA_WFA219(XPerson.Gender gender, XPatient patient, List<XMeasurement> list, boolean blackAndWhite) throws Exception {
        String recordNumber = StringUtils.defaultString((String)patient.getPatientRecordNumber());
        String name = patient.getName();
        TreeMap<LocalDate, HFA_WFA219.DATA> datas = new TreeMap<LocalDate, HFA_WFA219.DATA>();
        for (XMeasurement e : list) {
            HFA_WFA219.DATA data;
            int ageInMonths;
            LocalDate date = LocalDate.fromTimeInMillisLOCAL((Long)e.getTimeVitalSign());
            if (date == null || Boolean.TRUE.equals(e.getIsDeleted()) || (ageInMonths = date.getMonthDiff(patient.getBirthDate())) < 24 || ageInMonths > 228) continue;
            if (datas.containsKey(date)) {
                data = (HFA_WFA219.DATA)datas.get(date);
                if (e.getWeight() != null && data.weight == null) {
                    data.weight = Float.valueOf(e.getWeight().floatValue() * 1000.0f);
                }
                if (e.getHeight() != null && data.height == null) {
                    data.height = e.getHeight();
                }
                JoinList joinList = new JoinList(" ");
                joinList.setAllowBlank(false);
                joinList.setNoDuplicate(true);
                joinList.add((CharSequence)data.comments).add((CharSequence)e.getNote());
                data.comments = joinList.toString();
                continue;
            }
            data = new HFA_WFA219.DATA(date, e.getHeight(), e.getWeight() == null ? null : Float.valueOf(e.getWeight().floatValue() * 1000.0f), e.getNote());
            datas.put(date, data);
        }
        if (!datas.isEmpty()) {
            HFA_WFA219 hfa_WFA219 = new HFA_WFA219();
            hfa_WFA219.setBlackAndWhite(blackAndWhite);
            hfa_WFA219.setLanguage(Language.FR);
            hfa_WFA219.setSex(gender == XPerson.Gender.FEMININ ? Sex.GIRLS : Sex.BOYS);
            hfa_WFA219.setBirthdate(LocalDate.fromDayFrom1970((int)patient.getBirthDate().dayFrom1970));
            hfa_WFA219.setRecordnumber(recordNumber);
            hfa_WFA219.setFullname(name);
            hfa_WFA219.setDatas(new ArrayList<HFA_WFA219.DATA>(datas.values()));
            return hfa_WFA219.render();
        }
        return null;
    }

    private static byte[] renderBMI_219(XPerson.Gender gender, XPatient patient, List<XMeasurement> list, boolean blackAndWhite) throws Exception {
        String recordNumber = StringUtils.defaultString((String)patient.getPatientRecordNumber());
        String name = patient.getName();
        TreeMap<LocalDate, BMI_219.Data> datas = new TreeMap<LocalDate, BMI_219.Data>();
        for (XMeasurement e : list) {
            BMI_219.Data data;
            int ageInMonths;
            LocalDate date = LocalDate.fromTimeInMillisLOCAL((Long)e.getTimeVitalSign());
            if (date == null || Boolean.TRUE.equals(e.getIsDeleted()) || (ageInMonths = date.getMonthDiff(patient.getBirthDate())) < 24 || ageInMonths > 228) continue;
            if (datas.containsKey(date)) {
                data = (BMI_219.Data)datas.get(date);
                if (e.getWeight() != null && data.weight == null) {
                    data.weight = Float.valueOf(e.getWeight().floatValue() * 1000.0f);
                }
                if (e.getHeight() != null && data.height == null) {
                    data.height = e.getHeight();
                }
                if (e.getIMC() != null && data.imc == null) {
                    data.imc = Float.valueOf(e.getIMC().floatValue());
                }
                JoinList joinList = new JoinList(" ");
                joinList.setAllowBlank(false);
                joinList.setNoDuplicate(true);
                joinList.add((CharSequence)data.comments).add((CharSequence)e.getNote());
                data.comments = joinList.toString();
                continue;
            }
            data = new BMI_219.Data(date, e.getWeight() == null ? null : Float.valueOf(e.getWeight().floatValue() * 1000.0f), e.getHeight(), e.getIMC() == null ? null : Float.valueOf(e.getIMC().floatValue()), e.getNote());
            datas.put(date, data);
        }
        if (!datas.isEmpty()) {
            BMI_219 bmi_219 = new BMI_219();
            bmi_219.setBlackAndWhite(blackAndWhite);
            bmi_219.setLanguage(Language.FR);
            bmi_219.setSex(gender == XPerson.Gender.FEMININ ? Sex.GIRLS : Sex.BOYS);
            bmi_219.setBirthdate(LocalDate.fromDayFrom1970((int)patient.getBirthDate().dayFrom1970));
            bmi_219.setRecordnumber(recordNumber);
            bmi_219.setFullname(name);
            bmi_219.setDatas(new ArrayList<BMI_219.Data>(datas.values()));
            return bmi_219.render();
        }
        return null;
    }

    public static byte[] getChart024Pdf(XPerson.Gender gender, XPatient pat, List<XMeasurement> measurementsForGraph, boolean blackAndWhite) {
        try {
            LocalDate birthdate = MeasurementGraph.getBirthdate(pat);
            if (gender != null && birthdate != null) {
                byte[] lfa_WFA024Rendered = MeasurementGraph.renderLFA_WFA024(gender, pat, measurementsForGraph, blackAndWhite);
                byte[] hc_WFL024Rendered = MeasurementGraph.renderHC_WFL024(gender, pat, measurementsForGraph, blackAndWhite);
                byte[] pdf = PdfUtil.joinPdfs(lfa_WFA024Rendered, hc_WFL024Rendered);
                return pdf;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to show growChart024", e);
        }
        return null;
    }

    private static byte[] renderLFA_WFA024(XPerson.Gender gender, XPatient patient, List<XMeasurement> measurementsForGraph, boolean blackAndWhite) throws Exception {
        String recordNumber = StringUtils.defaultString((String)patient.getPatientRecordNumber());
        String name = patient.getName();
        TreeMap<LocalDate, LFA_WFA024.Data> datas = new TreeMap<LocalDate, LFA_WFA024.Data>();
        int nbJrsPremature = 0;
        int nbMoisPremature = 0;
        for (XMeasurement xMeasurement : measurementsForGraph) {
            if (xMeasurement.nbJrsPremature == null || xMeasurement.nbJrsPremature <= 0) continue;
            nbJrsPremature = xMeasurement.nbJrsPremature;
            nbMoisPremature = Math.round((float)nbJrsPremature / 30.0f);
            break;
        }
        LocalDate birthDate = patient.getBirthDate();
        for (XMeasurement e : measurementsForGraph) {
            LFA_WFA024.Data data;
            int ageInMonths;
            LocalDate date = LocalDate.fromTimeInMillisLOCAL((Long)e.getTimeVitalSign());
            if (date == null || Boolean.TRUE.equals(e.getIsDeleted()) || (ageInMonths = date.getMonthDiff(birthDate.plusDay(nbMoisPremature))) > 24) continue;
            if (datas.containsKey(date)) {
                data = (LFA_WFA024.Data)datas.get(date);
                if (e.getWeight() != null && data.weight == null) {
                    data.weight = Float.valueOf(e.getWeight().floatValue() * 1000.0f);
                }
                if (e.getHeight() != null && data.height == null) {
                    data.height = e.getHeight();
                }
                JoinList joinList = new JoinList(" ");
                joinList.setAllowBlank(false);
                joinList.setNoDuplicate(true);
                joinList.add((CharSequence)data.comments).add((CharSequence)e.getNote());
                data.comments = joinList.toString();
                continue;
            }
            data = new LFA_WFA024.Data(date, e.getWeight() == null ? null : Float.valueOf(e.getWeight().floatValue() * 1000.0f), e.getHeight(), e.getNote());
            datas.put(date, data);
        }
        if (!datas.isEmpty()) {
            LFA_WFA024 lFA_WFA024 = new LFA_WFA024();
            lFA_WFA024.setBlackAndWhite(blackAndWhite);
            lFA_WFA024.setLanguage(Language.FR);
            lFA_WFA024.setSex(gender == XPerson.Gender.FEMININ ? Sex.GIRLS : Sex.BOYS);
            lFA_WFA024.setBirthdate(LocalDate.fromDayFrom1970((int)birthDate.dayFrom1970));
            lFA_WFA024.setGestionalAgeAtBirth(40 - Math.round((float)nbJrsPremature / 7.0f) + "");
            lFA_WFA024.setNbJrsPremature(nbJrsPremature);
            lFA_WFA024.setRecordnumber(recordNumber);
            lFA_WFA024.setFullname(name);
            lFA_WFA024.setDatas(new ArrayList<LFA_WFA024.Data>(datas.values()));
            return lFA_WFA024.render();
        }
        return null;
    }

    private static byte[] renderHC_WFL024(XPerson.Gender gender, XPatient patient, List<XMeasurement> measurementsForGraph, boolean blackAndWhite) throws Exception {
        String recordNumber = StringUtils.defaultString((String)patient.getPatientRecordNumber());
        String name = patient.getName();
        TreeMap<LocalDate, HC_WFL024.DATA> datas = new TreeMap<LocalDate, HC_WFL024.DATA>();
        int nbJrsPremature = 0;
        for (XMeasurement e : measurementsForGraph) {
            if (e.nbJrsPremature == null || e.nbJrsPremature <= 0) continue;
            nbJrsPremature = e.nbJrsPremature;
            break;
        }
        for (XMeasurement e : measurementsForGraph) {
            HC_WFL024.DATA data;
            LocalDate date = LocalDate.fromTimeInMillisLOCAL((Long)e.getTimeVitalSign());
            if (date == null || Boolean.TRUE.equals(e.getIsDeleted())) continue;
            LocalDate.DateDiff diff = date.getDiff(patient.getBirthDate().plusDay(nbJrsPremature));
            if (diff.years > 2) continue;
            if (datas.containsKey(date)) {
                data = (HC_WFL024.DATA)datas.get(date);
                if (e.getWeight() != null && data.weight == null) {
                    data.weight = Float.valueOf(e.getWeight().floatValue() * 1000.0f);
                }
                if (e.getHeight() != null && data.length == null) {
                    data.length = e.getHeight();
                }
                if (e.getHeadCirc() != null && data.headCirc == null) {
                    data.headCirc = e.getHeadCirc();
                }
                JoinList joinList = new JoinList(" ");
                joinList.setAllowBlank(false);
                joinList.setNoDuplicate(true);
                joinList.add((CharSequence)data.comments).add((CharSequence)e.getNote());
                data.comments = joinList.toString();
                continue;
            }
            data = new HC_WFL024.DATA(LocalDate.fromDayFrom1970((int)date.dayFrom1970), e.getHeadCirc(), e.getWeight() == null ? null : Float.valueOf(e.getWeight().floatValue() * 1000.0f), e.getHeight(), e.getNote());
            datas.put(date, data);
        }
        if (!datas.isEmpty()) {
            HC_WFL024 hc_WFL024 = new HC_WFL024();
            hc_WFL024.setBlackAndWhite(blackAndWhite);
            hc_WFL024.setLanguage(Language.FR);
            hc_WFL024.setSex(gender == XPerson.Gender.FEMININ ? Sex.GIRLS : Sex.BOYS);
            hc_WFL024.setBirthdate(LocalDate.fromDayFrom1970((int)patient.getBirthDate().dayFrom1970));
            hc_WFL024.setGestionalAgeAtBirth(40 - Math.round((float)nbJrsPremature / 7.0f) + "");
            hc_WFL024.setNbJrsPremature(nbJrsPremature);
            hc_WFL024.setRecordnumber(recordNumber);
            hc_WFL024.setFullname(name);
            hc_WFL024.setDatas(new ArrayList<HC_WFL024.DATA>(datas.values()));
            return hc_WFL024.render();
        }
        return null;
    }

    private static byte[] renderFenton_060(XPerson.Gender gender, XPatient patient, List<XMeasurement> measurementsForGraph) throws Exception {
        String recordNumber = StringUtils.defaultString((String)patient.getPatientRecordNumber());
        String name = patient.getName();
        TreeMap<LocalDate, HC_WFL024.DATA> datas = new TreeMap<LocalDate, HC_WFL024.DATA>();
        int nbJrsPremature = 0;
        for (XMeasurement e : measurementsForGraph) {
            if (e.nbJrsPremature == null || e.nbJrsPremature <= 0) continue;
            nbJrsPremature = e.nbJrsPremature;
            break;
        }
        for (XMeasurement e : measurementsForGraph) {
            HC_WFL024.DATA data;
            LocalDate date = LocalDate.fromTimeInMillisLOCAL((Long)e.getTimeVitalSign());
            if (date == null || Boolean.TRUE.equals(e.getIsDeleted())) continue;
            LocalDate.DateDiff diff = date.getDiff(patient.getBirthDate().plusDay(nbJrsPremature));
            if (diff.years > 2) continue;
            if (datas.containsKey(date)) {
                data = (HC_WFL024.DATA)datas.get(date);
                if (e.getWeight() != null && data.weight == null) {
                    data.weight = Float.valueOf(e.getWeight().floatValue() * 1000.0f);
                }
                if (e.getHeight() != null && data.length == null) {
                    data.length = e.getHeight();
                }
                if (e.getHeadCirc() != null && data.headCirc == null) {
                    data.headCirc = e.getHeadCirc();
                }
                JoinList joinList = new JoinList(" ");
                joinList.setAllowBlank(false);
                joinList.setNoDuplicate(true);
                joinList.add((CharSequence)data.comments).add((CharSequence)e.getNote());
                data.comments = joinList.toString();
                continue;
            }
            data = new HC_WFL024.DATA(LocalDate.fromDayFrom1970((int)date.dayFrom1970), e.getHeadCirc(), e.getWeight() == null ? null : Float.valueOf(e.getWeight().floatValue() * 1000.0f), e.getHeight(), e.getNote());
            datas.put(date, data);
        }
        if (!datas.isEmpty()) {
            HC_WFL024 hc_WFL024 = new HC_WFL024();
            hc_WFL024.setLanguage(Language.FR);
            hc_WFL024.setSex(gender == XPerson.Gender.FEMININ ? Sex.GIRLS : Sex.BOYS);
            hc_WFL024.setBirthdate(LocalDate.fromDayFrom1970((int)patient.getBirthDate().dayFrom1970));
            hc_WFL024.setGestionalAgeAtBirth(40 - Math.round((float)nbJrsPremature / 7.0f) + "");
            hc_WFL024.setNbJrsPremature(nbJrsPremature);
            hc_WFL024.setRecordnumber(recordNumber);
            hc_WFL024.setFullname(name);
            hc_WFL024.setDatas(new ArrayList<HC_WFL024.DATA>(datas.values()));
            return hc_WFL024.render();
        }
        return null;
    }
}

