/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.billingnb;

import ca.infodata.util1.date.LocaleProvider;

public enum XReferralType {
    M0(new Integer(0), "None", "Aucun"),
    M1(new Integer(1), "Referred To", "Aiguille vers"),
    M2(new Integer(2), "Referred From", "Transfere de");

    public final Integer id;
    private final String descFr;
    private final String descEn;

    private XReferralType(Integer i, String dFr, String dEn) {
        this.id = i;
        this.descFr = dFr;
        this.descEn = dEn;
    }

    public String value() {
        return this.name();
    }

    public int getId() {
        return this.id;
    }

    public String getId1char() {
        return String.valueOf(this.id);
    }

    public String description(int langue) {
        return this.id + "-" + (langue == 0 ? this.descFr : this.descEn);
    }

    public String description() {
        return this.id + "-" + (LocaleProvider.isFrench() ? this.descFr : this.descEn);
    }

    public static XReferralType getReferralType(Integer i) {
        if (i != null) {
            return XReferralType.getReferralType((int)i);
        }
        return M0;
    }

    public static XReferralType getReferralType(int i) {
        for (XReferralType o : XReferralType.values()) {
            if (o.id != i) continue;
            return o;
        }
        return M0;
    }
}

