/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects;

import ca.infodata.ofys.data.middle.dataobjects.IImportance;
import ca.infodata.ofys.data.middle.dataobjects.IPersonReader;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XAddress;
import ca.infodata.ofys.data.middle.dataobjects.XCitizenship;
import ca.infodata.ofys.data.middle.dataobjects.XCity;
import ca.infodata.ofys.data.middle.dataobjects.XContactInformation;
import ca.infodata.ofys.data.middle.dataobjects.XCountry;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.XPersonType;
import ca.infodata.ofys.data.middle.dataobjects.XProvince;
import ca.infodata.ofys.data.middle.dataobjects.XUser;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPerson;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.site.SiteAddedAs;
import ca.infodata.ofys.data.middle.dataobjects.site.XPersonSite;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.Comparator;

public abstract class XPerson
extends EditableDataObject
implements IPerson,
IPersonReader,
KryoSerializable {
    private static final long serialVersionUID = 1L;
    public static final String[] MARITAL_STATUS_TEXT = new String[]{Messages.getString("SO", new String[0]), Messages.getString("CELIBATAIRE", new String[0]), Messages.getString("CONJOINT_DE_FAIT", new String[0]), Messages.getString("MARIE", new String[0]), Messages.getString("DIVORCE", new String[0]), Messages.getString("VEUF", new String[0])};
    public static final int MARITAL_STATUS_SO = 0;
    public static final int MARITAL_STATUS_SINGLE = 1;
    public static final int MARITAL_STATUS_SPOUSE_IN_FACT = 2;
    public static final int MARITAL_STATUS_MARRIED = 3;
    public static final int MARITAL_STATUS_DIVORCED = 4;
    public static final int MARITAL_STATUS_WIDOWED = 5;
    public static final String[] LANGUAGE_CODE_TEXT = new String[]{Messages.getString("FRANCAIS", new String[0]), Messages.getString("ANGLAIS", new String[0]), Messages.getString("ESPAGNOL", new String[0]), Messages.getString("AUTRE", new String[0])};
    public static final int LANGUAGE_CODE_FRENCH = 0;
    public static final int LANGUAGE_CODE_ENGLISH = 1;
    public static final int LANGUAGE_CODE_SPANISH = 2;
    public static final int LANGUAGE_CODE_OTHER = 3;
    public static final String[] RACE_TEXT = new String[]{Messages.getString("BLANC", new String[0]), Messages.getString("AUTOCHTONE", new String[0]), Messages.getString("NOIR", new String[0]), Messages.getString("ORIGINE_AMERIQUE_LATINE", new String[0]), Messages.getString("ASIATIQUE", new String[0]), Messages.getString("CHINOIS", new String[0]), Messages.getString("PHILIPPIN", new String[0]), Messages.getString("ARABEASIATIQUE_OCCIDENTAL", new String[0]), Messages.getString("JAPONAIS", new String[0]), Messages.getString("COREEN", new String[0]), Messages.getString("AUTRE", new String[0]), Messages.getString("NON_SPECIFIE", new String[0])};
    public static final String[] STATUS_TEXT = new String[]{Messages.getString("ACTIF", new String[0]), Messages.getString("INACTIF", new String[0])};
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_PATIENT = 1;
    public static final int TYPE_EMPLOYEE = 2;
    public static final int TYPE_PROFESSIONNAL = 3;
    public XUser user;
    public Boolean isUser;
    public String lastName;
    public String searchLastName;
    public String midInitial;
    public String firstName;
    public String searchFirstName;
    public String gender;
    public Short race;
    public Short languageCode;
    public Short maritalStatus;
    public LocalDate birthDate;
    public String note;
    public String title;
    public Boolean isDeleted;
    public Integer idPerson;
    public Short age;
    public XCitizenship citizenship;
    public XImageDecorator decorators;
    public String[] sites;
    public String[] adresses;
    public String[] contacts;
    public EditableDataObjectList<XContactInformation> lstContactInformation;
    public EditableDataObjectList<XAddress> lstAddress;
    public EditableDataObjectList<XPersonSite> lstSites;
    public static Comparator<IImportance> compImportance = new Comparator<IImportance>(){

        @Override
        public int compare(IImportance o1, IImportance o2) {
            int i = o1.getImportance().compareTo(o2.getImportance());
            if (i == 0) {
                if (o1.getId() == null) {
                    return -1;
                }
                if (o2.getId() == null) {
                    return 1;
                }
                return o1.getId().compareTo(o2.getId());
            }
            return i;
        }
    };
    protected String str;
    public XPersonType personType = XPersonType.PAT;
    public Integer externalId;

    public XPerson() {
        this.initialize();
    }

    @Override
    public void write(Kryo k, Output out) {
        int i;
        out.writeByte(MiscUtil.fromBoolean(this.isUser));
        out.writeString(MiscUtil.fromString(this.lastName));
        out.writeString(MiscUtil.fromString(this.searchLastName));
        out.writeString(MiscUtil.fromString(this.midInitial));
        out.writeString(MiscUtil.fromString(this.firstName));
        out.writeString(MiscUtil.fromString(this.searchFirstName));
        out.writeString(MiscUtil.fromString(this.gender));
        out.writeShort((int)MiscUtil.fromShort(this.race));
        out.writeShort((int)MiscUtil.fromShort(this.languageCode));
        out.writeShort((int)MiscUtil.fromShort(this.maritalStatus));
        out.writeShort((int)MiscUtil.fromLocalDateToShort(this.birthDate));
        out.writeString(MiscUtil.fromString(this.note));
        out.writeString(MiscUtil.fromString(this.title));
        out.writeByte(MiscUtil.fromBoolean(this.isDeleted));
        out.writeInt(MiscUtil.fromInt(this.idPerson));
        out.writeShort((int)MiscUtil.fromShort(this.age));
        k.writeObjectOrNull(out, (Object)this.citizenship, XCitizenship.class);
        k.writeObjectOrNull(out, (Object)this.decorators, XImageDecorator.class);
        int size = this.lstContactInformation == null ? 0 : this.lstContactInformation.size();
        out.writeShort(size);
        if (size > 0) {
            for (i = 0; i < size; ++i) {
                k.writeObject(out, this.lstContactInformation.get(i));
            }
        }
        size = (short)(this.lstAddress == null ? 0 : this.lstAddress.size());
        out.writeShort(size);
        if (size > 0) {
            for (i = 0; i < size; ++i) {
                k.writeObject(out, this.lstAddress.get(i));
            }
        }
        size = (short)(this.lstSites == null ? 0 : this.lstSites.size());
        out.writeShort(size);
        if (size > 0) {
            for (i = 0; i < size; ++i) {
                k.writeObject(out, this.lstSites.get(i));
            }
        }
        out.writeString(MiscUtil.fromString(this.str));
        out.writeShort(this.personType == null ? XPersonType.SYST.getValue() : this.personType.getValue());
        out.writeInt(MiscUtil.fromInt(this.externalId));
        k.writeObjectOrNull(out, (Object)this.user, XUser.class);
        super.write(k, out);
    }

    @Override
    public void read(Kryo k, Input in) {
        this.isUser = MiscUtil.toBoolean(in.readByte());
        this.lastName = MiscUtil.toString(in.readString());
        this.searchLastName = MiscUtil.toString(in.readString());
        this.midInitial = MiscUtil.toString(in.readString());
        this.firstName = MiscUtil.toString(in.readString());
        this.searchFirstName = MiscUtil.toString(in.readString());
        this.gender = MiscUtil.toString(in.readString());
        this.race = MiscUtil.toShort(in.readShort());
        this.languageCode = MiscUtil.toShort(in.readShort());
        this.maritalStatus = MiscUtil.toShort(in.readShort());
        this.birthDate = MiscUtil.toLocalDate(in.readShort());
        this.note = MiscUtil.toString(in.readString());
        this.title = MiscUtil.toString(in.readString());
        this.isDeleted = MiscUtil.toBoolean(in.readByte());
        this.idPerson = MiscUtil.toInt(in.readInt());
        this.age = MiscUtil.toShort(in.readShort());
        this.citizenship = (XCitizenship)k.readObjectOrNull(in, XCitizenship.class);
        this.decorators = (XImageDecorator)k.readObjectOrNull(in, XImageDecorator.class);
        short b = in.readShort();
        this.lstContactInformation = MiscUtil.extracted(k, in, b, XContactInformation.class);
        MiscUtil.trySort(this.lstContactInformation, compImportance);
        b = in.readShort();
        this.lstAddress = MiscUtil.extracted(k, in, b, XAddress.class);
        MiscUtil.trySort(this.lstAddress, compImportance);
        b = in.readShort();
        this.lstSites = MiscUtil.extracted(k, in, b, XPersonSite.class);
        this.str = MiscUtil.toString(in.readString());
        this.personType = XPersonType.from(Integer.valueOf(in.readShort()));
        this.externalId = MiscUtil.toInt(in.readInt());
        this.user = (XUser)k.readObjectOrNull(in, XUser.class);
        super.read(k, in);
    }

    @Override
    public XPerson clone() {
        XPerson c = (XPerson)super.clone();
        c.idPerson = this.idPerson;
        c.lastName = this.lastName;
        c.searchLastName = this.searchLastName;
        c.firstName = this.firstName;
        c.searchFirstName = this.searchFirstName;
        c.midInitial = this.midInitial;
        c.gender = this.gender;
        c.birthDate = this.birthDate;
        c.isDeleted = this.isDeleted;
        c.isUser = this.isUser;
        c.user = this.user == null ? null : this.user.clone();
        c.note = this.note;
        c.title = this.title;
        c.citizenship = this.citizenship == null ? null : this.citizenship.clone();
        c.languageCode = this.languageCode;
        c.maritalStatus = this.maritalStatus;
        c.age = this.age;
        c.decorators = this.decorators;
        c.race = this.race;
        if (this.lstAddress != null) {
            c.lstAddress = this.lstAddress.deepClone();
        }
        if (this.lstContactInformation != null) {
            c.lstContactInformation = this.lstContactInformation.deepClone();
        }
        if (this.lstSites != null) {
            c.lstSites = this.lstSites.deepClone();
        }
        c.contacts = this.contacts;
        c.adresses = this.adresses;
        c.sites = this.sites;
        c.externalId = this.externalId;
        c.personType = this.personType;
        return c;
    }

    public Integer getExternalId() {
        return this.externalId;
    }

    public void setExternalId(Integer externalId) {
        this.externalId = externalId;
        this.setUpdated();
    }

    @Override
    public void initialize() {
        this.setNew();
        this.setLastName("");
        this.setSearchLastName("");
        this.setMidInitial("");
        this.setFirstName("");
        this.setSearchFirstName("");
        this.setBirthDate(null);
        this.setGender("");
        this.setIsUser(false);
        this.setNote("");
        this.setTitle("");
        this.setIsDeleted(false);
        this.setCitizenship(null);
        this.setLstContactInformation(new EditableDataObjectList<XContactInformation>());
        this.setLstAddress(new EditableDataObjectList<XAddress>());
        this.setAge((short)0);
        this.setDecorators(XImageDecorator.NULL_DECORATORS);
        this.setLstSites(new EditableDataObjectList<XPersonSite>());
    }

    @Override
    public boolean isDirty() {
        boolean dirty = super.isDirty();
        dirty = dirty || this.user != null && this.user.isDirty();
        dirty = dirty || this.lstContactInformation != null && this.lstContactInformation.isDirty();
        dirty = dirty || this.lstAddress != null && this.lstAddress.isDirty();
        dirty = dirty || this.lstSites != null && this.lstSites.isDirty();
        return dirty;
    }

    @Override
    public XUser getUser() {
        return this.user;
    }

    @Override
    public Integer getIdPerson() {
        if (this.idPerson != null && Integer.MIN_VALUE == this.idPerson) {
            return null;
        }
        return this.idPerson;
    }

    public void setIdPerson(Integer idPerson) {
        if (idPerson != null && Integer.MIN_VALUE == idPerson) {
            idPerson = null;
        }
        this.idPerson = idPerson;
        this.setUpdated();
    }

    public void setIdPerson(int idPerson) {
        this.idPerson = idPerson;
        this.setUpdated();
    }

    @Override
    public Short getAge() {
        return this.age;
    }

    public void setAge(Short age) {
        this.age = age;
        this.setUpdated();
    }

    @Override
    public boolean isPatient() {
        return XPersonType.PAT.equals(this.personType);
    }

    @Override
    public boolean isEmployee() {
        return XPersonType.EMP.equals(this.personType);
    }

    @Override
    public boolean isProfessionnal() {
        return XPersonType.PROF.equals(this.personType);
    }

    @Override
    public String getName() {
        String last = this.getLastName();
        String first = this.getFirstName();
        JoinList list = new JoinList(", ", 2);
        list.setAllowBlank(false);
        list.setTrim(true);
        list.add((CharSequence)last);
        list.add((CharSequence)first);
        return list.toString();
    }

    @Override
    public String getFirstAndLastName() {
        String first = this.getFirstName();
        String last = this.getLastName();
        JoinList list = new JoinList(" ", 2);
        list.setAllowBlank(false);
        list.setTrim(true);
        list.add((CharSequence)first);
        list.add((CharSequence)last);
        return list.toString();
    }

    public void setUser(XUser user) {
        this.user = user;
        this.setUpdated();
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
        this.searchLastName = lastName == null ? null : lastName.toUpperCase();
        this.setUpdated();
    }

    @Override
    public String getSearchLastName() {
        return this.searchLastName;
    }

    public void setSearchLastName(String searchLastName) {
        this.searchLastName = searchLastName;
        this.setUpdated();
    }

    @Override
    public String getMidInitial() {
        return this.midInitial;
    }

    public void setMidInitial(String midInitial) {
        this.midInitial = midInitial;
        this.setUpdated();
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
        this.searchFirstName = firstName == null ? null : firstName.toUpperCase();
        this.setUpdated();
    }

    @Override
    public String getSearchFirstName() {
        return this.searchFirstName;
    }

    public void setSearchFirstName(String searchFirstName) {
        this.searchFirstName = searchFirstName;
        this.setUpdated();
    }

    @Override
    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
        this.setUpdated();
    }

    @Override
    public Short getRace() {
        return this.race;
    }

    public void setRace(Short race) {
        this.race = race;
        this.setUpdated();
    }

    @Override
    public Short getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(Short languageCode) {
        this.languageCode = languageCode;
        this.setUpdated();
    }

    @Override
    public Short getMaritalStatus() {
        return this.maritalStatus;
    }

    public void setMaritalStatus(Short maritalStatus) {
        this.maritalStatus = maritalStatus;
        this.setUpdated();
    }

    @Override
    public LocalDate getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(LocalDate birthDate) {
        this.birthDate = birthDate;
        this.setUpdated();
    }

    @Override
    public Boolean getIsUser() {
        return this.isUser;
    }

    public void setIsUser(Boolean isUser) {
        this.isUser = isUser;
        this.setUpdated();
    }

    @Override
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
        this.setUpdated();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.setUpdated();
    }

    @Override
    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
        this.setUpdated();
    }

    @Override
    public XCitizenship getCitizenship() {
        return this.citizenship;
    }

    public void setCitizenship(XCitizenship citizenship) {
        this.citizenship = citizenship;
        this.setUpdated();
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof XPerson) {
            equals = this.getId() == null ? super.equals(obj) : this.hashCode() == obj.hashCode();
        }
        return equals;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : ("XPerson" + this.getId().hashCode()).hashCode();
        return hashCode;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public void setText(String string) {
        this.str = string;
    }

    public void copyTo(XPerson c) {
        c.lastName = this.lastName;
        c.searchLastName = this.searchLastName;
        c.midInitial = this.midInitial;
        c.firstName = this.firstName;
        c.searchFirstName = this.searchFirstName;
        c.gender = this.gender;
        c.race = this.race;
        c.languageCode = this.languageCode;
        c.maritalStatus = this.maritalStatus;
        c.birthDate = this.birthDate;
        c.isUser = this.isUser;
        c.note = this.note;
        c.title = this.title;
        c.isDeleted = this.isDeleted;
        c.idPerson = this.idPerson;
        c.age = this.age;
        c.str = this.str;
        if (this.citizenship != null) {
            c.citizenship = this.citizenship.clone();
        }
        if (this.lstAddress != null) {
            c.lstAddress = this.lstAddress.deepClone();
        }
        if (this.lstContactInformation != null) {
            c.lstContactInformation = this.lstContactInformation.deepClone();
        }
        if (this.lstSites != null) {
            c.lstSites = this.lstSites.deepClone();
        }
        if (this.user != null) {
            c.user = this.user.clone();
        }
        c.personType = this.personType;
    }

    public EditableDataObjectList<XAddress> getLstAddress() {
        return this.lstAddress;
    }

    public void setLstAddress(EditableDataObjectList<XAddress> lstAddress) {
        this.lstAddress = lstAddress;
        this.setUpdated();
    }

    public void addAddress(XAddress a) {
        if (this.lstAddress == null) {
            this.lstAddress = new EditableDataObjectList();
        }
        this.lstAddress.add(a);
        this.setUpdated();
    }

    public EditableDataObjectList<XContactInformation> getLstContactInformation() {
        return this.lstContactInformation;
    }

    public void setLstContactInformation(EditableDataObjectList<XContactInformation> lstContactInformation) {
        this.lstContactInformation = lstContactInformation;
        this.setUpdated();
    }

    public void addContactInformation(XContactInformation a) {
        if (this.lstContactInformation == null) {
            this.lstContactInformation = new EditableDataObjectList();
        }
        this.lstContactInformation.add(a);
        this.setUpdated();
    }

    @Override
    public XImageDecorator getDecorators() {
        return this.decorators;
    }

    public void setDecorators(XImageDecorator decorators) {
        this.decorators = decorators;
    }

    @Override
    public IStatus valid() {
        MultiStatus status = new MultiStatus();
        status.add(super.valid());
        if (this.user != null) {
            status.add(this.user.valid());
        }
        return status;
    }

    @Override
    public String getNameBirthdateSex() {
        String sex;
        StringBuilder b = new StringBuilder(30);
        b.append(this.getName());
        LocalDate dob = this.getBirthDate();
        if (dob != null) {
            b.append(' ');
            b.append(LocalDateFormat.format((LocalDate)dob, (String)FormatDateProvider.getFormatDate().toString()));
        }
        if (!StringUtils.isBlank((CharSequence)(sex = this.getGender())) && !"I".equals(sex)) {
            b.append('(').append(sex).append(')');
        }
        return b.toString();
    }

    @Override
    public IEditableDataObjectList<XPersonSite> getLstSites() {
        return this.lstSites;
    }

    public void setLstSites(EditableDataObjectList<XPersonSite> sites) {
        this.lstSites = sites;
        this.setUpdated();
    }

    @Override
    public boolean isAssociatedWithSite(XSite site) {
        if (site == null || site.getId() == null || this.lstSites == null || this.lstSites.isEmpty()) {
            return false;
        }
        for (XPersonSite ps : this.lstSites) {
            if (ps == null || ps.getAddedAs() != SiteAddedAs.WORK_SITE || ps.getIdSite() == null || !ps.getIdSite().equals(site.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public XAddress getAddress1() {
        if (this.lstAddress != null && this.lstAddress.size() > 0) {
            return (XAddress)this.lstAddress.get(0);
        }
        return null;
    }

    @Override
    public String getStreet() {
        XAddress addr = this.getAddress1();
        if (addr != null) {
            return addr.getStreet();
        }
        return null;
    }

    @Override
    public XCity getCity() {
        XAddress addr = this.getAddress1();
        if (addr != null) {
            return addr.getCity();
        }
        return null;
    }

    @Override
    public XProvince getProvince() {
        XAddress addr = this.getAddress1();
        if (addr != null) {
            return addr.getProvince();
        }
        return null;
    }

    @Override
    public XCountry getCountry() {
        XAddress addr = this.getAddress1();
        if (addr != null) {
            return addr.getCountry();
        }
        return null;
    }

    @Override
    public String getPostalCode() {
        XAddress addr = this.getAddress1();
        if (addr != null) {
            return addr.getPostalCode();
        }
        return null;
    }

    @Override
    public String getNoteAddress() {
        XAddress addr = this.getAddress1();
        if (addr != null) {
            return addr.getNote();
        }
        return null;
    }

    @Override
    public XContactInformation getContactInformation(int i) {
        if (this.lstContactInformation != null && this.lstContactInformation.size() > i) {
            return (XContactInformation)this.lstContactInformation.get(i);
        }
        return null;
    }

    @Override
    public XContactInformation getFirstContactInformation() {
        return this.getContactInformation1();
    }

    @Override
    public XContactInformation getSecondContactInformation() {
        return this.getContactInformation2();
    }

    @Override
    public XContactInformation getContactInformation1() {
        return this.getContactInformation(0);
    }

    @Override
    public String getFirstContactInformationContact() {
        XContactInformation c = this.getContactInformation1();
        if (c != null) {
            return c.contact;
        }
        return null;
    }

    @Override
    public XContactInformation getContactInformation2() {
        return this.getContactInformation(1);
    }

    @Override
    public String getSecondContactInformationContact() {
        XContactInformation c = this.getContactInformation2();
        if (c != null) {
            return c.contact;
        }
        return null;
    }

    @Override
    public Integer getTypeContact1() {
        XContactInformation c = this.getContactInformation1();
        if (c != null) {
            return c.typeContact;
        }
        return null;
    }

    @Override
    public String getFirstContactInformationNote() {
        XContactInformation c = this.getContactInformation1();
        if (c != null) {
            return c.note;
        }
        return null;
    }

    @Override
    public Integer getSecondContactInformationType() {
        XContactInformation c = this.getContactInformation2();
        if (c != null) {
            return c.typeContact;
        }
        return null;
    }

    @Override
    public String getSecondContactInformationNote() {
        XContactInformation c = this.getContactInformation2();
        if (c != null) {
            return c.note;
        }
        return null;
    }

    @Override
    public String getEmailPrincContact() {
        for (XContactInformation contact : this.lstContactInformation) {
            if (contact.typeContact.intValue() != XContactInformation.CONTACT_TYPE_EMAIL.intValue()) continue;
            return contact.contact;
        }
        return null;
    }

    public String getEmailAutreContact() {
        for (XContactInformation contact : this.lstContactInformation) {
            if (contact.typeContact.intValue() != XContactInformation.CONTACT_TYPE_EMAILS_AUTRES.intValue()) continue;
            return contact.contact;
        }
        return null;
    }

    @Override
    public XContactInformation getEmailPrinc() {
        for (XContactInformation contact : this.lstContactInformation) {
            if (contact.typeContact.intValue() != XContactInformation.CONTACT_TYPE_EMAIL.intValue()) continue;
            return contact;
        }
        return null;
    }

    @Override
    public String getCell() {
        for (XContactInformation contact : this.lstContactInformation) {
            if (contact.typeContact.intValue() != XContactInformation.CONTACT_TYPE_CELL_TEXTO.intValue()) continue;
            return contact.contact;
        }
        return null;
    }

    @Override
    public XContactInformation getContactInformationCellPrinc() {
        for (XContactInformation contact : this.lstContactInformation) {
            if (contact.typeContact.intValue() != XContactInformation.CONTACT_TYPE_CELL_TEXTO.intValue()) continue;
            return contact;
        }
        return null;
    }

    @Override
    public XContactInformation getContactInformationCellAutre() {
        for (XContactInformation contact : this.lstContactInformation) {
            if (contact.typeContact.intValue() != XContactInformation.CONTACT_TYPE_CELL_AUTRE.intValue()) continue;
            return contact;
        }
        return null;
    }

    public XContactInformation getFirstPhoneNumberContactInformation() {
        String contact = this.getFirstContactInformationContact();
        Integer type = this.getTypeContact1();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)contact) && XContactInformation.CONTACT_PHONE_TYPES.contains(type)) {
            return this.getFirstContactInformation();
        }
        contact = this.getSecondContactInformationContact();
        type = this.getSecondContactInformationType();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)contact) && XContactInformation.CONTACT_PHONE_TYPES.contains(type)) {
            return this.getSecondContactInformation();
        }
        return null;
    }

    @Override
    public String getFirstPhoneNumberContact() {
        XContactInformation contact = this.getFirstPhoneNumberContactInformation();
        if (contact != null) {
            return contact.getFormatedContact();
        }
        return null;
    }

    @Override
    public String getFirstPhoneNumberContactNote() {
        XContactInformation contact = this.getFirstPhoneNumberContactInformation();
        if (contact != null) {
            return contact.getNote();
        }
        return null;
    }

    @Override
    public Integer getIdEmailPrinc() {
        XContactInformation princ = this.getEmailPrinc();
        if (princ != null) {
            return princ.id;
        }
        return null;
    }

    @Override
    public String getEmailPrincNote() {
        XContactInformation princ = this.getEmailPrinc();
        if (princ != null) {
            return princ.note;
        }
        return null;
    }

    @Override
    public Integer getIdCell() {
        XContactInformation princ = this.getContactInformationCellPrinc();
        if (princ != null) {
            return princ.id;
        }
        return null;
    }

    @Override
    public String getCellNote() {
        XContactInformation princ = this.getContactInformationCellPrinc();
        if (princ != null) {
            return princ.note;
        }
        return null;
    }

    public XPersonType getPersonType() {
        return this.personType;
    }

    public void setPersonType(XPersonType personType) {
        this.personType = personType;
    }

    public static enum Gender {
        INCONNU("I"){

            public String toString() {
                return Messages.getString("INCONNU", new String[0]);
            }
        }
        ,
        MASCULIN("M"){

            public String toString() {
                return Messages.getString("MASCULIN", new String[0]);
            }
        }
        ,
        FEMININ("F"){

            public String toString() {
                return Messages.getString("FEMININ", new String[0]);
            }
        };

        public final String id;

        private Gender(String id) {
            this.id = id;
        }

        public static Gender from(String id) {
            for (Gender g : Gender.values()) {
                if (!g.id.equals(id)) continue;
                return g;
            }
            return null;
        }
    }
}

