/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects;

import ca.infodata.ofys.data.middle.dataobjects.GenericDataMapping;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPatientProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.data.middle.dataobjects.XPersonType;
import ca.infodata.ofys.data.middle.dataobjects.XVulnerability;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XDisabilityCode;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XInscriptionStatus;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XPatientB2b;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XPatientRepresentativeType;
import ca.infodata.ofys.data.middle.dataobjects.identifiers.XPatientIdentifier;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.patient.XConsentement;
import ca.infodata.ofys.data.middle.dataobjects.patient.XPatientInactiveRaison;
import ca.infodata.ofys.data.middle.dataobjects.patient.XPatientValue;
import ca.infodata.ofys.data.middle.dataobjects.site.XPersonSite;
import ca.infodata.ofys.util.Comparators;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.PartialDate;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class XPatient
extends XPerson
implements IPatient,
KryoSerializable {
    private static final long serialVersionUID = 1L;
    public static final String[] BLOOD_TYPE_TEXT = new String[]{Messages.getString("INCONNU", new String[0]), "O-", "O+", "A-", "A+", "B-", "B+", "AB-", "AB+"};
    public transient boolean saveContextVar_saveFromHub;
    public transient boolean saveContextVar_saveFromIClsc;
    public transient Short idClient;
    public String[] consents;
    public String[] identifiers;
    public String[] patProfs;
    public String[] patValues;
    public String b2binfos;
    public IEditableDataObjectList<XConsentement> lstConsentement;
    public IEditableDataObjectList<XPatientIdentifier> lstPatientIdentifier;
    public IEditableDataObjectList<XPatientProfessionnal> lstPatientProfessionnal;
    public XPatientB2b b2bInformation;
    public boolean mustDeleteFutureAppointmentAndReccallOnDelete = false;
    public IEditableDataObjectList<XPatientValue> lstPatientAlerts;
    public Integer id;
    public String niu;
    public IntAVLTreeSet allIds;
    public String healthInsuranceNumber;
    public String patientRecordNumber;
    public Short bloodType;
    public String messageAppointment;
    public LocalDate lastVerificationDate;
    public LocalDate lastActivityDate;
    public String expirationCAM;
    public String fatherName;
    public String spouseName;
    public String motherName;
    public String tutorName;
    public String fatherHin;
    public String motherHin;
    public Integer lastProfileVersion;
    public Integer treatingProfessionnal;
    public Boolean isSensible;
    public Boolean isScanned;
    public String custodyTerms;
    public Integer motherId;
    public Integer fatherId;
    public Integer tutorId;
    public XPatient mother;
    public XPatient father;
    public XPatient tutor;
    public PartialDate inactiveDate;
    public XPatientInactiveRaison inactiveRaison;
    public Boolean sofyAuthorized;
    public Integer idSofyLink;
    public short sofyGuardianAccess;
    public static Comparator<IDataObject> idComparator = new Comparator<IDataObject>(){

        @Override
        public int compare(IDataObject o1, IDataObject o2) {
            return o1.getId().compareTo(o2.getId());
        }
    };
    public static Comparator<XPatient> namNameDdnComparator = new Comparator<XPatient>(){

        @Override
        public int compare(XPatient o1, XPatient o2) {
            String n1 = StringUtils.isBlank((CharSequence)o1.getHealthInsuranceNumber()) ? null : o1.getHealthInsuranceNumber();
            String n2 = StringUtils.isBlank((CharSequence)o2.getHealthInsuranceNumber()) ? null : o2.getHealthInsuranceNumber();
            int c1 = Comparators.compareAscNullsFirst(n1, n2);
            if (c1 == 0 && (c1 = Comparators.compareAscNullsFirst(o1.getLastName(), o2.getLastName())) == 0 && (c1 = Comparators.compareAscNullsFirst(o1.getFirstName(), o2.getFirstName())) == 0) {
                c1 = Comparators.compareAscNullsFirst(o1.getBirthDate() == null ? null : new Integer(o1.getBirthDate().dayFrom1970), o2.getBirthDate() == null ? null : new Integer(o2.getBirthDate().dayFrom1970));
            }
            return c1;
        }
    };

    public XPatient() {
        this.setPersonType(XPersonType.PAT);
    }

    @Override
    public void write(Kryo k, Output out) {
        short i;
        out.writeInt(MiscUtil.fromInt(this.id));
        out.writeString(MiscUtil.fromString(this.niu));
        k.writeObjectOrNull(out, (Object)this.allIds, IntAVLTreeSet.class);
        out.writeString(MiscUtil.fromString(this.healthInsuranceNumber));
        out.writeString(MiscUtil.fromString(this.patientRecordNumber));
        out.writeShort((int)MiscUtil.fromShort(this.bloodType));
        out.writeString(MiscUtil.fromString(this.messageAppointment));
        out.writeShort((int)MiscUtil.fromLocalDateToShort(this.lastVerificationDate));
        out.writeShort((int)MiscUtil.fromLocalDateToShort(this.lastActivityDate));
        out.writeString(MiscUtil.fromString(this.expirationCAM));
        out.writeString(MiscUtil.fromString(this.fatherName));
        out.writeString(MiscUtil.fromString(this.spouseName));
        out.writeString(MiscUtil.fromString(this.motherName));
        out.writeString(MiscUtil.fromString(this.fatherHin));
        out.writeString(MiscUtil.fromString(this.motherHin));
        out.writeString(MiscUtil.fromString(this.tutorName));
        out.writeInt(MiscUtil.fromInt(this.lastProfileVersion));
        out.writeInt(MiscUtil.fromInt(this.treatingProfessionnal));
        out.writeByte(MiscUtil.fromBoolean(this.isSensible));
        out.writeByte(MiscUtil.fromBoolean(this.isScanned));
        out.writeString(MiscUtil.fromString(this.custodyTerms));
        out.writeInt(MiscUtil.fromInt(this.motherId));
        out.writeInt(MiscUtil.fromInt(this.fatherId));
        out.writeInt(MiscUtil.fromInt(this.tutorId));
        boolean noNam = StringUtils.isEmpty((CharSequence)this.healthInsuranceNumber);
        if (noNam) {
            if (this.motherId != null) {
                k.writeObjectOrNull(out, (Object)this.mother, XPatient.class);
            }
            if (this.fatherId != null) {
                k.writeObjectOrNull(out, (Object)this.father, XPatient.class);
            }
            if (this.tutorId != null) {
                k.writeObjectOrNull(out, (Object)this.tutor, XPatient.class);
            }
        }
        out.writeByte(MiscUtil.fromBoolean(this.sofyAuthorized));
        out.writeShort((int)MiscUtil.fromShort(this.sofyGuardianAccess));
        out.writeInt(MiscUtil.fromInt(this.idSofyLink));
        k.writeObjectOrNull(out, (Object)this.inactiveDate, PartialDate.class);
        k.writeObjectOrNull(out, (Object)this.inactiveRaison, XPatientInactiveRaison.class);
        short size = (short)(this.lstConsentement == null ? 0 : this.lstConsentement.size());
        out.writeShort((int)size);
        if (size > 0) {
            for (i = 0; i < size; i = (short)(i + 1)) {
                k.writeObject(out, this.lstConsentement.get(i));
            }
        }
        size = (short)(this.lstPatientIdentifier == null ? 0 : this.lstPatientIdentifier.size());
        out.writeShort((int)size);
        if (size > 0) {
            for (i = 0; i < size; i = (short)(i + 1)) {
                k.writeObject(out, this.lstPatientIdentifier.get(i));
            }
        }
        size = (short)(this.lstPatientProfessionnal == null ? 0 : this.lstPatientProfessionnal.size());
        out.writeShort((int)size);
        if (size > 0) {
            for (i = 0; i < size; i = (short)(i + 1)) {
                k.writeObject(out, this.lstPatientProfessionnal.get(i));
            }
        }
        k.writeObjectOrNull(out, (Object)this.b2bInformation, XPatientB2b.class);
        out.writeBoolean(this.mustDeleteFutureAppointmentAndReccallOnDelete);
        size = (short)(this.lstPatientAlerts == null ? 0 : this.lstPatientAlerts.size());
        out.writeShort((int)size);
        if (size > 0) {
            for (i = 0; i < size; i = (short)(i + 1)) {
                XPatientValue xPatientValue = (XPatientValue)this.lstPatientAlerts.get(i);
                if (xPatientValue.getIdPatientAnchor() == null) {
                    xPatientValue.setIdPatientAnchor(this.getId());
                }
                k.writeObject(out, (Object)xPatientValue);
            }
        }
        super.write(k, out);
    }

    @Override
    public void read(Kryo k, Input in) {
        this.id = MiscUtil.toInt(in.readInt());
        this.niu = MiscUtil.toString(in.readString());
        this.allIds = (IntAVLTreeSet)k.readObjectOrNull(in, IntAVLTreeSet.class);
        this.healthInsuranceNumber = MiscUtil.toString(in.readString());
        this.patientRecordNumber = MiscUtil.toString(in.readString());
        this.bloodType = MiscUtil.toShort(in.readShort());
        this.messageAppointment = MiscUtil.toString(in.readString());
        this.lastVerificationDate = MiscUtil.toLocalDate(in.readShort());
        this.lastActivityDate = MiscUtil.toLocalDate(in.readShort());
        this.expirationCAM = MiscUtil.toString(in.readString());
        this.fatherName = MiscUtil.toString(in.readString());
        this.spouseName = MiscUtil.toString(in.readString());
        this.motherName = MiscUtil.toString(in.readString());
        this.fatherHin = MiscUtil.toString(in.readString());
        this.motherHin = MiscUtil.toString(in.readString());
        this.tutorName = MiscUtil.toString(in.readString());
        this.lastProfileVersion = MiscUtil.toInt(in.readInt());
        this.treatingProfessionnal = MiscUtil.toInt(in.readInt());
        this.isSensible = MiscUtil.toBoolean(in.readByte());
        this.isScanned = MiscUtil.toBoolean(in.readByte());
        this.custodyTerms = MiscUtil.toString(in.readString());
        this.motherId = MiscUtil.toInt(in.readInt());
        this.fatherId = MiscUtil.toInt(in.readInt());
        this.tutorId = MiscUtil.toInt(in.readInt());
        boolean noNam = StringUtils.isEmpty((CharSequence)this.healthInsuranceNumber);
        if (noNam) {
            if (this.motherId != null) {
                this.mother = (XPatient)k.readObjectOrNull(in, XPatient.class);
            }
            if (this.fatherId != null) {
                this.father = (XPatient)k.readObjectOrNull(in, XPatient.class);
            }
            if (this.tutorId != null) {
                this.tutor = (XPatient)k.readObjectOrNull(in, XPatient.class);
            }
        }
        this.sofyAuthorized = MiscUtil.toBoolean(in.readByte());
        this.sofyGuardianAccess = MiscUtil.toShort(in.readShort());
        this.idSofyLink = MiscUtil.toInt(in.readInt());
        this.inactiveDate = (PartialDate)k.readObjectOrNull(in, PartialDate.class);
        this.inactiveRaison = (XPatientInactiveRaison)k.readObjectOrNull(in, XPatientInactiveRaison.class);
        short b = in.readShort();
        this.lstConsentement = MiscUtil.extracted(k, in, b, XConsentement.class);
        b = in.readShort();
        this.lstPatientIdentifier = MiscUtil.extracted(k, in, b, XPatientIdentifier.class);
        b = in.readShort();
        this.lstPatientProfessionnal = MiscUtil.extracted(k, in, b, XPatientProfessionnal.class);
        this.b2bInformation = (XPatientB2b)k.readObjectOrNull(in, XPatientB2b.class);
        this.mustDeleteFutureAppointmentAndReccallOnDelete = in.readBoolean();
        b = in.readShort();
        this.lstPatientAlerts = MiscUtil.extracted(k, in, b, XPatientValue.class);
        super.read(k, in);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.setHealthInsuranceNumber("");
        this.setPatientRecordNumber("");
        this.setBloodType((Short)0);
        this.setMessageAppointment("");
        this.setExpirationCAM("");
        this.setFatherName("");
        this.setSpouseName("");
        this.setMotherName("");
        this.setLastProfileVersion(0);
        this.setLstPatientProfessionnal(new EditableDataObjectList<XPatientProfessionnal>());
        this.setPatientIdentifier(new EditableDataObjectList<XPatientIdentifier>());
        this.setB2bInformation(new XPatientB2b());
        this.setLstPatientAlerts(new EditableDataObjectList<XPatientValue>());
        this.setConsentement(new EditableDataObjectList<XConsentement>());
        this.setIsDeleted(false);
        this.setNeutral();
        this.setAllIds(new IntAVLTreeSet());
        this.setPersonType(XPersonType.PAT);
    }

    @Override
    public boolean isDirty() {
        boolean dirty = super.isDirty();
        dirty = dirty || this.lstConsentement != null && this.lstConsentement.isDirty();
        dirty = dirty || this.lstPatientIdentifier != null && this.lstPatientIdentifier.isDirty();
        dirty = dirty || this.lstPatientProfessionnal != null && this.lstPatientProfessionnal.isDirty();
        dirty = dirty || this.lstPatientAlerts != null && this.lstPatientAlerts.isDirty();
        dirty = dirty || this.b2bInformation != null && this.b2bInformation.isDirty();
        return dirty;
    }

    @Override
    public String getFormatedHealthInsuranceNumber() {
        return XPatient.getFormatedHealthInsuranceNumber(this.healthInsuranceNumber);
    }

    @Override
    public String getFormatedExpirationCAM() {
        return XPatient.getFormatedExpirationCAM(this.expirationCAM);
    }

    @Override
    public String getFormatedPatientRecordNumber() {
        return this.patientRecordNumber == null ? "" : this.patientRecordNumber.trim();
    }

    public IEditableDataObjectList<XConsentement> getConsentement() {
        return this.lstConsentement;
    }

    public void setConsentement(IEditableDataObjectList<XConsentement> lst) {
        this.lstConsentement = lst;
        this.setUpdated();
    }

    public IEditableDataObjectList<XPatientIdentifier> getLstPatientIdentifier() {
        return this.lstPatientIdentifier;
    }

    public void setPatientIdentifier(IEditableDataObjectList<XPatientIdentifier> lstPatientIdentifier) {
        this.lstPatientIdentifier = lstPatientIdentifier;
        this.setUpdated();
    }

    @Override
    public Integer getId() {
        if (this.id != null && Integer.MIN_VALUE == this.id) {
            return null;
        }
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        if (id != null && Integer.MIN_VALUE == id) {
            id = null;
        }
        this.id = id;
        this.setUpdated();
    }

    public void setAllIds(IntAVLTreeSet allIds) {
        this.allIds = allIds;
        this.setUpdated();
    }

    public void setBloodType(short bloodType) {
        this.bloodType = bloodType;
        this.setUpdated();
    }

    public void setLastProfileVersion(int lastProfileVersion) {
        this.lastProfileVersion = lastProfileVersion;
        this.setUpdated();
    }

    public void setTreatingProfessionnal(int treatingProfessionnal) {
        this.treatingProfessionnal = treatingProfessionnal;
        this.setUpdated();
    }

    @Override
    public String getHealthInsuranceNumber() {
        return this.healthInsuranceNumber;
    }

    public void setHealthInsuranceNumber(String healthInsuranceNumber) {
        this.healthInsuranceNumber = healthInsuranceNumber;
        this.setUpdated();
    }

    @Override
    public String getPatientRecordNumber() {
        return this.patientRecordNumber;
    }

    public void setPatientRecordNumber(String patientRecordNumber) {
        this.patientRecordNumber = patientRecordNumber;
        this.setUpdated();
    }

    @Override
    public Short getBloodType() {
        return this.bloodType;
    }

    public void setBloodType(Short bloodType) {
        this.bloodType = bloodType;
        this.setUpdated();
    }

    @Override
    public String getMessageAppointment() {
        return this.messageAppointment;
    }

    public void setMessageAppointment(String messageAppointment) {
        this.messageAppointment = messageAppointment;
        this.setUpdated();
    }

    @Override
    public LocalDate getLastVerificationDate() {
        return this.lastVerificationDate;
    }

    public void setLastVerificationDate(LocalDate lastVerificationDate) {
        this.lastVerificationDate = lastVerificationDate;
        this.setUpdated();
    }

    @Override
    public LocalDate getLastActivityDate() {
        return this.lastActivityDate;
    }

    public void setLastActivityDate(LocalDate lastActivityDate) {
        this.lastActivityDate = lastActivityDate;
        this.setUpdated();
    }

    @Override
    public String getExpirationCAM() {
        return this.expirationCAM;
    }

    public String[] getExpirationCAMYearAndMonth() {
        if (this.expirationCAM == null) {
            return null;
        }
        if (this.expirationCAM.length() == 4) {
            String[] s = new String[]{"20" + this.expirationCAM.substring(0, 2), this.expirationCAM.substring(2, 4)};
            return s;
        }
        return null;
    }

    public void setExpirationCAM(PartialDate date) {
        if (date == null) {
            this.setExpirationCAM((String)null);
        } else {
            if (date.getYear() == null) {
                throw new IllegalArgumentException("date.year is required");
            }
            if (date.getMonth() == null) {
                throw new IllegalArgumentException("date.month is required");
            }
            String year2lastDigits = String.valueOf(date.getYear() % 100);
            String month = StringUtils.leftPad((String)date.getMonth().toString(), (int)2, (char)'0');
            this.setExpirationCAM(year2lastDigits + month);
        }
    }

    public void setExpirationCAM(String expirationCAM) {
        this.expirationCAM = expirationCAM;
        this.setUpdated();
    }

    @Override
    public String getFatherName() {
        return this.fatherName;
    }

    public void setFatherName(String fatherName) {
        if (!MiscUtil.objectsAreEquals(this.fatherName, fatherName)) {
            this.fatherName = fatherName;
            this.setUpdated();
        }
    }

    @Override
    public String getSpouseName() {
        return this.spouseName;
    }

    public void setSpouseName(String spouseName) {
        this.spouseName = spouseName;
        this.setUpdated();
    }

    @Override
    public String getMotherName() {
        return this.motherName;
    }

    public void setMotherName(String motherName) {
        if (!MiscUtil.objectsAreEquals(this.motherName, motherName)) {
            this.motherName = motherName;
            this.setUpdated();
        }
    }

    public final String getFatherHin() {
        return this.fatherHin;
    }

    public final void setFatherHin(String fatherHin) {
        if (!MiscUtil.objectsAreEquals(this.fatherHin, fatherHin)) {
            this.fatherHin = fatherHin;
            this.setUpdated();
        }
    }

    public final String getMotherHin() {
        return this.motherHin;
    }

    public final void setMotherHin(String motherHin) {
        if (!MiscUtil.objectsAreEquals(this.motherHin, motherHin)) {
            this.motherHin = motherHin;
            this.setUpdated();
        }
    }

    @Override
    public Integer getLastProfileVersion() {
        return this.lastProfileVersion;
    }

    public void setLastProfileVersion(Integer lastProfileVersion) {
        this.lastProfileVersion = lastProfileVersion;
        this.setUpdated();
    }

    @Override
    public Integer getTreatingProfessionnal() {
        return this.treatingProfessionnal;
    }

    public void setTreatingProfessionnal(Integer treatingProfessionnal) {
        this.treatingProfessionnal = treatingProfessionnal;
        this.setUpdated();
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof XPatient) {
            equals = this.getId() == null ? super.equals(obj) : this.hashCode() == obj.hashCode();
        }
        return equals;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : ("XPatient" + this.getId().hashCode()).hashCode();
        return hashCode;
    }

    @Override
    public XPatient clone() {
        XPatient c = (XPatient)super.clone();
        c.id = this.id;
        c.healthInsuranceNumber = this.healthInsuranceNumber;
        c.patientRecordNumber = this.patientRecordNumber;
        c.bloodType = this.bloodType;
        c.messageAppointment = this.messageAppointment;
        c.lastVerificationDate = this.lastVerificationDate == null ? null : this.lastVerificationDate.clone();
        c.lastActivityDate = this.lastActivityDate == null ? null : this.lastActivityDate.clone();
        c.expirationCAM = this.expirationCAM;
        c.fatherName = this.fatherName;
        c.spouseName = this.spouseName;
        c.motherName = this.motherName;
        c.tutorName = this.tutorName;
        c.tutorId = this.tutorId;
        c.fatherId = this.fatherId;
        c.motherId = this.motherId;
        c.lastProfileVersion = this.lastProfileVersion;
        c.isSensible = this.isSensible;
        c.isScanned = this.isScanned;
        c.treatingProfessionnal = this.treatingProfessionnal;
        c.b2binfos = this.b2binfos;
        c.b2bInformation = this.b2bInformation == null ? null : this.b2bInformation.clone();
        c.mustDeleteFutureAppointmentAndReccallOnDelete = this.mustDeleteFutureAppointmentAndReccallOnDelete;
        c.inactiveDate = this.inactiveDate == null ? null : this.inactiveDate.clone();
        c.inactiveRaison = this.inactiveRaison;
        c.custodyTerms = this.custodyTerms;
        if (this.mother != null) {
            c.mother = this.mother.clone();
        }
        if (this.father != null) {
            c.father = this.father.clone();
        }
        if (this.tutor != null) {
            c.tutor = this.tutor.clone();
        }
        if (this.consents != null) {
            c.consents = new String[this.consents.length];
            System.arraycopy(this.consents, 0, c.consents, 0, this.consents.length);
        }
        if (this.identifiers != null) {
            c.identifiers = new String[this.identifiers.length];
            System.arraycopy(this.identifiers, 0, c.identifiers, 0, this.identifiers.length);
        }
        if (this.patProfs != null) {
            c.patProfs = new String[this.patProfs.length];
            System.arraycopy(this.patProfs, 0, c.patProfs, 0, this.patProfs.length);
        }
        if (this.lstConsentement != null) {
            c.lstConsentement = this.lstConsentement.deepClone();
        }
        if (this.lstPatientIdentifier != null) {
            c.lstPatientIdentifier = this.lstPatientIdentifier.deepClone();
        }
        if (this.lstPatientProfessionnal != null) {
            c.lstPatientProfessionnal = this.lstPatientProfessionnal.deepClone();
        }
        if (this.lstPatientAlerts != null) {
            c.lstPatientAlerts = this.lstPatientAlerts.deepClone();
        }
        if (this.allIds != null) {
            c.allIds = new IntAVLTreeSet((IntSortedSet)this.allIds);
        }
        c.niu = this.niu;
        c.sofyAuthorized = this.sofyAuthorized;
        c.sofyGuardianAccess = this.sofyGuardianAccess;
        return c;
    }

    public void setGuardianAccessAccepted(Integer idGuardian) {
        short guardianAccess = this.getSofyGuardianAccess();
        if (XPatient.isGuardianValid(this.getMother(), idGuardian)) {
            this.setSofyGuardianAccess((short)(guardianAccess | 0x80));
        } else if (XPatient.isGuardianValid(this.getFather(), idGuardian)) {
            this.setSofyGuardianAccess((short)(guardianAccess | 0x100));
        } else if (XPatient.isGuardianValid(this.getTutor(), idGuardian)) {
            this.setSofyGuardianAccess((short)(guardianAccess | 0x200));
        }
    }

    public boolean getGuardianAccessAccepted(Integer idGuardian) {
        short guardianAccess = this.getSofyGuardianAccess();
        if (XPatient.isGuardianValid(this.getMother(), idGuardian)) {
            return (guardianAccess & 0x80) != 0;
        }
        if (XPatient.isGuardianValid(this.getFather(), idGuardian)) {
            return (guardianAccess & 0x100) != 0;
        }
        if (XPatient.isGuardianValid(this.getTutor(), idGuardian)) {
            return (guardianAccess & 0x200) != 0;
        }
        return false;
    }

    public void setGuardianAccessLocked(Integer idGuardian) {
        short guardianAccess = this.getSofyGuardianAccess();
        if (XPatient.isGuardianValid(this.getMother(), idGuardian)) {
            this.setSofyGuardianAccess((short)(guardianAccess | 0x10));
        } else if (XPatient.isGuardianValid(this.getFather(), idGuardian)) {
            this.setSofyGuardianAccess((short)(guardianAccess | 0x20));
        } else if (XPatient.isGuardianValid(this.getTutor(), idGuardian)) {
            this.setSofyGuardianAccess((short)(guardianAccess | 0x40));
        }
    }

    public void removeGuardianAccess(Integer idGuardian) {
        short guardianAccess = this.getSofyGuardianAccess();
        if (XPatient.isGuardianValid(this.getMother(), idGuardian)) {
            this.setSofyGuardianAccess((short)(guardianAccess | 1));
        } else if (XPatient.isGuardianValid(this.getFather(), idGuardian)) {
            this.setSofyGuardianAccess((short)(guardianAccess | 2));
        } else if (XPatient.isGuardianValid(this.getTutor(), idGuardian)) {
            this.setSofyGuardianAccess((short)(guardianAccess | 4));
        }
    }

    public boolean getGuardianAccessLocked(Integer idGuardian) {
        short guardianAccess = this.getSofyGuardianAccess();
        if (XPatient.isGuardianValid(this.getMother(), idGuardian)) {
            return (guardianAccess & 0x10) != 0;
        }
        if (XPatient.isGuardianValid(this.getFather(), idGuardian)) {
            return (guardianAccess & 0x20) != 0;
        }
        if (XPatient.isGuardianValid(this.getTutor(), idGuardian)) {
            return (guardianAccess & 0x40) != 0;
        }
        return false;
    }

    public static boolean isDependentWithSofyAccess(Integer idGuardian, XPatient child) {
        Short age = child.getAge();
        short sofyGuardianAccess = child.getSofyGuardianAccess();
        if (XPatient.isGuardianValid(child.getMother(), idGuardian) && XPatient.hasSofyAccess(0, sofyGuardianAccess, age)) {
            return true;
        }
        if (XPatient.isGuardianValid(child.getFather(), idGuardian) && XPatient.hasSofyAccess(1, sofyGuardianAccess, age)) {
            return true;
        }
        return XPatient.isGuardianValid(child.getTutor(), idGuardian) && XPatient.hasSofyAccess(2, sofyGuardianAccess, age);
    }

    public static boolean isGuardianValid(XPatient guardian, Integer idGuardian) {
        return guardian != null && guardian.getId().equals(idGuardian);
    }

    public static boolean hasSofyAccess(int cursor, short sofyGuardianAccess, Short age) {
        return (sofyGuardianAccess & 1 << cursor) != 0 && XPatient.patientLessThan14OrPermanentAccess(sofyGuardianAccess, age);
    }

    public static boolean hasPermanentSofyAccess(short sofyGuardianAccess) {
        return (sofyGuardianAccess & 8) != 0;
    }

    public static boolean patientLessThan14OrPermanentAccess(short sofyGuardianAccess, Short age) {
        return age != null && age <= 14 || XPatient.hasPermanentSofyAccess(sofyGuardianAccess);
    }

    @Override
    public String toString() {
        String ret = this.str;
        if (ret == null) {
            ret = this.isNewOrNewUpdated() ? (StringUtils.isBlank((CharSequence)this.getLastName()) && StringUtils.isBlank((CharSequence)this.getFirstName()) ? Messages.getString("NOUVEAU_CLIENT", new String[0]) : this.getNameBirthdateSex()) : this.getNameBirthdateSex();
        }
        return ret;
    }

    @Override
    public String getNiu() {
        return this.niu;
    }

    public void setNiu(String niu) {
        this.niu = niu;
        this.setUpdated();
    }

    @Override
    public List<Integer> getAllIds() {
        return this.allIds == null ? null : Arrays.asList(this.allIds.toArray((Object[])new Integer[this.allIds.size()]));
    }

    public void setAllIds(List<Integer> allIds) {
        this.allIds = new IntAVLTreeSet(allIds);
    }

    @Override
    public XPatientB2b getB2bInformation() {
        return this.b2bInformation;
    }

    public void setB2bInformation(XPatientB2b b2bInformation) {
        this.b2bInformation = b2bInformation;
        this.setUpdated();
    }

    @Override
    public Boolean getIsSensible() {
        return this.isSensible;
    }

    public void setIsSensible(Boolean isSensible) {
        this.isSensible = isSensible;
        this.setUpdated();
    }

    @Override
    public Boolean getIsScanned() {
        return this.isScanned;
    }

    public void setIsScanned(Boolean isScanned) {
        this.isScanned = isScanned;
        this.setUpdated();
    }

    public IEditableDataObjectList<XPatientValue> getLstPatientAlerts() {
        return this.lstPatientAlerts;
    }

    public void setLstPatientAlerts(IEditableDataObjectList<XPatientValue> patientAlerts) {
        this.lstPatientAlerts = patientAlerts;
    }

    @Override
    public String getCustodyTerms() {
        return this.custodyTerms;
    }

    public void setCustodyTerms(String custodyTerms) {
        this.custodyTerms = custodyTerms;
        this.setUpdated();
    }

    @Override
    public XPatient getMother() {
        return this.mother;
    }

    public void setMother(XPatient mother) {
        this.mother = mother;
        boolean notEqualsIds = !MiscUtil.objectsAreEquals(this.motherId, mother == null ? null : mother.getId());
        this.motherId = mother == null || mother.getId() == null ? null : mother.getId();
        if (notEqualsIds) {
            this.setUpdated();
        }
    }

    @Override
    public XPatient getFather() {
        return this.father;
    }

    public void setFather(XPatient father) {
        this.father = father;
        boolean notEqualsIds = !MiscUtil.objectsAreEquals(this.fatherId, father == null ? null : father.getId());
        this.fatherId = father == null || father.getId() == null ? null : Integer.valueOf(father.getId());
        if (notEqualsIds) {
            this.setUpdated();
        }
    }

    @Override
    public XPatient getTutor() {
        return this.tutor;
    }

    public void setTutor(XPatient tutor) {
        this.tutor = tutor;
        boolean notEqualsIds = !MiscUtil.objectsAreEquals(this.tutorId, tutor == null ? null : tutor.getId());
        this.tutorId = tutor == null || tutor.getId() == null ? null : Integer.valueOf(tutor.getId());
        if (notEqualsIds) {
            this.setUpdated();
        }
    }

    @Override
    public String getTutorName() {
        return this.tutorName;
    }

    public void setTutorName(String tutorName) {
        if (!MiscUtil.objectsAreEquals(this.tutorName, tutorName)) {
            this.tutorName = tutorName;
            this.setUpdated();
        }
    }

    @Override
    public Integer getMotherId() {
        return this.motherId;
    }

    public void setMotherId(Integer motherId) {
        this.motherId = motherId;
    }

    @Override
    public Integer getFatherId() {
        return this.fatherId;
    }

    public void setFatherId(Integer fatherId) {
        this.fatherId = fatherId;
    }

    @Override
    public Integer getTutorId() {
        return this.tutorId;
    }

    public void setTutorId(Integer tutorId) {
        this.tutorId = tutorId;
    }

    public IEditableDataObjectList<XPatientProfessionnal> getLstPatientProfessionnal() {
        return this.lstPatientProfessionnal;
    }

    public void setLstPatientProfessionnal(IEditableDataObjectList<XPatientProfessionnal> lstPatientProfessionnal) {
        this.lstPatientProfessionnal = lstPatientProfessionnal;
    }

    @Override
    public IPartialDate getInactiveDate() {
        return this.inactiveDate;
    }

    public void setInactiveDate(IPartialDate inactiveDate) {
        this.inactiveDate = PartialDate.from((LocalDate)LocalDate.from((IPartialDate)inactiveDate));
    }

    @Override
    public XPatientInactiveRaison getInactiveRaison() {
        return this.inactiveRaison;
    }

    public void setInactiveRaison(XPatientInactiveRaison inactiveRaison) {
        this.inactiveRaison = inactiveRaison;
    }

    @Override
    public Boolean getSofyAuthorized() {
        return this.sofyAuthorized;
    }

    public void setSofyAuthorized(Boolean sofyAuthorized) {
        this.sofyAuthorized = sofyAuthorized;
        this.setUpdated();
    }

    @Override
    public short getSofyGuardianAccess() {
        return this.sofyGuardianAccess;
    }

    public void setSofyGuardianAccess(short sofyGuardianAccess) {
        this.sofyGuardianAccess = sofyGuardianAccess;
        this.setUpdated();
    }

    public Integer getIdSofyLink() {
        return this.idSofyLink;
    }

    public void setIdSofyLink(Integer idSofyLink) {
        this.idSofyLink = idSofyLink;
    }

    @Override
    public boolean hasActiveConsentement(Integer idUser, int right) {
        boolean showToAll = true;
        IEditableDataObjectList<XConsentement> list = this.lstConsentement;
        if (list != null && list.size() > 0) {
            showToAll = false;
            for (XConsentement consentement : list) {
                if (idUser == null || !idUser.equals(consentement.getIdUserAnchor()) || !consentement.hasRight(right)) continue;
                return true;
            }
        }
        return showToAll;
    }

    @Override
    public final boolean getShowToAllAndConsent(XConsentement consent, Integer idUser) {
        if (consent == null) {
            throw new NullPointerException("consent");
        }
        boolean showToAll = true;
        IEditableDataObjectList<XConsentement> list = this.lstConsentement;
        if (list != null && list.size() > 0) {
            showToAll = false;
            for (XConsentement consentement : list) {
                if (idUser == null || !idUser.equals(consentement.getIdUserAnchor())) continue;
                consent.droits = consentement.droits;
                consent.datetimeStart = consentement.datetimeStart;
                break;
            }
        }
        return showToAll;
    }

    public static void generateSousObjectFromStringArrays(XPatient patient) {
        GenericDataMapping gdm = new GenericDataMapping();
        if (patient.sites != null && patient.sites.length > 0) {
            gdm.setList(patient.getLstSites(), XPersonSite.class, null, patient.sites);
            for (XPersonSite xPersonSite : patient.getLstSites()) {
                xPersonSite.setNeutral();
            }
            patient.sites = null;
        }
        if (patient.consents != null && patient.consents.length > 0) {
            gdm.setList(patient.lstConsentement, XConsentement.class, null, patient.consents);
            for (XConsentement xConsentement : patient.getConsentement()) {
                xConsentement.setNeutral();
            }
            patient.consents = null;
        }
        if (StringUtils.isNotEmpty((CharSequence)patient.b2binfos)) {
            Iterator lstTemp = new ArrayList();
            gdm.setList((List)((Object)lstTemp), XPatientB2b.class, XVulnerability.class, new String[]{patient.b2binfos});
            if (!lstTemp.isEmpty()) {
                if (patient.getId().equals(((XPatientB2b)lstTemp.get(0)).getIdPatientRepresentative())) {
                    ((XPatientB2b)lstTemp.get((int)0)).idPatientRepresentative = null;
                    ((XPatientB2b)lstTemp.get((int)0)).patientRepresentativeType = XPatientRepresentativeType.SO;
                }
                ((XPatientB2b)lstTemp.get(0)).setNeutral();
                for (XVulnerability xVuln : ((XPatientB2b)lstTemp.get(0)).getVulnerabilities()) {
                    xVuln.setNeutral();
                }
                patient.b2bInformation = (XPatientB2b)lstTemp.get(0);
            }
            patient.b2binfos = null;
        }
        if (patient.identifiers != null && patient.identifiers.length > 0) {
            gdm.setList(patient.lstPatientIdentifier, XPatientIdentifier.class, null, patient.identifiers);
            for (XPatientIdentifier xPatientIdentifier : patient.getLstPatientIdentifier()) {
                xPatientIdentifier.setNeutral();
                xPatientIdentifier.getType().setNeutral();
            }
            Collections.sort(patient.getLstPatientIdentifier(), idComparator);
            patient.identifiers = null;
        }
        if (patient.patProfs != null && patient.patProfs.length > 0) {
            gdm.setList(patient.lstPatientProfessionnal, XPatientProfessionnal.class, null, patient.patProfs);
            for (XPatientProfessionnal xPatientProfessionnal : patient.getLstPatientProfessionnal()) {
                xPatientProfessionnal.setNeutral();
            }
            Collections.sort(patient.getLstPatientProfessionnal(), idComparator);
            patient.patProfs = null;
        }
        if (patient.patValues != null && patient.patValues.length > 0) {
            EditableDataObjectList ptVal = new EditableDataObjectList();
            gdm.setList(ptVal, XPatientValue.class, null, patient.patValues);
            ArrayList<XPatientValue> arrayList = new ArrayList<XPatientValue>();
            ArrayList<XPatientValue> listAlertes = new ArrayList<XPatientValue>();
            for (XPatientValue xc : ptVal) {
                xc.setNeutral();
                if ("patient_alert".equals(xc.getKey())) {
                    listAlertes.add(xc);
                    continue;
                }
                if (!"last_pharma_update".equals(xc.getKey())) continue;
                arrayList.add(xc);
            }
            for (XPatientValue pv : listAlertes) {
                if (pv == null || !StringUtils.isNotBlank((CharSequence)pv.getValue()) || pv.getValue().length() < 2) continue;
                String splitter = pv.getValue().substring(0, 1);
                String[] split = pv.getValue().substring(1).split("[" + splitter + "]");
                int count = 0;
                for (String s : split) {
                    XPatientValue xpv = new XPatientValue(pv.getKey(), s);
                    xpv.id = pv.getId() + count++;
                    xpv.idPatientAnchor = pv.idPatientAnchor != null ? pv.idPatientAnchor : null;
                    patient.getLstPatientAlerts().add(xpv);
                }
            }
            Collections.sort(patient.getLstPatientAlerts(), idComparator);
            patient.patValues = null;
        }
    }

    @Override
    public XInscriptionStatus getB2bStatus() {
        if (this.b2bInformation != null && this.b2bInformation.status != null) {
            return this.b2bInformation.status;
        }
        return XInscriptionStatus.NON_INSCRIT;
    }

    @Override
    public XDisabilityCode getXDisabilityCode(int i) {
        if (this.b2bInformation != null && this.b2bInformation.getVulnerabilities() != null && this.b2bInformation.getVulnerabilities().size() > i) {
            return this.b2bInformation.getVulnerabilities().get(i).getDisCode();
        }
        return XDisabilityCode.C00;
    }

    @Override
    public LocalDate getXDisabilityDate(int i) {
        if (this.b2bInformation != null && this.b2bInformation.getVulnerabilities() != null && this.b2bInformation.getVulnerabilities().size() > i) {
            return this.b2bInformation.getVulnerabilities().get(i).getDate();
        }
        return null;
    }

    @Override
    public XDisabilityCode getB2bDisabilityCode1() {
        return this.getXDisabilityCode(0);
    }

    @Override
    public XDisabilityCode getB2bDisabilityCode2() {
        return this.getXDisabilityCode(1);
    }

    @Override
    public XDisabilityCode getB2bDisabilityCode3() {
        return this.getXDisabilityCode(2);
    }

    @Override
    public LocalDate getB2bDisabilityDate1() {
        return this.getXDisabilityDate(0);
    }

    @Override
    public LocalDate getB2bDisabilityDate2() {
        return this.getXDisabilityDate(1);
    }

    @Override
    public LocalDate getB2bDisabilityDate3() {
        return this.getXDisabilityDate(2);
    }

    public static String getFormatedHealthInsuranceNumber(String s) {
        String number = "";
        if (s != null) {
            String healthInsuranceNumber = s.trim();
            number = healthInsuranceNumber != null && healthInsuranceNumber.length() == 12 ? healthInsuranceNumber.substring(0, 4) + " " + healthInsuranceNumber.substring(4, 8) + " " + healthInsuranceNumber.substring(8, 12) : (healthInsuranceNumber != null && healthInsuranceNumber.length() == 9 ? healthInsuranceNumber.substring(0, 3) + " " + healthInsuranceNumber.substring(3, 6) + " " + healthInsuranceNumber.substring(6, 9) : healthInsuranceNumber);
        }
        return number;
    }

    public static String getFormatedExpirationCAM(String s) {
        String number = "";
        if (s != null && s.length() == 4) {
            number = s.substring(0, 2) + "/" + s.substring(2, 4);
        }
        return number;
    }

    public static boolean isExpiredCAM(String s, LocalDate referenceDate) {
        boolean expired = false;
        if (StringUtils.isNotBlank((CharSequence)s) && s.length() == 4) {
            try {
                int an = Integer.parseInt("20" + s.substring(0, 2));
                int mois = Integer.parseInt(s.substring(2, 4));
                if (mois >= 0 && mois <= 12) {
                    LocalDate date = LocalDate.from((int)1, (int)mois, (int)an);
                    expired = referenceDate.dayFrom1970 == date.dayFrom1970 || referenceDate.after((IPartialDate)date);
                }
            }
            catch (Exception e) {
                expired = true;
            }
        }
        return expired;
    }
}

