/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.IPatientAccessor;
import ca.infodata.ofys.data.dataaccess.ISearchTextAccessor;
import ca.infodata.ofys.data.dataaccess.XFindPatientSummaryCriteria;
import ca.infodata.ofys.data.middle.dataobjects.PatientFlag;
import ca.infodata.ofys.data.middle.dataobjects.XBasePatient;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XPatientFamilly;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.search.Group;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.util.EnumWithValues;
import ca.infodata.util1.date.LocalDateRange;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;

public class PatientAccessorClient
extends BaseAccessorClient
implements ISearchTextAccessor {
    private static PatientAccessorClient instance;
    private final IPatientAccessor accessor;

    public static PatientAccessorClient getInstance() throws CannotConnectToServerException {
        return PatientAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static PatientAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new PatientAccessorClient(serverConnectionInfo);
        }
        return instance;
    }

    private PatientAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getPatientAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(this.getClass().getName(), "cinit", e2);
            throw e2;
        }
    }

    public void findLastUsed(XSession session, final ICallback callback) {
        if (this.isOkToCallFunction("PatientAccessorClient.findLastUsed", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.findLastUsed());
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            PatientAccessorClient.this.functionCallEnded("PatientAccessorClient.findLastUsed", callback);
                        }
                    }
                    finally {
                        PatientAccessorClient.this.functionCallEnded("PatientAccessorClient.findLastUsed", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getPatientFlag(XSession session, final Integer idPatient, final ICallback callback) {
        if (this.isOkToCallFunction("PatientAccessorClient.getPatientFlag", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject ret = instance.accessor.getPatientFlag(idPatient);
                            callback.response(ret);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            PatientAccessorClient.this.functionCallEnded("PatientAccessorClient.getPatientFlag", callback);
                        }
                    }
                    finally {
                        PatientAccessorClient.this.functionCallEnded("PatientAccessorClient.getPatientFlag", callback);
                    }
                    return callback;
                }
            };
        } else {
            callback.kill();
        }
    }

    public void findPatientIdentifiers(XSession session, final Integer idPatient, final ICallback callback) {
        if (this.isOkToCallFunction("PatientAccessorClient.getPatientFlag", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.findPatientIdentifiers(idPatient));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            PatientAccessorClient.this.functionCallEnded("PatientAccessorClient.getPatientFlag", callback);
                        }
                    }
                    finally {
                        PatientAccessorClient.this.functionCallEnded("PatientAccessorClient.getPatientFlag", callback);
                    }
                    return callback;
                }
            };
        } else {
            callback.kill();
        }
    }

    public ReturnObject findPatientIdentifiersSync(XSession session, Integer idPatient) {
        ReturnObject ro = null;
        if (this.isOkToCallFunction("PatientAccessorClient.findPatientIdentifiers")) {
            try {
                try {
                    ro = PatientAccessorClient.instance.accessor.findPatientIdentifiers(idPatient);
                }
                catch (Exception e) {
                    Log.severe((String)"Erreur", (Exception)e);
                    this.functionCallEnded("PatientAccessorClient.findPatientIdentifiers");
                }
            }
            finally {
                this.functionCallEnded("PatientAccessorClient.findPatientIdentifiers");
            }
        }
        return ro;
    }

    public void getPatientFlagDetail(XSession session, final Integer idPatient, final PatientFlag flagType, final ICallback callback) {
        if (this.isOkToCallFunction("PatientAccessorClient.getPatientFlagDetail", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.getPatientFlagDetail(idPatient, flagType));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            PatientAccessorClient.this.functionCallEnded("PatientAccessorClient.getPatientFlagDetail", callback);
                        }
                    }
                    finally {
                        PatientAccessorClient.this.functionCallEnded("PatientAccessorClient.getPatientFlagDetail", callback);
                    }
                    return callback;
                }
            };
        } else {
            callback.kill();
        }
    }

    public void findMostUsed(XSession session, final ICallback callback) {
        if (this.isOkToCallFunction("PatientAccessorClient.findMostUsed", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.findMostUsed());
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            PatientAccessorClient.this.functionCallEnded("PatientAccessorClient.findMostUsed", callback);
                        }
                    }
                    finally {
                        PatientAccessorClient.this.functionCallEnded("PatientAccessorClient.findMostUsed", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public Object setAsUsed(XSession session, int patientId) {
        ReturnObject returnObject = null;
        if (this.isOkToCallFunction("PatientAccessorClient.setAsUsed")) {
            try {
                try {
                    returnObject = this.accessor.setAsUsed(patientId);
                }
                catch (Exception e) {
                    Log.severe((String)"Erreur", (Exception)e);
                    this.functionCallEnded("PatientAccessorClient.setAsUsed");
                }
            }
            finally {
                this.functionCallEnded("PatientAccessorClient.setAsUsed");
            }
        }
        return returnObject;
    }

    public void getPatient(final int uniqueKey, XSession session, final ICallback callback, final int patientId) {
        if (this.isOkToCallFunction("PatientAccessorClient.getPatient" + uniqueKey, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = PatientAccessorClient.this.accessor.getPatient(patientId);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            PatientAccessorClient.this.functionCallEnded("PatientAccessorClient.getPatient" + uniqueKey, callback);
                        }
                    }
                    finally {
                        PatientAccessorClient.this.functionCallEnded("PatientAccessorClient.getPatient" + uniqueKey, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public XPatient getPatientSync(XSession session, int patientId) throws Exception {
        String function = "PatientAccessorClient.getPatient" + patientId;
        if (this.isOkToCallFunction(function)) {
            try {
                ReturnObject returnObject = this.accessor.getPatient(patientId);
                if (returnObject.getObj() instanceof XPatient[]) {
                    XPatient[] xpts = (XPatient[])returnObject.getObj();
                    if (xpts != null && xpts.length == 1) {
                        XPatient xPatient = xpts[0];
                        return xPatient;
                    }
                    throw new Exception(String.valueOf(xpts == null ? "Patient on trouv\u00e9" : "ai trouv\u00e9 > 1 XPatient") + " pour idPatient:" + patientId);
                }
                if (returnObject.getObj() instanceof XPatient) {
                    XPatient xPatient = (XPatient)(returnObject == null ? null : returnObject.getObj());
                    return xPatient;
                }
                try {
                    System.out.println("N'est pas une instance de XPatient ou XPatient[] : " + (returnObject.getObj() == null ? "returnObject.getObj() is null" : returnObject.getObj().getClass().getName().toString()));
                    throw new Exception("N'est pas une instance de XPatient ou XPatient[]");
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to get Patient " + patientId, e);
                    throw e;
                }
            }
            finally {
                this.functionCallEnded(function);
            }
        }
        return null;
    }

    @Override
    public void findFromSearchText(int uniqueKey, XSession session, ICallback callback, int specialCase, String recordNumber) {
        this.findPatient(session, callback, false, recordNumber, null, null, null, null, null, null, false, null, new Integer(-1), false, null, specialCase != 1, false);
    }

    @Override
    public void findFromId(int uniqueKey, XSession session, final ICallback callback, final int idPatient) {
        if (this.isOkToCallFunction("PatientAccessorClient.getBasePatient", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = PatientAccessorClient.this.accessor.getBasePatient(idPatient);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            PatientAccessorClient.this.functionCallEnded("PatientAccessorClient.findPatient", callback);
                        }
                    }
                    finally {
                        PatientAccessorClient.this.functionCallEnded("PatientAccessorClient.findPatient", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findFamilly(XSession session, final ICallback callback, final int idPatient, final EnumSet<XPatientFamilly> filter) {
        final String key = "PatientAccessorClient.findFamilly" + idPatient + (filter == null ? 0 : filter.hashCode());
        if (this.isOkToCallFunction(key, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            Integer filterValue = EnumWithValues.toSet((EnumSet)filter);
                            ReturnObject returnObject = PatientAccessorClient.this.accessor.findFamilly(idPatient, filterValue);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            PatientAccessorClient.this.functionCallEnded(key, callback);
                        }
                    }
                    finally {
                        PatientAccessorClient.this.functionCallEnded(key, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getSimplePatients(int uniqueKey, XSession session, final ICallback callback, final List<Integer> ids) {
        if (this.isOkToCallFunction("PatientAccessorClient.findSimplePatientFromIds", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = PatientAccessorClient.this.accessor.getSimplePatients(ids);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            PatientAccessorClient.this.functionCallEnded("PatientAccessorClient.findSimplePatientFromIds", callback);
                        }
                    }
                    finally {
                        PatientAccessorClient.this.functionCallEnded("PatientAccessorClient.findSimplePatientFromIds", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findPatient(XSession session, final ICallback callback, final boolean noLimit, final String nameDossier, final String noDossier, final String nam, final String[] dateDernActivite, final String noTelephone, final String[] dateRapp, final String note, final boolean inObjectUsage, final Integer idProfessionnal, final Integer idIntervenant, final boolean rdvsToMove, final List<XSite> sites, final boolean returnOneOrNull, final Boolean deleted) {
        if (this.isOkToCallFunction("PatientAccessorClient.findPatient", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = PatientAccessorClient.this.accessor.findPatient(noLimit, nameDossier, noDossier, nam, dateDernActivite, noTelephone, dateRapp, note, inObjectUsage, idProfessionnal, idIntervenant, rdvsToMove, sites, returnOneOrNull, deleted);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            PatientAccessorClient.this.functionCallEnded("PatientAccessorClient.findPatient", callback);
                        }
                    }
                    finally {
                        PatientAccessorClient.this.functionCallEnded("PatientAccessorClient.findPatient", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findPatientSync(XSession session, ICallback callback, boolean noLimit, String nameDossier, String noDossier, String nam, String[] dateDernActivite, String noTelephone, String[] dateRapp, String note, boolean inObjectUsage, Integer idProfessionnal, Integer idIntervenant, boolean rdvsToMove, List<XSite> sites, boolean returnOneOrNull, Boolean deleted) {
        if (this.isOkToCallFunction("PatientAccessorClient.findPatient", callback)) {
            try {
                try {
                    ReturnObject returnObject = this.accessor.findPatient(noLimit, nameDossier, noDossier, nam, dateDernActivite, noTelephone, dateRapp, note, inObjectUsage, idProfessionnal, idIntervenant, rdvsToMove, sites, returnOneOrNull, deleted);
                    callback.response(returnObject);
                }
                catch (Exception e) {
                    callback.exception(e);
                    Log.severe((String)"Erreur", (Exception)e);
                    this.functionCallEnded("PatientAccessorClient.findPatient", callback);
                }
            }
            finally {
                this.functionCallEnded("PatientAccessorClient.findPatient", callback);
            }
        }
    }

    public void getSimplePatient(int uniqueKey, XSession session, final ICallback callback, final int patientId) {
        if (this.isOkToCallFunction("PatientAccessorClient.getSimplePatient", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.getSimplePatient(patientId);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            PatientAccessorClient.this.functionCallEnded("PatientAccessorClient.getSimplePatient", callback);
                        }
                    }
                    finally {
                        PatientAccessorClient.this.functionCallEnded("PatientAccessorClient.getSimplePatient", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public XPatient getSimplePatientSync(int uniqueKey, XSession session, int patientId) throws Exception {
        String function = "PatientAccessorClient.getSimplePatient";
        if (this.isOkToCallFunction(function)) {
            try {
                ReturnObject returnObject = PatientAccessorClient.instance.accessor.getSimplePatient(patientId);
                if (returnObject == null) {
                    return null;
                }
                XPatient pt = null;
                if (returnObject.getObj() instanceof XPatient[]) {
                    XPatient[] xpts = (XPatient[])returnObject.getObj();
                    if (xpts.length == 1) {
                        pt = xpts[0];
                    }
                } else {
                    pt = (XPatient)returnObject.getObj();
                }
                XPatient xPatient = pt;
                return xPatient;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to get simple patient " + patientId, e);
                throw e;
            }
            finally {
                this.functionCallEnded(function);
            }
        }
        return null;
    }

    public XBasePatient getBasePatientSync(int uniqueKey, XSession session, int patientId) throws Exception {
        String function = "PatientAccessorClient.getBasePatient";
        if (this.isOkToCallFunction(function)) {
            try {
                ReturnObject returnObject = PatientAccessorClient.instance.accessor.getBasePatient(patientId);
                XBasePatient xBasePatient = (XBasePatient)(returnObject == null ? null : returnObject.getObj());
                return xBasePatient;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to get base patient " + patientId, e);
                throw e;
            }
            finally {
                this.functionCallEnded(function);
            }
        }
        return null;
    }

    public void getFusionPatient(int uniqueKey, XSession session, final ICallback callback, final int patientId) {
        final String function = "PatientAccessorClient.getFusionPatient" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.getFusionPatient(patientId));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            PatientAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        PatientAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    protected IPatientAccessor getAccessor() {
        return this.accessor;
    }

    public void findPatientSummary(XSession session, final ICallback callback, final int idPatient, final Integer idProf, final LocalDateRange dateRange) {
        if (this.isOkToCallFunction("PatientAccessorClient.findPatientSummary", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            XFindPatientSummaryCriteria parameters = new XFindPatientSummaryCriteria();
                            parameters.idProf = idProf;
                            parameters.dateRange = dateRange;
                            ReturnObject returnObject = PatientAccessorClient.this.accessor.findPatientSummary(idPatient, parameters);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            PatientAccessorClient.this.functionCallEnded("PatientAccessorClient.findPatient", callback);
                        }
                    }
                    finally {
                        PatientAccessorClient.this.functionCallEnded("PatientAccessorClient.findPatient", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject find(XSession session, Group group) throws Exception {
        if (this.isOkToCallFunction("PatientAccessorClient.find", null)) {
            try {
                ReturnObject returnObject;
                ReturnObject returnObject2 = returnObject = this.accessor.find(group);
                return returnObject2;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.functionCallEnded("PatientAccessorClient.find", null);
            }
        }
        return null;
    }

    public ReturnObject validNam(IPatient patient) {
        throw new UnsupportedOperationException();
    }
}

