/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.ISearchTextAccessor;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import java.lang.reflect.Method;

public class DelegateSearchTextAccessor
implements ISearchTextAccessor {
    private Class<? extends ISearchTextAccessor> delegate;
    private ISearchTextAccessor delegateInstance;

    public DelegateSearchTextAccessor(Class<? extends ISearchTextAccessor> delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate");
        }
        this.delegate = delegate;
    }

    @Override
    public void findFromSearchText(int uniqueKey, XSession session, ICallback callback, int specialCase, String strSearch) {
        ISearchTextAccessor instance = this.getInstance();
        if (instance != null) {
            instance.findFromSearchText(uniqueKey, session, callback, specialCase, strSearch);
        }
    }

    @Override
    public void findFromId(int uniqueKey, XSession session, ICallback callback, int id) {
        ISearchTextAccessor instance = this.getInstance();
        if (instance != null) {
            instance.findFromId(uniqueKey, session, callback, id);
        }
    }

    private ISearchTextAccessor getInstance() {
        if (this.delegateInstance == null) {
            try {
                Method getInstanceMethod = this.delegate.getMethod("getInstance", new Class[0]);
                this.delegateInstance = (ISearchTextAccessor)getInstanceMethod.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                if (DelegateSearchTextAccessor.isCannotConnectToServerException(e)) {
                    MessageUtil.cannotConnectToServerExceptionMsg();
                }
                throw new RuntimeException("Failed to get delegate instance via static getInstance() method", e);
            }
        }
        return this.delegateInstance;
    }

    private static boolean isCannotConnectToServerException(Throwable t) {
        boolean is = false;
        while (!(is = t instanceof CannotConnectToServerException) && t != null && (t = t.getCause()) != null) {
        }
        return is;
    }
}

