/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.tools;

import ca.infodata.dsq.service.Transaction;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class SimpleTransactionLogHandler
extends Handler {
    public static final Logger logger = Logger.getLogger(SimpleTransactionLogHandler.class.getName());
    private FileWriter out;
    private final File file;

    public SimpleTransactionLogHandler(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.file = file;
        this.out = new FileWriter(file);
    }

    @Override
    public void close() throws SecurityException {
        try {
            this.out.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to close " + this.file, e);
        }
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to flush stream to file " + this.file, e);
        }
    }

    @Override
    public void publish(LogRecord record) {
        Transaction<?, ?> transaction = this.findTransaction(record.getParameters());
        if (transaction == null) {
            logger.fine("no transaction to write");
        } else {
            try {
                this.writeToFile(this.computeString(transaction));
                SimpleTransactionLogHandler.serialize(transaction.getResult(), this.out);
                logger.fine("Writen to log " + transaction.toStringShort());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to log transaction " + transaction, e);
            }
        }
    }

    private String computeString(Transaction<?, ?> t) {
        return String.valueOf(t);
    }

    private Transaction<?, ?> findTransaction(Object[] parameters) {
        for (Object p : parameters) {
            if (!(p instanceof Transaction)) continue;
            return (Transaction)p;
        }
        return null;
    }

    private void writeToFile(String s) throws IOException {
        this.out.write("\n");
        this.out.write("===================================================================");
        this.out.write("\n");
        this.out.write(s, 0, s.length());
        this.out.flush();
    }

    public static void serialize(Serializable t, Writer out) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(baos);
        os.writeObject(t);
        os.flush();
        baos.flush();
        os.close();
        baos.close();
        out.write(baos.toString());
    }
}

