/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.tools;

import ca.infodata.dsq.domain.Application;
import ca.infodata.dsq.domain.Author;
import ca.infodata.dsq.domain.ICandidate;
import ca.infodata.dsq.domain.Location;
import ca.infodata.dsq.service.DSQTimeSourceProvider;
import ca.infodata.dsq.tools.CheckedProperties;
import ca.infodata.dsq.tools.DocumentBuilderFactoryCache;
import ca.infodata.dsq.tools.Helper;
import ca.infodata.dsq.tools.IgnoreAllErrorHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import nu.xom.Node;
import nu.xom.canonical.Canonicalizer;
import nu.xom.converters.DOMConverter;
import org.hl7.v3.dm.AD;
import org.hl7.v3.dm.BinaryDataEncoding;
import org.hl7.v3.dm.CE;
import org.hl7.v3.dm.COCTMT050202CAPatient;
import org.hl7.v3.dm.COCTMT050202CAPerson;
import org.hl7.v3.dm.COCTMT090102CAAssignedEntity;
import org.hl7.v3.dm.COCTMT090102CAHealthCareProvider;
import org.hl7.v3.dm.COCTMT090102CAPerson;
import org.hl7.v3.dm.COCTMT240002CAPlace;
import org.hl7.v3.dm.COCTMT240002CAServiceDeliveryLocation;
import org.hl7.v3.dm.CS;
import org.hl7.v3.dm.CV;
import org.hl7.v3.dm.EnFamily;
import org.hl7.v3.dm.EnGiven;
import org.hl7.v3.dm.EntityClassDevice;
import org.hl7.v3.dm.EntityDeterminer;
import org.hl7.v3.dm.EntityNamePartType;
import org.hl7.v3.dm.II;
import org.hl7.v3.dm.INT;
import org.hl7.v3.dm.MCCIMT002100CADevice1;
import org.hl7.v3.dm.MCCIMT002100CADevice2;
import org.hl7.v3.dm.MCCIMT002100CAReceiver;
import org.hl7.v3.dm.MCCIMT002100CASender;
import org.hl7.v3.dm.NullFlavor;
import org.hl7.v3.dm.ObjectFactory;
import org.hl7.v3.dm.PN;
import org.hl7.v3.dm.PostalAddressUse;
import org.hl7.v3.dm.QUQIMT020000CAAuthor;
import org.hl7.v3.dm.QUQIMT020000CALocation;
import org.hl7.v3.dm.QUQIMT020000CARecordTarget;
import org.hl7.v3.dm.QUQIMT020000CASubject3;
import org.hl7.v3.dm.ST;
import org.hl7.v3.dm.TS;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public final class RequestHelper {
    public static String QUERY_ID = "QUERY_ID";
    public static String QUERY_LIMIT = "QUERY_LIMIT";
    public static String INTERACTION_TYPE = "INTERACTION_TYPE";
    public static String INTERACTION_TYPE_REFLECTION_CLASS_PART = "INTERACTION_TYPE_REFLECTION_CLASS_PART";
    public static String RECEIVER_ID = "RECEIVER_ID";
    public static String RECEIVER_ID_OE_VALUE = "2.16.124.10.101.1.60.6.30";
    public static String RECEIVER_ID_DM_VALUE = "2.16.124.10.101.1.60.6.7";
    public static String EVENT_ID = "EVENT_ID";
    public static String EVENT_TYPE = "EVENT_TYPE";
    public static String CANDIDATE = "CANDIDATE";

    private RequestHelper() {
        throw new UnsupportedOperationException();
    }

    public static String computeCanonicalizedXmlHash(String xml) throws Exception {
        xml = RequestHelper.canonicalizeXml(xml);
        String sha1 = RequestHelper.hashWithSha1(xml);
        return sha1;
    }

    public static String marshalElement(JAXBContext jaxbContext, JAXBElement<?> object) throws Exception {
        if (object == null) {
            throw new NullPointerException("object");
        }
        if (jaxbContext == null) {
            throw new NullPointerException("jaxbContext");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(2000);
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.FALSE);
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.marshal(object, (OutputStream)bos);
        bos.flush();
        bos.close();
        String xml = bos.toString("UTF-8");
        return xml;
    }

    public static Document marshalElementToDocument(JAXBContext jaxbContext, JAXBElement<?> object) throws Exception {
        if (object == null) {
            throw new NullPointerException("object");
        }
        if (jaxbContext == null) {
            throw new NullPointerException("jaxbContext");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactoryCache.getInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.newDocument();
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.schemaLocation", (Object)"http://www.w3.org/2001/XMLSchema-instance");
        marshaller.marshal(object, (org.w3c.dom.Node)document);
        return document;
    }

    public static String docToStringUsingLSSerializer(Document doc) throws Exception {
        if (doc == null) {
            return null;
        }
        DOMImplementationRegistry reg = DOMImplementationRegistry.newInstance();
        DOMImplementationLS impl = (DOMImplementationLS)((Object)reg.getDOMImplementation("LS"));
        LSSerializer serializer = impl.createLSSerializer();
        serializer.getDomConfig().setParameter("format-pretty-print", true);
        LSOutput lsOutput = impl.createLSOutput();
        lsOutput.setEncoding("UTF-8");
        StringWriter stringWriter = new StringWriter(2000);
        lsOutput.setCharacterStream(stringWriter);
        serializer.write(doc, lsOutput);
        return ((Object)stringWriter).toString();
    }

    private static String canonicalizeXml(String xml) throws Exception {
        if (xml == null) {
            throw new NullPointerException("xml");
        }
        DocumentBuilderFactory dfactory = DocumentBuilderFactoryCache.getInstance(new DocumentBuilderFactoryCache.DocumentBuilderFactoryArg().setNamespaceAware(true).setValidating(true));
        DocumentBuilder documentBuilder = dfactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new IgnoreAllErrorHandler());
        Document allInputDoc = documentBuilder.parse(new ByteArrayInputStream(xml.getBytes("UTF-8")));
        RequestHelper.removeSubjectOfNode(allInputDoc);
        allInputDoc.normalizeDocument();
        ByteArrayOutputStream out = new ByteArrayOutputStream(10000);
        Canonicalizer canonicalizer = new Canonicalizer((OutputStream)out, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        canonicalizer.write((Node)DOMConverter.convert((Document)allInputDoc));
        return out.toString("UTF-8");
    }

    private static void removeSubjectOfNode(org.w3c.dom.Node parent) {
        NodeList lst = parent.getChildNodes();
        int len = lst.getLength();
        for (int i = len - 1; i >= 0; --i) {
            org.w3c.dom.Node n = lst.item(i);
            if (n.getNodeName().equals("subjectOf1") && n.getParentNode() != null && n.getParentNode().getNodeName().equals("controlActEvent")) {
                parent.removeChild(n);
                continue;
            }
            if (n.getNodeType() != 1) continue;
            RequestHelper.removeSubjectOfNode(n);
        }
    }

    public static String getNodeName(org.w3c.dom.Node node) {
        if (node == null) {
            return null;
        }
        org.w3c.dom.Node parentNode = node.getParentNode();
        if (parentNode != null) {
            return RequestHelper.getNodeName(parentNode) + "/" + node.getNodeName();
        }
        return node.getNodeName();
    }

    public static Document parse(InputStream is) throws Exception {
        DocumentBuilderFactory dfactory = DocumentBuilderFactoryCache.getInstance(new DocumentBuilderFactoryCache.DocumentBuilderFactoryArg().setNamespaceAware(true).setValidating(true));
        DocumentBuilder documentBuilder = dfactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new IgnoreAllErrorHandler());
        Document doc = documentBuilder.parse(is);
        return doc;
    }

    private static String hashWithSha1(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] sha1hash = new byte[40];
        byte[] bytes = text.getBytes("UTF-8");
        md.update(bytes, 0, bytes.length);
        sha1hash = md.digest();
        return RequestHelper.convertToHex(sha1hash);
    }

    private static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    public static org.w3c.dom.Node findNode(QName qname, NodeList childNodes) {
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            org.w3c.dom.Node node = childNodes.item(i);
            if (qname.getNamespaceURI().equals(node.getNamespaceURI()) && qname.getLocalPart().equals(node.getLocalName())) {
                return node;
            }
            if ((node = RequestHelper.findNode(qname, node.getChildNodes())) == null) continue;
            return node;
        }
        return null;
    }

    public static List<org.w3c.dom.Node> findNodes(QName qname, NodeList childNodes) {
        ArrayList<org.w3c.dom.Node> nodes = new ArrayList<org.w3c.dom.Node>(3);
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            org.w3c.dom.Node node = childNodes.item(i);
            if (qname.getNamespaceURI().equals(node.getNamespaceURI()) && qname.getLocalPart().equals(node.getLocalName())) {
                nodes.add(node);
                continue;
            }
            nodes.addAll(RequestHelper.findNodes(qname, node.getChildNodes()));
        }
        return nodes;
    }

    public static void constructMCCI_MT002100CARequestTransportWrapper(ObjectFactory factory, Object body, Map<String, Object> properties) {
        properties = new CheckedProperties(properties);
        String queryId = (String)properties.get(QUERY_ID);
        String interactionType = (String)properties.get(INTERACTION_TYPE);
        Application application9 = (Application)properties.get("ca.infodata.dsq.application");
        Helper.invokeA(body, "setITSVersion", "XML_1.0");
        II id = factory.createII();
        id.setRoot(queryId);
        Helper.invokeA(body, "setId", id);
        String creationTime = Helper.formatFULLDATETIME(DSQTimeSourceProvider.currentTimeMillis(), TimeZone.getTimeZone("GMT"), true, false);
        TS creationTimeTS = factory.createTS();
        creationTimeTS.setValue(creationTime);
        Helper.invokeA(body, "setCreationTime", creationTimeTS);
        CS versionCode = factory.createCS();
        versionCode.setCode("V3-2008N");
        Helper.invokeA(body, "setVersionCode", versionCode);
        II interactId = factory.createII();
        interactId.setRoot("2.16.840.1.113883.1.6");
        interactId.setExtension(interactionType);
        interactId.setDisplayable(Boolean.valueOf(true));
        interactId.setUse("BUS");
        Helper.invokeA(body, "setInteractionId", interactId);
        CS responseModeCode = factory.createCS();
        responseModeCode.setCode((String)properties.get("ca.infodata.dsq.response_mode_code"));
        Helper.invokeA(body, "setResponseModeCode", responseModeCode);
        CS procCode = factory.createCS();
        procCode.setCode((String)properties.get("ca.infodata.dsq.processing_code"));
        Helper.invokeA(body, "setProcessingCode", procCode);
        CS procModeCode = factory.createCS();
        procModeCode.setCode((String)properties.get("ca.infodata.dsq.processing_mode_code"));
        Helper.invokeA(body, "setProcessingModeCode", procModeCode);
        CS ackCode = factory.createCS();
        ackCode.setCode("NE");
        Helper.invokeA(body, "setAcceptAckCode", ackCode);
        II profileId = factory.createII();
        profileId.setRoot("2.16.124.10.101.1.60.110");
        profileId.setExtension("V02R04D01");
        profileId.setUse("BUS");
        Helper.invokeA2(body, "getProfileId().add", profileId);
        MCCIMT002100CAReceiver receiver = factory.createMCCIMT002100CAReceiver();
        receiver.setTypeCode("RCV");
        Helper.invokeA(body, "setReceiver", receiver);
        MCCIMT002100CADevice2 device = factory.createMCCIMT002100CADevice2();
        device.setClassCode(EntityClassDevice.DEV);
        device.setDeterminerCode(EntityDeterminer.INSTANCE);
        receiver.setDevice(device);
        II idDevice = factory.createII();
        idDevice.setRoot((String)properties.get(RECEIVER_ID));
        idDevice.setUse("BUS");
        device.setId(idDevice);
        MCCIMT002100CASender sender = factory.createMCCIMT002100CASender();
        sender.setTypeCode("SND");
        Helper.invokeA(body, "setSender", sender);
        MCCIMT002100CADevice1 senderDevice = factory.createMCCIMT002100CADevice1();
        senderDevice.setClassCode(EntityClassDevice.DEV);
        senderDevice.setDeterminerCode(EntityDeterminer.INSTANCE);
        sender.setDevice(senderDevice);
        II senderIdDevice = factory.createII();
        senderIdDevice.setRoot((String)properties.get("ca.infodata.dsq.application.new_application_id"));
        senderIdDevice.setExtension(application9.shortName);
        senderIdDevice.setUse("BUS");
        senderDevice.setId(senderIdDevice);
        ST senderDeviceName = factory.createST();
        senderDeviceName.setRepresentation(BinaryDataEncoding.TXT);
        senderDeviceName.setMediaType("text/plain");
        senderDeviceName.setText(application9.name);
        senderDevice.setName(senderDeviceName);
    }

    public static void constructQUQI_MT020000CAQueryRequestWrapper(ObjectFactory factory, Object controlActEvent, Map<String, Object> properties) {
        Number limit;
        String eventType = (String)properties.get(EVENT_TYPE);
        String eventId = (String)properties.get(EVENT_ID);
        String queryId = (String)properties.get(QUERY_ID);
        Author author9 = (Author)properties.get("ca.infodata.dsq.author");
        Location location9 = (Location)properties.get("ca.infodata.dsq.location");
        ICandidate candidate = (ICandidate)properties.get(CANDIDATE);
        String creationTime = Helper.formatFULLDATETIME(DSQTimeSourceProvider.currentTimeMillis(), TimeZone.getTimeZone("GMT"), true, false);
        String interactionClassPart = (String)properties.get(INTERACTION_TYPE_REFLECTION_CLASS_PART);
        II controlId = factory.createII();
        controlId.setRoot((String)properties.get("ca.infodata.dsq.application.new_application_id"));
        controlId.setExtension(eventId);
        controlId.setUse("BUS");
        Helper.invokeA(controlActEvent, "setId", controlId);
        CV controlCode = factory.createCV();
        controlCode.setCode(eventType);
        controlCode.setCodeSystem("2.16.840.1.113883.1.18");
        Helper.invokeA(controlActEvent, "setCode", controlCode);
        CE languageCode = factory.createCE();
        languageCode.setCode((String)properties.get("ca.infodata.dsq.language"));
        languageCode.setCodeSystem("2.16.840.1.113883.6.121");
        Helper.invokeA(controlActEvent, "setLanguageCode", languageCode);
        CS statusCode = factory.createCS();
        statusCode.setCode("completed");
        Helper.invokeA(controlActEvent, "setStatusCode", statusCode);
        QUQIMT020000CAAuthor author = factory.createQUQIMT020000CAAuthor();
        Helper.invokeA(controlActEvent, "setAuthor", author);
        TS authorTime = factory.createTS();
        authorTime.setValue(creationTime);
        author.setTime(authorTime);
        COCTMT090102CAAssignedEntity assignedEntity = factory.createCOCTMT090102CAAssignedEntity();
        II assignedEntityId = factory.createII();
        assignedEntityId.setUse("BUS");
        assignedEntityId.setDisplayable(Boolean.valueOf(true));
        assignedEntityId.setRoot("2.16.840.1.113883.4.277");
        assignedEntityId.setExtension(author9.getNIU_I().value());
        assignedEntity.getId().add(assignedEntityId);
        author.setAssignedEntity1(assignedEntity);
        COCTMT090102CAPerson assignedPerson = factory.createCOCTMT090102CAPerson();
        assignedPerson.setName(RequestHelper.createPN(factory, Helper.truncate(author9.getFirstName(), 50), Helper.truncate(author9.getLastName(), 50)));
        assignedEntity.setAssignedPerson(assignedPerson);
        if (author9.getNIU_COLLEGE() != null) {
            COCTMT090102CAHealthCareProvider asLicensedEntity = factory.createCOCTMT090102CAHealthCareProvider();
            assignedPerson.setAsHealthCareProvider(factory.createCOCTMT090102CAPersonAsHealthCareProvider(asLicensedEntity));
            II asLicensedEntityID = factory.createII();
            asLicensedEntityID.setRoot(author9.getNIU_COLLEGE().oid());
            asLicensedEntityID.setExtension(author9.getNIU_COLLEGE().value());
            asLicensedEntityID.setUse("BUS");
            asLicensedEntityID.setDisplayable(Boolean.valueOf(true));
            asLicensedEntity.setId(asLicensedEntityID);
        }
        QUQIMT020000CARecordTarget recordTarget = factory.createQUQIMT020000CARecordTarget();
        COCTMT050202CAPatient patient1 = factory.createCOCTMT050202CAPatient();
        II patient1Id = factory.createII();
        patient1Id.setUse("BUS");
        patient1Id.setDisplayable(Boolean.valueOf(true));
        patient1Id.setRoot(candidate.getNiu().oid());
        patient1Id.setExtension(candidate.getNiu().value());
        patient1.getId().add(patient1Id);
        COCTMT050202CAPerson patient1Person = factory.createCOCTMT050202CAPerson();
        patient1Person.setName(RequestHelper.createPN(factory, Helper.truncate(candidate.getFirstName(), 25), Helper.truncate(candidate.getLastName(), 40)));
        TS mskBirthtime = factory.createTS();
        mskBirthtime.setNullFlavor(NullFlavor.MSK);
        patient1Person.setBirthTime(mskBirthtime);
        CV mskGender = factory.createCV();
        mskGender.setNullFlavor(NullFlavor.MSK);
        patient1Person.setAdministrativeGenderCode(mskGender);
        patient1.setPatientPerson(patient1Person);
        recordTarget.setPatient1(patient1);
        Helper.invokeA(controlActEvent, "setRecordTarget", recordTarget);
        QUQIMT020000CALocation location = factory.createQUQIMT020000CALocation();
        String method = "create" + interactionClassPart + "QUQIMT020000CAControlActEventLocation";
        Helper.invokeA(controlActEvent, "setLocation", Helper.invokeA(factory, method, location));
        COCTMT240002CAServiceDeliveryLocation serviceDeliveryLocation = factory.createCOCTMT240002CAServiceDeliveryLocation();
        location.setServiceDeliveryLocation(serviceDeliveryLocation);
        II serviceDeliveryLocationID = factory.createII();
        serviceDeliveryLocationID.setUse("BUS");
        serviceDeliveryLocationID.setDisplayable(Boolean.valueOf(true));
        serviceDeliveryLocationID.setRoot(location9.getNIU().oid());
        serviceDeliveryLocationID.setExtension(location9.getNIU().value());
        serviceDeliveryLocation.setId(serviceDeliveryLocationID);
        AD serviceDeliveryLocationAddr = factory.createAD();
        serviceDeliveryLocationAddr.getUse().add(PostalAddressUse.PHYS);
        COCTMT240002CAPlace locationName = factory.createCOCTMT240002CAPlace();
        ST nameLocation = factory.createST();
        nameLocation.setText(Helper.truncate(location9.getName(), 60));
        locationName.setName(nameLocation);
        serviceDeliveryLocation.setLocation(locationName);
        QUQIMT020000CASubject3 subjectOf2 = factory.createQUQIMT020000CASubject3();
        method = "create" + interactionClassPart + "QUQIMT020000CAControlActEventSubjectOf2";
        Helper.invokeA(controlActEvent, "setSubjectOf2", Helper.invokeA(factory, method, subjectOf2));
        method = "create" + interactionClassPart + "QUQIMT020000CAQueryByParameter";
        Object queryByparameters = Helper.invoke((Object)factory, method);
        Helper.invokeA(controlActEvent, "setQueryByParameter", queryByparameters);
        II queryID = factory.createII();
        queryID.setRoot(queryId);
        Helper.invokeA(queryByparameters, "setQueryId", queryID);
        if (properties.containsKey(QUERY_LIMIT) && (limit = (Number)properties.get(QUERY_LIMIT)) != null) {
            INT initialQuantityINT = factory.createINT();
            initialQuantityINT.setValue(BigInteger.valueOf(limit.longValue()));
            Helper.invokeA(queryByparameters, "setInitialQuantity", initialQuantityINT);
        }
    }

    public static COCTMT090102CAAssignedEntity createAssignedEntity(ObjectFactory factory, Author author9) {
        COCTMT090102CAAssignedEntity assignedEntity = factory.createCOCTMT090102CAAssignedEntity();
        II assignedEntityId = factory.createII();
        assignedEntityId.setUse("BUS");
        assignedEntityId.setDisplayable(Boolean.valueOf(true));
        assignedEntityId.setRoot("2.16.840.1.113883.4.277");
        assignedEntityId.setExtension(author9.getNIU_I().value());
        assignedEntity.getId().add(assignedEntityId);
        COCTMT090102CAPerson assignedPerson = factory.createCOCTMT090102CAPerson();
        assignedPerson.setName(RequestHelper.createPN(factory, Helper.truncate(author9.getFirstName(), 50), Helper.truncate(author9.getLastName(), 50)));
        assignedEntity.setAssignedPerson(assignedPerson);
        if (author9.getNIU_COLLEGE() != null) {
            COCTMT090102CAHealthCareProvider asLicensedEntity = factory.createCOCTMT090102CAHealthCareProvider();
            assignedPerson.setAsHealthCareProvider(factory.createCOCTMT090102CAPersonAsHealthCareProvider(asLicensedEntity));
            II asLicensedEntityID = factory.createII();
            asLicensedEntityID.setRoot(author9.getNIU_COLLEGE().oid());
            asLicensedEntityID.setExtension(author9.getNIU_COLLEGE().value());
            asLicensedEntityID.setUse("BUS");
            asLicensedEntityID.setDisplayable(Boolean.valueOf(true));
            asLicensedEntity.setId(asLicensedEntityID);
        }
        return assignedEntity;
    }

    private static PN createPN(ObjectFactory factory, String firstName, String lastName) {
        PN pn = factory.createPN();
        pn.getUse().add("L");
        EnGiven enGiven = factory.createEnGiven();
        enGiven.setPartType(EntityNamePartType.GIV);
        enGiven.setMediaType("text/plain");
        enGiven.setRepresentation(BinaryDataEncoding.TXT);
        enGiven.setText(firstName);
        EnFamily enFamily = factory.createEnFamily();
        enFamily.setPartType(EntityNamePartType.FAM);
        enFamily.setMediaType("text/plain");
        enFamily.setRepresentation(BinaryDataEncoding.TXT);
        enFamily.setText(lastName);
        pn.getContent().add(factory.createENGiven(enGiven));
        pn.getContent().add(factory.createENFamily(enFamily));
        return pn;
    }
}

