/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn;

import java.util.Random;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.alg.AxisSplitRuleRandomK;
import org.ddogleg.nn.alg.AxisSplitterMedian;
import org.ddogleg.nn.alg.KdTreeDistance;
import org.ddogleg.nn.alg.VpTree;
import org.ddogleg.nn.alg.searches.KdTreeSearch1Bbf;
import org.ddogleg.nn.alg.searches.KdTreeSearchNBbf;
import org.ddogleg.nn.wrap.KdForestBbfNearestNeighbor;
import org.ddogleg.nn.wrap.KdTreeNearestNeighbor;
import org.ddogleg.nn.wrap.WrapExhaustiveNeighbor;

public class FactoryNearestNeighbor {
    public static <P> NearestNeighbor<P> kdtree(KdTreeDistance<P> distance) {
        return new KdTreeNearestNeighbor<P>(distance);
    }

    public static <P> NearestNeighbor<P> kdtree(KdTreeDistance<P> distance, int maxNodesSearched) {
        return new KdTreeNearestNeighbor<P>(new KdTreeSearch1Bbf<P>(distance, maxNodesSearched), new KdTreeSearchNBbf<P>(distance, maxNodesSearched), new AxisSplitterMedian<P>(distance));
    }

    public static <P> NearestNeighbor<P> kdRandomForest(KdTreeDistance<P> distance, int maxNodesSearched, int numTrees, int numConsiderSplit, long randomSeed) {
        Random rand = new Random(randomSeed);
        return new KdForestBbfNearestNeighbor<P>(numTrees, maxNodesSearched, distance, new AxisSplitterMedian<P>(distance, new AxisSplitRuleRandomK(rand, numConsiderSplit)));
    }

    public static <P> NearestNeighbor<P> exhaustive(KdTreeDistance<P> distance) {
        return new WrapExhaustiveNeighbor<P>(distance);
    }

    public static NearestNeighbor<double[]> vptree(long randSeed) {
        return new VpTree(randSeed);
    }
}

