/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.line;

import georegression.struct.line.LinePolar2D_F32;
import georegression.struct.line.LinePolar2D_F64;
import georegression.struct.point.Point2D_I32;
import java.util.List;

public class FitLine_I32 {
    public static LinePolar2D_F32 polar(List<Point2D_I32> points, int start, int length, LinePolar2D_F32 ret) {
        if (ret == null) {
            ret = new LinePolar2D_F32();
        }
        int sumX = 0;
        int sumY = 0;
        int N = length;
        for (int i = 0; i < N; ++i) {
            Point2D_I32 p = points.get(start + i);
            sumX += p.x;
            sumY += p.y;
        }
        float meanX = (float)sumX / (float)N;
        float meanY = (float)sumY / (float)N;
        float top = 0.0f;
        float bottom = 0.0f;
        for (int i = 0; i < N; ++i) {
            Point2D_I32 p = points.get(start + i);
            float dx = meanX - (float)p.x;
            float dy = meanY - (float)p.y;
            top += dx * dy;
            bottom += dy * dy - dx * dx;
        }
        ret.angle = (float)Math.atan2(-2.0f * top, bottom) / 2.0f;
        ret.distance = (float)((double)meanX * Math.cos(ret.angle) + (double)meanY * Math.sin(ret.angle));
        return ret;
    }

    public static LinePolar2D_F64 polar(List<Point2D_I32> points, int start, int length, LinePolar2D_F64 ret) {
        if (ret == null) {
            ret = new LinePolar2D_F64();
        }
        int sumX = 0;
        int sumY = 0;
        int N = length;
        for (int i = 0; i < N; ++i) {
            Point2D_I32 p = points.get(start + i);
            sumX += p.x;
            sumY += p.y;
        }
        double meanX = (double)sumX / (double)N;
        double meanY = (double)sumY / (double)N;
        double top = 0.0;
        double bottom = 0.0;
        for (int i = 0; i < N; ++i) {
            Point2D_I32 p = points.get(start + i);
            double dx = meanX - (double)p.x;
            double dy = meanY - (double)p.y;
            top += dx * dy;
            bottom += dy * dy - dx * dx;
        }
        ret.angle = Math.atan2(-2.0 * top, bottom) / 2.0;
        ret.distance = meanX * Math.cos(ret.angle) + meanY * Math.sin(ret.angle);
        return ret;
    }
}

