/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_I32;
import java.io.Serializable;

public abstract class ImageBase<T extends ImageBase>
implements Serializable,
Cloneable {
    public int startIndex;
    public int stride;
    public int width;
    public int height;
    public boolean subImage = false;
    public ImageType imageType;

    public abstract T subimage(int var1, int var2, int var3, int var4, T var5);

    public T subimage(int x0, int y0, int x1, int y1) {
        return this.subimage(x0, y0, x1, y1, null);
    }

    public abstract void reshape(int var1, int var2);

    public void matchShape(ImageBase image) {
        this.reshape(image.width, image.height);
    }

    public abstract void setTo(T var1);

    public boolean isSubimage() {
        return this.subImage;
    }

    public final boolean isInBounds(int x, int y) {
        return x >= 0 && x < this.width && y >= 0 && y < this.height;
    }

    public int getIndex(int x, int y) {
        return this.startIndex + y * this.stride + x;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int width) {
        this.width = width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int height) {
        this.height = height;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getStride() {
        return this.stride;
    }

    public void setStride(int stride) {
        this.stride = stride;
    }

    public Point2D_I32 indexToPixel(int index) {
        return new Point2D_I32((index -= this.startIndex) % this.stride, index / this.stride);
    }

    public abstract T createNew(int var1, int var2);

    public ImageType<T> getImageType() {
        return this.imageType;
    }

    public T createSameShape() {
        return this.createNew(this.width, this.height);
    }

    public int totalPixels() {
        return this.width * this.height;
    }

    public abstract void copyRow(int var1, int var2, int var3, int var4, Object var5);

    public abstract void copyCol(int var1, int var2, int var3, int var4, Object var5);

    public T clone() {
        ImageBase ret = this.createSameShape();
        ret.setTo((ImageBase)this);
        return (T)ret;
    }
}

