/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure2;

import boofcv.struct.feature.AssociatedIndex;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ddogleg.struct.FastQueue;
import org.ejml.data.DMatrixRMaj;

public class PairwiseImageGraph2 {
    public FastQueue<View> nodes = new FastQueue<View>(View.class, true);
    public FastQueue<Motion> edges = new FastQueue<Motion>(Motion.class, true);
    public Map<String, View> mapNodes = new HashMap<String, View>();

    public void reset() {
        this.mapNodes.clear();
        this.nodes.reset();
        this.edges.reset();
    }

    public View createNode(String id) {
        View v = this.nodes.grow();
        v.init(id);
        this.mapNodes.put(id, v);
        return v;
    }

    public View lookupNode(String id) {
        return this.mapNodes.get(id);
    }

    public static class Motion {
        public DMatrixRMaj F = new DMatrixRMaj(3, 3);
        public boolean is3D;
        public int countF;
        public int countH;
        public FastQueue<AssociatedIndex> inliers = new FastQueue<AssociatedIndex>(AssociatedIndex.class, true);
        public View src;
        public View dst;
        public int index;

        public void init() {
            this.F.zero();
            this.is3D = false;
            this.index = -1;
            this.src = null;
            this.dst = null;
        }

        public View other(View src) {
            if (src == this.src) {
                return this.dst;
            }
            if (src == this.dst) {
                return this.src;
            }
            throw new RuntimeException("BUG!");
        }
    }

    public static class View {
        public String id;
        public int totalFeatures;
        public FastQueue<Motion> connections = new FastQueue<Motion>(Motion.class, false);

        void init(String id) {
            this.id = id;
            this.connections.reset();
        }

        public Motion findMotion(View target) {
            int idx = this.findMotionIdx(target);
            if (idx == -1) {
                return null;
            }
            return this.connections.get(idx);
        }

        public int findMotionIdx(View target) {
            for (int i = 0; i < this.connections.size; ++i) {
                Motion m = this.connections.get(i);
                if (m.src != target && m.dst != target) continue;
                return i;
            }
            return -1;
        }

        public void getConnections(int[] indexes, int length, List<View> views) {
            views.clear();
            for (int i = 0; i < length; ++i) {
                views.add(this.connections.get(indexes[i]).other(this));
            }
        }
    }
}

