/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation.slic;

import boofcv.alg.segmentation.ComputeRegionMeanColor;
import boofcv.alg.segmentation.ms.ClusterLabeledImage;
import boofcv.alg.segmentation.ms.MergeSmallRegions;
import boofcv.factory.segmentation.FactorySegmentationAlg;
import boofcv.struct.ConnectRule;
import boofcv.struct.feature.ColorQueue_F32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import java.util.Arrays;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;
import org.ddogleg.struct.Stoppable;

public abstract class SegmentSlic<T extends ImageBase<T>>
implements Stoppable {
    public static final int BORDER = 2;
    private int numBands;
    private int numberOfRegions;
    private float m;
    private int totalIterations;
    protected int gridInterval;
    private float adjustSpacial;
    protected T input;
    private GrayS32 initialSegments = new GrayS32(1, 1);
    private GrowQueue_I32 regionMemberCount = new GrowQueue_I32();
    private FastQueue<float[]> regionColor;
    private MergeSmallRegions<T> mergeSmall;
    protected ClusterLabeledImage segment;
    protected FastQueue<Cluster> clusters;
    protected FastQueue<Pixel> pixels = new FastQueue<Pixel>(Pixel.class, true);
    protected ImageType<T> imageType;
    protected ConnectRule connectRule;
    private volatile boolean stopRequested = false;

    public SegmentSlic(int numberOfRegions, float m, int totalIterations, ConnectRule connectRule, ImageType<T> imageType) {
        this.numberOfRegions = numberOfRegions;
        this.m = m;
        this.totalIterations = totalIterations;
        this.numBands = imageType.getNumBands();
        this.connectRule = connectRule;
        this.imageType = imageType;
        ComputeRegionMeanColor<T> regionColor = FactorySegmentationAlg.regionMeanColor(imageType);
        this.mergeSmall = new MergeSmallRegions<T>(-1, connectRule, regionColor);
        this.segment = new ClusterLabeledImage(connectRule);
        this.regionColor = new ColorQueue_F32(this.numBands);
        this.clusters = new FastQueue<Cluster>(Cluster.class, () -> {
            Cluster c = new Cluster();
            c.color = new float[this.numBands];
            return c;
        });
    }

    public void process(T input, GrayS32 output) {
        output.reshape(((ImageBase)input).width, ((ImageBase)input).height);
        this.stopRequested = false;
        if (((ImageBase)input).width < 4 || ((ImageBase)input).height < 4) {
            throw new IllegalArgumentException("Image is too small to process.  Must have a width and height of at least 4");
        }
        this.initalize(input);
        this.initializeClusters();
        for (int i = 0; i < this.totalIterations && !this.stopRequested; ++i) {
            this.computeClusterDistance();
            this.updateClusters();
        }
        if (this.stopRequested) {
            return;
        }
        this.computeClusterDistance();
        this.assignLabelsToPixels(this.initialSegments, this.regionMemberCount, this.regionColor);
        int N = ((ImageBase)input).width * ((ImageBase)input).height / this.numberOfRegions;
        this.segment.process(this.initialSegments, output, this.regionMemberCount);
        this.mergeSmall.setMinimumSize(N / 2);
        this.mergeSmall.process(input, output, this.regionMemberCount, this.regionColor);
    }

    protected void initalize(T input) {
        this.input = input;
        this.pixels.resize(((ImageBase)input).width * ((ImageBase)input).height);
        this.initialSegments.reshape(((ImageBase)input).width, ((ImageBase)input).height);
        int numberOfUsable = (((ImageBase)input).width - 4) * (((ImageBase)input).height - 4);
        this.gridInterval = (int)Math.sqrt((double)numberOfUsable / (double)this.numberOfRegions);
        if (this.gridInterval <= 0) {
            throw new IllegalArgumentException("Too many regions for an image of this size");
        }
        this.adjustSpacial = this.m / (float)this.gridInterval;
    }

    protected void initializeClusters() {
        int offsetX = Math.max(2, (((ImageBase)this.input).width - 1) % this.gridInterval / 2);
        int offsetY = Math.max(2, (((ImageBase)this.input).height - 1) % this.gridInterval / 2);
        int clusterId = 0;
        this.clusters.reset();
        for (int y = offsetY; y < ((ImageBase)this.input).height - 2; y += this.gridInterval) {
            for (int x = offsetX; x < ((ImageBase)this.input).width - 2; x += this.gridInterval) {
                Cluster c = this.clusters.grow();
                c.id = clusterId++;
                if (c.color == null) {
                    c.color = new float[this.numBands];
                }
                this.perturbCenter(c, x, y);
            }
        }
    }

    protected void perturbCenter(Cluster c, int x, int y) {
        float best = Float.MAX_VALUE;
        int bestX = 0;
        int bestY = 0;
        for (int dy = -1; dy <= 1; ++dy) {
            for (int dx = -1; dx <= 1; ++dx) {
                float d = this.gradient(x + dx, y + dy);
                if (!(d < best)) continue;
                best = d;
                bestX = dx;
                bestY = dy;
            }
        }
        c.x = x + bestX;
        c.y = y + bestY;
        this.setColor(c.color, x + bestX, y + bestY);
    }

    protected float gradient(int x, int y) {
        float dx = this.getIntensity(x + 1, y) - this.getIntensity(x - 1, y);
        float dy = this.getIntensity(x, y + 1) - this.getIntensity(x, y - 1);
        return dx * dx + dy * dy;
    }

    public abstract void setColor(float[] var1, int var2, int var3);

    public abstract void addColor(float[] var1, int var2, float var3);

    public abstract float colorDistance(float[] var1, int var2);

    public abstract float getIntensity(int var1, int var2);

    protected void computeClusterDistance() {
        int i;
        for (i = 0; i < this.pixels.size; ++i) {
            ((Pixel[])this.pixels.data)[i].reset();
        }
        for (i = 0; i < this.clusters.size && !this.stopRequested; ++i) {
            Cluster c = ((Cluster[])this.clusters.data)[i];
            int centerX = (int)(c.x + 0.5f);
            int centerY = (int)(c.y + 0.5f);
            int x0 = centerX - this.gridInterval;
            int x1 = centerX + this.gridInterval + 1;
            int y0 = centerY - this.gridInterval;
            int y1 = centerY + this.gridInterval + 1;
            if (x0 < 0) {
                x0 = 0;
            }
            if (y0 < 0) {
                y0 = 0;
            }
            if (x1 > ((ImageBase)this.input).width) {
                x1 = ((ImageBase)this.input).width;
            }
            if (y1 > ((ImageBase)this.input).height) {
                y1 = ((ImageBase)this.input).height;
            }
            for (int y = y0; y < y1; ++y) {
                int indexPixel = y * ((ImageBase)this.input).width + x0;
                int indexInput = ((ImageBase)this.input).startIndex + y * ((ImageBase)this.input).stride + x0;
                int dy = y - centerY;
                for (int x = x0; x < x1; ++x) {
                    int dx = x - centerX;
                    float distanceColor = this.colorDistance(c.color, indexInput++);
                    float distanceSpacial = dx * dx + dy * dy;
                    ((Pixel[])this.pixels.data)[indexPixel++].add(c, distanceColor + this.adjustSpacial * distanceSpacial);
                }
            }
        }
    }

    protected void updateClusters() {
        for (int i = 0; i < this.clusters.size; ++i) {
            ((Cluster[])this.clusters.data)[i].reset();
        }
        int indexPixel = 0;
        for (int y = 0; y < ((ImageBase)this.input).height && !this.stopRequested; ++y) {
            int indexInput = ((ImageBase)this.input).startIndex + y * ((ImageBase)this.input).stride;
            int x = 0;
            while (x < ((ImageBase)this.input).width) {
                Pixel p = this.pixels.get(indexPixel);
                p.computeWeights();
                for (int i = 0; i < p.clusters.size; ++i) {
                    ClusterDistance d = ((ClusterDistance[])p.clusters.data)[i];
                    d.cluster.x += (float)x * d.distance;
                    d.cluster.y += (float)y * d.distance;
                    d.cluster.totalWeight += d.distance;
                    this.addColor(d.cluster.color, indexInput, d.distance);
                }
                ++x;
                ++indexPixel;
                ++indexInput;
            }
        }
        for (int i = 0; i < this.clusters.size; ++i) {
            ((Cluster[])this.clusters.data)[i].update();
        }
    }

    public void assignLabelsToPixels(GrayS32 pixelToRegions, GrowQueue_I32 regionMemberCount, FastQueue<float[]> regionColor) {
        regionColor.reset();
        for (int i = 0; i < this.clusters.size(); ++i) {
            float[] r = regionColor.grow();
            float[] c = this.clusters.get((int)i).color;
            for (int j = 0; j < this.numBands; ++j) {
                r[j] = c[j];
            }
        }
        regionMemberCount.resize(this.clusters.size());
        regionMemberCount.fill(0);
        int indexPixel = 0;
        for (int y = 0; y < pixelToRegions.height; ++y) {
            int indexOutput = pixelToRegions.startIndex + y * pixelToRegions.stride;
            int x = 0;
            while (x < pixelToRegions.width) {
                Pixel p = ((Pixel[])this.pixels.data)[indexPixel];
                int best = -1;
                float bestDistance = Float.MAX_VALUE;
                for (int j = 0; j < p.clusters.size; ++j) {
                    ClusterDistance d = ((ClusterDistance[])p.clusters.data)[j];
                    if (!(d.distance < bestDistance)) continue;
                    bestDistance = d.distance;
                    best = d.cluster.id;
                }
                if (best == -1) {
                    regionColor.grow();
                    best = regionMemberCount.size();
                    regionMemberCount.add(0);
                }
                pixelToRegions.data[indexOutput] = best;
                int n = best;
                regionMemberCount.data[n] = regionMemberCount.data[n] + 1;
                ++x;
                ++indexPixel;
                ++indexOutput;
            }
        }
    }

    public GrowQueue_I32 getRegionMemberCount() {
        return this.regionMemberCount;
    }

    public FastQueue<Cluster> getClusters() {
        return this.clusters;
    }

    public ImageType<T> getImageType() {
        return this.imageType;
    }

    public ConnectRule getConnectRule() {
        return this.connectRule;
    }

    @Override
    public void requestStop() {
        this.stopRequested = true;
    }

    @Override
    public boolean isStopRequested() {
        return this.stopRequested;
    }

    public static class Cluster {
        public int id;
        public float x;
        public float y;
        public float[] color;
        public float totalWeight;

        public void reset() {
            this.y = 0.0f;
            this.x = 0.0f;
            Arrays.fill(this.color, 0.0f);
            this.totalWeight = 0.0f;
        }

        public void update() {
            this.x /= this.totalWeight;
            this.y /= this.totalWeight;
            int i = 0;
            while (i < this.color.length) {
                int n = i++;
                this.color[n] = this.color[n] / this.totalWeight;
            }
        }
    }

    public static class ClusterDistance {
        public Cluster cluster;
        public float distance;
    }

    public static class Pixel {
        public FastQueue<ClusterDistance> clusters = new FastQueue<ClusterDistance>(12, ClusterDistance.class, true);

        public void add(Cluster c, float distance) {
            ClusterDistance d = this.clusters.grow();
            d.cluster = c;
            d.distance = distance;
        }

        public void computeWeights() {
            if (this.clusters.size == 1) {
                ((ClusterDistance[])this.clusters.data)[0].distance = 1.0f;
            } else {
                int i;
                float sum = 0.0f;
                for (i = 0; i < this.clusters.size; ++i) {
                    sum += ((ClusterDistance[])this.clusters.data)[i].distance;
                }
                for (i = 0; i < this.clusters.size; ++i) {
                    ((ClusterDistance[])this.clusters.data)[i].distance = 1.0f - ((ClusterDistance[])this.clusters.data)[i].distance / sum;
                }
            }
        }

        public void reset() {
            this.clusters.reset();
        }
    }
}

