/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.sgm.cost;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.convolve.ConvolveImageNormalized;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.alg.misc.ImageStatistics;
import boofcv.alg.misc.PixelMath;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import java.util.Random;
import org.ejml.UtilEjml;

public class StereoMutualInformation {
    Kernel1D_F32 smoothKernel;
    GrayF32 smoothWork = new GrayF32(1, 1);
    float eps = UtilEjml.F_EPS;
    int[] histogramIntensity;
    int totalDispPixels;
    GrayS32 histJoint = new GrayS32(1, 1);
    GrayF32 entropyJoint = new GrayF32(1, 1);
    GrayF32 entropyLeft = new GrayF32(1, 1);
    GrayF32 entropyRight = new GrayF32(1, 1);
    GrayU16 scaledCost = new GrayU16(1, 1);

    public StereoMutualInformation() {
        this.configureHistogram(256);
        this.configureSmoothing(1);
    }

    public void configureHistogram(int totalGrayLevels) {
        this.histogramIntensity = new int[totalGrayLevels];
        this.histJoint.reshape(totalGrayLevels, totalGrayLevels);
        this.entropyJoint.reshape(this.histJoint);
        this.entropyLeft.reshape(totalGrayLevels, 1);
        this.entropyRight.reshape(totalGrayLevels, 1);
        this.scaledCost.reshape(this.histJoint);
    }

    public void randomHistogram(Random rand, int maxCost) {
        int N = this.scaledCost.totalPixels();
        for (int i = 0; i < N; ++i) {
            this.scaledCost.data[i] = (short)rand.nextInt(maxCost);
        }
    }

    public void diagonalHistogram(double scaleLeftToRight, int maxCost) {
        int costLow = maxCost / 20;
        int costHigh = maxCost / 3;
        int idx = 0;
        for (int y = 0; y < this.scaledCost.height; ++y) {
            int matchingX = (int)Math.round(Math.min((double)(this.scaledCost.width - 1), Math.max(0.0, (double)y * scaleLeftToRight)));
            for (int x = 0; x < this.scaledCost.width; ++x) {
                this.scaledCost.data[idx++] = (short)(x == matchingX ? costLow : costHigh);
            }
        }
    }

    public void configureSmoothing(int radius) {
        this.smoothKernel = (Kernel1D_F32)FactoryKernelGaussian.gaussian(1, true, 32, -1.0, radius);
    }

    public void process(GrayU8 left, GrayU8 right, int minDisparity, GrayU8 disparity, int invalid) {
        InputSanityCheck.checkSameShape(left, right);
        if (left.isSubimage() || right.isSubimage() || disparity.isSubimage()) {
            throw new IllegalArgumentException("Can't process sub images. Is this a major issue? Could be fixed");
        }
        disparity.reshape(left);
        this.computeJointHistogram(left, right, minDisparity, disparity, invalid);
        this.computeProbabilities();
        this.computeEntropy();
    }

    public float cost(int leftValue, int rightValue) {
        return this.entropyJoint.unsafe_get(rightValue, leftValue) - this.entropyLeft.data[leftValue] - this.entropyRight.data[rightValue];
    }

    public int costScaled(int leftValue, int rightValue) {
        return this.scaledCost.unsafe_get(rightValue, leftValue);
    }

    void computeJointHistogram(GrayU8 left, GrayU8 right, int minDisparity, GrayU8 disparity, int invalid) {
        ImageMiscOps.fill(this.histJoint, 0);
        int histLength = this.histogramIntensity.length;
        for (int y = 0; y < left.height; ++y) {
            int idx = y * left.stride;
            int x = 0;
            while (x < left.width) {
                int d = disparity.data[idx] & 0xFF;
                if (d < invalid) {
                    int leftValue = left.data[idx] & 0xFF;
                    int rightValue = right.data[idx - (d += minDisparity)] & 0xFF;
                    int n = leftValue * histLength + rightValue;
                    this.histJoint.data[n] = this.histJoint.data[n] + 1;
                }
                ++x;
                ++idx;
            }
        }
    }

    void computeProbabilities() {
        this.totalDispPixels = ImageStatistics.sum(this.histJoint);
        float totalPixels = this.totalDispPixels;
        int histN = this.histJoint.totalPixels();
        for (int i = 0; i < histN; ++i) {
            this.entropyJoint.data[i] = (float)this.histJoint.data[i] / totalPixels;
        }
        GImageMiscOps.fill((ImageBase)this.entropyRight, 0.0);
        for (int row = 0; row < this.entropyJoint.height; ++row) {
            int idx = row * this.entropyJoint.width;
            float sumRow = 0.0f;
            int col = 0;
            while (col < this.entropyJoint.width) {
                float v = this.entropyJoint.data[idx];
                sumRow += v;
                int n = col++;
                this.entropyRight.data[n] = this.entropyRight.data[n] + v;
                ++idx;
            }
            this.entropyLeft.data[row] = sumRow;
        }
    }

    void computeEntropy() {
        ConvolveImageNormalized.horizontal(this.smoothKernel, this.entropyJoint, this.smoothWork);
        ConvolveImageNormalized.vertical(this.smoothKernel, this.smoothWork, this.entropyJoint);
        PixelMath.log(this.entropyJoint, this.eps, this.entropyJoint);
        ConvolveImageNormalized.horizontal(this.smoothKernel, this.entropyJoint, this.smoothWork);
        ConvolveImageNormalized.vertical(this.smoothKernel, this.smoothWork, this.entropyJoint);
        PixelMath.divide(this.entropyJoint, (float)(-this.totalDispPixels), this.entropyJoint);
        ConvolveImageNormalized.horizontal(this.smoothKernel, this.entropyLeft, this.smoothWork);
        PixelMath.log(this.smoothWork, this.eps, this.smoothWork);
        ConvolveImageNormalized.horizontal(this.smoothKernel, this.smoothWork, this.entropyLeft);
        PixelMath.divide(this.entropyLeft, (float)(-this.totalDispPixels), this.entropyLeft);
        ConvolveImageNormalized.horizontal(this.smoothKernel, this.entropyRight, this.smoothWork);
        PixelMath.log(this.smoothWork, this.eps, this.smoothWork);
        ConvolveImageNormalized.horizontal(this.smoothKernel, this.smoothWork, this.entropyRight);
        PixelMath.divide(this.entropyRight, (float)(-this.totalDispPixels), this.entropyRight);
    }

    public void precomputeScaledCost(int maxCost) {
        int N = this.scaledCost.width;
        float minValue = Float.MAX_VALUE;
        float maxValue = -3.4028235E38f;
        for (int left = 0; left < N; ++left) {
            for (int right = 0; right < N; ++right) {
                float v = this.entropyJoint.unsafe_get(right, left) - this.entropyLeft.data[left] - this.entropyRight.data[right];
                if (minValue > v) {
                    minValue = v;
                }
                if (!(maxValue < v)) continue;
                maxValue = v;
            }
        }
        float rangeValue = maxValue - minValue;
        for (int left = 0; left < N; ++left) {
            for (int right = 0; right < N; ++right) {
                float v = this.entropyJoint.unsafe_get(right, left) - this.entropyLeft.data[left] - this.entropyRight.data[right];
                this.scaledCost.data[left * N + right] = (short)((float)maxCost * (v - minValue) / rangeValue);
            }
        }
    }

    public float getEps() {
        return this.eps;
    }

    public void setEps(float eps) {
        this.eps = eps;
    }
}

