/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.associate;

import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.RectifyImageOps;
import boofcv.alg.geo.rectify.RectifyCalibrated;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.distort.Point2Transform2_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se3_F64;
import org.ejml.data.DMatrixRMaj;

public class StereoConsistencyCheck {
    protected Point2Transform2_F64 leftImageToRect;
    protected Point2Transform2_F64 rightImageToRect;
    Point2D_F64 rectLeft = new Point2D_F64();
    Point2D_F64 rectRight = new Point2D_F64();
    double toleranceY;
    double toleranceX;

    public StereoConsistencyCheck(double toleranceX, double toleranceY) {
        this.toleranceX = toleranceX;
        this.toleranceY = toleranceY;
    }

    public void setCalibration(StereoParameters param) {
        CameraPinholeBrown left = param.getLeft();
        CameraPinholeBrown right = param.getRight();
        RectifyCalibrated rectifyAlg = RectifyImageOps.createCalibrated();
        Se3_F64 leftToRight = param.getRightToLeft().invert((Se3_F64)null);
        DMatrixRMaj K1 = PerspectiveOps.pinholeToMatrix((CameraPinhole)left, (DMatrixRMaj)null);
        DMatrixRMaj K2 = PerspectiveOps.pinholeToMatrix((CameraPinhole)right, (DMatrixRMaj)null);
        rectifyAlg.process(K1, new Se3_F64(), K2, leftToRight);
        DMatrixRMaj rect1 = rectifyAlg.getRect1();
        DMatrixRMaj rect2 = rectifyAlg.getRect2();
        this.leftImageToRect = RectifyImageOps.transformPixelToRect(param.left, rect1);
        this.rightImageToRect = RectifyImageOps.transformPixelToRect(param.right, rect2);
    }

    public boolean checkPixel(Point2D_F64 left, Point2D_F64 right) {
        this.leftImageToRect.compute(left.x, left.y, this.rectLeft);
        this.rightImageToRect.compute(right.x, right.y, this.rectRight);
        return this.checkRectified(this.rectLeft, this.rectRight);
    }

    public boolean checkRectified(Point2D_F64 left, Point2D_F64 right) {
        if (Math.abs(left.y - right.y) > this.toleranceY) {
            return false;
        }
        return right.x <= left.x + this.toleranceX;
    }
}

