/*
 * Decompiled with CFR 0.152.
 */
package org.oscarehr.utils.checkstyle;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlUtils {
    public static void writeNode(Node node, OutputStream os) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        DOMSource domSource = new DOMSource(node);
        StreamResult streamResult = new StreamResult(os);
        transformer.transform(domSource, streamResult);
    }

    public static String toString(Node node) throws TransformerException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XmlUtils.writeNode(node, baos);
        return baos.toString();
    }

    public static Document toDocument(byte[] x) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        ByteArrayInputStream baos = new ByteArrayInputStream(x, 0, x.length);
        Document document = builder.parse(baos);
        baos.close();
        return document;
    }

    public static Document newDocument(String rootName) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        doc.appendChild(doc.createElement(rootName));
        return doc;
    }

    public static void appendChildToRoot(Document doc, String childName, String childContents) {
        XmlUtils.appendChild(doc, doc.getFirstChild(), childName, childContents);
    }

    public static void appendChild(Document doc, Node parentNode, String childName, String childContents) {
        Element child = doc.createElement(childName);
        child.appendChild(doc.createTextNode(childContents));
        parentNode.appendChild(child);
    }

    public static String toFormattedString(Document doc) throws IOException {
        OutputFormat outputFormat = new OutputFormat(doc);
        outputFormat.setIndenting(true);
        StringWriter stringWriter = new StringWriter();
        XMLSerializer xmlSerializer = new XMLSerializer(stringWriter, outputFormat);
        xmlSerializer.serialize(doc);
        return stringWriter.toString();
    }

    public static Node getChildNode(Node node, String name) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node temp = nodeList.item(i);
            if (!name.equals(temp.getLocalName()) && !name.equals(temp.getNodeName())) continue;
            return temp;
        }
        return null;
    }

    public static String getChildNodeTextContents(Node node, String name) {
        Node tempNode = XmlUtils.getChildNode(node, name);
        if (tempNode != null) {
            return tempNode.getTextContent();
        }
        return null;
    }

    public static String getAttribute(Node node, String attributeName) {
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node tempNode = attributes.item(i);
            if (!attributeName.equals(tempNode.getLocalName())) continue;
            return tempNode.getNodeValue();
        }
        return null;
    }

    public static void main(String ... argv) throws Exception {
        Document doc = XmlUtils.newDocument("testRoot");
        XmlUtils.appendChildToRoot(doc, "testChild1", "test child< bla< > contents");
        XmlUtils.appendChildToRoot(doc, "testChild2", "test child contents 2");
        System.err.println(XmlUtils.toFormattedString(doc));
    }
}

