/*
 * Decompiled with CFR 0.152.
 */
package org.oscarehr.utils.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.oscarehr.utils.checkstyle.MultiValueMap;
import org.oscarehr.utils.checkstyle.XmlUtils;
import org.w3c.dom.Document;

public class TrackingRegexpCheck
extends AbstractFileSetCheck {
    private static HashMap<String, MultiValueMap> trackingFileMap = new HashMap();
    private static int instanceCounter = 0;
    private static String pathPrefix = System.getProperty("user.dir");
    private MultiValueMap violations = null;
    private String illegalRegex;
    private String violationDescription;
    private String dataStoreFilename = "TrackingRegexpCheck.data.xml";
    private Pattern illegalRegexPattern;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginProcessing(String s) {
        super.beginProcessing(s);
        Class<TrackingRegexpCheck> clazz = TrackingRegexpCheck.class;
        synchronized (TrackingRegexpCheck.class) {
            ++instanceCounter;
            try {
                this.violations = trackingFileMap.get(this.dataStoreFilename);
                if (this.violations == null) {
                    File file = new File(this.dataStoreFilename);
                    System.out.println("Using data file path : " + file.getCanonicalPath() + ", pathPrefix=" + pathPrefix);
                    if (file.exists()) {
                        FileInputStream fis = new FileInputStream(file);
                        byte[] b = new byte[fis.available()];
                        fis.read(b);
                        Document doc = XmlUtils.toDocument(b);
                        this.violations = MultiValueMap.fromXml(doc);
                        trackingFileMap.put(this.dataStoreFilename, this.violations);
                        fis.close();
                    } else {
                        this.violations = new MultiValueMap();
                        trackingFileMap.put(this.dataStoreFilename, this.violations);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishProcessing() {
        Class<TrackingRegexpCheck> clazz = TrackingRegexpCheck.class;
        synchronized (TrackingRegexpCheck.class) {
            if (--instanceCounter == 0) {
                for (Map.Entry<String, MultiValueMap> entry : trackingFileMap.entrySet()) {
                    File file = new File(entry.getKey());
                    if (file.exists()) continue;
                    try {
                        System.out.println("Saving new data file : " + file.getCanonicalPath());
                        FileOutputStream fos = new FileOutputStream(file);
                        Document doc = entry.getValue().toXml();
                        String s = XmlUtils.toFormattedString(doc);
                        fos.write(s.getBytes());
                        fos.flush();
                        fos.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            super.finishProcessing();
            return;
        }
    }

    protected void processFiltered(File file, List<String> fileLines) {
        for (int i = 0; i < fileLines.size(); ++i) {
            String line = fileLines.get(i).trim();
            Matcher m = this.illegalRegexPattern.matcher(line);
            if (!m.matches()) continue;
            try {
                String violationValue;
                boolean isNew;
                String fileRelativePath = file.getCanonicalPath();
                if (fileRelativePath.startsWith(pathPrefix)) {
                    fileRelativePath = fileRelativePath.substring(pathPrefix.length());
                }
                boolean bl = isNew = !this.violations.exists(this.illegalRegex, violationValue = fileRelativePath + ':' + line);
                if (!isNew) continue;
                this.violations.put(this.illegalRegex, violationValue);
                this.log(i + 1, "{0}", new Object[]{line + " : " + this.violationDescription});
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getIllegalRegex() {
        return this.illegalRegex;
    }

    public void setIllegalRegex(String illegalRegex) {
        this.illegalRegex = illegalRegex;
        this.illegalRegexPattern = Pattern.compile(illegalRegex);
    }

    public String getViolationDescription() {
        return this.violationDescription;
    }

    public void setViolationDescription(String violationDescription) {
        this.violationDescription = violationDescription;
    }

    public String getDataStoreFilename() {
        return this.dataStoreFilename;
    }

    public void setDataStoreFilename(String dataStoreFilename) {
        this.dataStoreFilename = dataStoreFilename;
    }

    public static void main(String ... argv) throws Exception {
        File f = new File("/data/repo/foo/bar.txt");
        System.err.println("" + f.getAbsolutePath());
        System.err.println("" + f.getCanonicalPath());
        System.err.println("" + f.getPath());
        System.err.println("" + f.getParent());
        System.err.println("---");
        File f2 = new File(".");
        System.err.println("" + f2.getAbsolutePath());
        System.err.println("" + f2.getCanonicalPath());
        System.err.println("" + f2.getPath());
        System.err.println("" + f2.getParent());
    }
}

