/*
 * Decompiled with CFR 0.152.
 */
package org.oscarehr.utils.checkstyle;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import org.oscarehr.utils.checkstyle.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MultiValueMap {
    private static final String ROOT_NODE_NAME = "TrackingRegexpCheck";
    private static final String VIOLATION_SET_NODE_NAME = "ViolationSet";
    private static final String VIOLATION_KEY_NODE_NAME = "ViolationKey";
    private static final String VIOLATION_VALUE_NODE_NAME = "ViolationValue";
    private TreeMap<String, TreeSet<String>> map = new TreeMap();

    public void put(String key, String value) {
        TreeSet<String> list = this.map.get(key);
        if (list == null) {
            list = new TreeSet();
            this.map.put(key, list);
        }
        list.add(value);
    }

    public boolean exists(String key, String value) {
        TreeSet<String> list = this.map.get(key);
        if (list == null) {
            return false;
        }
        return list.contains(value);
    }

    public TreeSet<String> getSet(String key) {
        return this.map.get(key);
    }

    protected Set<Map.Entry<String, TreeSet<String>>> entrySet() {
        return this.map.entrySet();
    }

    public Document toXml() throws ParserConfigurationException {
        Document doc = XmlUtils.newDocument(ROOT_NODE_NAME);
        for (Map.Entry<String, TreeSet<String>> entry : this.entrySet()) {
            MultiValueMap.addSetContents(doc, entry.getKey(), entry.getValue());
        }
        return doc;
    }

    private static void addSetContents(Document doc, String key, TreeSet<String> value) {
        Element element = doc.createElement(VIOLATION_SET_NODE_NAME);
        XmlUtils.appendChild(doc, element, VIOLATION_KEY_NODE_NAME, key);
        for (String temp : value) {
            XmlUtils.appendChild(doc, element, VIOLATION_VALUE_NODE_NAME, temp);
        }
        doc.getFirstChild().appendChild(element);
    }

    public static MultiValueMap fromXml(Document doc) {
        MultiValueMap mvm = new MultiValueMap();
        Node rootNode = doc.getFirstChild();
        NodeList violiationSets = rootNode.getChildNodes();
        for (int i = 0; i < violiationSets.getLength(); ++i) {
            Node node = violiationSets.item(i);
            if (!VIOLATION_SET_NODE_NAME.equals(node.getNodeName())) continue;
            MultiValueMap.addViolationSet(mvm, node);
        }
        return mvm;
    }

    private static void addViolationSet(MultiValueMap mvm, Node parentNode) {
        String violationType = XmlUtils.getChildNodeTextContents(parentNode, VIOLATION_KEY_NODE_NAME);
        NodeList violiationValues = parentNode.getChildNodes();
        for (int i = 0; i < violiationValues.getLength(); ++i) {
            Node node = violiationValues.item(i);
            if (!VIOLATION_VALUE_NODE_NAME.equals(node.getNodeName())) continue;
            String value = node.getTextContent();
            mvm.put(violationType, value);
        }
    }

    public static void main(String ... argv) throws ParserConfigurationException, IOException {
        MultiValueMap mvm = new MultiValueMap();
        mvm.put(".\\*+-_()", "one");
        mvm.put("bbb", "two");
        mvm.put("asdf", "asdf1");
        mvm.put("asdf", "asdf2");
        mvm.put("asdf", "asdf3");
        Document doc = mvm.toXml();
        String s = XmlUtils.toFormattedString(doc);
        System.err.println(s);
        MultiValueMap mvm2 = MultiValueMap.fromXml(doc);
        Document doc2 = mvm2.toXml();
        String s2 = XmlUtils.toFormattedString(doc2);
        System.err.println(s2);
    }
}

