/*
 * Decompiled with CFR 0.152.
 */
package org.oscarehr.utils.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IllegalFilenameCheck
extends AbstractFileSetCheck {
    private String illegalRegex;
    private Pattern illegalRegexPattern;

    protected void processFiltered(File file, List<String> fileLines) {
        String filename = file.getName();
        Matcher m = this.illegalRegexPattern.matcher(filename);
        if (m.matches()) {
            this.log(0, "Illegal filename. Matches :  " + this.illegalRegex, new Object[0]);
        }
    }

    public String getIllegalRegex() {
        return this.illegalRegex;
    }

    public void setIllegalRegex(String illegalRegex) {
        this.illegalRegex = illegalRegex;
        this.illegalRegexPattern = Pattern.compile(illegalRegex);
    }

    public static void main(String ... argv) {
        String filename = "foo.PNG";
        String regex = ".*\\.(GIF|PNG|JPG)";
        System.err.println(filename.matches(regex));
    }
}

