/*
 * Decompiled with CFR 0.152.
 */
package org.mb.listeners;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.mb.listeners.IListenerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefListenerManager<T>
implements IListenerManager<T> {
    private List<T> m_arrListeners;
    private Class m_objClass;
    private T m_objProxy;

    public RefListenerManager(Class clazz) {
        this(clazz, RefListenerManager.class.getClassLoader());
    }

    public RefListenerManager(Class clazz, ClassLoader classLoader) {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("The listener type " + this.m_objClass + " must be an interface");
        }
        this.m_objClass = clazz;
        this.m_arrListeners = new ArrayList<T>();
        this.m_objProxy = Proxy.newProxyInstance(classLoader, new Class[]{this.m_objClass}, (InvocationHandler)new ListenerInvocationHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(T t) throws IllegalArgumentException {
        if (!this.m_objClass.isInstance(t)) {
            throw new IllegalArgumentException("The listener must of type " + this.m_objClass);
        }
        T t2 = this.m_objProxy;
        synchronized (t2) {
            ArrayList<T> arrayList = new ArrayList<T>(this.m_arrListeners);
            if (arrayList.contains(t)) {
                return;
            }
            arrayList.add(t);
            this.m_arrListeners = arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(T t) throws IllegalArgumentException {
        if (!this.m_objClass.isInstance(t)) {
            throw new IllegalArgumentException("The listener must of type " + this.m_objClass);
        }
        T t2 = this.m_objProxy;
        synchronized (t2) {
            ArrayList<T> arrayList = new ArrayList<T>(this.m_arrListeners);
            arrayList.remove(t);
            this.m_arrListeners = arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isListener(T t) {
        T t2 = this.m_objProxy;
        synchronized (t2) {
            return this.m_arrListeners.contains(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T[] getListeners() {
        T t = this.m_objProxy;
        synchronized (t) {
            return this.m_arrListeners.toArray();
        }
    }

    @Override
    public T getProxy() {
        return this.m_objProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        T t = this.m_objProxy;
        synchronized (t) {
            this.m_arrListeners = new ArrayList<T>();
        }
    }

    private class ListenerInvocationHandler
    implements InvocationHandler {
        private ListenerInvocationHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object object, Method method, Object[] objectArray) throws RuntimeException {
            List list;
            Object object2 = this;
            synchronized (object2) {
                list = RefListenerManager.this.m_arrListeners;
            }
            object2 = null;
            int n = list.size();
            if (n > 0) {
                try {
                    for (int i = 0; i < n; ++i) {
                        Object e = RefListenerManager.this.m_arrListeners.get(i);
                        object2 = method.invoke(e, objectArray);
                    }
                }
                catch (Throwable throwable) {
                    throw new RuntimeException("An exception occurred while invoking listeners", throwable);
                }
            } else if (!method.getReturnType().equals(Void.TYPE)) {
                throw new IllegalStateException("Cannot return a value -- there are no listeners");
            }
            return object2;
        }
    }
}

