/*
 * Decompiled with CFR 0.152.
 */
package org.mb.listeners;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Random;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Loader;
import javassist.LoaderClassPath;
import org.mb.listeners.CannotCreateListenerProxyException;
import org.mb.listeners.IListenerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenListenerManager<T>
implements IListenerManager<T> {
    private static int s_nCount = 0;
    private WeakReference<T>[] m_arrListeners;
    private boolean m_bAllowDuplicates;
    private Class<T> m_objClass;
    private T m_objProxy;

    public GenListenerManager(Class clazz) throws CannotCreateListenerProxyException {
        this(clazz, GenListenerManager.class.getClassLoader());
    }

    public GenListenerManager(Class clazz, boolean bl) throws CannotCreateListenerProxyException {
        this(clazz, GenListenerManager.class.getClassLoader(), bl);
    }

    public GenListenerManager(Class clazz, ClassLoader classLoader) throws CannotCreateListenerProxyException {
        this(clazz, classLoader, false);
    }

    public GenListenerManager(Class clazz, ClassLoader classLoader, boolean bl) throws CannotCreateListenerProxyException {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("The listener type " + this.m_objClass + " must be an interface");
        }
        this.m_objClass = clazz;
        this.m_bAllowDuplicates = bl;
        this.m_arrListeners = new WeakReference[0];
        this.createProxy(clazz, classLoader);
    }

    @Override
    public synchronized void addListener(T t) throws IllegalArgumentException {
        Object object;
        int n;
        if (!this.m_objClass.isInstance(t)) {
            throw new IllegalArgumentException("The listener must of type " + this.m_objClass);
        }
        this.cleanListenerArray();
        WeakReference<T>[] weakReferenceArray = this.m_arrListeners;
        if (!this.m_bAllowDuplicates) {
            for (n = 0; n < weakReferenceArray.length; ++n) {
                object = weakReferenceArray[n].get();
                if (!t.equals(object)) continue;
                return;
            }
        }
        n = weakReferenceArray.length;
        object = new WeakReference[n + 1];
        System.arraycopy(weakReferenceArray, 0, object, 0, n);
        object[n] = new WeakReference<T>(t);
        this.m_arrListeners = object;
    }

    private synchronized void cleanListenerArray() {
        int n;
        int[] nArray = new int[this.m_arrListeners.length];
        int n2 = 0;
        WeakReference<T>[] weakReferenceArray = this.m_arrListeners;
        for (n = 0; n < weakReferenceArray.length; ++n) {
            if (weakReferenceArray[n].get() == null) continue;
            nArray[n2++] = n;
        }
        if (n2 != weakReferenceArray.length) {
            weakReferenceArray = new WeakReference[n2];
            for (n = 0; n < weakReferenceArray.length; ++n) {
                weakReferenceArray[n] = this.m_arrListeners[nArray[n]];
            }
        }
        this.m_arrListeners = weakReferenceArray;
    }

    @Override
    public synchronized void removeListener(T t) throws IllegalArgumentException {
        if (!this.m_objClass.isInstance(t)) {
            throw new IllegalArgumentException("The listener must of type " + this.m_objClass);
        }
        this.cleanListenerArray();
        int n = this.findListenerIndex(t);
        if (n < 0) {
            return;
        }
        WeakReference<T>[] weakReferenceArray = this.m_arrListeners;
        int n2 = weakReferenceArray.length;
        WeakReference[] weakReferenceArray2 = new WeakReference[n2 - 1];
        System.arraycopy(weakReferenceArray, 0, weakReferenceArray2, 0, n);
        System.arraycopy(weakReferenceArray, n + 1, weakReferenceArray2, n, n2 - n - 1);
        this.m_arrListeners = weakReferenceArray2;
    }

    @Override
    public synchronized boolean isListener(T t) {
        return this.findListenerIndex(t) >= 0;
    }

    protected int findListenerIndex(T t) {
        WeakReference<T>[] weakReferenceArray = this.m_arrListeners;
        int n = weakReferenceArray.length;
        for (int i = n - 1; i >= 0; --i) {
            Object t2 = weakReferenceArray[i].get();
            if (!t.equals(t2)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public synchronized T[] getListeners() {
        this.cleanListenerArray();
        Object[] objectArray = (Object[])Array.newInstance(this.m_objClass, this.m_arrListeners.length);
        for (int i = 0; i < this.m_arrListeners.length; ++i) {
            objectArray[i] = this.m_arrListeners[i].get();
        }
        return objectArray;
    }

    @Override
    public T getProxy() {
        return this.m_objProxy;
    }

    private void createProxy(Class<T> clazz, ClassLoader classLoader) throws CannotCreateListenerProxyException {
        ClassPool classPool;
        ClassPool classPool2;
        ClassPool classPool3;
        ClassLoader classLoader2 = clazz.getClassLoader();
        if (classLoader2 == null) {
            classPool3 = ClassPool.getDefault();
        } else {
            classPool3 = new ClassPool(null);
            classPool3.insertClassPath(new LoaderClassPath(classLoader2));
        }
        ClassLoader classLoader3 = this.getClass().getClassLoader();
        if (classLoader3 == classLoader2) {
            classPool2 = classPool3;
        } else if (classLoader3 == null) {
            classPool2 = ClassPool.getDefault();
        } else {
            classPool2 = new ClassPool(null);
            classPool2.insertClassPath(new LoaderClassPath(classLoader3));
        }
        if (classLoader == classLoader2) {
            classPool = classPool3;
        } else if (classLoader == null) {
            classPool = ClassPool.getDefault();
        } else {
            classPool = new ClassPool(null);
            classPool.insertClassPath(new LoaderClassPath(classLoader));
        }
        String string = clazz.getName();
        String string2 = this.generateProxyName(string);
        CtClass ctClass = classPool.makeClass(string2);
        try {
            Object object;
            Object object2;
            Object object3;
            CtClass ctClass2 = classPool3.get(string);
            ctClass.addInterface(ctClass2);
            CtClass ctClass3 = classPool2.get(this.getClass().getName());
            CtField ctField = new CtField(ctClass3, "_mgr", ctClass);
            ctClass.addField(ctField);
            String string3 = "{\n  _mgr = $1;}\n";
            CtConstructor ctConstructor = CtNewConstructor.make(new CtClass[]{ctClass3}, null, string3, ctClass);
            ctClass.addConstructor(ctConstructor);
            CtMethod[] ctMethodArray = ctClass2.getDeclaredMethods();
            for (int i = 0; i < ctMethodArray.length; ++i) {
                object3 = ctMethodArray[i];
                object2 = CtNewMethod.copy((CtMethod)object3, ctClass, null);
                object = ((CtMethod)object2).getReturnType();
                String string4 = object == CtClass.voidType ? "{ \n  java.lang.Object[] listeners = _mgr.getListeners();  int size = listeners.length;\n  for (int i = 0; i < size; i++) {\n    " + string + " listener = (" + string + ") listeners[i];\n" + "    listener." + ((CtMethod)object2).getName() + "($$);\n" + "  }\n" + "}" : "{ \n  java.lang.Object[] listeners = _mgr.getListeners();  int size = listeners.length;\n  for (int i = 0; i < size; i++) {\n    " + string + " listener = (" + string + ") listeners[i];\n" + "    " + ((CtClass)object).getName() + " ret = listener." + ((CtMethod)object2).getName() + "($$);\n" + "    if (i+1 == size) return ret;\n" + "  }\n" + "  throw new java.lang.IllegalStateException(\"Cannot return a value -- there are no listeners\");\n" + "}";
                ((CtBehavior)object2).setBody(string4);
                ctClass.addMethod((CtMethod)object2);
            }
            Loader loader = new Loader(classLoader, classPool);
            loader.delegateLoadingOf(ctClass2.getName());
            loader.delegateLoadingOf(this.getClass().getName());
            object3 = loader.loadClass(string2);
            object2 = ((Class)object3).getConstructors()[0];
            object = this.getClass();
            this.m_objProxy = ((Constructor)object2).newInstance(this);
        }
        catch (Exception exception) {
            throw new CannotCreateListenerProxyException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateProxyName(String string) {
        Object object = GenListenerManager.class;
        synchronized (GenListenerManager.class) {
            int n = s_nCount++;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            object = string + "$listenerProxy" + n;
            if (((String)object).startsWith("java")) {
                object = "listenerProxy." + (String)object;
            }
            return object;
        }
    }

    @Override
    public synchronized void clear() {
        this.m_arrListeners = new WeakReference[0];
    }

    static {
        Random random = new Random();
        s_nCount = random.nextInt(0x3FFFFFFF);
    }
}

