/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Date;
import java.util.Set;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.tsp.TimeStampResp;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TSPValidationException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampTokenGenerator;

public class TimeStampResponseGenerator {
    int status;
    ASN1EncodableVector statusStrings;
    int failInfo;
    private TimeStampTokenGenerator tokenGenerator;
    private Set acceptedAlgorithms;
    private Set acceptedPolicies;
    private Set acceptedExtensions;

    public TimeStampResponseGenerator(TimeStampTokenGenerator timeStampTokenGenerator, Set set) {
        this(timeStampTokenGenerator, set, null, null);
    }

    public TimeStampResponseGenerator(TimeStampTokenGenerator timeStampTokenGenerator, Set set, Set set2) {
        this(timeStampTokenGenerator, set, set2, null);
    }

    public TimeStampResponseGenerator(TimeStampTokenGenerator timeStampTokenGenerator, Set set, Set set2, Set set3) {
        this.tokenGenerator = timeStampTokenGenerator;
        this.acceptedAlgorithms = set;
        this.acceptedPolicies = set2;
        this.acceptedExtensions = set3;
        this.statusStrings = new ASN1EncodableVector();
    }

    private void addStatusString(String string) {
        this.statusStrings.add(new DERUTF8String(string));
    }

    private void setFailInfoField(int n) {
        this.failInfo |= n;
    }

    private PKIStatusInfo getPKIStatusInfo() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DERInteger(this.status));
        if (this.statusStrings.size() > 0) {
            aSN1EncodableVector.add(new PKIFreeText(new DERSequence(this.statusStrings)));
        }
        if (this.failInfo != 0) {
            FailInfo failInfo = new FailInfo(this.failInfo);
            aSN1EncodableVector.add(failInfo);
        }
        return new PKIStatusInfo(new DERSequence(aSN1EncodableVector));
    }

    public TimeStampResponse generate(TimeStampRequest timeStampRequest, BigInteger bigInteger, Date date, String string) throws NoSuchAlgorithmException, NoSuchProviderException, TSPException {
        TimeStampResp timeStampResp;
        try {
            if (date == null) {
                throw new TSPValidationException("The time source is not available.", 512);
            }
            timeStampRequest.validate(this.acceptedAlgorithms, this.acceptedPolicies, this.acceptedExtensions, string);
            this.status = 0;
            this.addStatusString("Operation Okay");
            PKIStatusInfo pKIStatusInfo = this.getPKIStatusInfo();
            ContentInfo contentInfo = null;
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.tokenGenerator.generate(timeStampRequest, bigInteger, date, string).toCMSSignedData().getEncoded());
                ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
                contentInfo = ContentInfo.getInstance(aSN1InputStream.readObject());
            }
            catch (IOException iOException) {
                throw new TSPException("Timestamp token received cannot be converted to ContentInfo", iOException);
            }
            timeStampResp = new TimeStampResp(pKIStatusInfo, contentInfo);
        }
        catch (TSPValidationException tSPValidationException) {
            this.status = 2;
            this.setFailInfoField(tSPValidationException.getFailureCode());
            this.addStatusString(tSPValidationException.getMessage());
            PKIStatusInfo pKIStatusInfo = this.getPKIStatusInfo();
            timeStampResp = new TimeStampResp(pKIStatusInfo, null);
        }
        try {
            return new TimeStampResponse(timeStampResp);
        }
        catch (IOException iOException) {
            throw new TSPException("created badly formatted response!");
        }
    }

    public TimeStampResponse generate(TimeStampRequest timeStampRequest, BigInteger bigInteger, Date date) throws TSPException {
        TimeStampResp timeStampResp;
        try {
            if (date == null) {
                throw new TSPValidationException("The time source is not available.", 512);
            }
            timeStampRequest.validate(this.acceptedAlgorithms, this.acceptedPolicies, this.acceptedExtensions);
            this.status = 0;
            this.addStatusString("Operation Okay");
            PKIStatusInfo pKIStatusInfo = this.getPKIStatusInfo();
            ContentInfo contentInfo = null;
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.tokenGenerator.generate(timeStampRequest, bigInteger, date).toCMSSignedData().getEncoded());
                ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
                contentInfo = ContentInfo.getInstance(aSN1InputStream.readObject());
            }
            catch (IOException iOException) {
                throw new TSPException("Timestamp token received cannot be converted to ContentInfo", iOException);
            }
            timeStampResp = new TimeStampResp(pKIStatusInfo, contentInfo);
        }
        catch (TSPValidationException tSPValidationException) {
            this.status = 2;
            this.setFailInfoField(tSPValidationException.getFailureCode());
            this.addStatusString(tSPValidationException.getMessage());
            PKIStatusInfo pKIStatusInfo = this.getPKIStatusInfo();
            timeStampResp = new TimeStampResp(pKIStatusInfo, null);
        }
        try {
            return new TimeStampResponse(timeStampResp);
        }
        catch (IOException iOException) {
            throw new TSPException("created badly formatted response!");
        }
    }

    public TimeStampResponse generateFailResponse(int n, int n2, String string) throws TSPException {
        this.status = n;
        this.setFailInfoField(n2);
        if (string != null) {
            this.addStatusString(string);
        }
        PKIStatusInfo pKIStatusInfo = this.getPKIStatusInfo();
        TimeStampResp timeStampResp = new TimeStampResp(pKIStatusInfo, null);
        try {
            return new TimeStampResponse(timeStampResp);
        }
        catch (IOException iOException) {
            throw new TSPException("created badly formatted response!");
        }
    }

    class FailInfo
    extends DERBitString {
        FailInfo(int n) {
            super(FailInfo.getBytes(n), FailInfo.getPadBits(n));
        }
    }
}

