/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.EOFException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.jce.interfaces.ElGamalKey;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyValidationException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPUtil;

public class PGPPublicKeyEncryptedData
extends PGPEncryptedData {
    PublicKeyEncSessionPacket keyData;

    PGPPublicKeyEncryptedData(PublicKeyEncSessionPacket publicKeyEncSessionPacket, InputStreamPacket inputStreamPacket) {
        super(inputStreamPacket);
        this.keyData = publicKeyEncSessionPacket;
    }

    private static Cipher getKeyCipher(int n, Provider provider) throws PGPException {
        try {
            switch (n) {
                case 1: 
                case 2: {
                    return Cipher.getInstance("RSA/ECB/PKCS1Padding", provider);
                }
                case 16: 
                case 20: {
                    return Cipher.getInstance("ElGamal/ECB/PKCS1Padding", provider);
                }
            }
            throw new PGPException("unknown asymmetric algorithm: " + n);
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }

    private boolean confirmCheckSum(byte[] byArray) {
        int n = 0;
        for (int i = 1; i != byArray.length - 2; ++i) {
            n += byArray[i] & 0xFF;
        }
        return byArray[byArray.length - 2] == (byte)(n >> 8) && byArray[byArray.length - 1] == (byte)n;
    }

    public long getKeyID() {
        return this.keyData.getKeyID();
    }

    public int getSymmetricAlgorithm(PGPPrivateKey pGPPrivateKey, String string) throws PGPException, NoSuchProviderException {
        return this.getSymmetricAlgorithm(pGPPrivateKey, PGPUtil.getProvider(string));
    }

    public int getSymmetricAlgorithm(PGPPrivateKey pGPPrivateKey, Provider provider) throws PGPException, NoSuchProviderException {
        byte[] byArray = this.fetchSymmetricKeyData(pGPPrivateKey, provider);
        return byArray[0];
    }

    public InputStream getDataStream(PGPPrivateKey pGPPrivateKey, String string) throws PGPException, NoSuchProviderException {
        return this.getDataStream(pGPPrivateKey, string, string);
    }

    public InputStream getDataStream(PGPPrivateKey pGPPrivateKey, Provider provider) throws PGPException {
        return this.getDataStream(pGPPrivateKey, provider, provider);
    }

    public InputStream getDataStream(PGPPrivateKey pGPPrivateKey, String string, String string2) throws PGPException, NoSuchProviderException {
        return this.getDataStream(pGPPrivateKey, PGPUtil.getProvider(string), PGPUtil.getProvider(string2));
    }

    public InputStream getDataStream(PGPPrivateKey pGPPrivateKey, Provider provider, Provider provider2) throws PGPException {
        Cipher cipher;
        byte[] byArray = this.fetchSymmetricKeyData(pGPPrivateKey, provider);
        try {
            cipher = this.encData instanceof SymmetricEncIntegrityPacket ? Cipher.getInstance(PGPUtil.getSymmetricCipherName(byArray[0]) + "/CFB/NoPadding", provider2) : Cipher.getInstance(PGPUtil.getSymmetricCipherName(byArray[0]) + "/OpenPGPCFB/NoPadding", provider2);
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception creating cipher", exception);
        }
        if (cipher != null) {
            try {
                int n;
                int n2;
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, 1, byArray.length - 3, PGPUtil.getSymmetricCipherName(byArray[0]));
                byte[] byArray2 = new byte[cipher.getBlockSize()];
                cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(byArray2));
                this.encStream = new BCPGInputStream(new CipherInputStream(this.encData.getInputStream(), cipher));
                if (this.encData instanceof SymmetricEncIntegrityPacket) {
                    this.truncStream = new PGPEncryptedData.TruncatedStream(this.encStream);
                    this.encStream = new DigestInputStream(this.truncStream, MessageDigest.getInstance(PGPUtil.getDigestName(2), provider2));
                }
                for (n2 = 0; n2 != byArray2.length; ++n2) {
                    n = this.encStream.read();
                    if (n < 0) {
                        throw new EOFException("unexpected end of stream.");
                    }
                    byArray2[n2] = (byte)n;
                }
                n2 = this.encStream.read();
                n = this.encStream.read();
                if (n2 < 0 || n < 0) {
                    throw new EOFException("unexpected end of stream.");
                }
                return this.encStream;
            }
            catch (PGPException pGPException) {
                throw pGPException;
            }
            catch (Exception exception) {
                throw new PGPException("Exception starting decryption", exception);
            }
        }
        return this.encData.getInputStream();
    }

    private byte[] fetchSymmetricKeyData(PGPPrivateKey pGPPrivateKey, Provider provider) throws PGPException {
        Object object;
        Cipher cipher = PGPPublicKeyEncryptedData.getKeyCipher(this.keyData.getAlgorithm(), provider);
        try {
            cipher.init(2, pGPPrivateKey.getKey());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("error setting asymmetric cipher", invalidKeyException);
        }
        BigInteger[] bigIntegerArray = this.keyData.getEncSessionKey();
        if (this.keyData.getAlgorithm() == 2 || this.keyData.getAlgorithm() == 1) {
            object = bigIntegerArray[0].toByteArray();
            if (object[0] == 0) {
                cipher.update((byte[])object, 1, ((Object)object).length - 1);
            } else {
                cipher.update((byte[])object);
            }
        } else {
            object = (ElGamalKey)((Object)pGPPrivateKey.getKey());
            int n = (object.getParameters().getP().bitLength() + 7) / 8;
            byte[] byArray = new byte[n];
            byte[] byArray2 = bigIntegerArray[0].toByteArray();
            if (byArray2.length > n) {
                cipher.update(byArray2, 1, byArray2.length - 1);
            } else {
                System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
                cipher.update(byArray);
            }
            byArray2 = bigIntegerArray[1].toByteArray();
            for (int i = 0; i != byArray.length; ++i) {
                byArray[i] = 0;
            }
            if (byArray2.length > n) {
                cipher.update(byArray2, 1, byArray2.length - 1);
            } else {
                System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
                cipher.update(byArray);
            }
        }
        try {
            object = cipher.doFinal();
        }
        catch (Exception exception) {
            throw new PGPException("exception decrypting secret key", exception);
        }
        if (!this.confirmCheckSum((byte[])object)) {
            throw new PGPKeyValidationException("key checksum failed");
        }
        return object;
    }
}

