/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.DigestOutputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SymmetricKeyAlgorithmTags;
import org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.StreamGenerator;
import org.bouncycastle.openpgp.WrappedGeneratorStream;

public class PGPEncryptedDataGenerator
implements SymmetricKeyAlgorithmTags,
StreamGenerator {
    public static final int S2K_SHA1 = 2;
    public static final int S2K_SHA224 = 11;
    public static final int S2K_SHA256 = 8;
    public static final int S2K_SHA384 = 9;
    public static final int S2K_SHA512 = 10;
    private BCPGOutputStream pOut;
    private CipherOutputStream cOut;
    private Cipher c;
    private boolean withIntegrityPacket = false;
    private boolean oldFormat = false;
    private DigestOutputStream digestOut;
    private List methods = new ArrayList();
    private int defAlgorithm;
    private SecureRandom rand;
    private Provider defProvider;

    public PGPEncryptedDataGenerator(int n, SecureRandom secureRandom, String string) {
        this(n, secureRandom, Security.getProvider(string));
    }

    public PGPEncryptedDataGenerator(int n, SecureRandom secureRandom, Provider provider) {
        this.defAlgorithm = n;
        this.rand = secureRandom;
        this.defProvider = provider;
    }

    public PGPEncryptedDataGenerator(int n, boolean bl, SecureRandom secureRandom, String string) {
        this(n, bl, secureRandom, Security.getProvider(string));
    }

    public PGPEncryptedDataGenerator(int n, boolean bl, SecureRandom secureRandom, Provider provider) {
        this.defAlgorithm = n;
        this.rand = secureRandom;
        this.defProvider = provider;
        this.withIntegrityPacket = bl;
    }

    public PGPEncryptedDataGenerator(int n, SecureRandom secureRandom, boolean bl, String string) {
        this.defAlgorithm = n;
        this.rand = secureRandom;
        this.defProvider = Security.getProvider(string);
        this.oldFormat = bl;
    }

    public PGPEncryptedDataGenerator(int n, SecureRandom secureRandom, boolean bl, Provider provider) {
        this.defAlgorithm = n;
        this.rand = secureRandom;
        this.defProvider = provider;
        this.oldFormat = bl;
    }

    public void addMethod(char[] cArray) throws NoSuchProviderException, PGPException {
        this.addMethod(cArray, 2);
    }

    public void addMethod(char[] cArray, int n) throws NoSuchProviderException, PGPException {
        if (this.defProvider == null) {
            throw new NoSuchProviderException("unable to find provider.");
        }
        byte[] byArray = new byte[8];
        this.rand.nextBytes(byArray);
        S2K s2K = new S2K(n, byArray, 96);
        this.methods.add(new PBEMethod(this.defAlgorithm, s2K, PGPUtil.makeKeyFromPassPhrase(this.defAlgorithm, s2K, cArray, this.defProvider)));
    }

    public void addMethod(PGPPublicKey pGPPublicKey) throws NoSuchProviderException, PGPException {
        if (!pGPPublicKey.isEncryptionKey()) {
            throw new IllegalArgumentException("passed in key not an encryption key!");
        }
        if (this.defProvider == null) {
            throw new NoSuchProviderException("unable to find provider.");
        }
        this.methods.add(new PubMethod(pGPPublicKey));
    }

    private void addCheckSum(byte[] byArray) {
        int n = 0;
        for (int i = 1; i != byArray.length - 2; ++i) {
            n += byArray[i] & 0xFF;
        }
        byArray[byArray.length - 2] = (byte)(n >> 8);
        byArray[byArray.length - 1] = (byte)n;
    }

    private byte[] createSessionInfo(int n, Key key) {
        byte[] byArray = key.getEncoded();
        byte[] byArray2 = new byte[byArray.length + 3];
        byArray2[0] = (byte)n;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        this.addCheckSum(byArray2);
        return byArray2;
    }

    private OutputStream open(OutputStream outputStream, long l, byte[] byArray) throws IOException, PGPException, IllegalStateException {
        Object object;
        Object object2;
        if (this.cOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        if (this.methods.size() == 0) {
            throw new IllegalStateException("no encryption methods specified");
        }
        if (this.defProvider == null) {
            throw new IllegalStateException("provider resolves to null");
        }
        Key key = null;
        this.pOut = new BCPGOutputStream(outputStream);
        if (this.methods.size() == 1) {
            if (this.methods.get(0) instanceof PBEMethod) {
                object2 = (PBEMethod)this.methods.get(0);
                key = ((PBEMethod)object2).getKey();
            } else {
                key = PGPUtil.makeRandomKey(this.defAlgorithm, this.rand);
                object2 = this.createSessionInfo(this.defAlgorithm, key);
                PubMethod pubMethod = (PubMethod)this.methods.get(0);
                try {
                    pubMethod.addSessionInfo((byte[])object2);
                }
                catch (Exception exception) {
                    throw new PGPException("exception encrypting session key", exception);
                }
            }
            this.pOut.writePacket((ContainedPacket)this.methods.get(0));
        } else {
            key = PGPUtil.makeRandomKey(this.defAlgorithm, this.rand);
            object2 = this.createSessionInfo(this.defAlgorithm, key);
            for (int i = 0; i != this.methods.size(); ++i) {
                object = (EncMethod)this.methods.get(i);
                try {
                    ((EncMethod)object).addSessionInfo((byte[])object2);
                }
                catch (Exception exception) {
                    throw new PGPException("exception encrypting session key", exception);
                }
                this.pOut.writePacket((ContainedPacket)object);
            }
        }
        object2 = PGPUtil.getSymmetricCipherName(this.defAlgorithm);
        if (object2 == null) {
            throw new PGPException("null cipher specified");
        }
        try {
            Object object3;
            this.c = this.withIntegrityPacket ? Cipher.getInstance((String)object2 + "/CFB/NoPadding", this.defProvider) : Cipher.getInstance((String)object2 + "/OpenPGPCFB/NoPadding", this.defProvider);
            byte[] byArray2 = new byte[this.c.getBlockSize()];
            this.c.init(1, key, new IvParameterSpec(byArray2), this.rand);
            if (byArray == null) {
                if (this.withIntegrityPacket) {
                    this.pOut = new BCPGOutputStream(outputStream, 18, l + (long)this.c.getBlockSize() + 2L + 1L + 22L);
                    this.pOut.write(1);
                } else {
                    this.pOut = new BCPGOutputStream(outputStream, 9, l + (long)this.c.getBlockSize() + 2L, this.oldFormat);
                }
            } else if (this.withIntegrityPacket) {
                this.pOut = new BCPGOutputStream(outputStream, 18, byArray);
                this.pOut.write(1);
            } else {
                this.pOut = new BCPGOutputStream(outputStream, 9, byArray);
            }
            this.cOut = new CipherOutputStream(this.pOut, this.c);
            object = this.cOut;
            if (this.withIntegrityPacket) {
                object3 = PGPUtil.getDigestName(2);
                MessageDigest messageDigest = MessageDigest.getInstance((String)object3, this.defProvider);
                this.digestOut = new DigestOutputStream(this.cOut, messageDigest);
                object = this.digestOut;
            }
            object3 = new byte[this.c.getBlockSize() + 2];
            this.rand.nextBytes((byte[])object3);
            object3[((Object)object3).length - 1] = object3[((Object)object3).length - 3];
            object3[((Object)object3).length - 2] = object3[((Object)object3).length - 4];
            ((OutputStream)object).write((byte[])object3);
            return new WrappedGeneratorStream((OutputStream)object, this);
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }

    public OutputStream open(OutputStream outputStream, long l) throws IOException, PGPException {
        return this.open(outputStream, l, null);
    }

    public OutputStream open(OutputStream outputStream, byte[] byArray) throws IOException, PGPException {
        return this.open(outputStream, 0L, byArray);
    }

    @Override
    public void close() throws IOException {
        if (this.cOut != null) {
            if (this.digestOut != null) {
                BCPGOutputStream bCPGOutputStream = new BCPGOutputStream((OutputStream)this.digestOut, 19, 20L);
                bCPGOutputStream.flush();
                this.digestOut.flush();
                byte[] byArray = this.digestOut.getMessageDigest().digest();
                this.cOut.write(byArray);
            }
            this.cOut.flush();
            try {
                this.pOut.write(this.c.doFinal());
                this.pOut.finish();
            }
            catch (Exception exception) {
                throw new IOException(exception.toString());
            }
            this.cOut = null;
            this.pOut = null;
        }
    }

    private abstract class EncMethod
    extends ContainedPacket {
        protected byte[] sessionInfo;
        protected int encAlgorithm;
        protected Key key;

        private EncMethod() {
        }

        public abstract void addSessionInfo(byte[] var1) throws Exception;
    }

    private class PBEMethod
    extends EncMethod {
        S2K s2k;

        PBEMethod(int n, S2K s2K, Key key) {
            this.encAlgorithm = n;
            this.s2k = s2K;
            this.key = key;
        }

        public Key getKey() {
            return this.key;
        }

        @Override
        public void addSessionInfo(byte[] byArray) throws Exception {
            String string = PGPUtil.getSymmetricCipherName(this.encAlgorithm);
            Cipher cipher = Cipher.getInstance(string + "/CFB/NoPadding", PGPEncryptedDataGenerator.this.defProvider);
            cipher.init(1, this.key, new IvParameterSpec(new byte[cipher.getBlockSize()]), PGPEncryptedDataGenerator.this.rand);
            this.sessionInfo = cipher.doFinal(byArray, 0, byArray.length - 2);
        }

        @Override
        public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
            SymmetricKeyEncSessionPacket symmetricKeyEncSessionPacket = new SymmetricKeyEncSessionPacket(this.encAlgorithm, this.s2k, this.sessionInfo);
            bCPGOutputStream.writePacket(symmetricKeyEncSessionPacket);
        }
    }

    private class PubMethod
    extends EncMethod {
        PGPPublicKey pubKey;
        BigInteger[] data;

        PubMethod(PGPPublicKey pGPPublicKey) {
            this.pubKey = pGPPublicKey;
        }

        @Override
        public void addSessionInfo(byte[] byArray) throws Exception {
            Cipher cipher;
            switch (this.pubKey.getAlgorithm()) {
                case 1: 
                case 2: {
                    cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", PGPEncryptedDataGenerator.this.defProvider);
                    break;
                }
                case 16: 
                case 20: {
                    cipher = Cipher.getInstance("ElGamal/ECB/PKCS1Padding", PGPEncryptedDataGenerator.this.defProvider);
                    break;
                }
                case 17: {
                    throw new PGPException("Can't use DSA for encryption.");
                }
                case 19: {
                    throw new PGPException("Can't use ECDSA for encryption.");
                }
                default: {
                    throw new PGPException("unknown asymmetric algorithm: " + this.pubKey.getAlgorithm());
                }
            }
            PublicKey publicKey = this.pubKey.getKey(PGPEncryptedDataGenerator.this.defProvider);
            cipher.init(1, (Key)publicKey, PGPEncryptedDataGenerator.this.rand);
            byte[] byArray2 = cipher.doFinal(byArray);
            switch (this.pubKey.getAlgorithm()) {
                case 1: 
                case 2: {
                    this.data = new BigInteger[1];
                    this.data[0] = new BigInteger(1, byArray2);
                    break;
                }
                case 16: 
                case 20: {
                    byte[] byArray3 = new byte[byArray2.length / 2];
                    byte[] byArray4 = new byte[byArray2.length / 2];
                    System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
                    System.arraycopy(byArray2, byArray3.length, byArray4, 0, byArray4.length);
                    this.data = new BigInteger[2];
                    this.data[0] = new BigInteger(1, byArray3);
                    this.data[1] = new BigInteger(1, byArray4);
                    break;
                }
                default: {
                    throw new PGPException("unknown asymmetric algorithm: " + this.encAlgorithm);
                }
            }
        }

        @Override
        public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
            PublicKeyEncSessionPacket publicKeyEncSessionPacket = new PublicKeyEncSessionPacket(this.pubKey.getKeyID(), this.pubKey.getAlgorithm(), this.data);
            bCPGOutputStream.writePacket(publicKeyEncSessionPacket);
        }
    }
}

