/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl.recovery;

import com.rabbitmq.client.impl.recovery.BackoffPolicy;
import com.rabbitmq.client.impl.recovery.RecordedBinding;
import com.rabbitmq.client.impl.recovery.RecordedConsumer;
import com.rabbitmq.client.impl.recovery.RecordedEntity;
import com.rabbitmq.client.impl.recovery.RecordedExchange;
import com.rabbitmq.client.impl.recovery.RecordedQueue;
import com.rabbitmq.client.impl.recovery.RetryContext;
import com.rabbitmq.client.impl.recovery.RetryHandler;
import com.rabbitmq.client.impl.recovery.RetryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRetryHandler
implements RetryHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRetryHandler.class);
    private final RetryCondition<? super RecordedQueue> queueRecoveryRetryCondition;
    private final RetryCondition<? super RecordedExchange> exchangeRecoveryRetryCondition;
    private final RetryCondition<? super RecordedBinding> bindingRecoveryRetryCondition;
    private final RetryCondition<? super RecordedConsumer> consumerRecoveryRetryCondition;
    private final RetryOperation<?> queueRecoveryRetryOperation;
    private final RetryOperation<?> exchangeRecoveryRetryOperation;
    private final RetryOperation<?> bindingRecoveryRetryOperation;
    private final RetryOperation<?> consumerRecoveryRetryOperation;
    private final int retryAttempts;
    private final BackoffPolicy backoffPolicy;

    public DefaultRetryHandler(RetryCondition<? super RecordedQueue> queueRecoveryRetryCondition, RetryCondition<? super RecordedExchange> exchangeRecoveryRetryCondition, RetryCondition<? super RecordedBinding> bindingRecoveryRetryCondition, RetryCondition<? super RecordedConsumer> consumerRecoveryRetryCondition, RetryOperation<?> queueRecoveryRetryOperation, RetryOperation<?> exchangeRecoveryRetryOperation, RetryOperation<?> bindingRecoveryRetryOperation, RetryOperation<?> consumerRecoveryRetryOperation, int retryAttempts, BackoffPolicy backoffPolicy) {
        this.queueRecoveryRetryCondition = queueRecoveryRetryCondition;
        this.exchangeRecoveryRetryCondition = exchangeRecoveryRetryCondition;
        this.bindingRecoveryRetryCondition = bindingRecoveryRetryCondition;
        this.consumerRecoveryRetryCondition = consumerRecoveryRetryCondition;
        this.queueRecoveryRetryOperation = queueRecoveryRetryOperation;
        this.exchangeRecoveryRetryOperation = exchangeRecoveryRetryOperation;
        this.bindingRecoveryRetryOperation = bindingRecoveryRetryOperation;
        this.consumerRecoveryRetryOperation = consumerRecoveryRetryOperation;
        this.backoffPolicy = backoffPolicy;
        if (retryAttempts <= 0) {
            throw new IllegalArgumentException("Number of retry attempts must be greater than 0");
        }
        this.retryAttempts = retryAttempts;
    }

    @Override
    public RetryResult retryQueueRecovery(RetryContext context) throws Exception {
        return this.doRetry(this.queueRecoveryRetryCondition, this.queueRecoveryRetryOperation, context.queue(), context);
    }

    @Override
    public RetryResult retryExchangeRecovery(RetryContext context) throws Exception {
        return this.doRetry(this.exchangeRecoveryRetryCondition, this.exchangeRecoveryRetryOperation, context.exchange(), context);
    }

    @Override
    public RetryResult retryBindingRecovery(RetryContext context) throws Exception {
        return this.doRetry(this.bindingRecoveryRetryCondition, this.bindingRecoveryRetryOperation, context.binding(), context);
    }

    @Override
    public RetryResult retryConsumerRecovery(RetryContext context) throws Exception {
        return this.doRetry(this.consumerRecoveryRetryCondition, this.consumerRecoveryRetryOperation, context.consumer(), context);
    }

    protected <T extends RecordedEntity> RetryResult doRetry(RetryCondition<T> condition, RetryOperation<?> operation, T entity, RetryContext context) throws Exception {
        Exception exception = context.exception();
        for (int attempts = 0; attempts < this.retryAttempts; ++attempts) {
            if (condition.test(entity, exception)) {
                this.log(entity, exception, attempts);
                this.backoffPolicy.backoff(attempts + 1);
                try {
                    Object result = operation.call(context);
                    return new RetryResult(entity, result == null ? null : result.toString());
                }
                catch (Exception e) {
                    exception = e;
                    continue;
                }
            }
            throw exception;
        }
        throw exception;
    }

    protected void log(RecordedEntity entity, Exception exception, int attempts) {
        LOGGER.info("Error while recovering {}, retrying with {} more attempt(s).", entity, this.retryAttempts - attempts, exception);
    }

    public static abstract class RetryCondition<E extends RecordedEntity> {
        public abstract boolean test(E var1, Exception var2);

        public RetryCondition<E> and(final RetryCondition<? super E> other) {
            if (other == null) {
                throw new IllegalArgumentException("Condition cannot be null");
            }
            return new RetryCondition<E>(){

                @Override
                public boolean test(E entity, Exception ex) {
                    return RetryCondition.this.test(entity, ex) && other.test(entity, ex);
                }
            };
        }

        public RetryCondition<E> negate(RetryCondition<? super E> other) {
            if (other == null) {
                throw new IllegalArgumentException("Condition cannot be null");
            }
            return new RetryCondition<E>(){

                @Override
                public boolean test(E entity, Exception ex) {
                    return !RetryCondition.this.test(entity, ex);
                }
            };
        }
    }

    public static abstract class RetryOperation<T> {
        public abstract T call(RetryContext var1) throws Exception;

        public <V> RetryOperation<V> andThen(final RetryOperation<V> after) {
            return new RetryOperation<V>(){

                @Override
                public V call(RetryContext context) throws Exception {
                    RetryOperation.this.call(context);
                    return after.call(context);
                }
            };
        }
    }
}

