/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.restful.server;

import ca.infodata.util1.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import com.sun.jersey.server.impl.inject.InjectableValuesProvider;
import com.sun.jersey.spi.inject.Injectable;
import java.util.List;
import javax.ws.rs.WebApplicationException;

public class JsonParamInjectableValuesProvider
extends InjectableValuesProvider {
    public static final String JSON_ELEMENT_CONTEXT_PROPERTY_KEY = "JsonParamInjectableValuesProvider.jsonElementContextPropertyKey";

    public JsonParamInjectableValuesProvider(List<Injectable> is) {
        super(is);
    }

    public Object[] getInjectableValues(HttpContext context) {
        List is = this.getInjectables();
        Object[] params = new Object[is.size()];
        try {
            context.getProperties().put(JSON_ELEMENT_CONTEXT_PROPERTY_KEY, JsonParamInjectableValuesProvider.parseJsonElement(context));
            int index = 0;
            for (AbstractHttpContextInjectable i : is) {
                params[index++] = i.getValue(context);
            }
            Object[] objectArray = params;
            return objectArray;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (ContainerException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new ContainerException("Exception obtaining parameters", (Throwable)e);
        }
        finally {
            context.getProperties().remove(JSON_ELEMENT_CONTEXT_PROPERTY_KEY);
        }
    }

    private static JsonElement parseJsonElement(HttpContext context) {
        String entity = (String)context.getRequest().getEntity(String.class);
        if (StringUtils.isBlank(entity)) {
            throw new ContainerException("entity is blank for request " + context.getRequest());
        }
        JsonParser parser = new JsonParser();
        return parser.parse(entity);
    }
}

