/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.restful.server;

import ca.infodata.util1.restful.server.JsonParam;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.core.util.Base64;
import com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class JsonParamInjectable
extends AbstractHttpContextInjectable<Object> {
    private final JsonParam param;
    private final Type type;
    private final String signature;
    private final Gson gson;

    public JsonParamInjectable(String signature, JsonParam param, Type type, Gson gson) {
        this.signature = signature;
        this.param = param;
        this.type = type;
        this.gson = gson;
    }

    public Object getValue(HttpContext context) {
        JsonElement jsonElement = (JsonElement)context.getProperties().get("JsonParamInjectableValuesProvider.jsonElementContextPropertyKey");
        if (jsonElement == null) {
            throw new ContainerException("invalid json element in context. " + context.getRequest());
        }
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return null;
        }
        JsonElement valueJsonElement = ((JsonObject)jsonElement).get(this.param.value());
        if (valueJsonElement == null || valueJsonElement.isJsonNull()) {
            return null;
        }
        if (this.type.equals(Integer.class)) {
            Number number = valueJsonElement.getAsNumber();
            return number.intValue();
        }
        if (this.type.equals(String.class)) {
            return valueJsonElement.getAsString();
        }
        Class c = (Class)this.type;
        if (Integer.TYPE.equals(c)) {
            return valueJsonElement.getAsInt();
        }
        if (Long.TYPE.equals(c)) {
            return valueJsonElement.getAsLong();
        }
        if (Boolean.TYPE.equals(c)) {
            return valueJsonElement.getAsBoolean();
        }
        if (byte[].class.equals((Object)c)) {
            return Base64.decode(valueJsonElement.getAsString());
        }
        if (String[].class.equals((Object)c)) {
            JsonArray array = valueJsonElement.getAsJsonArray();
            String[] array2 = new String[array.size()];
            for (int i = 0; i < array2.length; ++i) {
                JsonElement e = array.get(i);
                array2[i] = e.isJsonNull() ? null : e.getAsString();
            }
            return array2;
        }
        if (int[].class.equals((Object)c)) {
            JsonArray array = valueJsonElement.getAsJsonArray();
            int[] array2 = new int[array.size()];
            for (int i = 0; i < array2.length; ++i) {
                JsonElement e = array.get(i);
                if (e.isJsonNull()) {
                    throw new NullPointerException("Unable to parse a int[] with a null value in the array: " + this.param.value() + "/ " + array);
                }
                array2[i] = e.getAsInt();
            }
            return array2;
        }
        if (long[].class.equals((Object)c)) {
            JsonArray array = valueJsonElement.getAsJsonArray();
            long[] array2 = new long[array.size()];
            for (int i = 0; i < array2.length; ++i) {
                JsonElement e = array.get(i);
                if (e.isJsonNull()) {
                    throw new NullPointerException("Unable to parse a long[] with a null value in the array: " + this.param.value() + "/ " + array);
                }
                array2[i] = e.getAsLong();
            }
            return array2;
        }
        try {
            Method method;
            if (valueJsonElement.isJsonPrimitive()) {
                Method method2 = ((Class)this.type).getDeclaredMethod("valueOf", String.class);
                if (method2 != null) {
                    return method2.invoke(null, valueJsonElement.getAsString());
                }
            } else if (valueJsonElement.isJsonArray() && valueJsonElement.getAsJsonArray().size() > 0 && (method = ((Class)this.type).getDeclaredMethod("valueOf", JsonArray.class)) != null) {
                return method.invoke(null, valueJsonElement.getAsJsonArray());
            }
        }
        catch (NoSuchMethodException method) {
        }
        catch (IllegalAccessException method) {
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.getCause().getMessage());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        return this.gson.fromJson(valueJsonElement, this.type);
    }

    public String toString() {
        return "JsonParamInjectable " + ((Object)((Object)this)).hashCode() + " [param=" + this.param + ", type=" + this.type + ", signature=" + this.signature + "]";
    }
}

