/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.restful.server;

import ca.infodata.util1.restful.server.GsonFactory;
import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.servlet.ServletConfig;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"application/json"})
public class JsonMessageBodyWriter
implements MessageBodyWriter<Object> {
    private final Gson gson;

    public JsonMessageBodyWriter(@Context ServletConfig sc) throws Exception {
        this.gson = GsonFactory.newGson(sc);
    }

    @Override
    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    @Override
    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        httpHeaders.putSingle("Content-Type", mediaType.toString());
        JsonWriter writer = new JsonWriter(new OutputStreamWriter(entityStream, "UTF-8"));
        writer.setSerializeNulls(true);
        this.gson.toJson(t, type, writer);
        writer.flush();
    }
}

