/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.restful.server;

import ca.infodata.util1.restful.JsonTypeAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.Context;

public final class GsonFactory {
    public static final String TYPE_ADAPTERS = "ca.infodata.util1.restful.server.gsonTypeAdapters";
    private static final Logger logger = Logger.getLogger("ca.infodata.util1.restful.server.GsonFactory");

    public static Gson newGson(@Context ServletConfig sc) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        GsonBuilder builder = new GsonBuilder().disableHtmlEscaping();
        String s_typeAdapters = sc.getInitParameter(TYPE_ADAPTERS);
        ArrayList<JsonTypeAdapter> adapters = new ArrayList<JsonTypeAdapter>();
        if (s_typeAdapters != null && s_typeAdapters.length() > 0) {
            Object[] split = s_typeAdapters.split(",");
            System.out.println("TypeAdapter classes found " + Arrays.toString(split));
            for (Object className : split) {
                try {
                    Class<?> c = GsonFactory.loadClass(Thread.currentThread().getContextClassLoader(), (String)className, ((String)className).replaceAll("\\.", "/"));
                    JsonTypeAdapter adapter = (JsonTypeAdapter)c.newInstance();
                    adapters.add(adapter);
                    if (adapter.asHierarchyAdapter()) {
                        builder.registerTypeHierarchyAdapter(adapter.type(), adapter);
                        continue;
                    }
                    builder.registerTypeAdapter(adapter.type(), adapter);
                }
                catch (Error e) {
                    logger.log(Level.SEVERE, "Failed to load and initialize class " + (String)className);
                    throw e;
                }
                catch (RuntimeException e) {
                    logger.log(Level.SEVERE, "Failed to load and initialize class " + (String)className);
                    throw e;
                }
            }
        }
        Gson gson = builder.create();
        for (JsonTypeAdapter adapter : adapters) {
            adapter.setGson(gson);
        }
        return gson;
    }

    private static Class<?> loadClass(ClassLoader loader, String className, String resourceName) throws ClassNotFoundException {
        try {
            return loader.loadClass(className);
        }
        catch (Throwable e) {
            ClassLoader parent = loader.getParent();
            if (parent != null) {
                return GsonFactory.loadClass(parent, className, resourceName);
            }
            NoClassDefFoundError ncdfe = new NoClassDefFoundError(className);
            logger.log(Level.WARNING, "CANT LOAD " + className, ncdfe);
            throw ncdfe;
        }
    }
}

