/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.restful;

import ca.infodata.util1.restful.Response;
import ca.infodata.util1.restful.ResponseType;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;

public class ResponseReader
implements MessageBodyReader<Object> {
    private Gson gson;

    public ResponseReader(Gson gson) {
        this.gson = gson;
    }

    public ResponseReader() {
        this(new Gson());
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Response.class.isAssignableFrom(type);
    }

    @Override
    public Response readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        JsonElement structElement;
        if (genericType instanceof ResponseType.A) {
            genericType = ((ResponseType.A)genericType).getActualTypeArguments()[0];
        }
        String s = ResponseReader.readAsString(entityStream);
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(s);
        JsonObject object = element.getAsJsonObject();
        Response response = new Response();
        JsonElement htmlElement = object.get("html");
        if (htmlElement != null && !htmlElement.isJsonNull()) {
            response.html = htmlElement.getAsString();
        }
        response.errorIndicator = false;
        JsonObject error = object.getAsJsonObject("error");
        if (error != null) {
            JsonElement messageElement;
            JsonElement indElement = error.get("ind");
            if (indElement != null && !indElement.isJsonNull()) {
                response.errorIndicator = indElement.getAsBoolean();
            }
            if ((messageElement = error.get("message")) != null && !messageElement.isJsonNull()) {
                response.errorMessage = messageElement.getAsString();
            }
        }
        if ((structElement = object.get("struct")) == null) {
            response.struct = null;
        } else if (structElement.isJsonArray()) {
            ArrayList list = new ArrayList();
            JsonArray jsonArray = structElement.getAsJsonArray();
            for (JsonElement jsonElement : jsonArray) {
                list.add(this.gson.fromJson(jsonElement, genericType));
            }
            response.struct = list;
        } else if (structElement.isJsonObject()) {
            response.struct = this.gson.fromJson(structElement, genericType);
        } else if (structElement.isJsonNull()) {
            response.struct = null;
        } else if (structElement.isJsonPrimitive()) {
            response.struct = Boolean.class.equals((Object)genericType) ? Boolean.valueOf(structElement.getAsBoolean()) : (Integer.class.equals((Object)genericType) ? Integer.valueOf(structElement.getAsInt()) : structElement.getAsString());
        }
        return response;
    }

    private static String readAsString(InputStream entityStream) throws IOException {
        String inputLine;
        BufferedReader in = new BufferedReader(new InputStreamReader(entityStream, "UTF-8"));
        StringBuilder b = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            b.append(inputLine);
        }
        String input = b.toString();
        System.out.println(input.getBytes().length);
        return input;
    }
}

