/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.date;

import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IRelativeDate;
import ca.infodata.util1.date.LocalDate;
import java.io.Serializable;

public final class RelativeDate
implements IRelativeDate,
Serializable {
    private static final long serialVersionUID = 1L;
    private Integer day;
    private Integer month;
    private Integer year;

    public RelativeDate(Integer day, Integer month, Integer year) {
        this.day = day;
        this.month = month;
        this.year = year;
    }

    @Override
    public LocalDate toAbsoluteDate() {
        LocalDate date = LocalDate.today();
        if (this.year != null) {
            date = date.plusYear(this.year);
        }
        if (this.month != null) {
            date = date.plusMonth(this.month);
        }
        if (this.day != null) {
            date = date.plusMonth(this.day);
        }
        return date;
    }

    public Integer getDay() {
        return this.day;
    }

    public void setDay(Integer day) {
        this.day = day;
    }

    public Integer getMonth() {
        return this.month;
    }

    public void setMonth(Integer month) {
        this.month = month;
    }

    public Integer getYear() {
        return this.year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public String toString() {
        JoinList list = new JoinList(" ", 3);
        if (this.day != null) {
            list.add(this.day + "d");
        }
        if (this.month != null) {
            list.add(this.month + "m");
        }
        if (this.year != null) {
            list.add(this.year + "y");
        }
        return list.toString();
    }

    public static String format(IRelativeDate date) {
        return date == null ? "" : date.toString();
    }

    @Override
    public String store() {
        return "RelativeDate;" + this.getDay() + ";" + this.getMonth() + ";" + this.getYear();
    }

    public static IRelativeDate restore(String s) {
        String[] split;
        if (StringUtils.isNotBlank(s) && (split = s.split(";")).length == 4 && split[0].equals("RelativeDate")) {
            try {
                Integer d = split[1].equals("null") ? null : Integer.valueOf(Integer.parseInt(split[1]));
                Integer m = split[2].equals("null") ? null : Integer.valueOf(Integer.parseInt(split[2]));
                Integer y = split[3].equals("null") ? null : Integer.valueOf(Integer.parseInt(split[3]));
                return new RelativeDate(d, m, y);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

