/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1;

public enum RangeNotation {
    OPEN{

        @Override
        public boolean inRange(int i, int lowerLimit, int upperLimit) {
            return i > lowerLimit && i < upperLimit;
        }
    }
    ,
    CLOSED{

        @Override
        public boolean inRange(int i, int lowerLimit, int upperLimit) {
            return i >= lowerLimit && i <= upperLimit;
        }
    }
    ,
    LEFT_CLOSED{

        @Override
        public boolean inRange(int i, int lowerLimit, int upperLimit) {
            return i >= lowerLimit && i < upperLimit;
        }
    }
    ,
    RIGHT_CLOSED{

        @Override
        public boolean inRange(int i, int lowerLimit, int upperLimit) {
            return i > lowerLimit && i <= upperLimit;
        }
    };


    public abstract boolean inRange(int var1, int var2, int var3);

    public <E extends Comparable<? super E>> boolean inRange(E e, E lowerLimit, E upperLimit) {
        if (e == null) {
            return false;
        }
        if (lowerLimit == null && upperLimit == null) {
            return true;
        }
        if (lowerLimit != null && upperLimit != null && lowerLimit.compareTo(upperLimit) == 1) {
            throw new IllegalArgumentException("lowerLimit must be lower than or equals to upperLimit");
        }
        switch (this) {
            case OPEN: {
                if (lowerLimit == null) {
                    return e.compareTo(upperLimit) < 0;
                }
                if (upperLimit == null) {
                    return e.compareTo(lowerLimit) > 0;
                }
                return e.compareTo(lowerLimit) > 0 && e.compareTo(upperLimit) < 0;
            }
            case CLOSED: {
                if (lowerLimit == null) {
                    return e.compareTo(upperLimit) <= 0;
                }
                if (upperLimit == null) {
                    return e.compareTo(lowerLimit) >= 0;
                }
                return e.compareTo(lowerLimit) >= 0 && e.compareTo(upperLimit) <= 0;
            }
            case LEFT_CLOSED: {
                if (lowerLimit == null) {
                    return e.compareTo(upperLimit) < 0;
                }
                if (upperLimit == null) {
                    return e.compareTo(lowerLimit) >= 0;
                }
                return e.compareTo(lowerLimit) >= 0 && e.compareTo(upperLimit) < 0;
            }
            case RIGHT_CLOSED: {
                if (lowerLimit == null) {
                    return e.compareTo(upperLimit) <= 0;
                }
                if (upperLimit == null) {
                    return e.compareTo(lowerLimit) > 0;
                }
                return e.compareTo(lowerLimit) > 0 && e.compareTo(upperLimit) <= 0;
            }
        }
        throw new IllegalStateException("should never pass here");
    }
}

