/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1;

import ca.infodata.util1.JoinIterable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class JoinIterator<E>
implements Iterator<E> {
    private Collection<E>[] collections;
    private Iterator<E> iterator;
    private int index;
    private int collectionIndex;
    private int[] collectionSize;

    public JoinIterator(Collection<E> ... collections) {
        this.collections = collections;
        this.index = 0;
        this.collectionIndex = 0;
        this.collectionSize = new int[collections.length];
        for (int i = 0; i < collections.length; ++i) {
            this.collectionSize[i] = i == 0 ? collections[i].size() : this.collectionSize[i - 1] + collections[i].size();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.collectionIndex > this.collections.length - 1) {
            return false;
        }
        if (this.index < this.collectionSize[this.collectionIndex] - 1) {
            return true;
        }
        if (this.collectionIndex < this.collections.length - 1) {
            ++this.collectionIndex;
            this.iterator = this.collections[this.collectionIndex].iterator();
            return this.hasNext();
        }
        return false;
    }

    @Override
    public E next() {
        if (this.iterator == null) {
            if (this.hasNext()) {
                this.iterator = this.collections[this.collectionIndex].iterator();
                return this.iterator.next();
            }
            throw new NoSuchElementException();
        }
        if (this.index < this.collectionSize[this.collectionIndex] - 1) {
            ++this.index;
            return this.iterator.next();
        }
        if (this.collectionIndex < this.collections.length - 1) {
            ++this.collectionIndex;
            this.iterator = this.collections[this.collectionIndex].iterator();
            return this.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) {
        List<Integer> list1 = Arrays.asList(1, 2, 3, 4);
        List<Integer> list2 = Arrays.asList(5, 6, 7, 8);
        List<Object> list3 = Arrays.asList(new Object[0]);
        for (Integer n : new JoinIterable<Object>((Collection<Object>)list1, (Collection<Object>)list2, (Collection<Object>)list3)) {
            System.out.println(n);
        }
    }
}

