/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq;

import ca.infodata.dsq.signaturexml.DsqToolApplication;
import ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq.RabbitMqThreadFactory;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.date.DateUtil;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ExceptionHandler;
import com.rabbitmq.client.Recoverable;
import com.rabbitmq.client.RecoveryListener;
import com.rabbitmq.client.TopologyRecoveryException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class RabbitMqConnection {
    private static final Logger logger = Logger.getLogger(RabbitMqConnection.class.getName());
    private static final String mqUser = "ofys4DesktopWin";
    private static final String mqPswd = "mq#dWsP@!o5%pq";
    private static final String exchange = "ofys_app";
    private static final String type = "topic";
    private ExecutorService bindingExecutor;
    private ExecutorService handleDeliveryExecutor;
    private ScheduledExecutorService testServiceExecutor;
    private Connection connection;
    private final ReentrantLock publishChannelLock = new ReentrantLock();
    private final ReentrantLock consumeChannelLock = new ReentrantLock();
    private Channel publishChannel;
    private Channel consumeChannel;
    private Consumer consumer;
    private final String queueName;
    private final Integer sessionId;
    private String userName;
    private String clientCode;
    private volatile boolean active;

    public RabbitMqConnection(String clientCode, String userName, Integer sessionId, ExecutorService handleDeliveryExecutor) throws Exception {
        this.sessionId = sessionId;
        this.handleDeliveryExecutor = handleDeliveryExecutor;
        this.userName = userName;
        this.clientCode = clientCode;
        this.queueName = String.valueOf(clientCode) + ":" + userName + ":" + sessionId;
        this.createConnexion();
        this.createChannel();
        if (this.consumeChannel != null) {
            this.createQueue();
            this.createConsumer();
            this.bindingExecutor = Executors.newCachedThreadPool(new RabbitMqThreadFactory("rabbitmq-binding"));
            this.active = true;
        }
    }

    private void createQueue() throws IOException {
        logger.log(Level.INFO, "createQueue");
        boolean durable = true;
        boolean exclusive = false;
        boolean autodelete = false;
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put("x-expires", TimeUnit.HOURS.toMillis(6L));
        arguments.put("v", "1.0.0");
        arguments.put("t", DateUtil.format(System.currentTimeMillis(), "yyyy-MM-dd HH:mm"));
        AMQP.Queue.DeclareOk declareOk = this.consumeChannel.queueDeclare(this.queueName, durable, exclusive, autodelete, arguments);
        logger.info(String.valueOf(declareOk));
    }

    private void createChannel() throws IOException {
        if (this.connection != null) {
            logger.log(Level.INFO, "createChannel");
            this.consumeChannel = this.connection.createChannel();
            ChannelRecoveryListener recListenerConsume = new ChannelRecoveryListener(this.consumeChannel);
            ((Recoverable)((Object)this.consumeChannel)).addRecoveryListener(recListenerConsume);
            this.publishChannel = this.connection.createChannel();
            ChannelRecoveryListener recListenerPublish = new ChannelRecoveryListener(this.publishChannel);
            ((Recoverable)((Object)this.publishChannel)).addRecoveryListener(recListenerPublish);
            this.createExchange(this.consumeChannel);
            this.createExchange(this.publishChannel);
        }
    }

    private void createExchange(Channel channel) throws IOException {
        boolean durable = true;
        boolean autodelete = false;
        boolean internal = false;
        Map<String, Object> arguments = null;
        AMQP.Exchange.DeclareOk declareOk = channel.exchangeDeclare(exchange, type, durable, autodelete, internal, arguments);
        logger.info(String.valueOf(declareOk));
    }

    private void createConnexion() {
        HashMap<String, Object> clientProp = new HashMap<String, Object>();
        String clientCode = "inc";
        String user = "inc";
        if (this.sessionId != null && this.clientCode != null) {
            clientCode = this.clientCode;
            user = this.userName;
        }
        clientProp.put("Code client", clientCode);
        clientProp.put("User", user);
        clientProp.put("Version", "1.0.0");
        ConnectionFactory factory = new ConnectionFactory();
        factory.setUsername(mqUser);
        factory.setPassword(mqPswd);
        String rabbitMqUrl = System.getProperty("rabbitMqUrl");
        if (rabbitMqUrl != null) {
            factory.setHost(rabbitMqUrl);
        } else {
            factory.setHost(DsqToolApplication.propertiesFile.getProperty("rabbitMqUrl", "69.70.45.133"));
        }
        try {
            String rabbitMqPort = System.getProperty("rabbitMqPort");
            if (rabbitMqPort != null) {
                factory.setPort(Integer.parseInt(rabbitMqPort));
            } else {
                factory.setPort(Integer.parseInt(DsqToolApplication.propertiesFile.getProperty("rabbitMqPort", "5672")));
            }
        }
        catch (Exception exception) {
            factory.setPort(5672);
        }
        factory.setAutomaticRecoveryEnabled(true);
        factory.setNetworkRecoveryInterval(10000);
        factory.setTopologyRecoveryEnabled(true);
        factory.setConnectionTimeout(10000);
        factory.setRequestedHeartbeat(15);
        factory.setExceptionHandler(new ExceptionHandler(){

            @Override
            public void handleBlockedListenerException(Connection c, Throwable t) {
                logger.info("ExceptionHandler.handleBlockedListenerException " + RabbitMqConnection.this.formatConnection(c) + "\n" + RabbitMqConnection.this.getStackTraceAsString(t));
            }

            @Override
            public void handleChannelRecoveryException(Channel h, Throwable t) {
                logger.info("ExceptionHandler.handleChannelRecoveryException " + RabbitMqConnection.this.formatChannel(h) + "\n" + RabbitMqConnection.this.getStackTraceAsString(t));
            }

            @Override
            public void handleConfirmListenerException(Channel h, Throwable t) {
                logger.info("ExceptionHandler.handleConfirmListenerException " + RabbitMqConnection.this.formatChannel(h) + "\n" + RabbitMqConnection.this.getStackTraceAsString(t));
            }

            @Override
            public void handleConnectionRecoveryException(Connection c, Throwable t) {
                logger.info("ExceptionHandler.handleConnectionRecoveryException " + RabbitMqConnection.this.formatConnection(c) + "\n" + RabbitMqConnection.this.getStackTraceAsString(t));
            }

            @Override
            public void handleConsumerException(Channel h, Throwable t, Consumer s, String arg3, String arg4) {
                logger.info("ExceptionHandler.handleConsumerException " + RabbitMqConnection.this.formatChannel(h) + "\n" + s.toString() + "\n" + RabbitMqConnection.this.getStackTraceAsString(t));
            }

            @Override
            public void handleFlowListenerException(Channel h, Throwable t) {
                logger.info("ExceptionHandler.handleFlowListenerException " + RabbitMqConnection.this.formatChannel(h) + "\n" + RabbitMqConnection.this.getStackTraceAsString(t));
            }

            @Override
            public void handleReturnListenerException(Channel h, Throwable t) {
                logger.info("ExceptionHandler.handleReturnListenerException " + RabbitMqConnection.this.formatChannel(h) + "\n" + RabbitMqConnection.this.getStackTraceAsString(t));
            }

            @Override
            public void handleTopologyRecoveryException(Connection c, Channel h, TopologyRecoveryException tr) {
                logger.info("ExceptionHandler.handleTopologyRecoveryException " + RabbitMqConnection.this.formatConnection(c) + "\n" + RabbitMqConnection.this.formatChannel(h) + "\n" + tr.getMessage());
            }

            @Override
            public void handleUnexpectedConnectionDriverException(Connection c, Throwable t) {
                logger.info("ExceptionHandler.handleUnexpectedConnectionDriverException " + RabbitMqConnection.this.formatConnection(c) + "\n" + RabbitMqConnection.this.getStackTraceAsString(t));
            }
        });
        factory.setClientProperties(clientProp);
        try {
            factory.useSslProtocol();
            this.connection = factory.newConnection();
            ((Recoverable)((Object)this.connection)).addRecoveryListener(new RecoveryListener(){

                @Override
                public void handleRecovery(Recoverable r) {
                    logger.info("RecoveryListener handleRecovery " + RabbitMqConnection.this.formatConnection(RabbitMqConnection.this.connection));
                }

                @Override
                public void handleRecoveryStarted(Recoverable r) {
                    logger.info("RecoveryListener handleRecoveryStarted " + RabbitMqConnection.this.formatConnection(RabbitMqConnection.this.connection));
                }
            });
        }
        catch (Exception e) {
            logger.info("createConnexion - newConnection error " + e.getMessage());
        }
    }

    protected abstract void onFailure();

    private synchronized void fail() {
        if (this.isActive()) {
            logger.info("RabbitMqConnection.fail()");
            this.close(false);
            this.onFailure();
        } else {
            logger.info("RabbitMqConnection already has failed.");
        }
    }

    private void setInactive() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    private void createConsumer() throws IOException {
        logger.log(Level.INFO, "createConsumer");
        this.consumer = new DefaultConsumerExtension(this.consumeChannel);
        boolean autoAck = false;
        this.consumeChannel.basicConsume(this.queueName, autoAck, this.consumer);
    }

    public void basicPublish(String routingKey, AMQP.BasicProperties properties, byte[] body) throws Exception {
        if (this.isActive()) {
            try {
                logger.info("basic publish to " + routingKey);
                this.publishChannelLock.lock();
                this.publishChannel.basicPublish(exchange, routingKey, properties, body);
                this.publishChannelLock.unlock();
            }
            catch (Exception e) {
                this.publishChannelLock.unlock();
                throw e;
            }
        } else {
            logger.log(Level.SEVERE, "Failed to publish on channel with binding " + routingKey + " to exchange " + exchange + " because connection has failed");
        }
    }

    public void queueBindAsync(String bindingKey) {
        if (this.isActive()) {
            this.bindingExecutor.submit(new QueueBindRunnable(bindingKey));
        } else {
            logger.log(Level.SEVERE, "Failed to ADD bindingKey " + bindingKey + " to queue " + this.queueName + " because connection has failed");
        }
    }

    public void queueUnbindAsync(String bindingKey) {
        if (this.isActive()) {
            this.bindingExecutor.submit(new QueueUnbindRunnable(bindingKey));
        } else {
            logger.log(Level.SEVERE, "Failed to REMOVE bindingKey " + bindingKey + " from queue " + this.queueName + " because connection has failed");
        }
    }

    private String formatChannel(Channel c) {
        String f;
        if (c == null) {
            f = "channel is null";
        } else {
            ArrayList<String> l = new ArrayList<String>();
            l.add("channelNumber:" + c.getChannelNumber());
            if (c.getDefaultConsumer() != null) {
                l.add("defaultConsumer non null");
            }
            if (c.getCloseReason() != null) {
                l.add("closeReason: " + this.getStackTraceAsString(c.getCloseReason()));
            }
            f = new JoinList(",", l).toString();
        }
        return f;
    }

    private String formatConnection(Connection c) {
        String f;
        if (c == null) {
            f = "connection is null";
        } else {
            ArrayList<String> l = new ArrayList<String>();
            if (c.isOpen()) {
                l.add("isOpen");
            }
            if (c.getAddress() != null) {
                l.add("hostAddress:" + c.getAddress().getHostAddress());
            }
            l.add("port:" + c.getPort());
            f = new JoinList(",", l).toString();
        }
        return f;
    }

    private String getStackTraceAsString(Throwable t) {
        StringWriter errors = new StringWriter();
        t.printStackTrace(new PrintWriter(errors));
        return errors.toString();
    }

    public void applicationShudown() {
        this.setInactive();
        try {
            if (this.testServiceExecutor != null) {
                this.testServiceExecutor.shutdownNow();
            }
        }
        catch (Exception e1) {
            logger.log(Level.INFO, "RabbitMqProducer.executorTestService.shutdown", e1);
        }
        try {
            if (this.bindingExecutor != null && !this.bindingExecutor.isShutdown()) {
                this.bindingExecutor.shutdownNow();
            }
        }
        catch (Exception e1) {
            logger.log(Level.INFO, "RabbitMqProducer.executorService.shutdown", e1);
        }
        try {
            if (this.connection != null) {
                logger.log(Level.INFO, "Close: Connection abort");
                this.connection.abort(500);
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Connection abort", e);
        }
    }

    public void close(boolean deleteQueue) {
        logger.log(Level.FINE, "RabbitMqConnection.close");
        this.setInactive();
        try {
            if (this.testServiceExecutor != null) {
                this.testServiceExecutor.shutdownNow();
            }
        }
        catch (Exception e1) {
            logger.log(Level.INFO, "RabbitMqProducer.executorTestService.shutdown", e1);
        }
        try {
            if (this.bindingExecutor != null && !this.bindingExecutor.isShutdown()) {
                this.bindingExecutor.shutdownNow();
            }
        }
        catch (Exception e1) {
            logger.log(Level.INFO, "RabbitMqProducer.executorService.shutdown", e1);
        }
        if (deleteQueue) {
            try {
                logger.log(Level.INFO, "Close: Queue delete");
                this.consumeChannelLock.lock();
                if (this.consumeChannel != null && this.queueName != null) {
                    this.consumeChannel.queueDelete(this.queueName);
                }
                this.consumeChannelLock.unlock();
            }
            catch (Exception e) {
                this.consumeChannelLock.unlock();
                logger.log(Level.INFO, "Failed to delete queue", e);
            }
        }
        try {
            if (this.connection != null) {
                logger.log(Level.INFO, "Close: Connection abort");
                this.connection.abort();
                this.connection = null;
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Connection abort", e);
        }
    }

    public abstract void handleDelivery(ExecutorService var1, String var2, Envelope var3, AMQP.BasicProperties var4, byte[] var5) throws IOException;

    class ChannelRecoveryListener
    implements RecoveryListener {
        private Channel channel;

        public ChannelRecoveryListener(Channel c) {
            this.channel = c;
        }

        @Override
        public void handleRecovery(Recoverable r) {
            logger.info("RecoveryListener handleRecovery " + RabbitMqConnection.this.formatChannel(this.channel));
        }

        @Override
        public void handleRecoveryStarted(Recoverable r) {
            logger.info("RecoveryListener handleRecoveryStarted " + RabbitMqConnection.this.formatChannel(this.channel));
        }
    }

    private final class DefaultConsumerExtension
    extends DefaultConsumer {
        private DefaultConsumerExtension(Channel channel) {
            super(channel);
        }

        @Override
        public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
            block4: {
                try {
                    if (RabbitMqConnection.this.handleDeliveryExecutor.isShutdown()) break block4;
                    try {
                        boolean multiple = false;
                        this.getChannel().basicAck(envelope.getDeliveryTag(), multiple);
                    }
                    catch (Exception e1) {
                        logger.log(Level.SEVERE, "consumer handleDelivery", e1);
                    }
                    RabbitMqConnection.this.handleDelivery(RabbitMqConnection.this.handleDeliveryExecutor, consumerTag, envelope, properties, body);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "consumer handleDelivery", e);
                }
            }
        }
    }

    private final class QueueBindRunnable
    implements Runnable {
        private final String bindingKey;

        private QueueBindRunnable(String bindingKey) {
            this.bindingKey = bindingKey;
        }

        @Override
        public void run() {
            try {
                try {
                    RabbitMqConnection.this.consumeChannelLock.lock();
                    Map<String, Object> arguments = null;
                    RabbitMqConnection.this.consumeChannel.queueBind(RabbitMqConnection.this.queueName, RabbitMqConnection.exchange, this.bindingKey, arguments);
                    logger.log(Level.INFO, "ADDED bindingKey " + this.bindingKey + " to queue " + RabbitMqConnection.this.queueName);
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Failed to ADD bindingKey " + this.bindingKey + " to queue " + RabbitMqConnection.this.queueName, e);
                    RabbitMqConnection.this.consumeChannelLock.unlock();
                }
            }
            finally {
                RabbitMqConnection.this.consumeChannelLock.unlock();
            }
        }
    }

    private final class QueueUnbindRunnable
    implements Runnable {
        private final String bindingKey;

        private QueueUnbindRunnable(String bindingKey) {
            this.bindingKey = bindingKey;
        }

        @Override
        public void run() {
            try {
                try {
                    RabbitMqConnection.this.consumeChannelLock.lock();
                    Map<String, Object> arguments = null;
                    RabbitMqConnection.this.consumeChannel.queueUnbind(RabbitMqConnection.this.queueName, RabbitMqConnection.exchange, this.bindingKey, arguments);
                    logger.log(Level.INFO, "REMOVED bindingKey " + this.bindingKey + " from queue " + RabbitMqConnection.this.queueName);
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Failed to REMOVE bindingKey " + this.bindingKey + " from queue " + RabbitMqConnection.this.queueName, e);
                    RabbitMqConnection.this.consumeChannelLock.unlock();
                }
            }
            finally {
                RabbitMqConnection.this.consumeChannelLock.unlock();
            }
        }
    }
}

