/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq;

import ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq.NotificationData;
import ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq.RabbitMqConsumer2;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import com.rabbitmq.client.AMQP;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.SerializationUtils;

public class BasicPublishTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(BasicPublishTask.class.getName());
    private Notification notification;
    private Integer toUserId;
    private final RabbitMqConsumer2 consumer;
    private String clientCode;
    private String userName;
    private Integer sessionId;

    public BasicPublishTask(RabbitMqConsumer2 consumer, String username, String clientCode, Integer sessionId) {
        this.consumer = consumer;
        this.sessionId = sessionId;
        this.clientCode = clientCode;
        this.userName = username;
    }

    @Override
    public void run() {
        try {
            String expiration = "" + TimeUnit.HOURS.toMillis(1L);
            int priority = 2;
            int deliverMode = 1;
            HashSet lstRoutingKeys = new HashSet();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("sessionId", this.sessionId);
            params.put("uName", this.userName);
            AMQP.BasicProperties properties = new AMQP.BasicProperties.Builder().deliveryMode(deliverMode).contentType("application/octet-stream").expiration(expiration).priority(priority).headers(params).build();
            byte[] body = SerializationUtils.serialize(this.notification);
            for (String rk : lstRoutingKeys) {
                this.consumer.getConnection().basicPublish(rk, properties, body);
                this.consumer.getNotifications().add(new NotificationData(System.currentTimeMillis(), NotificationData.IO.OUT));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to send notification(s) " + this.notification + " from client" + this.clientCode, e);
        }
    }

    public Notification getNotification() {
        return this.notification;
    }

    public void setNotification(Notification notification) {
        this.notification = notification;
    }

    public Integer getToUserId() {
        return this.toUserId;
    }

    public void setToUserId(Integer toUserId) {
        this.toUserId = toUserId;
    }
}

