/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq;

import ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq.RabbitMqConsumer2;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.SerializationUtils;

public class BasicConsumeTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(BasicConsumeTask.class.getName());
    protected RabbitMqConsumer2 consumer;
    private Envelope envelope;
    private AMQP.BasicProperties properties;
    private byte[] body;

    public BasicConsumeTask(RabbitMqConsumer2 consumer, String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
        this.consumer = consumer;
        this.envelope = envelope;
        this.properties = properties;
        this.body = body;
    }

    @Override
    public void run() {
        try {
            Object object;
            logger.info("-->handleDelivery - tag = " + this.envelope.getDeliveryTag());
            Integer session = this.consumer.getActiveSessionId();
            if (session != null && this.shouldProcess(session, object = SerializationUtils.deserialize(this.body))) {
                this.onMessage(object);
            }
        }
        catch (Exception e) {
            logger.info("erreur: " + this.properties);
            logger.log(Level.SEVERE, "consumer handleDelivery", e);
        }
    }

    private boolean shouldProcess(Integer session, Object object) {
        boolean doitAnyway = true;
        return doitAnyway;
    }

    private Integer parseMessageSessionId() {
        Integer sessionId = null;
        if (this.properties.getHeaders() != null && this.properties.getHeaders().containsKey("sessionId")) {
            try {
                sessionId = (Integer)this.properties.getHeaders().get("sessionId");
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "properties.getHeaders().get('sessionId') dans messageSelector: ", e);
            }
        }
        return sessionId;
    }

    private void onMessage(Object object) {
        try {
            if (object instanceof Notification) {
                this.consumer.process((Notification)object);
            } else if (object instanceof Notification[]) {
                this.consumer.process((Notification[])object);
            } else {
                logger.log(Level.SEVERE, "Unsupported message object received " + object);
            }
        }
        catch (Exception e) {
            String smessage;
            try {
                smessage = String.valueOf(object);
            }
            catch (Exception e2) {
                smessage = e2.getMessage();
            }
            logger.log(Level.SEVERE, "Unexpected exception for message " + smessage, e);
        }
    }
}

