/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq_calls.web;

import ca.infodata.dsq.signature.Pkcs7Signature;
import ca.infodata.dsq.signature.Pkcs7SignatureI;
import ca.infodata.dsq.signature.XmlSignature;
import ca.infodata.dsq.signature.XmlSignatureCore;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.dsq.signature.XmlSignatureS;
import ca.infodata.dsq_calls.web.CancelException;
import ca.infodata.dsq_calls.web.DeactivateException;
import ca.infodata.dsq_calls.web.Pair;
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class DSQApplet
extends JApplet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(DSQApplet.class.getName());
    private static final String appletInfo = "DSQ Web Security 2.0, Logiciels INFO-DATA inc., All rights reserved.";
    private Image logo;
    private Map<String, SignatureData> signatureCache;
    private Map<String, SignatureData> signatureCachePkcs7;
    private Map<Pair<String, String>, SignatureData> signatureNiuCache;
    private Map<Pair<String, String>, SignatureData> signatureNiuCachePkcs7;
    private Set<String> usedAliases;
    private volatile boolean forceResetCache;
    private XmlSignatureCore core;

    @Override
    public void init() {
        super.init();
        this.loadLogo();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Security.addProvider(new BouncyCastleProvider());
                return null;
            }
        });
        this.signatureCache = new HashMap<String, SignatureData>();
        this.signatureNiuCache = new HashMap<Pair<String, String>, SignatureData>();
        this.signatureCachePkcs7 = new HashMap<String, SignatureData>();
        this.signatureNiuCachePkcs7 = new HashMap<Pair<String, String>, SignatureData>();
        this.usedAliases = new HashSet<String>();
        this.forceResetCache = true;
        this.core = new XmlSignatureCore();
    }

    @Override
    public void destroy() {
        this.logo = null;
        this.signatureCache.clear();
        this.signatureNiuCache.clear();
        this.signatureCachePkcs7.clear();
        this.signatureNiuCachePkcs7.clear();
        this.usedAliases.clear();
        super.destroy();
    }

    public String getSignatureI(final String alias, final String password) throws CancelException, DeactivateException {
        if (alias != null) {
            this.cleanSignatureCache();
            SignatureData signatureData = this.signatureCache.get(alias);
            if (signatureData != null && !signatureData.hasExpired()) {
                return signatureData.signature;
            }
        }
        String jsonSignature = null;
        do {
            try {
                XmlSignature xmlSignature = AccessController.doPrivileged(new PrivilegedExceptionAction<XmlSignature>(){

                    @Override
                    public XmlSignature run() throws Exception {
                        DSQApplet.this.core.initOnChange(alias, password);
                        XmlSignatureI s = new XmlSignatureI();
                        s.sign(DSQApplet.this.core);
                        return s;
                    }
                });
                jsonSignature = this.toJsonSignature(xmlSignature);
            }
            catch (Exception e) {
                String message = this.getExceptionMessage(e);
                if (DSQApplet.isBlank(message)) {
                    throw new CancelException();
                }
                this.showTryOrCancelDialog(message);
            }
        } while (jsonSignature == null);
        if (jsonSignature != null) {
            this.forceResetCache = false;
            this.signatureCache.put(alias, new SignatureData(jsonSignature));
        }
        return jsonSignature;
    }

    public String getSignatureIPkcs7(final String alias, final String password) throws CancelException, DeactivateException {
        if (alias != null) {
            this.cleanSignatureCache();
            SignatureData signatureData = this.signatureCachePkcs7.get(alias);
            if (signatureData != null && !signatureData.hasExpired()) {
                return signatureData.signature;
            }
        }
        String jsonSignature = null;
        do {
            try {
                Pkcs7Signature signature = AccessController.doPrivileged(new PrivilegedExceptionAction<Pkcs7Signature>(){

                    @Override
                    public Pkcs7Signature run() throws Exception {
                        Pkcs7SignatureI s = new Pkcs7SignatureI();
                        s.sign(alias, password, DSQApplet.this.forceResetCache);
                        return s;
                    }
                });
                jsonSignature = this.toJsonSignature(signature);
            }
            catch (Exception e) {
                String message = this.getExceptionMessage(e);
                if (DSQApplet.isBlank(message)) {
                    throw new CancelException();
                }
                this.showTryOrCancelDialog(message);
            }
        } while (jsonSignature == null);
        if (jsonSignature != null) {
            this.forceResetCache = false;
            this.signatureCachePkcs7.put(alias, new SignatureData(jsonSignature));
        }
        return jsonSignature;
    }

    private String toJsonSignature(XmlSignature signature) throws Exception {
        String json = "";
        if (signature != null) {
            String isXml = "\"isXml\" : true";
            String xmlToken = "\"xmlToken\" : \"" + signature.getToken() + "\"";
            String xmlActor = "\"xmlActor\" : \"" + signature.getActor() + "\"";
            String xmlSignature = "\"xmlSignature\" : \"" + DSQApplet.escapeDoubleQuotes(signature.getXmlSignature()) + "\"";
            json = "{" + isXml + ", " + xmlToken + ", " + xmlActor + ", " + xmlSignature + "}";
        }
        return json;
    }

    private String toJsonSignature(Pkcs7Signature signature) throws Exception {
        String json = "";
        if (signature != null) {
            String isXml = "\"isPkcs7\" : true";
            String xmlToken = "\"pkcs7Data\" : \"" + signature.getData() + "\"";
            String xmlActor = "\"pkcs7Actor\" : \"" + signature.getActor() + "\"";
            String xmlSignature = "\"pkcs7Signature\" : \"" + DSQApplet.escapeDoubleQuotes(signature.getSignature()) + "\"";
            json = "{" + isXml + ", " + xmlToken + ", " + xmlActor + ", " + xmlSignature + "}";
        }
        return json;
    }

    private static String escapeDoubleQuotes(String s) {
        String s2 = s.replaceAll("\"", "\\\\\"");
        return s2;
    }

    private int showTryOrCancelDialog(String message) throws CancelException, DeactivateException {
        String retry = "R\u00e9essayer";
        String cancel = "Annuler";
        String deactivate = "D\u00e9sactiver pour cette session";
        JOptionPane pane = new JOptionPane();
        pane.setMessage(message);
        pane.setOptions(new String[]{"R\u00e9essayer", "D\u00e9sactiver pour cette session", "Annuler"});
        pane.setMessageType(2);
        pane.setValue("R\u00e9essayer");
        JDialog dialog = pane.createDialog(this, "???");
        dialog.setModal(true);
        dialog.setVisible(true);
        Object value = pane.getValue();
        if ("R\u00e9essayer".equals(value)) {
            return 0;
        }
        if ("D\u00e9sactiver pour cette session".equals(value)) {
            throw new DeactivateException();
        }
        throw new CancelException();
    }

    public final String getSignatureI(final String alias, final String password, final String niu) throws CancelException, DeactivateException {
        if (alias != null && niu != null) {
            this.cleanSignatureNiuCache();
            SignatureData signatureData = this.signatureNiuCache.get(Pair.newPair(alias, niu));
            if (signatureData != null && !signatureData.hasExpired()) {
                return signatureData.signature;
            }
        }
        String jsonSignature = null;
        do {
            try {
                XmlSignature xmlSignature = AccessController.doPrivileged(new PrivilegedExceptionAction<XmlSignature>(){

                    @Override
                    public XmlSignature run() throws Exception {
                        DSQApplet.this.core.initOnChange(alias, password);
                        XmlSignatureI s = new XmlSignatureI(niu);
                        s.sign(DSQApplet.this.core);
                        return s;
                    }
                });
                jsonSignature = this.toJsonSignature(xmlSignature);
            }
            catch (Exception e) {
                String message = this.getExceptionMessage(e);
                if (DSQApplet.isBlank(message)) {
                    throw new CancelException();
                }
                this.showTryOrCancelDialog(message);
            }
        } while (jsonSignature == null);
        if (jsonSignature != null) {
            this.forceResetCache = false;
            this.signatureNiuCache.put(Pair.newPair(alias, niu), new SignatureData(jsonSignature));
        }
        return jsonSignature;
    }

    public final String getSignatureIPkcs7(final String alias, final String password, final String niu) throws CancelException, DeactivateException {
        if (alias != null && niu != null) {
            this.cleanSignatureNiuCache();
            SignatureData signatureData = this.signatureNiuCachePkcs7.get(Pair.newPair(alias, niu));
            if (signatureData != null && !signatureData.hasExpired()) {
                return signatureData.signature;
            }
        }
        String jsonSignature = null;
        do {
            try {
                Pkcs7Signature signature = AccessController.doPrivileged(new PrivilegedExceptionAction<Pkcs7Signature>(){

                    @Override
                    public Pkcs7Signature run() throws Exception {
                        Pkcs7SignatureI s = new Pkcs7SignatureI(niu);
                        s.sign(alias, password, DSQApplet.this.forceResetCache);
                        return s;
                    }
                });
                jsonSignature = this.toJsonSignature(signature);
            }
            catch (Exception e) {
                String message = this.getExceptionMessage(e);
                if (DSQApplet.isBlank(message)) {
                    throw new CancelException();
                }
                this.showTryOrCancelDialog(message);
            }
        } while (jsonSignature == null);
        if (jsonSignature != null) {
            this.forceResetCache = false;
            this.signatureNiuCachePkcs7.put(Pair.newPair(alias, niu), new SignatureData(jsonSignature));
        }
        return jsonSignature;
    }

    public final String getSignatureS(final String alias, final String password, final String hash) throws CancelException, DeactivateException {
        String jsonSignature = null;
        do {
            try {
                XmlSignature xmlSignature = AccessController.doPrivileged(new PrivilegedExceptionAction<XmlSignature>(){

                    @Override
                    public XmlSignature run() throws Exception {
                        DSQApplet.this.core.initOnChange(alias, password);
                        XmlSignatureS s = new XmlSignatureS(hash);
                        s.sign(DSQApplet.this.core);
                        return s;
                    }
                });
                jsonSignature = this.toJsonSignature(xmlSignature);
            }
            catch (Exception e) {
                String message = this.getExceptionMessage(e);
                if (DSQApplet.isBlank(message)) {
                    throw new CancelException();
                }
                this.showTryOrCancelDialog(message);
            }
        } while (jsonSignature == null);
        if (jsonSignature != null) {
            this.forceResetCache = false;
        }
        return jsonSignature;
    }

    private String getExceptionMessage(Throwable e) {
        String message;
        if (e == null) {
            return "";
        }
        if (e instanceof KeyStoreException && (message = e.getMessage()).indexOf("cannot be found in keyStore") != -1) {
            String alias = message.substring(6, message.indexOf("cannot"));
            return "L'alias " + alias + " n'a pu \u00eatre trouv\u00e9e dans le registre. " + "\n" + "\n1. Assurez-vous d'avoir ins\u00e9rer votre cl\u00e9 s\u00e9curis\u00e9e dans un port USB. " + "\n2. Essayez d'enlever et de r\u00e9ins\u00e9rer votre cl\u00e9 s\u00e9curis\u00e9e. " + "\n3. Assurez-vous \u00e9galement que l'alias saisi dans votre fiche professionnelle correspond bien \u00e0 l'alias de votre cl\u00e9.";
        }
        SignatureException signatureException = DSQApplet.getSignatureException(e);
        if (signatureException != null) {
            return signatureException.getLocalizedMessage();
        }
        return e.getMessage();
    }

    private static SignatureException getSignatureException(Throwable e) {
        while (e != null) {
            if (e instanceof SignatureException) {
                return (SignatureException)e;
            }
            e = e.getCause();
        }
        return null;
    }

    private void cleanSignatureNiuCache() {
        Iterator<Map.Entry<Pair<String, String>, SignatureData>> iterator2 = this.signatureNiuCache.entrySet().iterator();
        while (iterator2.hasNext()) {
            if (!iterator2.next().getValue().hasExpired()) continue;
            iterator2.remove();
        }
        iterator2 = this.signatureNiuCachePkcs7.entrySet().iterator();
        while (iterator2.hasNext()) {
            if (!iterator2.next().getValue().hasExpired()) continue;
            iterator2.remove();
        }
    }

    private void cleanSignatureCache() {
        Iterator<Map.Entry<String, SignatureData>> iterator = this.signatureCache.entrySet().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getValue().hasExpired()) continue;
            iterator.remove();
        }
        iterator = this.signatureCachePkcs7.entrySet().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getValue().hasExpired()) continue;
            iterator.remove();
        }
    }

    public void resetState() {
        this.forceResetCache = true;
        this.signatureCache.clear();
        this.signatureNiuCache.clear();
        this.signatureCachePkcs7.clear();
        this.signatureNiuCachePkcs7.clear();
        if (!this.usedAliases.isEmpty()) {
            try {
                KeyStore keyStore = KeyStore.getInstance("Windows-MY", "SunMSCAPI");
                keyStore.load(null, null);
                for (String alias : this.usedAliases) {
                    try {
                        System.out.println("deleting " + alias);
                        keyStore.deleteEntry(alias);
                    }
                    catch (Exception e) {
                        logger.log(Level.INFO, "Failed to remove alias " + alias + " from keyStore", e);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to load the keyStore", e);
            }
        }
    }

    private static boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    @Override
    public String getAppletInfo() {
        return appletInfo;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.logo != null) {
            g.drawImage(this.logo, 0, 0, null);
        }
    }

    private void loadLogo() {
        URL url = Thread.currentThread().getContextClassLoader().getResource("ca/infodata/dsq_calls/web/logo.gif");
        try {
            this.logo = this.getImage(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void start() {
        super.start();
    }

    private static class SignatureData {
        public final String signature;
        private final long timestamp;

        public SignatureData(String signature) {
            this.signature = signature;
            this.timestamp = System.currentTimeMillis();
        }

        private long ageInMinutes() {
            return TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis() - this.timestamp);
        }

        private long ageInSecond() {
            return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.timestamp);
        }

        public boolean hasExpired() {
            return this.ageInMinutes() > 1L;
        }
    }
}

