/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.signaturexml;

import ca.infodata.ofys.web.client.ByteAResponseReader;
import ca.infodata.ofys.web.client.MyMapRequestWriter;
import ca.infodata.ofys.web.client.ReturnObjectResponseReader;
import ca.infodata.util1.restful.GroupTypeAdapter;
import ca.infodata.util1.restful.RequestWriter;
import ca.infodata.util1.restful.ResponseReader;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.apache4.ApacheHttpClient4Handler;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;

public class RestfulClient {
    private Client client;
    private CloseableHttpClient apacheClient;

    public RestfulClient() {
        boolean requestSentRetryEnabled = false;
        StandardHttpRequestRetryHandler retryHandler = new StandardHttpRequestRetryHandler(3, requestSentRetryEnabled){

            @Override
            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                try {
                    TimeUnit.MILLISECONDS.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
                boolean retryRequest = exception instanceof NoHttpResponseException || super.retryRequest(exception, executionCount, context);
                return retryRequest;
            }

            @Override
            protected boolean handleAsIdempotent(HttpRequest request) {
                String method;
                boolean b = super.handleAsIdempotent(request);
                if (!b && "POST".equals(method = request.getRequestLine().getMethod().toUpperCase(Locale.ROOT))) {
                    return request.getFirstHeader("disableStandardRetry") == null;
                }
                return b;
            }
        };
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.useSystemProperties();
        httpClientBuilder.setRetryHandler(retryHandler);
        httpClientBuilder.setSSLHostnameVerifier(new IgnoreHostNameVerifier());
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new AllowAllTrustManager()}, null);
            httpClientBuilder.setSSLContext(sslContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        RequestConfig.Builder requestConfig = RequestConfig.custom();
        requestConfig.setConnectTimeout((int)TimeUnit.MINUTES.toMillis(1L));
        requestConfig.setSocketTimeout((int)TimeUnit.MINUTES.toMillis(30L));
        httpClientBuilder.setDefaultRequestConfig(requestConfig.build());
        httpClientBuilder.setServiceUnavailableRetryStrategy(new DefaultServiceUnavailableRetryStrategy(3, 2000){

            @Override
            public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
                return executionCount <= 3 && (response.getStatusLine().getStatusCode() == 503 || response.getStatusLine().getStatusCode() == 502);
            }
        });
        httpClientBuilder.evictExpiredConnections();
        httpClientBuilder.evictIdleConnections(5L, TimeUnit.SECONDS);
        httpClientBuilder.setMaxConnTotal(200);
        httpClientBuilder.setMaxConnPerRoute(20);
        httpClientBuilder.addInterceptorLast(new HttpRequestInterceptor(){

            @Override
            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                String value;
                Header userHeader;
                String value2;
                Header clientHeader = request.getFirstHeader("client");
                if (clientHeader != null && (value2 = clientHeader.getValue()) != null) {
                    request.setHeader("clientCode", value2);
                }
                if ((userHeader = request.getFirstHeader("userName")) != null && (value = userHeader.getValue()) != null) {
                    request.setHeader("userName", value);
                }
            }
        });
        this.apacheClient = httpClientBuilder.build();
        DefaultClientConfig cc = new DefaultClientConfig();
        this.config(cc);
        ApacheHttpClient4Handler clientHandler = new ApacheHttpClient4Handler(this.apacheClient, new BasicCookieStore(), false);
        this.client = new Client(clientHandler, cc);
    }

    public Client getJerseyClient() {
        return this.client;
    }

    public CloseableHttpClient getApacheClient() {
        return this.apacheClient;
    }

    public void close() {
        this.client.destroy();
    }

    protected final void config(ClientConfig config) {
        GsonBuilder builder = new GsonBuilder();
        GroupTypeAdapter groupTypeAdapter = new GroupTypeAdapter();
        Gson gson = builder.create();
        groupTypeAdapter.setGson(gson);
        config.getSingletons().add(new ResponseReader(gson));
        config.getSingletons().add(new ByteAResponseReader());
        config.getSingletons().add(new ReturnObjectResponseReader());
        config.getSingletons().add(new MyMapRequestWriter(gson));
        config.getSingletons().add(new RequestWriter(gson));
        config.getProperties().put("com.sun.jersey.impl.client.httpclient.enableBuffering", true);
    }

    protected static class AllowAllTrustManager
    implements X509TrustManager,
    TrustManager {
        protected AllowAllTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    protected static class IgnoreHostNameVerifier
    implements HostnameVerifier {
        protected IgnoreHostNameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

