/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.signaturexml;

import ca.infodata.dsq.signaturexml.DsqToolApplication;
import com.sun.javafx.application.LauncherImpl;
import java.io.File;
import java.io.InputStream;
import java.net.URLDecoder;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainApp {
    private static final Logger logger = LoggerFactory.getLogger(MainApp.class);
    protected static String jarPath = "";
    protected static String userhomeDir = String.valueOf(System.getProperty("user.home")) + "/connect_oscarqc/";
    private static String os_name = System.getProperty("os.name").toLowerCase();
    public static final boolean ON_MAC = os_name.indexOf("mac") > -1;
    public static final boolean ON_WIN = os_name.indexOf("win") > -1;
    public static final String VERSION_SOFT = "1.0.0";
    private static String[] parameters;

    public static void main(String[] args) throws Exception {
        File file;
        parameters = args;
        String path = MainApp.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String decodedPath = URLDecoder.decode(path, "UTF-8");
        jarPath = String.valueOf(new File(decodedPath).getParentFile().getPath()) + "/";
        System.out.println("jarPath = " + jarPath);
        File folder = new File(userhomeDir);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        boolean hasLoadedLog4j = false;
        String filename = System.getProperty("log4j.configuration");
        if (filename != null && filename.trim().length() > 0) {
            file = new File(filename);
            if (file.exists()) {
                PropertyConfigurator.configure(file.getAbsolutePath());
                hasLoadedLog4j = true;
            } else {
                System.out.println("It is not possible to load the given log4j properties file :" + file.getAbsolutePath());
            }
        }
        if (!hasLoadedLog4j) {
            file = new File(String.valueOf(jarPath) + "../log4j.xml");
            if (file.exists()) {
                PropertyConfigurator.configure(file.getAbsolutePath());
                hasLoadedLog4j = true;
            } else {
                logger.info("Using default log4j configuration log4j.default.properties.");
                logger.info("If you would like to change the default configuration please add following param before startup -Dlog4j.configuration=<log4jfile>");
                InputStream stream = MainApp.class.getResourceAsStream("/log4j.default.xml");
                PropertyConfigurator.configure(stream);
            }
        }
        LauncherImpl.launchApplication(DsqToolApplication.class, (String[])args);
    }

    public static String[] getParameters() {
        return parameters;
    }
}

