/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.signaturexml;

import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.dsq.signaturexml.ConnectToOfys;
import ca.infodata.dsq.signaturexml.DSQApplet;
import ca.infodata.dsq.signaturexml.DsqToolApplication;
import ca.infodata.dsq.signaturexml.MainApp;
import ca.infodata.dsq.signaturexml.MyFileProperties;
import ca.infodata.dsq.signaturexml.WorkIndicatorDialog;
import ca.infodata.dsq_calls.web.CancelException;
import ca.infodata.dsq_calls.web.DeactivateException;
import ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq.RabbitMqConsumer2;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.util1.encryption.DesEncrypter;
import ca.infodata.util1.encryption.EncryptionException;
import java.awt.AWTException;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.KeyStore;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.effect.DropShadow;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tbee.javafx.scene.layout.MigPane;

public class LoginController
implements Initializable {
    private static final Logger logger = LoggerFactory.getLogger(LoginController.class);
    @FXML
    private TextField txtIdentifiant;
    @FXML
    private PasswordField txtPassword;
    @FXML
    private PasswordField txtCodeClient;
    @FXML
    protected Label messageLabel;
    @FXML
    private ComboBox<String> comboAlias;
    @FXML
    private MigPane rootPane;
    @FXML
    private MigPane mpConnection;
    @FXML
    private Button btnConnect;
    private VBox vboxCenter;
    private Stage stage;
    private static final String iconImageLoc = "http://icons.iconarchive.com/icons/scafer31000/bubble-circle-3/16/GameCenter-icon.png";
    private ConnectToOfys connect;
    public DSQApplet dsqApplet = new DSQApplet();
    private SystemTray tray;
    private TrayIcon trayIcon;
    private Integer sessionId;
    private String alias;
    private String identifiant = "";
    private String clientUid;
    private String password = "";
    private String codeClient = "";
    private RabbitMqConsumer2 rabbitMq;
    DropShadow shadow = new DropShadow();
    private WorkIndicatorDialog<String> wd = null;

    public void test() {
    }

    public void quitDsqTool() {
        try {
            if (this.connect != null && this.getSessionId() != null) {
                this.connect.logOut(this.getUsernameForLogin(), this.getPassword(), this.getCodeClient(), this.getSessionId());
            }
            Platform.exit();
            if (this.tray != null) {
                this.tray.remove(this.trayIcon);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    void onOpenProject() {
        this.wd = new WorkIndicatorDialog(this.rootPane.getScene().getWindow(), "...");
        this.wd.addTaskEndNotification(result -> {
            System.out.println(result);
            this.wd = null;
        });
    }

    public void connectToOfys() {
        Task<String> task = new Task<String>(){

            protected String call() throws Exception {
                LoginController.this.onOpenProject();
                LoginController.this.wd.exec("123", inputParam -> {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (LoginController.this.btnConnect.getText().equalsIgnoreCase("Se connecter")) {
                        LoginController.this.login();
                    } else {
                        LoginController.this.logoff();
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    return new Integer(1);
                });
                return "";
            }
        };
        new Thread((Runnable)task).run();
    }

    public void logoff() {
        if (this.getSessionId() != null) {
            this.connect.logOut(this.getUsernameForLogin(), this.getEncyrptedPassword(), this.getCodeClient(), this.getSessionId());
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    LoginController.this.messageLabel.setText("Non connect\u00e9");
                    LoginController.this.setDisableFieldsIdent(false);
                    LoginController.this.btnConnect.setText("Se connecter");
                    LoginController.this.setPassword("");
                    LoginController.this.txtPassword.setText("");
                }
            });
            if (DsqToolApplication.propertiesFile.getProperty("minimiseApp", "false").equalsIgnoreCase("true")) {
                this.showStage();
            }
            this.connect.closeClient();
            this.rabbitMq.close();
        }
    }

    public StringBuilder getErrorBuilder() {
        this.setIdentifiant(this.txtIdentifiant.getText());
        this.setPassword(this.txtPassword.getText());
        this.setCodeClient(this.txtCodeClient.getText());
        if (this.comboAlias.getValue() != null) {
            this.setAlias((String)this.comboAlias.getValue());
        } else {
            this.setAlias("___" + this.getIdentifiant());
        }
        StringBuilder errorBuilder = new StringBuilder();
        if (StringUtils.isEmpty(this.alias)) {
            errorBuilder.append(String.valueOf(errorBuilder != null && errorBuilder.length() != 0 ? ", " : "") + "alias");
        }
        if (StringUtils.isEmpty(this.getIdentifiant())) {
            errorBuilder.append(String.valueOf(errorBuilder != null && errorBuilder.length() != 0 ? ", " : "") + "identifiant");
        }
        if (StringUtils.isEmpty(this.getPassword())) {
            errorBuilder.append(String.valueOf(errorBuilder != null && errorBuilder.length() != 0 ? ", " : "") + "mot de passe");
        }
        if (StringUtils.isEmpty(this.getCodeClient())) {
            errorBuilder.append(String.valueOf(errorBuilder != null && errorBuilder.length() != 0 ? ", " : "") + "code client");
        }
        return errorBuilder;
    }

    public void login() {
        this.setSessionId(null);
        StringBuilder errorBuilder = this.getErrorBuilder();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                LoginController.this.messageLabel.setText("");
                LoginController.this.rootPane.requestLayout();
            }
        });
        if (errorBuilder.length() > 0) {
            final String error = errorBuilder.toString();
            logger.debug("identifiant probleme " + error);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    LoginController.this.messageLabel.setText("Veuillez pr\u00e9ciser: " + error);
                }
            });
        } else {
            logger.debug("tentative de connexion");
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    LoginController.this.messageLabel.setText("Connexion en cours...");
                }
            });
            if (this.connect == null) {
                this.connect = new ConnectToOfys(this);
            }
            ReturnObject contentConnection = this.connect.logIn(this.getUsernameForLogin(), this.getEncyrptedPassword(), "macAddress", "systemUser", "ip", Locale.getDefault().getLanguage(), this.getCodeClient());
            this.vboxCenter = (VBox)this.rootPane.getParent();
            if (!contentConnection.getStatus().isOK()) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LoginController.this.messageLabel.setText("\u00c9chec de la connexion.");
                    }
                });
            } else {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LoginController.this.messageLabel.setText("Connexion active.");
                    }
                });
                if (contentConnection.getObj() != null && contentConnection.getObj() instanceof Integer) {
                    this.setSessionId((Integer)contentConnection.getObj());
                    this.rabbitMq = new RabbitMqConsumer2(this);
                    this.rabbitMq.start();
                    System.out.println("LoginController.login().getSignatureI");
                    try {
                        XmlSignatureI signature = this.dsqApplet.getSignatureI(this.getAlias());
                        byte[] bsignature = SerializationUtils.serialize(signature);
                        this.getConnect().dsqSignatureTool(bsignature, null, 1, null, null, null, null, null, null, this.getUsernameForLogin(), this.getEncyrptedPassword(), this.getCodeClient());
                    }
                    catch (CancelException e) {
                        e.printStackTrace();
                    }
                    catch (DeactivateException e) {
                        e.printStackTrace();
                    }
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            LoginController.this.setDisableFieldsIdent(true);
                            LoginController.this.btnConnect.setText("Se d\u00e9connecter");
                        }
                    });
                }
            }
        }
    }

    protected void setDisableFieldsIdent(boolean b) {
        this.comboAlias.setDisable(b);
        this.txtIdentifiant.setDisable(b);
        this.txtPassword.setDisable(b);
        this.txtCodeClient.setDisable(b);
    }

    public void initialize(URL location, ResourceBundle resources) {
        logger.debug("INITIALIZE...");
        if (MainApp.ON_WIN) {
            try {
                KeyStore ks = KeyStore.getInstance("Windows-MY");
                ks.load(null, null);
                Enumeration<String> aliases = ks.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    if (ks.isCertificateEntry(alias)) {
                        // empty if block
                    }
                    this.comboAlias.getItems().add((Object)alias);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.comboAlias.getItems().add((Object)"Non support\u00e9 (Mac)");
            this.comboAlias.setValue((Object)((String)this.comboAlias.getItems().get(0)));
            this.comboAlias.setDisable(true);
        }
        this.rootPane.addEventHandler(KeyEvent.KEY_PRESSED, ev -> {
            if (ev.getCode() == KeyCode.ENTER) {
                this.login();
                ev.consume();
            }
        });
    }

    private void addAppToTray() {
        try {
            Toolkit.getDefaultToolkit();
            if (!SystemTray.isSupported()) {
                logger.info("No system tray support, application exiting.");
                Platform.exit();
            }
            this.tray = SystemTray.getSystemTray();
            URL imageLoc = new URL(iconImageLoc);
            BufferedImage image = ImageIO.read(imageLoc);
            this.trayIcon = new TrayIcon(image);
            this.trayIcon.addActionListener(event -> Platform.runLater(this::showStage));
            MenuItem openItem = new MenuItem("Voir app");
            openItem.addActionListener(event -> Platform.runLater(this::showStage));
            Font defaultFont = Font.decode(null);
            Font boldFont = defaultFont.deriveFont(1);
            openItem.setFont(boldFont);
            MenuItem exitItem = new MenuItem("Exit");
            exitItem.addActionListener(event -> this.quitDsqTool());
            PopupMenu popup = new PopupMenu();
            popup.add(openItem);
            popup.addSeparator();
            popup.add(exitItem);
            this.trayIcon.setPopupMenu(popup);
            this.tray.add(this.trayIcon);
        }
        catch (AWTException | IOException e) {
            System.out.println("Unable to init system tray");
            e.printStackTrace();
        }
    }

    public void showStage() {
        if (this.stage != null) {
            this.stage.show();
            this.stage.toFront();
        }
    }

    public void hideStage() {
        if (this.stage != null) {
            this.stage.hide();
        }
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public void setProp(MyFileProperties prop) {
    }

    public static String aesDecrypt(String encryptedData) throws Exception {
        Cipher decryptCipher = Cipher.getInstance("AES");
        decryptCipher.init(2, LoginController.generateMySQLAESKey("infodata is great", "UTF-8"));
        return new String(decryptCipher.doFinal(Hex.decodeHex(encryptedData.toCharArray())));
    }

    public static String aesEncrypt(String data) throws Exception {
        Cipher encryptCipher = Cipher.getInstance("AES");
        encryptCipher.init(1, LoginController.generateMySQLAESKey("infodata is great", "UTF-8"));
        return new String(Hex.encodeHex(encryptCipher.doFinal(data.getBytes("UTF-8"))));
    }

    public static SecretKeySpec generateMySQLAESKey(String key, String encoding) {
        try {
            byte[] finalKey = new byte[16];
            int i = 0;
            byte[] byArray = key.getBytes(encoding);
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                int n3 = i++ % 16;
                finalKey[n3] = (byte)(finalKey[n3] ^ b);
                ++n2;
            }
            return new SecretKeySpec(finalKey, "AES");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Integer getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(Integer sessionId) {
        this.sessionId = sessionId;
    }

    public String getIdentifiant() {
        return this.identifiant;
    }

    public void setIdentifiant(String identifiant) {
        this.identifiant = identifiant;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCodeClient() {
        return this.codeClient;
    }

    public void setCodeClient(String pin) {
        this.codeClient = pin;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    private void setClientUid(String s) {
        this.clientUid = s;
    }

    public String getClientUid() {
        return this.clientUid;
    }

    public String getUsernameForLogin() {
        return String.valueOf(this.identifiant) + (this.getSessionId() == null ? "" : ";" + this.getSessionId() + ";" + this.getClientUid());
    }

    public ConnectToOfys getConnect() {
        return this.connect;
    }

    public String getEncyrptedPassword() {
        String encPswd = null;
        try {
            encPswd = DesEncrypter.encryptMe(this.getPassword());
        }
        catch (EncryptionException e1) {
            logger.error("getEncyrptedPassword", e1);
        }
        return encPswd;
    }

    public static class CSession {
    }
}

