/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.signaturexml;

import ca.infodata.dsq.signaturexml.LoginController;
import ca.infodata.dsq.signaturexml.MainApp;
import ca.infodata.dsq.signaturexml.MyFileProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DsqToolApplication
extends Application {
    private static final Logger logger = LoggerFactory.getLogger(DsqToolApplication.class);
    public static MyFileProperties propertiesFile;

    public void start(Stage initStage) throws Exception {
        Platform.setImplicitExit((boolean)false);
        this.showStage();
    }

    private void showStage() {
        try {
            String[] imgs;
            propertiesFile = new MyFileProperties();
            propertiesFile.loadProperties();
            String fxmlFile = "/login.fxml";
            FXMLLoader loader = new FXMLLoader(DsqToolApplication.class.getResource(fxmlFile));
            Stage stage = new Stage(StageStyle.DECORATED);
            Pane pane = (Pane)loader.load();
            pane.getStylesheets().add((Object)"/styles.css");
            final LoginController loginController = (LoginController)loader.getController();
            loginController.setProp(propertiesFile);
            loginController.setStage(stage);
            BorderPane rootNode = new BorderPane();
            VBox vboxCenter = new VBox(10.0);
            vboxCenter.getChildren().add((Object)pane);
            rootNode.setCenter((Node)vboxCenter);
            Scene scene = new Scene((Parent)rootNode, 360.0, 240.0, (Paint)Color.TRANSPARENT);
            stage.setTitle("Outil de signatures DSQ");
            stage.setScene(scene);
            ArrayList<Image> lstImages = new ArrayList<Image>();
            String[] stringArray = imgs = new String[]{"lock16.png", "lock24.png", "lock32.png", "lock64.png", "lock128.png"};
            int n = imgs.length;
            int n2 = 0;
            while (n2 < n) {
                String img = stringArray[n2];
                File icon = new File(String.valueOf(MainApp.jarPath) + img);
                if (icon.exists()) {
                    System.out.println("Add image " + icon.getPath());
                    lstImages.add(new Image((InputStream)new FileInputStream(icon)));
                } else {
                    System.out.println("Image " + MainApp.jarPath + img + " not found...");
                    logger.error("Image " + MainApp.jarPath + img + " not found...");
                }
                ++n2;
            }
            if (lstImages.size() > 0) {
                stage.getIcons().addAll(lstImages);
            } else {
                System.out.println("Aucune image... ");
                logger.error("Aucune image... ");
            }
            pane.layout();
            stage.show();
            scene.getWindow().setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    loginController.quitDsqTool();
                    System.exit(0);
                }
            });
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            logger.error("showMainStage", e);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("showMainStage", e);
        }
    }
}

