/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.signature;

import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignatureCore;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringWriter;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collections;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

public class XmlSignature
implements Signature {
    private static final long serialVersionUID = 1L;
    private boolean lazyDeseralize = true;
    private String token;
    private String actor;
    private transient Document documentSignature;
    private String xmlSignature;

    public static Boolean validate(String alias, String password, String filename) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document doc = builder.parse(filename);
        Node signatureNode = doc.getElementsByTagName("Signature").item(0);
        KeyStore keyStore = KeyStore.getInstance("Windows-MY", "SunMSCAPI");
        keyStore.load(null, null);
        KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, new KeyStore.PasswordProtection(password == null ? "nopassword".toCharArray() : password.toCharArray()));
        if (entry == null) {
            throw new KeyStoreException("alias " + alias + " cannot be found in keyStore Windows-MY");
        }
        PublicKey publicKey = entry.getCertificate().getPublicKey();
        DOMValidateContext valContext = new DOMValidateContext(publicKey, signatureNode);
        XMLSignatureFactory factory = XMLSignatureFactory.getInstance("DOM");
        XMLSignature signature = factory.unmarshalXMLSignature(valContext);
        return signature.validate(valContext);
    }

    public XmlSignature(String token, String actor) {
        this.token = token;
        this.actor = actor;
    }

    public XmlSignature(String token, String digestValue, String actor) {
        this.token = token;
        this.actor = actor;
    }

    public XmlSignature(String token, String digestValue, String actor, String xmlSignature) {
        this.token = token;
        this.actor = actor;
        this.xmlSignature = xmlSignature;
    }

    public Node getSecurityNode() throws Exception {
        if (this.documentSignature == null && this.lazyDeseralize) {
            this.documentSignature = XmlSignature.stringToDocUsingLSParser(this.xmlSignature);
        }
        if (this.documentSignature != null) {
            return this.documentSignature.getFirstChild();
        }
        return null;
    }

    Document getDocumentSignature() {
        return this.documentSignature;
    }

    public void sign(XmlSignatureCore xmlSignatureCore) throws Exception, NoSuchProviderException {
        XMLSignatureFactory factory = xmlSignatureCore.getFactory();
        SignedInfo signer = xmlSignatureCore.newSignedInfo();
        KeyInfo keyInfo = xmlSignatureCore.getKeyInfo();
        PrivateKey privateKey = xmlSignatureCore.getPrivateKey();
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setNamespaceAware(true);
        dfactory.setValidating(true);
        DocumentBuilder documentBuilder = dfactory.newDocumentBuilder();
        this.documentSignature = documentBuilder.newDocument();
        Element securityElement = this.documentSignature.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wsswssecurity-secext-1.0.xsd", "Security");
        securityElement.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "S:actor", this.actor);
        this.documentSignature.appendChild(securityElement);
        Element tokenElement = this.documentSignature.createElement("Signature");
        tokenElement.setAttribute("xmlns", "");
        Text tokenTextNode = this.documentSignature.createTextNode(this.token);
        tokenElement.appendChild(tokenTextNode);
        XMLObject tokenObject = factory.newXMLObject(Collections.singletonList(new DOMStructure(tokenElement)), "Signature_I", null, null);
        XMLSignature signature = factory.newXMLSignature(signer, keyInfo, Collections.singletonList(tokenObject), null, null);
        DOMSignContext context = new DOMSignContext(privateKey, (Node)securityElement);
        signature.sign(context);
    }

    private void writeObject(ObjectOutputStream out) throws Exception {
        out.writeObject(this.token);
        out.writeBoolean(this.documentSignature != null);
        if (this.documentSignature != null) {
            String xml;
            this.xmlSignature = xml = XmlSignature.docToStringUsingLSSerializer(this.documentSignature);
            out.writeObject(xml);
        }
    }

    private void readObject(ObjectInputStream in) throws Exception {
        this.token = (String)in.readObject();
        if (in.readBoolean()) {
            String xml;
            this.xmlSignature = xml = (String)in.readObject();
            if (!this.lazyDeseralize) {
                this.documentSignature = XmlSignature.stringToDocUsingLSParser(xml);
            }
        }
    }

    static String docToStringUsingLSSerializer(Document doc) throws Exception {
        if (doc == null) {
            return null;
        }
        DOMImplementationRegistry reg = DOMImplementationRegistry.newInstance();
        DOMImplementationLS impl = (DOMImplementationLS)((Object)reg.getDOMImplementation("LS"));
        LSSerializer serializer = impl.createLSSerializer();
        LSOutput lsOutput = impl.createLSOutput();
        lsOutput.setEncoding("UTF-8");
        StringWriter stringWriter = new StringWriter(2000);
        lsOutput.setCharacterStream(stringWriter);
        serializer.write(doc, lsOutput);
        return ((Object)stringWriter).toString();
    }

    static Document stringToDocUsingLSParser(String s) throws ClassNotFoundException, InstantiationException, IllegalAccessException, ClassCastException {
        if (s == null) {
            return null;
        }
        DOMImplementationRegistry reg = DOMImplementationRegistry.newInstance();
        DOMImplementationLS impl = (DOMImplementationLS)((Object)reg.getDOMImplementation("LS"));
        LSParser parser = impl.createLSParser((short)1, null);
        LSInput input = impl.createLSInput();
        input.setEncoding("UTF-8");
        input.setStringData(s);
        Document doc = parser.parse(input);
        return doc;
    }

    public void setLazyDeseralize(boolean lazyDeseralize) {
        this.lazyDeseralize = lazyDeseralize;
    }

    public String getXmlSignature() throws Exception {
        if (this.documentSignature != null && this.xmlSignature == null) {
            this.xmlSignature = XmlSignature.docToStringUsingLSSerializer(this.documentSignature);
        }
        return this.xmlSignature;
    }

    public String getToken() {
        return this.token;
    }

    public String getActor() {
        return this.actor;
    }
}

