/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq;

import ca.infodata.dsq.signature.Pkcs7SignatureI;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.dsq.signature.XmlSignatureS;
import ca.infodata.dsq.signaturexml.LoginController;
import ca.infodata.ofys.data.dataaccess.util.notification.IConsumer;
import ca.infodata.ofys.data.dataaccess.util.notification.IConsumerListener;
import ca.infodata.ofys.data.dataaccess.util.notification.NotificationHandler;
import ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq.BasicConsumeTask;
import ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq.NotificationData;
import ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq.RabbitMqConnection;
import ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq.RabbitMqThreadFactory;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import ca.infodata.ofys.data.middle.dataobjects.notification.SessionStatusNotification;
import ca.infodata.util1.ConcurrentHashSet;
import ca.infodata.util1.IPair;
import ca.infodata.util1.Pair;
import ca.infodata.util1.StringUtils;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.SerializationUtils;
import org.mb.listeners.GenListenerManager;

public class RabbitMqConsumer2
implements IConsumer {
    private static final Logger logger = Logger.getLogger(RabbitMqConsumer2.class.getName());
    private final GenListenerManager<IConsumerListener> listenerManager;
    private final IConsumerListener listenerProxy;
    private final GenListenerManager<NotificationHandler> notificationManager;
    private final NotificationHandler notificationProxy;
    private List<NotificationData> notifications = new ArrayList<NotificationData>();
    private ArrayDeque<IPair<Long, Notification>> last10Notifications;
    private final Set<String> bindings = new ConcurrentHashSet();
    private ExecutorService executorService;
    private RabbitMqConnection connection;
    private final LoginController controller;
    private boolean enabled = true;
    private Integer activeSessionId = null;

    public RabbitMqConsumer2(LoginController controller) {
        this.listenerManager = new GenListenerManager(IConsumerListener.class);
        this.listenerProxy = (IConsumerListener)this.listenerManager.getProxy();
        this.notificationManager = new GenListenerManager(NotificationHandler.class);
        this.notificationProxy = (NotificationHandler)this.notificationManager.getProxy();
        this.last10Notifications = new ArrayDeque(10);
        this.controller = controller;
    }

    @Override
    public synchronized void start() {
        if (this.controller.getSessionId() != null) {
            if (this.controller.getSessionId().equals(this.activeSessionId)) {
                if (this.isActive()) {
                    return;
                }
                this.configureSafe(false);
            } else {
                this.activeSessionId = this.controller.getSessionId();
                this.clearBindings();
                this.configureSafe(true);
            }
        }
    }

    private void configureSafe(boolean newSession) {
        try {
            this.configure(newSession);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to configure RabbitMqConsumer2. newSession " + newSession, e);
        }
    }

    private void configure(boolean newSession) throws Exception {
        if (this.activeSessionId == null) {
            this.close();
        } else {
            if (this.executorService != null) {
                this.executorService.shutdown();
            }
            this.executorService = Executors.newCachedThreadPool(new RabbitMqThreadFactory("rabbitmq-executor"));
            if (this.connection != null) {
                boolean deleteQueue = newSession;
                this.connection.close(deleteQueue);
            }
            this.connection = new RabbitMqConnection(this.controller.getCodeClient(), this.controller.getIdentifiant(), this.activeSessionId, this.executorService){

                @Override
                public void handleDelivery(ExecutorService executorService, String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    executorService.submit(new BasicConsumeTask(RabbitMqConsumer2.this, consumerTag, envelope, properties, body));
                }

                @Override
                protected void onFailure() {
                    RabbitMqConsumer2.this.onConnectionFail();
                }
            };
            if (newSession) {
                int sessionId = this.activeSessionId;
                String clientCode = this.controller.getCodeClient();
                this.addBinding("*.*.*." + sessionId + ".*.*.*." + clientCode, true);
            } else {
                for (String binding : this.bindings) {
                    this.addBinding(binding, true);
                }
                this.forceRefresh();
            }
        }
    }

    protected void onConnectionFail() {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info("RabbitMqConsumer2.onConnectionFail - start");
                    RabbitMqConsumer2.this.listenerProxy.forceRefresh();
                    logger.info("RabbitMqConsumer2.onConnectionFail - end");
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error", e);
                }
            }
        });
    }

    private void forceRefresh() {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    RabbitMqConsumer2.this.listenerProxy.forceRefresh();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error", e);
                }
            }
        });
    }

    private void addBinding(String key, boolean force) {
        boolean added = this.bindings.add(key);
        if (force && this.connection != null) {
            if (this.connection.isActive()) {
                this.connection.queueBindAsync(key);
            }
        } else if (added && this.isActive()) {
            this.connection.queueBindAsync(key);
        }
    }

    private void removeBinding(String key) {
        boolean removed = this.bindings.remove(key);
        if (removed && this.isActive()) {
            this.connection.queueUnbindAsync(key);
        }
    }

    @Override
    public void addListener(IConsumerListener listener) {
        this.listenerManager.addListener((Object)listener);
    }

    @Override
    public void removeListener(IConsumerListener listener) {
        this.listenerManager.removeListener((Object)listener);
    }

    @Override
    public void addNotificationHandler(NotificationHandler handler) {
        this.notificationManager.addListener((Object)handler);
    }

    @Override
    public void removeNotificationHandler(NotificationHandler handler) {
        this.notificationManager.removeListener((Object)handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IPair<Long, Notification>> getLastNotifications() {
        ArrayDeque<IPair<Long, Notification>> arrayDeque = this.last10Notifications;
        synchronized (arrayDeque) {
            return new ArrayList<IPair<Long, Notification>>(this.last10Notifications);
        }
    }

    @Override
    public boolean isActive() {
        return this.connection != null && this.connection.isActive();
    }

    RabbitMqConnection getConnection() {
        return this.connection;
    }

    @Override
    public synchronized void close() {
        logger.log(Level.INFO, "RabbitMqConsumer.close");
        try {
            if (this.executorService != null) {
                this.executorService.shutdown();
                this.executorService = null;
            }
        }
        catch (Exception e1) {
            logger.log(Level.INFO, "RabbitMqConsumer.executorOnMessageService.shutdown", e1);
        }
        if (this.connection != null) {
            boolean deleteQueue = true;
            this.connection.close(deleteQueue);
            this.connection = null;
        }
        this.clearBindings();
    }

    @Override
    public void applicationShutdown() {
        logger.log(Level.INFO, "RabbitMqConsumer.forceShutdown");
        try {
            if (this.executorService != null) {
                this.executorService.shutdown();
                this.executorService = null;
            }
        }
        catch (Exception e1) {
            logger.log(Level.INFO, "RabbitMqConsumer.executorOnMessageService.shutdown", e1);
        }
        this.clearBindings();
        if (this.connection != null) {
            this.connection.applicationShudown();
            this.connection = null;
        }
    }

    private void clearBindings() {
        this.bindings.clear();
    }

    public void process(Notification[] notifications) {
        if (notifications == null) {
            return;
        }
        Notification[] notificationArray = notifications;
        int n = notifications.length;
        int n2 = 0;
        while (n2 < n) {
            Notification notification = notificationArray[n2];
            this.process(notification);
            ++n2;
        }
    }

    @Override
    public void process(Notification notification) {
        if (notification == null) {
            return;
        }
        if (this.activeSessionId == null) {
            return;
        }
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Processing notification " + StringUtils.safeToString((Logger)logger, (Object)notification));
            }
            this.notificationProxy.handle(notification);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in notification processing", e);
        }
        if (notification instanceof SessionStatusNotification) {
            try {
                SessionStatusNotification data;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Processing dataObjectNotification " + StringUtils.safeToString((Logger)logger, (Object)notification));
                }
                if ((data = (SessionStatusNotification)notification).getStatus().getData() == null) {
                    XmlSignatureI signature = this.controller.dsqApplet.getSignatureI(this.controller.getAlias());
                    byte[] bsignature = SerializationUtils.serialize((Serializable)signature);
                    this.controller.getConnect().dsqSignatureTool(bsignature, null, data.getWhatToDo(), data.getStart(), data.getEnd(), data.getIdSite(), data.getIdAskingSession(), data.getClientUid(), data.getChannelName(), this.controller.getUsernameForLogin(), this.controller.getEncyrptedPassword(), this.controller.getCodeClient());
                } else if (data.getStatus().getData() instanceof HashSet) {
                    HashSet setPt = (HashSet)data.getStatus().getData();
                    HashMap<Pair, Pair> mapPt = new HashMap<Pair, Pair>(setPt.size());
                    XmlSignatureI signature = this.controller.dsqApplet.getSignatureI(this.controller.getAlias());
                    for (Pair p : setPt) {
                        Pkcs7SignatureI pkcs7SignatureI = this.controller.dsqApplet.getSignatureCs7Niu(this.controller.getAlias(), (String)p.getSecond());
                        XmlSignatureI xmlSignatureI = this.controller.dsqApplet.getSignatureXmlNiu(this.controller.getAlias(), (String)p.getSecond());
                        if (pkcs7SignatureI == null || xmlSignatureI == null) continue;
                        mapPt.put(p, new Pair((Object)pkcs7SignatureI, (Object)xmlSignatureI));
                    }
                    byte[] bsignature = SerializationUtils.serialize((Serializable)signature);
                    byte[] bMapPatSign = SerializationUtils.serialize(mapPt);
                    this.controller.getConnect().dsqSignatureTool(bsignature, bMapPatSign, data.getWhatToDo(), data.getStart(), data.getEnd(), data.getIdSite(), data.getIdAskingSession(), data.getClientUid(), data.getChannelName(), this.controller.getUsernameForLogin(), this.controller.getEncyrptedPassword(), this.controller.getCodeClient());
                } else if (data.getStatus().getData() instanceof String) {
                    String hash = (String)((Object)data.getStatus().getData());
                    XmlSignatureS signature = this.controller.dsqApplet.getSignatureS(this.controller.getAlias(), hash);
                    byte[] bsignature = SerializationUtils.serialize((Serializable)signature);
                    this.controller.getConnect().dsqSignatureSTool(bsignature, hash, data.getClientUid(), data.getChannelName(), this.controller.getUsernameForLogin(), this.controller.getEncyrptedPassword(), this.controller.getCodeClient());
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in dataobjectNotification processing", e);
            }
        } else {
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Processing notification " + StringUtils.safeToString((Logger)logger, (Object)notification));
                }
                this.listenerProxy.handleOther(notification);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in notification processing", e);
            }
        }
    }

    public List<NotificationData> getNotifications() {
        return this.notifications;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabledFalse() {
        this.enabled = false;
    }

    public Integer getActiveSessionId() {
        return this.activeSessionId;
    }
}

