/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.signaturexml;

import ca.infodata.dsq.signaturexml.MainApp;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javafx.animation.FadeTransition;
import javafx.application.Preloader;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;

public class SplashScreenLoader
extends Preloader {
    private Stage splashScreen;
    public static final String SPLASH_IMAGE = "splash.png";
    VBox splashLayout;

    public void start(Stage stage) throws Exception {
        this.splashScreen = stage;
        this.splashScreen.initStyle(StageStyle.UNDECORATED);
        this.splashScreen.setScene(this.createScene());
        this.splashScreen.show();
    }

    public Scene createScene() {
        Scene scene = null;
        try {
            File splashImage = new File(String.valueOf(MainApp.jarPath) + SPLASH_IMAGE);
            if (splashImage.exists()) {
                ImageView splash = new ImageView(new Image((InputStream)new FileInputStream(splashImage)));
                this.splashLayout = new VBox();
                this.splashLayout.getChildren().addAll((Object[])new Node[]{splash});
                this.splashLayout.setStyle("-fx-padding: 5; -fx-background-color: cornsilk; -fx-border-width:5; -fx-border-color: linear-gradient(to bottom, chocolate, derive(chocolate, 50%));");
                this.splashLayout.setEffect((Effect)new DropShadow());
                scene = new Scene((Parent)this.splashLayout);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return scene;
    }

    public void handleStateChangeNotification(Preloader.StateChangeNotification evt) {
        if (evt != null && evt.getType() != null && evt.getType() == Preloader.StateChangeNotification.Type.BEFORE_START && this.splashScreen != null && this.splashScreen.getScene() != null) {
            if (this.splashScreen.isShowing()) {
                FadeTransition ft = new FadeTransition(Duration.millis((double)1000.0), (Node)this.splashScreen.getScene().getRoot());
                ft.setFromValue(1.0);
                ft.setToValue(0.0);
                final Stage s = this.splashScreen;
                EventHandler<ActionEvent> eh = new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent t) {
                        s.hide();
                    }
                };
                ft.setOnFinished((EventHandler)eh);
                ft.play();
            } else {
                this.splashScreen.hide();
            }
        }
    }

    public void handleApplicationNotification(Preloader.PreloaderNotification notification) {
        if (notification instanceof Preloader.StateChangeNotification && this.splashScreen != null) {
            this.splashScreen.hide();
        }
    }
}

