/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.signaturexml;

import ca.infodata.dsq.signaturexml.DsqToolApplication;
import ca.infodata.dsq.signaturexml.LoginController;
import ca.infodata.dsq.signaturexml.RestfulClient;
import ca.infodata.dsq.signaturexml.WebBuilder;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.util1.restful.Response;
import com.sun.jersey.api.client.WebResource;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectToOfys {
    private URL serverUrl;
    private String ofysUrl = "http://127.0.0.1:8080/";
    public URL serverUrlForAccessibilityTest;
    private String contextRoot = "ca.infodata.ofys.data.server.application.web.dataaccess";
    private String loginRoot = "/jaxrs/LoginAccessor";
    private String signatureToolRoot = "/jaxrs/DSQAccessor";
    private String login = "/logInFromSignatureTool";
    private String logOut = "/logOutFromSignatureTool";
    private String signTool = "/dsqSignatureTool";
    private String signSTool = "/dsqSignatureSTool";
    private RestfulClient restfulClient = new RestfulClient();
    private static final Logger logger = LoggerFactory.getLogger(ConnectToOfys.class);

    public ConnectToOfys(LoginController loginGui) {
        String property = System.getProperty("ofysURLClient");
        if (property != null) {
            this.setOfysUrl(property);
        } else {
            this.setOfysUrl(DsqToolApplication.propertiesFile.getProperty("ofysURLClient", "http://127.0.0.1:8080/"));
        }
    }

    public String checkIfSignatureTodo(String alias, String provNo, String sessionId, String method) {
        String responseBody = "{'result':'failed'}";
        return responseBody;
    }

    public ReturnObject dsqSignatureTool(byte[] signature, byte[] mapPatSign, int whatToDo, Integer start, Integer end, Integer idSite, Integer idSession, String clientUid, String channelName, String username, String password, String code_client) {
        WebBuilder wb = this.buildWebBuilder(this.getSecureURI(this.getDsqSignToolPath()), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", signature);
        post.put("mapPatSign", mapPatSign);
        post.put("whatToDo", whatToDo);
        post.put("start", start);
        post.put("end", end);
        post.put("idSite", idSite);
        post.put("idSession", idSession);
        post.put("clientuid", clientUid);
        post.put("channelname", channelName);
        post.put("username", username);
        post.put("password", password);
        post.put("code_client", code_client);
        ReturnObject response = wb.post(ReturnObject.class, post);
        return response;
    }

    public ReturnObject dsqSignatureSTool(byte[] signature, String hash, String clientUid, String channelName, String username, String password, String code_client) {
        WebBuilder wb = this.buildWebBuilder(this.getSecureURI(this.getDsqSignSToolPath()), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", signature);
        post.put("hash", hash);
        post.put("clientuid", clientUid);
        post.put("channelname", channelName);
        post.put("username", username);
        post.put("password", password);
        post.put("code_client", code_client);
        ReturnObject response = wb.post(ReturnObject.class, post);
        return response;
    }

    public ReturnObject logIn(String userName, String password, String macAddress, String systemUser, String ip, String nl, String clientCode) {
        WebBuilder wb = this.buildWebBuilder(this.getSecureURI(this.getLoginPath()), "application/octet-stream", "application/json");
        wb.disableStandardRetry();
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("userName", userName);
        post.put("password", password);
        post.put("macAddress", macAddress);
        post.put("systemUser", systemUser);
        post.put("ip", ip);
        post.put("nl", nl);
        post.put("clientCode", clientCode);
        post.put("st", 8);
        ReturnObject response = wb.post(ReturnObject.class, post);
        return response;
    }

    public void logOut(String userName, String password, String clientCode, Integer sessionId) {
        WebBuilder wb = this.buildWebBuilder(this.getSecureURI(this.getLogoutPath()), "application/octet-stream", "application/json");
        wb.disableStandardRetry();
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("userName", userName);
        post.put("password", password);
        post.put("clientCode", clientCode);
        post.put("id_session", sessionId);
        wb.post(post);
    }

    public String getOfysUrl() {
        return this.ofysUrl;
    }

    public void setOfysUrl(String o) {
        this.ofysUrl = o;
    }

    public String getLoginPath() {
        return new StringBuilder(40).append("/").append(this.contextRoot).append(this.loginRoot).append(this.login).toString();
    }

    public String getLogoutPath() {
        return new StringBuilder(40).append("/").append(this.contextRoot).append(this.loginRoot).append(this.logOut).toString();
    }

    public String getDsqSignToolPath() {
        return new StringBuilder(40).append("/").append(this.contextRoot).append(this.signatureToolRoot).append(this.signTool).toString();
    }

    public String getDsqSignSToolPath() {
        return new StringBuilder(40).append("/").append(this.contextRoot).append(this.signatureToolRoot).append(this.signSTool).toString();
    }

    protected URI getSecureURI(String path) {
        try {
            this.serverUrl = new URL(this.ofysUrl);
            this.serverUrlForAccessibilityTest = new URL(this.serverUrl, "ofys/test/ok.gif");
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("serverAddress '" + this.ofysUrl + "' is not a valid url", e);
        }
        try {
            return new URI(this.serverUrl.getProtocol(), null, this.serverUrl.getHost(), this.serverUrl.getPort(), path, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected WebBuilder buildWebBuilder(URI uri, String accept, String type) {
        WebResource resource = this.buildResource(uri);
        WebBuilder wb = new WebBuilder(resource, accept, type);
        return wb;
    }

    protected WebResource buildResource(URI uri) {
        WebResource resource = this.restfulClient.getJerseyClient().resource(uri);
        return resource;
    }

    protected void processResponse(Response<?> response) {
        if (response.errorIndicator.booleanValue()) {
            throw new RuntimeException(response.errorMessage);
        }
    }

    public void closeClient() {
        this.restfulClient.close();
    }
}

