(function(){
	var doc = angular.module('doc', ['ngSanitize']);

	doc.factory('DocAccessor', ['DashAPI', 'MessageLink', 'PatientAccessor', 'model','$filter', 'DashWebSocket', function(DashAPI, MessageLink, PatientAccessor, model, $filter, DashWebSocket) {
		var accessor = {
			status:['UNSEEN','SEEN', 'TO_RESOLVE','SIGNED_BY_OTHER','OPEN_WITH_FILE'],
			categories: {SEARCH : "SEARCH", TO_RESOLVE: 'TO_RESOLVE',UNSEEN:'UNSEEN'},
			utils:{
				updateAllDocs: function (pd) {
					var list = [];
					if (pd.docofys) {
						list = list.concat(pd.docofys);
					}
					if(pd.docdsq){
						list = list.concat(pd.docdsq);
					}
					if(pd.dsqSommhospList){
						list = list.concat(pd.dsqSommhospList);
					}
					pd.doc = list.sort(PatientAccessor.sortOnDate);
				},
				getBaseDocument: function (doc){
					var profDoc = accessor.utils.getCurrentProfessionalDocument(doc);
					if(profDoc !== null){
						doc.status = profDoc.status;
						doc.note = profDoc.note;
					}
					doc.activeProf = profDoc;
					if(!doc.viewbag){
						doc.viewbag = {};
					}

					doc.viewbag.notesHistory = doc.notesHistory.replaceAll("~VU_LE~",
							$filter('translate')('SeenOn'));
					doc.viewbag.notesHistory = doc.viewbag.notesHistory.replaceAll("~SIGNE_LE~",
							$filter('translate')('SignedOn'));
					doc.viewbag.notesHistory = doc.viewbag.notesHistory.replaceAll('<bp>',
						'<span class="multi-line-txt">').replaceAll('</bp>',
						'</span>');
					return doc;
				},
				getCurrentProfessionalDocument: function(doc){
					var currProf = model.user().profil;
					var i = 0;
					var notFound = true;
					while( i < doc.profs.length && notFound){
						if(doc.profs[i].idProf ==  currProf.id){
							return doc.profs[i];
						}
						i++;
					}
					return null;
				},
				findDocumentByIdInCurrentList: function (doc, listGrp, groups){
					var res = null;
					var i = 0;
					while(i < groups.length && res === null){
						var j= 0;
						while(j < listGrp[groups[i]].list.length && res === null){
							if(listGrp[groups[i]].list[j].id == doc.id){
								res = {group: groups[i], index: j};
							}
							j += 1;
						}
						i += 1;
					}
					return res;
				},
				isNotSeen : function(doc){
					var statusArray = doc.selectedProf ? doc.selectedProf.activeSt: doc.status;
					var res = $.inArray("UNSEEN",  statusArray) > -1;
					return res;
				},
				isToResolve: function(doc){
					var statusArray = doc.selectedProf ? doc.selectedProf.activeSt: doc.status;
					var res = $.inArray("TO_RESOLVE",  statusArray) > -1;
					return res;
				},
				labelsListSearchIn : function (query, resolve, reject){
					accessor.labels(function(v){
						if (query) {
							resolve(v.filter(function(a){return OfysUtils.matchInRegExpArray(OfysUtils.searchRegExpArray(query), a.nameLc);}));
						} else {
							resolve(v);
						}
					}, reject);
				}
			},
			labels : function (callback, error){
				if(model.labels().fetched===true){
					if (callback) callback(model.labels().data);
				}else{
					DashAPI.get('/dashboard/docs/ws/labels', function(res){
						OfysUtils.fuzzyListSearch(res.data, "name");
						model.labels(true, res.data);
						if (callback) callback(model.labels().data);
					}, error);
				}
			},
			growthChart : function (data, callback, error){
				return DashAPI.post('/dashboard/docs/growchart',data, callback, error);
			},
			docView : function (data, callback, error){
				DashAPI.get('/dashboard/docs/ws/docview?docId=' + data.id + '&idProf=' + data.idProf, callback, error);
			},
			review : function (status, callback, error){
				DashAPI.get('/dashboard/docs/ws/review?status='+status, callback, error);
			},
			reviewCount : function (idProf, callback, error){
				DashAPI.get('/dashboard/docs/ws/reviewCount?idProf=' + idProf, callback, error);
			},
			byPatient : function (id, callback, error){
				DashAPI.get('/dashboard/docs/ws/bypat?id=' + id +"&u=" + DashWebSocket.clientUid, callback, error);
			},
			byIds : function (data, callback, error){
				DashAPI.post('/dashboard/docs/ws/byIds', data, callback, error);
			},
			assignOtherPatient : function (data, callback, error){
				DashAPI.get('/dashboard/docs/ws/assignOtherPatient?id=' + data.id + "&idPatient=" + data.idPatient, callback, error);
			},
			assignOtherProf : function(data, callback, error){
				DashAPI.post('/dashboard/docs/ws/assignOtherProf?id=' + data.id, data.profs, callback, error);
			},
			search : function (q, callback, error){
				DashAPI.get("/dashboard/docs/ws/search?q="+ q, callback, error);
			},
			printDsqDoc : function (data, callback, error){
				DashAPI.post("/dashboard/dsq/ws/doc/printDoc", data, model.handlePrint(callback), error);
			},
			list : function (data, callback, error){
				DashAPI.post("/dashboard/docs/ws/search", data, callback, error);
			},
			open : function (id, callback, error){
				DashAPI.get("/dashboard/docs/editor?docId="+ id, callback, error);
			},
			save : function (data, callback, error){
				return DashAPI.post("/dashboard/docs/ws/save", data, callback, error);
			},
			saveQRCode : function (data, callback, error){
				return DashAPI.post("/dashboard/docs/ws/saveQRCode", data, callback, error)
			},
			saveEnumSet : function (data, callback, error){
				return DashAPI.post("/dashboard/docs/ws/saveEnumSet", data, callback, error);
			},
			delAllAutoOpen : function (data, callback, error){
				return DashAPI.post("/dashboard/docs/ws/delAllAutoOpen", data, callback, error);
			},
			print : function (data, callback, error){
				itemPrint = cleanDoctoPrint(data);
				return DashAPI.post("/dashboard/docs/ws/print", itemPrint, model.handlePrint(callback), error);
			},
			fax : function (faxdata, callback, error){
				return DashAPI.post('/dashboard/docs/ws/fax',faxdata, callback, error);
			},
			searchDoc : function(data, callback, error){
				return DashAPI.post('/dashboard/docs/ws/searchDoc', data, callback, error);
			},
			// sign : function (data, callback, error){
			// 	return DashAPI.get("/dashboard/docs/ws/sign?id="+ data, callback, error);
			// },
			msgLinkMap: {},
			updateMessageLink: function (doc, scope){
				if (doc.id) {
					accessor.messageLinkKey = MessageLink.setLinkType({
						patient: doc.idPatient,
						linkType: MessageLink.linkTypes.doc,
						id: doc.id,
						doc: doc,
						pat: doc.patient
					}, scope);
				}  else if (doc.className == "CImagingResultExam" && doc.viewbag && doc.viewbag.patient){
					accessor.messageLinkKey = MessageLink.setLinkType({
						patient: doc.viewbag.patient.id,
						linkType: MessageLink.linkTypes.patient,
						id: doc.viewbag.patient.id,
						pat: doc.viewbag.patient
					}, scope);
				}  else {
					accessor.messageLinkKey = MessageLink.setLinkType({
						patient: doc.idPatient,
						linkType: MessageLink.linkTypes.patient,
						id: doc.idPatient,
						pat: doc.patient
					}, scope);
				}
				accessor.msgLinkMap[doc.uid] = accessor.messageLinkKey
			},

		};
		function cleanDoctoPrint(item) {
			// Sert à régler un problème de "circular structure to JSON""
			if(item.origVersion && item.origVersion.patient && item.origVersion.patient.currItem){
				delete item.origVersion.patient.currItem;
			}
			return item;
		}

		return accessor;
	}]);

	doc.directive('docNote', ['$timeout', 'PatientAccessor', 'DocAccessor', 'MessageLink', 'model', '$filter', '$q', '$log', 'Event', 'QValidation', 'QConfirm', 'patientShowTitles', 'QuickView', 'FlView', 'ModificationStatus',
	                          function ($timeout,PatientAccessor, DocAccessor, MessageLink, model, $filter, $q, $log, Event, QValidation, QConfirm, patientShowTitles, QuickView, FlView, ModificationStatus) {
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/doc/doc_note.html?v=bl',
			scope: true,
			link: function(scope, element, attrs){
				scope.model = model;
				scope.resultatItems = [{n:$filter('translate')('SO'), id:'SO'},
				                       {n:$filter('translate')('NORMAL'), id:'NORMAL'},
				                       {n:$filter('translate')('ANORMAL'), id:'ANORMAL'},
				                       {n:$filter('translate')('VERY_ANORMAL'), id: 'VERY_ANORMAL'}];
				// charger les labels dans model au besoin.
				DocAccessor.labels(function(d) {
					scope.labelItems = $filter('filter')(d, {isDeleted: false});
				});
				var isDirty = false;
				scope.isProf = function(){
					return model.user().isProf;
				};
				scope.isClinicianNotStagiaire = function(){
					return model.user().isClinicianNotStagiaire();
				};
				scope.isShowReset = function(){
					if (scope.docNote && (scope.docNote.patient || model.patient())) {
						var pt = scope.docNote.patient ? scope.docNote.patient : model.patient().currPatient;
						var prof = model.user().profil;
						if (pt && prof && pt.treatingProfessionnal===prof.id && scope.docNote.profs) {
							for (var i = 0; i < scope.docNote.profs.length; i++) {
								var lp = scope.docNote.profs[i];
								if ($.inArray("TO_RESOLVE", lp.activeSt) >= 0 || $.inArray("OPEN_WITH_FILE", lp.activeSt) >= 0) {
									return true;
								}
							}
						}
					}
					return false;
				};
				scope.isShowResetTosOtherProv = function(){
					var prof = model.user().profil;
					for (var i = 0; i < scope.docNote.profs.length; i++) {
						var lp = scope.docNote.profs[i];
						if (prof.id!==lp.idProf && ($.inArray("TO_RESOLVE", lp.activeSt) >= 0 || $.inArray("OPEN_WITH_FILE", lp.activeSt) >= 0)) {
							return true;
						}
					}
					return false;
				};
				scope.isShowDelAllAutoOpen = function(){
					var prof = model.user().profil;
					for (var i = 0; i < scope.docNote.profs.length; i++) {
						var lp = scope.docNote.profs[i];
						if (prof.id!==lp.idProf && $.inArray("OPEN_WITH_FILE", lp.activeSt) >= 0) {
							return true;
						}
					}
					return false;
				};
				scope.resetTosOfOthers = function() {
					var qconfirmOptions = {title: $filter('translate')('MSG_CONFIRM_RESET_TOS')};
					QConfirm.open(qconfirmOptions).then(proceedWithReset);
					function proceedWithReset(proceed){
						if(proceed){
							scope.saveEnumSet();
						}
					}
				};
				scope.delAllAutoOpen = function() {
					var qconfirmOptions = {title: $filter('translate')('MSG_CONFIRM_DEL_ALL_AUTO_OPEN')};
					QConfirm.open(qconfirmOptions).then(proceedWithReset);
					function proceedWithReset(proceed){
						if(proceed){
							scope.saveDelAllAutoOpen();
						}
					}
				};
				scope.showPatientButton = function() {
					var q = model.qv();
					var isNotQv = q && q.group && Object.keys(q.group).length===0;
					if (isNotQv===false) {
						// sommaire ouvert? dans ce cas, on a un qv mais patient est différent habituellement
						if (scope.docNote && scope.docNote.idPatient) {
							if (q.group['pat' + scope.docNote.idPatient]==undefined) {
								isNotQv = true;
							}
						}
					}
					return isNotQv && (model.activeController()==='review' || model.activeController()==='actions');
				};
				scope.openLastEncounter = function(){
					// si dans dossier patient, le patient n'est pas avec labNote mais avec model.patient();
					var patient = scope.docNote.patient ? scope.docNote.patient : model.patient().currPatient;
					patientShowTitles.openActivity(patient, {mode: 'n', minimize: false, openLastEncounter:true}, patient, scope)
				};
				scope.openPatientFile = function(){
					// si dans dossier patient, le patient n'est pas avec labNote mais avec model.patient();
					var patient = scope.docNote.patient ? scope.docNote.patient : model.patient().currPatient;
					patientShowTitles.openActivity(patient, {mode: 'n', minimize: false}, patient)
				};

				function update(n, o){
					scope.quickViewData = scope.$eval(attrs.quickViewData);
					// console.log('update dans docNote:'+n);
					model.safeCall(addEventsEvent);
					if (model.docDataUpdated().doc) {
						scope.docNote = model.docDataUpdated().doc;	// est qvActData
						scope.noteFrm = model.docDataUpdated().noteFrm;	// est pour l'édition des données.
						scope.docNote.save = scope.save;	// ai besoin de cet méthode dans les event close
						scope.docNote.cancel = scope.cancel;
						scope.docNote.hasModification = hasModification;
						scope.docNote.unregisterDirty = unregisterDirty;
						if (scope.noteFrm) {
							setNoteFrm(scope.docNote);
						}
					}
					if(scope.docNote){
						scope.linkManager = MessageLink.linkManager(DocAccessor, scope.docNote, scope.docNote.uid, scope)
						scope.docNote.onChangeActivity = function () {
							scope.linkManager.clear()
						}
						scope.docNote.save = scope.save;
						scope.docNote.cancel = scope.cancel;
						scope.docNote.modifiedDoc = modifiedDoc;
						scope.docNote.unregisterDirty = unregisterDirty;
					}
					scope.assignOtherPatient = {};
				}
				var defaultDoc = {viewbag: {}};
				function setNoteFrm(docNote){
					// scope.noteFrm.id = docNote.id;
					// scope.noteFrm.className = docNote.className;
					// scope.noteFrm.name = docNote.name;
					// scope.noteFrm.date = docNote.date;
					scope.noteFrm = $.extend(angular.copy(defaultDoc),angular.copy(docNote));
					scope.noteFrm.viewbag.datetimeScanned = moment(docNote.datetimeScanned).format('YYYY-MM-DD HH:mm');
					scope.noteFrm.viewbag.selectedLabels = {};
					var prevLabelId = [];
					if(docNote.viewbag){
						docNote.viewbag.editable = scope.noteFrm;
					}
					if (docNote.labels) {
						for (var o=0;o<docNote.labels.length;o++) {
							var lab = docNote.labels[o];
							scope.noteFrm.viewbag.selectedLabels[lab.id] = true;
							prevLabelId.push(lab.id);
						}
					}
					// pour comparer facilement dans le isDirty
					scope.noteFrm.viewbag.prevSortedLabelId = prevLabelId.sort().toString();
					scope.noteFrm.viewbag.newSortedLabelId = scope.noteFrm.viewbag.prevSortedLabelId;	// updaté dans on lableChanged

					// scope.noteFrm.result = docNote.result;	// SO, NORMAL, ANORMAL, VERY_ANORMAL
					scope.noteFrm.viewbag.name = docNote.name;
					scope.noteFrm.viewbag.date = docNote.date;

					if (docNote.activeProf && docNote.activeProf.idProf) {
						scope.noteFrm.viewbag.signedDatetime = docNote.activeProf.signedDatetime;
						scope.noteFrm.viewbag.note = docNote.activeProf.note;
						var st = docNote.activeProf&&docNote.activeProf.activeSt ? docNote.activeProf.activeSt : [];
						scope.noteFrm.viewbag.ToResolve = $.inArray("TO_RESOLVE",  st) >= 0;
						scope.noteFrm.viewbag.OpenWithFile = $.inArray("OPEN_WITH_FILE", st) >= 0;
					}
				}

				function hasModification(){
					if(!scope.doc)return false;
					if (scope.docNote===undefined || scope.noteFrm===undefined) return false;		// pas encore loadé
					var note = scope.noteFrm.note ? scope.noteFrm.note.replace(/(\r\n|\n|\r)/gm,"") : '';
					return (scope.docNoteForm && scope.docNoteForm.$dirty && ((note.length>0 && !scope.docNote.activeProf) ||
							(scope.docNote.activeProf && scope.docNote.activeProf.note != undefined && note !== scope.docNote.activeProf.note.replace(/(\r\n|\n|\r)/gm,"")))) ||
							modifiedDoc()|| modifiedProfessional() ;
				}
				function isNew(){
					return scope.docNote && !scope.docNote.id;
				}
				function modifiedDoc(){
					return scope.noteFrm.result!=scope.docNote.result ||
					scope.noteFrm.viewbag.prevSortedLabelId!=scope.noteFrm.viewbag.newSortedLabelId ||
					scope.noteFrm.viewbag.name!=scope.docNote.name ||
					scope.noteFrm.viewbag.date!=scope.docNote.date;
				}
				function modifiedProfessional(){
					if (model.user().isProf!==true) return false;
					var st = scope.docNote.activeProf&&scope.docNote.activeProf.activeSt ? scope.docNote.activeProf.activeSt : [];
					var noteModified = (empty(scope.noteFrm.note) !== empty(scope.doc.note)) && scope.noteFrm.note !== scope.doc.note;
					return noteModified || scope.noteFrm.viewbag.ToResolve !== $.inArray("TO_RESOLVE", st) >= 0 ||
					scope.noteFrm.viewbag.OpenWithFile !== $.inArray("OPEN_WITH_FILE", st) >= 0;
				}
				function empty(str){
					return !!(str);
				}

				scope.lableChanged = function() {
					// il faut mettre à jour le newSortedLabelId afin de le comparer avec le old. pour dirty?
					var allNewLabelId = [];
					for(var labelId in scope.noteFrm.viewbag.selectedLabels) {
						if (scope.noteFrm.viewbag.selectedLabels[labelId]===true) {
							allNewLabelId.push(labelId);
						}
					}
					scope.noteFrm.viewbag.newSortedLabelId = allNewLabelId.sort().toString();
				};
				scope.regKey = "";
				function registerDirty(){
					scope.regKey = "doc_"+scope.docNote.id;
					QValidation.registerDirty(scope.regKey, scope.save, function(){
						if (scope.docNoteForm) scope.docNoteForm.$setPristine();
						return true;
					});
					scope.registerState = 1;
				}

				function unregisterDirty(){
					if(scope.docNoteForm){
						scope.docNoteForm.$setPristine();
					}
					isDirty = false;
					QValidation.unregisterDirty(scope.regKey);
					scope.registerState = 2;
				}

				scope.registerState = 0;
				scope.isDirty = function(docNoteForm){
					var registerUnregisterOrNon = 0
					//If form changes dirty state register the dirty state
//					if(angular.isDefined(isDirty) && angular.isDefined(docNoteForm.$dirty) ){
					if(scope.docNoteForm && angular.isDefined(scope.docNoteForm.$dirty) ){
						var mod = hasModification();
						// var dsqNew = isNew() && scope.docNote.prop && scope.docNote.prop.dsq ;
						registerUnregisterOrNon = mod ? 1: 2;
						registerUnregisterOrNon = scope.registerState === registerUnregisterOrNon ? 0: registerUnregisterOrNon;

						if(registerUnregisterOrNon == 1 && !scope.ignoreChanges){
							registerDirty();
						}else if(registerUnregisterOrNon == 2){
							unregisterDirty();
						}
						if(mod || isNew()){
							isDirty = true;
						}else{
							isDirty = false;
						}
					}else{
						isDirty = scope && scope.docNoteForm && scope.docNoteForm.$dirty;
					}
					if (scope.docNote) {
						if (scope.docNote.prop===undefined) scope.docNote.prop = {};
						scope.docNote.prop.readonly=!isDirty;	// pour savoir qu'a été modifié quand veut fermer.
					}
					return isDirty;
				};
				if(scope.qv){
					scope.qv.isDirty = function(){
						return isDirty;
					};
				}

				scope.open = function(id){
					DocAccessor.open(id, function(res){
						model.notice().ifEmbeded($filter('translate')('embedOpenDocument'));
					});
				};

				scope.isNotSigned = function(){
					if(angular.isDefined(scope.noteFrm) && (scope.noteFrm.className === "CBasePatientImage" || scope.noteFrm.className === "CPatientImage")){
						return angular.isUndefined(scope.noteFrm.viewbag.signedDatetime);
					}else{
						return true;
					}
				};
				
				scope.isNotSignedByOther = function(){
					if(angular.isDefined(scope.noteFrm) && (scope.noteFrm.className === "CBasePatientImage" || scope.noteFrm.className === "CPatientImage")){
						return !scope.noteFrm.profs.some((e)=> e.signedDatetime != undefined);
					}else{
						return true;
					}
				}

				scope.sign = function(){
					// console.log(scope.noteFrm);
					scope.noteFrm.viewbag.signedDatetime = new Date().getTime();
					scope.save();
				};

				scope.assignOtherPatient = {};
				scope.patientSearchAssist = {
					assistId: "autocomplete_patient",
					nextTabOnTab: true,
					nextTabOnEnter: true,
					hasDetails: true,
					hasHeader: false,
					keepOnScreen: true,
					detailsOnLeft:true,
					listWidth: 400,
					descWidth: 250,
					minChar: 5,
					trigger: 'focus',
					getAsyncData: function(query, assist){
						query = query.replace(',', '');//make sure that composed names with commas are searchable too
						return $q(function(resolve, reject) {
							if(query.length > 4){
								PatientAccessor.search(b64EncodeUnicode(query), function(res){
									resolve(res.data);
								}, angular.noop);
							}else{
								resolve([]);
							}
						});
					},
					getKey: function(pat) {
						return pat.lastName + ", " +pat.firstName + ' (' + pat.birthDate + '/' + pat.gender + ")";
					},
					getDescription: PatientAccessor.generatePatientSearchDescription,
					selection: function(pat, assistObject) {
						scope.assignOtherPatient = pat;
						scope.assignOtherPatient.completeName = pat.lastName + ", " +pat.firstName + ' (' + pat.birthDate + '/' + pat.gender + ")";
						return scope.assignOtherPatient.completeName;
					}
				};
				scope.focusAssignPat = function () {
					$timeout(function () {
						scope.assignOtherPatient.assignOtherPatSearchFocus()
					}, 50);
				}
				scope.doAssignOtherPatient = function() {
					if (scope.assignOtherPatient.id) {
						DocAccessor.assignOtherPatient({id:scope.noteFrm.id, idPatient:scope.assignOtherPatient.id}, function(res) {
							if (res.data && res.data.success===false) {
								model.notice().warn(res.data.ms);
							} else {
								scope.docNote.idPatient = scope.assignOtherPatient.id;
								scope.docNote.patient = scope.assignOtherPatient;
								scope.noteFrm.idPatient = scope.assignOtherPatient.id;
								scope.noteFrm.patient = scope.assignOtherPatient;
								model.actUpdated(true);
								model.notice().success($filter('translate')('docSuccessfulAssignOtherPatient'));
							}
						}, function(res) {
							if (res) {
								model.notice().warn(res);								
							}
						});
					}
				};
				scope.doAssignOtherProf = function() {
					var profs = [];
					scope.docNote.profs.forEach((a) => {
						if(!scope.unremovableProf.includes(a.idProf)){
							let index = scope.groupCriteria[0].selectedList.findIndex(element => {
								 return element && element.obj && element.obj.id == a.idProf
							})
							if(index == -1){
								a.modificationStatus = ModificationStatus.STATUS_DELETED;
							} else {
								a.st = ['UNSEEN'];
								a.activeSt = ['UNSEEN'];
								a.modificatioPnStatus = ModificationStatus.STATUS_UPDATED;
							}
							delete scope.groupCriteria[0].selectedList[index]
						}
						profs.push(a)
					})
					scope.groupCriteria[0].selectedList.forEach((list) => {
						profs.push(doGetDocProf(list.obj));
					})
					DocAccessor.assignOtherProf({id:scope.noteFrm.id, profs:profs}, function(res) {
						if (res.data && res.data.success===false) {
							model.notice().warn(res.data.ms);
						} else {
							scope.docNote.profs = profs.filter(e => e.modificationStatus != ModificationStatus.STATUS_DELETED);
							if (res && res.length && res.length>0) {
								scope.docNote.profs.filter(e => e.modificationStatus == ModificationStatus.STATUS_NEW_UPDATED).forEach((p) => {
									if (p.id==undefined) {
										res.forEach((r) => {
											if (r.tag==p.tag) {
												p.id=r.id;
											}
										});					
									}
								});								
							}
							model.actUpdated(true);
							model.notice().success($filter('translate')('docSuccessfulAssignOtherProf'));
						}
					}, function(res) {
						model.notice().warn(res);
					});
				};
				function doGetDocProf(prof){
					var res = {
						idProf:prof.id,
						profName:prof.lastName + ", "+ prof.firstName,
						dateAssigned: moment().valueOf(),
						modificationStatus: ModificationStatus.STATUS_NEW_UPDATED,
						st: ['UNSEEN'],
						activeSt: ['UNSEEN'],
						tag:  model.atomicInt()
					};
		
					return res;
				}
				
				function SearchPeriodResults(idProfessionnal) {
					this.idProfessionnal = idProfessionnal
				}
				
				SearchPeriodResults.prototype.getProfStr = function () {
					var periodResults = this;
					if (!periodResults.profStr && periodResults.idProfessionnal) {
						model.store.profs.get(periodResults.idProfessionnal, function(prof){
							periodResults.profStr = prof.lastName + ", " + prof.firstName
						})
					}
					return this.profStr
				}
		
				scope.profList = $filter('orderBy')(model.store.profs.filter.treating.list(), ['lastName', 'firstName']);
				function profList (q){
					return $q(function (resolve, reject){
						resolve(scope.profList.filter((a) => {
							return (!scope.unremovableProf.includes(a.id)) && a.id > -1
								  && a.str.toLowerCase().includes(q.toLowerCase());
							
						}))
					})
					
				}

				scope.groupCriteria = [];
				scope.groupCriteria.push({
					name: "assignProfSelector",
					list: profList,
					selectable: false,
					hideRemoveButton: function() {
						return scope.docNote.scanUserName!=model.user().sessionUser.user.name;
					},
					enableDoIt: function() {
						return scope.docNote.scanUserName!=model.user().sessionUser.user.name;
					},
					selectedList: [],
					selectorName:function (prof) {
						return prof.lastName + ', '+ prof.firstName + (prof.isOnCall == true ? " (" +$filter("translate")("on_call") + ")" : "");
					},
					getForCriteria: function (criteria) {
						criteria.professionnals = [];
						if (this.selectedList.length > 0 && criteria) {
							for (var i = 0; i < this.selectedList.length; i++) {
								criteria.professionnals.push(this.selectedList[i].obj.id)
							}
		
						}
					},
				});
				scope.unremovableProf = []
				scope.selectAssignProf = function(){
					$timeout(function () {
						var profSelect = scope.groupCriteria.find(function (e) {
							return e.name === 'assignProfSelector';
						})
						profSelect.selectedList = []
						if(scope.docNote.profs && scope.docNote.profs.length > 0){
							scope.docNote.profs.forEach(function(prof){	
								if (profSelect && typeof profSelect.select === 'function') {
									if(prof.activeSt[0] != 'UNSEEN'){
										scope.unremovableProf.push(prof.idProf)
									}else if(prof.modificationStatus){
										profSelect.select(scope.profList.find(e => e.id == prof.idProf));
									}
								}
							})
						}
					}, 100);
				}
				
				scope.getAssignedProf = function(){
					scope.docNote.profs
				}

				function documentSavedCallback(res){
					clearSaving();
					unregisterDirty()
					if(res){
						var addToDocs = !!(scope.docNote.isNew);
						var doc = DocAccessor.utils.getBaseDocument(res);
						if (scope.docNote.selectedProf && doc.activeProf && scope.docNote.selectedProf.idProf!==doc.activeProf.idProf) {
							delete doc.selectedProf;	// ne pas écraser celui en place
						}
						if(!addToDocs){
							delete doc.uid;
						}
						if(scope.docNoteForm.pictureToPrint && scope.docNoteForm.id){
							doc.pictureToPrint = scope.docNoteForm.pictureToPrint;
						}
						if(scope.docNoteForm.picture && scope.docNoteForm.id){
							doc.picture = scope.docNoteForm.picture;
						}
						if (doc.activeProf==null) delete doc.activeProf;
						if (doc.activeProf && doc.activeProf.seenDatetime===-1) {
							delete doc.activeProf.seenDatetime;
						}
						angular.extend(scope.docNote, doc);
						if (scope.docNote.prop===undefined) scope.docNote.prop = {};
						scope.docNote.prop.readonly = true;	// pour savoir qu'a été modifié quand veut fermer.
						setNoteFrm(scope.docNote);

						if(addToDocs){
							scope.quickViewData.pat.viewbag.patData.docofys.unshift(scope.docNote);
							scope.quickViewData.pat.viewbag.patData.doc.unshift(scope.docNote);
						}

						//Hook for Enconter of any other directive that has set an on save success listener.
						if(scope.viewOptions && scope.viewOptions.onSaveSuccess){
							scope.viewOptions.onSaveSuccess(scope.docNote, scope.viewOptions);
						}

						model.patientDataUpdated(true);
						model.docDataUpdated(true);
						model.notice().success($filter('translate')('docSuccessfulSave'));
					}else{
						model.notice().fail($filter('translate')('docFailedSave'));
					}
				}

				scope.cancel = function (skipOnCancel){
					unregisterDirty();
					//Hook for Enconter of any other directive that has set an on save success listener.
					if(scope.viewOptions && scope.viewOptions.onCancel){
						scope.viewOptions.onCancel(scope.docNote, scope.viewOptions);
					}
				}

				function documentSavedCallbackAndNext(res){
					documentSavedCallback(res);
					nextDoc();
				}

				function nextDoc(){
					console.log("Going to next element");
					if(scope.viewOptions != undefined && scope.viewOptions.gotToNext != undefined){
						scope.viewOptions.gotToNext(scope.docNote);
					}
				}

				scope.nextDoc = nextDoc;
				scope.setSeen = function() {
					var profDoc = DocAccessor.utils.getCurrentProfessionalDocument(scope.noteFrm);
					if(profDoc !== null){
						if (profDoc.seenDatetime===undefined) {
							profDoc.seenDatetime = new Date().getTime();
							addOrRemove(true,"SEEN", profDoc);
							addOrRemove(false,"UNSEEN", profDoc);
							profDoc.modificationStatus = ModificationStatus.STATUS_UPDATED;
							scope.noteFrm.name = scope.noteFrm.viewbag.name;
							scope.noteFrm.date = scope.noteFrm.viewbag.date;
							scope.noteFrm.activeProf = profDoc;
							var send = angular.copy(_.omit(scope.noteFrm, ['viewbag', 'patient', 'origVersion']));
							delete send.viewbag;
							if (send.valDsq == undefined && !send.isNew) {
								delete send.picture;
								delete send.pictureToPrint;
							}
							return DocAccessor.save(send, documentSavedCallbackAndNext);
						}
					}
				};

				function addOrRemove(add, it, arr){
					var exist = $.inArray(it, arr.activeSt)>-1;
					if(add && !exist){
						arr.activeSt.push(it);
						arr.modificationStatus = ModificationStatus.STATUS_UPDATED;
					}else if(!add && exist){
						arr.activeSt.splice(arr.activeSt.indexOf(it), 1);
						arr.modificationStatus = ModificationStatus.STATUS_UPDATED;
					}
					arr.st = arr.activeSt;
				}

				function prepForPrint(d){
					var doc = angular.copy(d);

					if (doc.activeProf==undefined || doc.activeProf==null) {
						doc.activeProf = DocAccessor.utils.getCurrentProfessionalDocument(doc);
					}

					doc.name = doc.viewbag.name;
					doc.date = doc.viewbag.date;
					var send = _.omit(doc, ['patient','selectedProf']);
					delete send.viewbag;
					if (send.valDsq == undefined && !send.isNew) {
						delete send.picture;
						delete send.pictureToPrint;
					}
					// delete send.activeProf;
					return send;
				}

				function prepForSave(doc){
					// var savable = $.extend({}, scope.noteFrm);
					// Angular $http doesn't seem to url encode line breaks
					// frm.note = frm.note.replaceAll("\n", '%0D%0A');
					var profDoc = doc.activeProf==undefined || doc.activeProf==null ? DocAccessor.utils.getCurrentProfessionalDocument(doc) : doc.activeProf;
					if(profDoc !== null){
						addOrRemove(doc.viewbag.ToResolve,"TO_RESOLVE", profDoc);
						addOrRemove(doc.viewbag.OpenWithFile,"OPEN_WITH_FILE", profDoc);
						if(profDoc.note != doc.note){
							profDoc.note = doc.note;
							profDoc.modificationStatus = ModificationStatus.STATUS_UPDATED;
						}
						if(profDoc.signedDatetime !== doc.viewbag.signedDatetime){
							profDoc.signedDatetime = doc.viewbag.signedDatetime;
							profDoc.modificationStatus = ModificationStatus.STATUS_UPDATED;
						}
						if (profDoc.seenDatetime===undefined) {
							profDoc.seenDatetime = new Date().getTime();
							addOrRemove(true,"SEEN", profDoc);
							addOrRemove(false,"UNSEEN", profDoc);
							profDoc.modificationStatus = ModificationStatus.STATUS_UPDATED;
						}
						doc.activeProf = profDoc;
					}

					doc.labels = [];
					var labels = OfysUtils.mapArrayToObject(function(item){return item.id;}, model.labels().data);
					for(var labelId in doc.viewbag.selectedLabels) {
						if (doc.viewbag.selectedLabels[labelId]===true) {
							doc.labels.push(labels[labelId]);
						}
					}
					if(modifiedDoc()){
						doc.modificationStatus = ModificationStatus.STATUS_UPDATED;
					}
					doc.name = doc.viewbag.name;
					doc.date = doc.viewbag.date;
					var send = _.omit(doc, ['patient','selectedProf']);
					delete send.viewbag;
					if (send.valDsq == undefined && !send.isNew) {
						delete send.picture;
						delete send.pictureToPrint;
					}
					// delete send.activeProf;
					return send;
				}

				function clearSaving(){
					delete scope.saving;
				}

				scope.save = function(){
					if(scope.validateForm(scope.docNoteForm.$valid)){
						if(scope.saving === undefined){
							var savable = prepForSave(scope.noteFrm);
							scope.saving = DocAccessor.save(savable, documentSavedCallback, clearSaving);
						}
						return scope.saving;
					}else{
						//Reject save request if form is not valid
						return $q(function (resolve, reject) {reject(); })
					}
				};
				
				if(scope.isReady){
					scope.addDoc.save = scope.save;
				}

				scope.validateForm = function (formValid) {
					if(!formValid){
						model.notice().fail($filter("translate")('docNoteFrmInvalid'), undefined,4000);
					}
					return formValid;
				}
				scope.print = function(){
					var savable = prepForPrint(scope.noteFrm);
					return DocAccessor.print(savable, angular.noop);
				};
				scope.faxDoc = OfysUtils.throttle(function(){
					var doc = prepForPrint(scope.noteFrm);
					if (doc) {
						var formName = doc.name + (doc.date ? " (" + doc.date + ")" : "");
					}
					var patient = scope.quickViewData && scope.quickViewData.pat ? scope.quickViewData.pat : scope.noteFrm.patient;
					FlView.open({templateUrl: "/dashboard/resources/ofys/fax/fax.html?v=bl", patient: patient, showCoverPageOptions: true }, {windowClass: "faxmodal",
					backdrop: 'static' }).then(function(faxdata){
						if (formName) {
							faxdata.docName = formName;
						}
						DocAccessor.fax({id: doc.id, faxdata: faxdata}, function(res){
							model.notice().success($filter('translate')('FAX_SERVER_SUCCESS'));
						});
					});
				});
				function documentSavedEnumSetCallback(res){
					if(res.data !== undefined) {
						if (res.data.severity=="OK"){
							if (res.data.data) {
								var ids = res.data.data;
								for (var i = 0; i < scope.docNote.profs.length; i++) {
									var lp = scope.docNote.profs[i];
									if (ids.indexOf(lp.id)!==-1) {
										lp.activeSt.length = 0;
										lp.st.length = 0;
									}
								}
								model.docDataUpdated(true);
							}
							model.notice().success($filter('translate')('docSuccessfulSave'));
						}else{
							model.notice().fail(res.data.message, $filter('translate')('docFailedSave'));
						}
					}else{
						model.notice().fail($filter('translate')('docFailedSave'));
					}
				}
				function documentSavedDellAutoOpenCallback(res){
					if(res.data !== undefined) {
						if (res.data.severity=="OK"){
							if (res.data.data) {
								var ids = res.data.data;
								if (scope.docNote.activeProf) {
									scope.docNote.activeProf.st.splice($.inArray("OPEN_WITH_FILE", scope.docNote.activeProf.st), 1);
								}
								if (scope.noteFrm && scope.noteFrm.viewbag) {
									scope.noteFrm.viewbag.OpenWithFile = false;
								}
								for (var i = 0; i < scope.docNote.profs.length; i++) {
									var lp = scope.docNote.profs[i];
									if (ids.indexOf(lp.id)!==-1) {
										lp.activeSt.splice($.inArray("OPEN_WITH_FILE", lp.activeSt), 1);
										lp.st.splice($.inArray("OPEN_WITH_FILE", lp.st), 1);
									}
								}
								model.docDataUpdated(true);
							}
							model.notice().success($filter('translate')('docSuccessfulSave'));
						}else{
							model.notice().fail(res.data.message, $filter('translate')('docFailedSave'));
						}
					}else{
						model.notice().fail($filter('translate')('docFailedSave'));
					}
				}
				scope.saveEnumSet = function(){
					var enumToReset = {docNotes:[], idPatient:scope.docNote.idPatient};
					if (scope.docNote.profs && scope.docNote.activeProf) {
						for (var i = 0; i < scope.docNote.profs.length; i++) {
							var lp = scope.docNote.profs[i];
							if (lp.idProf!==scope.docNote.activeProf.idProf) {
								// prof est different du prof actif
								var toResolve = $.inArray("TO_RESOLVE",  lp.activeSt) >= 0;
								var openWithFile = $.inArray("OPEN_WITH_FILE", lp.activeSt) >= 0;
								if (toResolve===true || openWithFile===true) {
									enumToReset.docNotes.push(lp);
								}
							}
						}
					}
					if (enumToReset.docNotes.length>0) {
						return DocAccessor.saveEnumSet(enumToReset, documentSavedEnumSetCallback);
					} else {
						// nothing to reset
					}
				};
				scope.saveDelAllAutoOpen = function(){
					var enumToReset = {docNotes:[], idPatient:scope.docNote.idPatient};
					if (scope.docNote.profs) {
						for (var i = 0; i < scope.docNote.profs.length; i++) {
							var lp = scope.docNote.profs[i];
							if ($.inArray("OPEN_WITH_FILE", lp.activeSt) >= 0) {
								enumToReset.docNotes.push(lp);
							}
						}
					}
					if (enumToReset.docNotes.length>0) {
						return DocAccessor.delAllAutoOpen(enumToReset, documentSavedDellAutoOpenCallback);
					} else {
						// nothing to reset
					}
				};


				//This function should be normalized and put in quickview function as a helper function
				//It is useful for all quickview activities that need to listen to quickview events
				//especially ones that can have a dirty state
				// - forms, docs, laboratories and eventullly all other items that can be modified
				function addEventsEvent(){
					if(!scope.qv){
						return;// not in quickview mode
					}

					if(!QuickView.eventsActive(scope.qv)){
						return;// event have already been deleted (because of a close or one quickview that triggers another)
					}
					//Si c'est la première ouverture, créer la variable d'événements
					if(!scope.qv.ActiveEventsRef){
						scope.qv.ActiveEventsRef = {};
					}
					//Make sure previously created evens are not referred to
					//Very important to avoid leaks
					QuickView.removeAllEventHandlers(scope);

					function onMinimizeOrClose(event, fct) {
						var act = event.mObj.quickViewData.qvActData;
						if ((!scope.ignoreChanges) && (angular.isDefined(act.prop) && act.prop.readonly===false)) {
							event.stopPropagation();
							QConfirm.open({title: $filter('translate')('documentUnsavedChanges')}).then(function(save){
								function continueAction(res){
									scope.ignoreChanges = true;
									unregisterDirty();
									//Makes sure the original action is called again in 'fct()'
									//- if changeActivity was the origianl action it should be recalled and
									//   the second time the validation message is not shown because scope.ignoreChanges === true
									if (fct) fct();
								}
								function saveFailedCanNotContinue(res){
									var errMsg = res.statusText ? res.statusText : "";
									model.notice().fail($filter('translate')('docFailedSaveErrMsg', {errMsg: errMsg}));
								}
								if(save){
									act.save().then(continueAction, saveFailedCanNotContinue);//should change the dirty state to make sure that the second time closing goes through
								}else{
									continueAction();
								}
							});
							return true;
						}
						return false;
					}

					//L'événement existe donc il ne faut pas le recréer
					if(!scope.qv.ActiveEventsRef.onQvClose){
						//Ici elle est appeller ajouté aussi-tot que le viewer s'ouvre donc toujours active
						//Comme le scope n'est pas passé en parametre, le handler est seulement detruit quand le quickview est fermer
						scope.qv.ActiveEventsRef.onQvClose = Event.on(scope.qv.onQvClose,function(event){
							// console.log("######Quick view is closing");
							onMinimizeOrClose(event, scope.qv.$$close);
						});
					}

					if(!scope.qv.ActiveEventsRef.onQvMinimize){
						scope.qv.ActiveEventsRef.onQvMinimize = Event.on(scope.qv.onQvMinimize, function(event){
							// console.log("######Quick view is minimizing");
							onMinimizeOrClose(event);
							QuickView.removeAllEventHandlers(scope, scope.qv.$$minimize);
						}, scope);
					}

					//événement de changement d'activité
					if(!scope.qv.ActiveEventsRef.onQvActivityChange){
						scope.qv.ActiveEventsRef.onQvActivityChange = Event.on(scope.qv.onQvActivityChange,function(event){
							// console.log("######Quick view is changing the activity");
							var newAct = event.newAct;
							onMinimizeOrClose(event, function(){
								if(scope.qv && scope.qv.$$changeActivity && scope.qv.$$changeActivity (newAct)){
									model.actUpdated(true);
									scope.ignoreChanges = false;
									QuickView.removeAllEventHandlers(scope);
								}
							});
						}, scope);
					}

					if(!scope.qv.ActiveEventsRef.onQvExternalize){
						scope.qv.ActiveEventsRef.onQvExternalize = Event.on(scope.qv.onQvExternalize,function(event){
							// console.log("######Quick view is externalizing");
							QuickView.removeAllEventHandlers(scope);
						}, scope);
					}
				}
				scope.$watch(function() {
					return model.docDataUpdated().val;
				}, update);
			}
		};
	}]);

	doc.directive('docDsqView', ['Notification','DashAPI','DashWebSocket','MessageLink','DocAccessor', 'model', '$filter',
		function(Notification, DashAPI, DashWebSocket, MessageLink, DocAccessor, model, $filter){
			return {
				restrict: 'E',
				templateUrl: '/dashboard/resources/ofys/doc/doc_dsq_view.html?v=bl',
				scope: true,
				link: function(scope, element, attrs){

					scope.resizeIframe = function(elem){
						scope.formWindow = elem[0].contentWindow;
						frameApi(elem[0].contentWindow);
						var parentSection = $(elem[0]).parents("section")[0];
						var headerheight = $(parentSection).find(".doc-header").outerHeight();
						if(headerheight === undefined)headerheight = 0;
						var height = $(parentSection).outerHeight() - headerheight;
						elem[0].style.height = (height - 15 ) + "px";
					};

					function frameApi(wx){
						//Not useful in dashboard but called when pdf has loaded in browser.
						// wx.finishedLoading = function(){};
					}

					var dsqItemHandlerId = Notification.registerHandler('dsqDocItem', function(msg){
						// console.log(msg);
						var statusError = DashAPI.handleReturnObject(msg.data.status);
						if (statusError=='OK' || statusError=='WARNING') {
							if(msg.data.obj.idPatient === scope.patient.id){
								scope.doc.viewbag.dsqpatientImage = msg.data.obj;
							}
						} else {
							// if (error) error();
						}
						scope.requestInProgress = false;
					}, scope);

					scope.print = function(){
						if(scope.doc && scope.doc.viewbag && scope.doc.viewbag){
							var printReq = {
								dsqImagingResultExam: scope.doc.viewbag.dsqpatientImage.dsqImagingResultExam,
								index: scope.activeReport,
								patientId: scope.patient.id
							};
							DocAccessor.printDsqDoc(printReq, function(msg) {
								var printUrl = msg;
								DashWebSocket.send({url: "/dashboard", data:{url: printUrl}});
							});
						}else{
							model.notice().fail($filter('translate')("dsqPrintInvalidDocDataError"));
						}
					};

					scope.openVersion = function(index){
						if(index != undefined && index !== scope.activeReport){
							getDoc(index);
						}
					};

					function update(n, o){
						scope.doc = n;
						if(!scope.doc.viewbag){
							scope.doc.viewbag = {};
						}
						if(scope && scope.quickViewData && scope.quickViewData.pat){
							scope.doc.viewbag.patient = scope.quickViewData.pat
						}
						scope.linkManager = MessageLink.linkManager(DocAccessor, scope.doc, scope.doc.uid, scope)
						scope.doc.onChangeActivity = function () {
							scope.linkManager.clear()
						}
						scope.doc.viewbag.dsqdocurl = '';
						scope.doc.viewbag.activeReport = 0;
						if(scope.doc){
							getDoc();
						}
					}

					scope.isActiveReport = function(i){
						var a = i === scope.activeReport;
						return a;
					};
					scope.isNotActiveReport = function(i){
						var a = i !== scope.activeReport;
						return a;
					};

					function cleanDoc() {
						var d = angular.copy(scope.doc);
						delete d.viewbag;
						return d;
					}

					function getDoc(index){
						var qvData = scope.$eval(attrs.quickViewData);
						scope.patient = qvData.pat;
						var searchCriteria = {
							patientId: scope.patient.id,
							dsqImagingResultExam: cleanDoc()
						};
						if(index != undefined && index > -1){
							searchCriteria.index = index;
						}
						scope.activeReport = searchCriteria.index?searchCriteria.index: 0;
						scope.requestInProgress = true;
						DashWebSocket.sendRequest("/dashboard/dsq/ws/doc/get", searchCriteria);
					}

					scope.$watch(attrs.docs, update);
				}
			};
	}]);

	doc.directive('sommhospDsqView', ['Notification','DashAPI','DashWebSocket','PatientUtils','DocAccessor',
		function(Notification, DashAPI, DashWebSocket, PatientUtils, DocAccessor){
			return {
				restrict: 'E',
				templateUrl: '/dashboard/resources/ofys/doc/sommhosp_dsq_view.html?v=bl',
				scope: true,
				link: function(scope, element, attrs){

					scope.resizeIframe = function(elem){
						scope.formWindow = elem[0].contentWindow;
						frameApi(elem[0].contentWindow);
						var parentSection = $(elem[0]).parents("section")[0];
						var headerheight = $(parentSection).find(".doc-header").outerHeight();
						if(headerheight === undefined)headerheight = 0;
						var height = $(parentSection).outerHeight() - headerheight;
						elem[0].style.height = (height - 25 ) + "px";
					};

					function frameApi(wx){
						//Not useful in dashboard but called when pdf has loaded in browser.
						// wx.finishedLoading = function(){};
					}

					var dsqSommhospHandlerId = Notification.registerHandler('dsqSommhospItem', function(msg){
						var status = DashAPI.getSimpleStatus(msg.data.status);
						if(scope.patient.id === msg.data.obj.idPatient){
							scope.doc.viewbag.dsqpatientImagesStatus = status;
							if (status.severity=='OK' || status.severity=='WARNING') {
								scope.doc.viewbag.dsqpatientImages = msg.data.obj;
								scope.doc.viewbag.dsqpatientImage = msg.data.obj[0];
								scope.doc.viewbag.activeReport = 0;
								if (scope.doc.viewbag.historyLoaded === 2) {
									scope.doc.viewbag.historyLoaded = 1;
								}
							} else {
								scope.doc.viewbag.dsqpatientImages = undefined;
								scope.doc.viewbag.dsqpatientImage = undefined;
								scope.doc.viewbag.activeReport = undefined;
								if (scope.doc.viewbag.historyLoaded === 2) {
									scope.doc.viewbag.historyLoaded = 1;
								}
							}
						}
						scope.requestInProgress = false;
					}, scope);

					function update(n, o){
						if (n && n.className === 'CPatientDischargeCareSummary') {
							//arg n is a CPatientDischargeCareSummary
							var csummary = n;
							if (!csummary.viewbag) {
								csummary.viewbag = {};
							}

							//modify scope
							scope.doc = csummary;
							scope.patient = scope.$eval(attrs.quickViewData).pat;

							if (csummary.viewbag.dsqpatientImage &&
								csummary.viewbag.dsqpatientImage &&
								csummary.viewbag.dsqpatientImage.dsqDischargeCare &&
								csummary.viewbag.dsqpatientImage.dsqDischargeCare.id &&
								csummary.viewbag.dsqpatientImage.dsqDischargeCare.id.value === csummary.id.value) {
								//we already load the detail for this summary
								scope.doc.viewbag.activeReport = 0;
								scope.doc.viewbag.dsqpatientImage = scope.doc.viewbag.dsqpatientImages[0];
							} else {
								//load sommhosp detail
								scope.doc.viewbag.historyLoaded = 0; //loading default
								loadSommhosp(false);
							}

						} else if (n) {
							console.log("update received an unsupported scope.doc.className " + scope.doc.className);
						} else {
							console.log("update received an undefined n argument " + n);
						}
					}

					scope.print = function(){
						DashWebSocket.send({url: "/dashboard", data:{url: scope.doc.viewbag.dsqpatientImage.printUrl}});
					};

					scope.openVersion = function(index){
						if(index != undefined && index !== scope.activeReport){
							//all version are already loaded
							if (scope.doc.viewbag.historyLoaded === 1) {
								if (scope.doc.viewbag.dsqpatientImages[index]) {
									scope.doc.viewbag.activeReport = index;
									scope.doc.viewbag.dsqpatientImage = scope.doc.viewbag.dsqpatientImages[index];
								} else {
									console.log("open version, invalid index asked " + index);
								}
							} else {
								console.log("open version, historyLoaded != 1");
							}
						}
					};

					scope.loadHistory = function() {
						scope.doc.viewbag.historyLoaded = 2; //loading history
						loadSommhospWithHistory();
					};

					scope.isActiveReport = function(i){
						var a = scope.doc != undefined &&
								scope.doc.viewbag != undefined &&
								i === scope.doc.viewbag.activeReport;
						return a;
					};

					scope.isNotActiveReport = function(i){
						var a = scope.doc != undefined &&
								scope.doc.viewbag != undefined &&
								i != scope.doc.viewbag.activeReport;
						return a;
					};

					//includeHistory default to false
					function loadSommhosp(includeHistory){
						scope.doc.viewbag.dsqpatientImagesStatus = undefined;
						scope.doc.viewbag.activeReport = 0;
						scope.requestInProgress = true;

						if(includeHistory === undefined) {
							includeHistory = false;
						}
						var patient = scope.$eval(attrs.quickViewData).pat;
						var searchCriteria = {
							patientId: patient.id,
							value: scope.doc.id.value,
							includeHistory: includeHistory
						};
						DashWebSocket.sendRequest("/dashboard/dsq/ws/sommhosp/get", searchCriteria);
					}

					function loadSommhospWithHistory(){
						loadSommhosp(true);
					}

					scope.$watch(attrs.docs, update);
				}
			};
	}]);

	doc.directive('docView', ['DocAccessor', 'model','$filter',
	                 function(DocAccessor, model, $filter){

		function setInitData(doc) {
			if (!doc.prop) doc.prop = {readonly:true, edit: false};
		}

		function getData(scope, doc){
			if(!doc)return;
			if (doc.prop) {
				// est en mode d'édition - donc a deja été chargé. Ne pas recharger le fichier - pas besoin car j'ai tout
				model.editModeUpdated(true);
				if(scope && scope.viewOptions && scope.viewOptions.hasHeader){
					model.docDataUpdated(true, doc, scope.noteFrm);
				}
			} else if(doc.id != undefined){
				// pour obtenir principalement la colonne picture (byte arr du doc).
				DocAccessor.docView({id:doc.id, idProf: model.currentLaboDocMd().id}, function success(response){
					// response.data.profs = doc.profs; // profs ici n'avait que le prof tx.
					if (!response.data || (response.data && response.data.success==false)) {
						var user = model.user();
						model.notice().warn($filter('translate')('ERR_GET_DOC'));
						return;
					}
					var docPatImg = DocAccessor.utils.getBaseDocument(response.data);
					if (docPatImg.activeProf) {
						delete doc.activeProf;
						doc.status = docPatImg.activeProf.activeSt;
						doc.note = docPatImg.activeProf.note;
					}
					if (doc.status && doc.notValidated) {
						doc.notValidated='OK';	// un delete n'est pas considéré instantanément dans le ui...
					}
					if (doc.uid !== undefined && docPatImg.uid !== undefined) {
						delete docPatImg.uid;
					}
					if (doc.labels && docPatImg.labels) {
						delete docPatImg.labels;
					}
					if (doc.profs && doc.profs.length===0) delete doc.profs;
					// angular.extend(doc, docPatImg);
					OfysUtils.extendIfNotDefined(doc, docPatImg);
					if (doc.activeProf) {
						var foundIt = false;
						for (var i=0; i < doc.profs.length; i++){
							if(doc.profs[i].idProf ==  doc.activeProf.idProf){
								doc.profs[i] = doc.activeProf;
								foundIt = true; break;
							}
						}
						if (foundIt===false) {
							doc.profs.push(doc.activeProf);
						}
					}

					doc.origVersion = angular.copy(doc);	// pour permettre cancel
					if(doc.viewerUrl){
						doc.t = 'urlframe';
					}else{
						doc.t = scope.doc.type == 'img' || scope.doc.type == 'pdf' ?
								model.isIE ?'ieframe': 'frame' : 'nan';
					}
					setInitData(doc);
					model.editModeUpdated(true);
					if(scope && scope.viewOptions && scope.viewOptions.hasHeader){
						model.docDataUpdated(true, doc, scope.noteFrm);
					}
				});
			}
		}

		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/doc/doc_view.html?v=bl',
			scope: true,
			link: function(scope, element, attrs){

				scope.model = model;
				scope.noteFrm = {};

				var defaultOptions = {
					hasHeader: true
				}
				function setViewOptions(options){
					scope.viewOptions = angular.copy(defaultOptions);
					if(options){
						$.extend(scope.viewOptions, options);
					}
				}
				function update(n, o, scope){
					scope.doc = n; //scope.$eval(attrs.docs);
					scope.quickViewData = scope.$eval(attrs.quickViewData);
					if(!scope.doc) return;
					setViewOptions(scope.$eval(attrs.options));
					getData(scope, scope.doc);
					// PatientAccessor.setCurrent(scope.doc.idPatient); // retrait de setCurrent
				}

				scope.$watch(function(){
					return scope.$parent.$eval(attrs.docs);
				}, update);

				scope.setupIframe = function(elem){
					// scope.iframeWindow = elem[0].contentWindow;
					adjustIFrame(elem);
				}

				function adjustIFrame(elem){
					//Resize iframe to parents height
					var parentSection = $(elem[0]).parents("section")[0];
					var headerheight = $(parentSection).find(".popSide").outerHeight();
					if(headerheight === undefined)headerheight = 0;
					var height = $(parentSection).outerHeight() - headerheight;
					elem[0].style.height = (height - 8 ) + "px";
				};

			}
		}
	}]);

	doc.directive('imgViewer', [function () {
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/doc/img_viewer.html?v=bl',
			scope: true,
			link: function(scope, element, attrs){
				function update(){
					scope.doc = scope.$eval(attrs.doc);
					scope.print = scope.$eval(attrs.print)
				}
				scope.$watch(attrs.doc, update)
			}
		}
	}]);

	doc.directive('pdfViewer', ['model', 'PatientAccessor', 'Rights', function (model, PatientAccessor, Rights) {
		return {
			restrict: 'E',
			template: '<iframe class="u-full-width frameViewer a4"  data-ng-src="{{viewerUrl}}" data-iframe-onload="setupIframe"></iframe>',
			scope: true,
			link: function(scope, element, attrs){
				if(model.prefSettings("user_settings_UseNewPDFViewer")){
					scope.viewerUrl = "/tools/pdf/web/pdf2_viewer.html?file=";
				}else{
					scope.viewerUrl = "/dashboard/resources/ofys/doc/pdf_viewer.html?v=bl";
				}
				
				function update(){
					scope.pdf = scope.$eval(attrs.pdf);
					scope.print = scope.$eval(attrs.print)
					if(scope.frame){
						loadPdf();
						if(!scope.pdf.patient){
							findPatient()
						}
					}
				}

				scope.setupIframe = function (elem) {
					scope.frame = elem[0].contentWindow;
					if(scope.pdfjs && scope.pdfjs.get){
						scope.pdfjs.lib = scope.frame.pdfjsLib;
					}
					loadPdf();
					
					if(!scope.pdf.patient){
						findPatient()
					}
				}
				
				function findPatient(){
					var pdf = scope.frame.pdfjsLib.getDocument(convertDataURIToBinary(scope.pdf.sanitizedImage));
					pdf.promise.then(function(pdf){
						var page = pdf.getPage(1)
						page.then(function(page){
							var textContent = page.getTextContent();
					        textContent.then(function(text){
					        	var text = text.items.map(function (s) { return s.str; }).join(' ');
								var namFound = text.match(/(\b([A-Z][A-Z][A-Z][A-Z|*]\s*[0-9][0-9][0156][0-9]\s*[0-3][0-9]([A-Z]|[0-9])[0-9])|(^[0-9]{9}[M]{0,1}$)|(^[0-9]{10})\b)/);
								if(namFound){
									var queryObj = {q:b64EncodeUnicode(namFound[0])}
									if(model.prefSettings("user_settings_SitePatients")){
										queryObj.sites = [{id: model.user().session.workSite.id}];
									}
									PatientAccessor.searchAdvanced(queryObj, function(res){
										if(res.data.length > 0){
											scope.criteria = scope.$eval(attrs.profs);
											let treatingProf = undefined;
											if(res.data[0].treatingProfessionnal){
												treatingProf = model.store.profs.list().find(function(prof){
													return prof.id == res.data[0].treatingProfessionnal && prof.isProfTx
												})
											}
											addProfToFile(treatingProf);
											scope.pdf.patient = res.data[0];
											scope.pdf.patient.viewbag = {limitations:Rights.getConsent()};
											scope.pdf.idPatient = res.data[0].idPatient;
										}else{
											addProfToFile();
										}
										model.actUpdated(true);
										pdf.destroy();
									});
								}else{
									addProfToFile();
									model.actUpdated(true);
									pdf.destroy();
								}
					        });
						})
					})
				}
				
				function addProfToFile(treatingProf){
					scope.pdf.profs = [];
					if(treatingProf){
						scope.pdf.profs[0] = treatingProf;
					}else if(scope.pdfjs && scope.pdfjs.onCallProf){
						scope.pdf.profs[0] = scope.pdfjs.onCallProf;
					}
					selectProf(scope.pdf.profs[0])
				}

				function loadPdf() {
					if(scope.frame && scope.pdf && scope.pdf.sanitizedImage){
						scope.frame.PDFViewerApplication.open(convertDataURIToBinary(scope.pdf.sanitizedImage), 0);
					}
				}
				function selectProf(prof){
					if (prof) {
						var profSelect = scope.groupCriteria.find(function (e) {
							return e.name === 'scanProfSelector';
						})
						if (profSelect && typeof profSelect.select === 'function') {
							profSelect.select(prof);
						}						
					}
				}
				function convertDataURIToBinary(dataURI) {
					var BASE64_MARKER = ';base64,';
					var base64Index = dataURI.indexOf(BASE64_MARKER) + BASE64_MARKER.length;
					var base64 = dataURI.substring(base64Index);
					var raw = window.atob(base64);
					var rawLength = raw.length;
					var array = new Uint8Array(new ArrayBuffer(rawLength));

					for(var i = 0; i < rawLength; i++) {
						array[i] = raw.charCodeAt(i);
					}
					return array;
				}
				scope.$watch(attrs.pdf, update)
			}
		}
	}])



	doc.directive('addDocument', ['model','patientShowTitles','PatientUtils','ModificationStatus', 'AppointmentAccessor', 'EncounterSummaryCommon', 'QConfirm', '$filter', '$rootScope',
	                               function(model, patientShowTitles, PatientUtils, ModificationStatus, AppointmentAccessor, EncounterSummaryCommon, QConfirm, $filter, $rootScope){
		return {
			restrict: 'A',
			scope: true,
			link: function(scope, element, attrs){
				function init(){
					scope.def = def = { added:[]};
					scope.file = {}
				}
				init();
				def.patient = scope.patient;
				def.openDoc = scope.openDoc;
				scope.isReady = false;
				scope.addDoc = {};

				/* Utility function to convert a canvas to a BLOB */
				var dataURLToBlob = function(dataURL) {
					var BASE64_MARKER = ';base64,';
					if (dataURL.indexOf(BASE64_MARKER) == -1) {
						var parts = dataURL.split(',');
						var contentType = parts[0].split(':')[1];
						var raw = parts[1];

						return new Blob([raw], {type: contentType});
					}

					var parts = dataURL.split(BASE64_MARKER);
					var contentType = parts[0].split(':')[1];
					var raw = window.atob(parts[1]);
					var rawLength = raw.length;

					var uInt8Array = new Uint8Array(rawLength);

					for (var i = 0; i < rawLength; ++i) {
						uInt8Array[i] = raw.charCodeAt(i);
					}

					return new Blob([uInt8Array], {type: contentType});
				}


				function convertDataURIToBinary(dataURI) {
					var BASE64_MARKER = ';base64,';
					var base64Index = dataURI.indexOf(BASE64_MARKER) + BASE64_MARKER.length;
					var base64 = dataURI.substring(base64Index);
					var raw = window.atob(base64);
					var rawLength = raw.length;
					var array = new Uint8Array(new ArrayBuffer(rawLength));

					for(var i = 0; i < rawLength; i++) {
						array[i] = raw.charCodeAt(i);
					}
					return array;
				}
				
				/* End Utility function to convert a canvas to a BLOB      */
			
				def.isMobile = model.isMobile();
				def.uploadPhotos = function(doc){
					if(doc && doc.uploadDoc){
						// Read in file
						var file = doc.uploadDoc;
						// console.log(file);
						var kb = Math.round(file.size/1024);
						scope.fileTooBig = false;
						scope.fileNotSupported = false;
						if(kb > 5120){
							scope.fileTooBig = true;
							return;
						}
						// Ensure it's an image
						// if(file.type.match(/image.*|application.*/)) {
						if(file.type == 'application/pdf' || file.type == 'image/png' || file.type == 'image/jpeg') {
							// console.log('An image has been loaded');

							// Load the image
							var reader = new FileReader();
							reader.onload = function (readerEvent) {
								if(file.type == 'application/pdf'){
									var input = {
										rawImage: readerEvent.target.result,
										sanitizedImage: readerEvent.target.result,
										file: file,
									};
									doc.uploadImage = defaultImage(input, def.patient, doc);
								}else{
									var image = new Image();
									image.onload = function (imageEvent) {

										// Resize the image
										var canvas = document.createElement('canvas'),
											max_size = 900,// TODO : pull max size from a site config
											width = image.width,
											height = image.height;
										if (width > height) {
											if (width > max_size) {
												height *= max_size / width;
												width = max_size;
											}
										} else {
											if (height > max_size) {
												width *= max_size / height;
												height = max_size;
											}
										}
										canvas.width = width;
										canvas.height = height;
										canvas.getContext('2d').drawImage(image, 0, 0, width, height);
										var dataUrl = canvas.toDataURL('image/jpeg');
										var resizedImage = dataURLToBlob(dataUrl);
										$.event.trigger({
											type: "imageResized",
											blob: resizedImage,
											url: dataUrl
										});
										var input = {
											rawImage: readerEvent.target.result,
											sanitizedImage: dataUrl,
											file: file,
										};
										doc.uploadImage = defaultImage(input, def.patient, doc);
									}
									image.src = readerEvent.target.result;
								}

							}
							reader.readAsDataURL(file);
						} else{
							scope.fileNotSupported = true;
							return
						}

					}
				};

				scope.userIsProf = true;
				function getDocProf(){
					var prof;
					if(model.user().hasClinicalRights() && model.user().profil && model.user().profil.professionalType){
						prof = model.user().profil;
						scope.userIsProf = true;
					}else if(model.user().session && model.user().session.clientPreferences &&
							model.user().session.clientPreferences.onCallProfessionnal){
						scope.userIsProf = false;
						prof = model.user().session.clientPreferences.onCallProfessionnal;
					}
					return doGetDocProf(prof);
				}

				function doGetDocProf(prof, fromsearch){
					var time = moment().valueOf();
					var res = {
						idProf:prof.id,
						profName:prof.lastName + ", "+ prof.firstName,
						dateAssigned: time,
						modificationStatus: ModificationStatus.STATUS_NEW_UPDATED,
						st: [],
						activeSt: []
					};
					scope.docProf = {name: res.profName, idProf: res.idProf};
					if(scope.userIsProf){
						res.seenDatetime = time;
						res.st.push('SEEN');
						res.activeSt.push('SEEN');
						scope.docProf.type = "Other";
					}else if(!fromsearch){
						scope.docProf.type = "onCall";
						res.st = ['UNSEEN'];
						res.activeSt = ['UNSEEN'];
					}

					return res;
				}

				scope.selectDocProf = function(prof){
					if(scope.file && scope.file.uploadImage &&
						scope.file.uploadImage.quickViewData.qvActData.viewbag && 
						scope.file.uploadImage.quickViewData.qvActData.viewbag.editable){
							scope.file.uploadImage.quickViewData.qvActData.viewbag.editable.profs[0] = doGetDocProf(prof, true);
					}
				}

				scope.changeAlreadyViewed = function(checked){

				var time = moment().valueOf();
				var res
				if(scope.file && scope.file.uploadImage &&
					scope.file.uploadImage.quickViewData.qvActData.viewbag && 
					scope.file.uploadImage.quickViewData.qvActData.viewbag.editable){
						res = scope.file.uploadImage.quickViewData.qvActData.viewbag.editable.profs[0]
				}
				if(!res && scope.docProf && scope.docProf.idProf){
					var res = {
						idProf:scope.docProf.idProf,
						dateAssigned: time,
						modificationStatus: ModificationStatus.STATUS_NEW_UPDATED,
						st: [],
						activeSt: []
					};
					scope.file.uploadImage.quickViewData.qvActData.viewbag.editable.profs[0] = res;
				}
				if(checked){
//					res.seenDatetime = time;
					res.st =['SEEN'];
					res.activeSt =['SEEN'];
				}else{
					// delete res.seenDatetime;
					res.st = ['UNSEEN'];
					res.activeSt = ['UNSEEN'];
				}
			}

			function defaultImage (input, pat, origDoc){
				var act = {
					rawImage:input.rawImage,
					modificationStatus: ModificationStatus.STATUS_NEW_UPDATED,
					sanitizedImage: input.sanitizedImage,
					picture: Array.from(convertDataURIToBinary(input.sanitizedImage)),
					className: "CBasePatientImage",
					date: moment().format("YYYY-MM-DD"),
					isNew: true,
					profs:[],
					idPatient: pat.id,
					patient: PatientUtils.getSuperCleanPatient(pat),
					pictureUpload: true,
				};
				var docProf = getDocProf();
				if(docProf){
					act.profs.push(docProf);
				}

				var ext = input.file.name.split('.').pop().toLowerCase();
				if(ext === 'jpg' || ext === 'png' || ext === 'jpeg' || ext === 'gif'){
					act.t = 'imgviewer';
				}else if(ext === 'pdf'){
					act.t = 'pdfviewer'
				}
				var res = patientShowTitles.getQVPayLoad(act, { onCancel: (function(doc){
					return function(doc){ onNewDocumentCancel(origDoc) ;}
				})(), onSaveSuccess: (function(){return function(doc){onNewDocumentSaveSuccess(doc, origDoc)}})()}, pat)
				if(res.quickViewData && res.quickViewData.qvActData){
					res.quickViewData.qvActData.viewbag = {notesSectionInactive: true};
					res.quickViewData.qvActData.prop = {readonly:false, edit: true};
				}
				return res;
			}
			function onNewDocumentCancel(doc){
				scope.userIsProf = true;
				if(doc && doc.uploadFileName && doc.uploadFileName[0]){
					doc.uploadFileName[0].value = "";
				}
				if(scope.file.uploadFileName){
					console.log("quick it works");
				}
				if(doc){
					delete doc.uploadImage;
					scope.file.uploadDoc = null;
				}
			}
			function onNewDocumentSaveSuccess(doc, item){
				scope.def.added.push(doc);
				onNewDocumentCancel(item)
			}
		}
	}
	}]);

	doc.controller('ReviewController', ['$scope', 'DocAccessor','LabAccessor', 'model','$stateParams','QValidation','$filter','$state','PatientAccessor','$timeout',
	                                    function($scope, DocAccessor, LabAccessor, model,$stateParams,QValidation,$filter,$state, PatientAccessor, $timeout){
		
		$scope.profList = filterCurrentWorksite();

		function filterCurrentWorksite(){
			var res = model.store.profs.filter.treating.list();
			if(model.prefSettings('user_settings_SiteLaboDocs')){
				var workSiteId = model.user().session.workSite.id;
				res = res.filter(function(e){
					if(e && e.sites && e.sites.length > 0){
						for (var i = 0; i < e.sites.length; i++) {
							if(e.sites[i].idSite === workSiteId){
								return true;
							}
						}
						return false;
					}else{
						// if the user does not have a session site.. always display
						return true;
					}
				});
			}
			return $filter('orderBy')(res, 'lastName');
		}

		model.activeController('review');
		model.activeMenu('Documents');
		$scope.setCurrentLaboDocProf = function(md) {
			model.currentLaboDocMd(md);
			if (md && md.id!==model.user().profil.id) {
				model.notice().info($filter('translate')('WARNING_OTHER_MD', model.user().profil));
				$scope.forceReloadLabosDocsOnly();
			} else {
				$scope.forceReload();
			}
		};

		$scope.showOptions = model.prefSettings();
		if (!($scope.showOptions.docShowLab===true || $scope.showOptions.docShowLab===false)) {
			model.prefSettings('docShowLab', true);
		}
		if (!($scope.showOptions.docShowDoc===true || $scope.showOptions.docShowDoc===false)) {
			model.prefSettings('docShowDoc', true);
		}
		if (!($scope.showOptions.docToSee===true || $scope.showOptions.docToSee===false)) {
			model.prefSettings('docToSee', true);
		}
		if (!($scope.showOptions.docToResolve===true || $scope.showOptions.docToResolve===false)) {
			model.prefSettings('docToResolve', true);
		}

		$scope.labs = {loaded:false, all:[], lastIds:'', first:-1, firstUnseen:-1, firstToResolve:-1};
		$scope.docs = {loaded:false, all:[], lastIds:'', first:-1, firstUnseen:-1, firstToResolve:-1};

		var filterData = function(d) {
			if (!filterSearchText(d)) return false;

			if ($scope.showOptions.docShowLab!==true && ('CLaboFile'===d.className || 'CLaboResultsProfessionnal'===d.className)) {
				return false;
			}
			if ($scope.showOptions.docShowDoc!==true && ('CPatientImage'===d.className || 'CBasePatientImage'===d.className)) {
				return false;
			}
			if (d.selectedProf) {
				if ($scope.showOptions.docToSee===true && $scope.showOptions.docToResolve===true) {
					return true;
				}
				if ($scope.showOptions.docToSee===true) {
					return $.inArray("UNSEEN", d.selectedProf.activeSt) > -1;
				}
				if ($scope.showOptions.docToResolve===true) {
					return $.inArray("TO_RESOLVE", d.selectedProf.activeSt) > -1;
				}
				return false;
			}
			return false;
		};

		$scope.newLabDocs = function() {
			var idProf = model.currentLaboDocMd() ? model.currentLaboDocMd().id: undefined;
			var labs = model.dayData(idProf) && model.dayData(idProf).cnts.new_labs ? model.dayData(idProf).cnts.new_labs.length : 0;
			var docs = model.dayData(idProf) && model.dayData(idProf).cnts.new_docs ? model.dayData(idProf).cnts.new_docs.length : 0;
			return labs + docs;
		};

		$scope.isFirst = function(d, arr) {
			var idx = $.inArray(d, arr);
			return idx>-1;
		};
		var filterDataManuel = function(toSee, toResolve) {
			return function(d) {
				if (d.selectedProf) {
					if (toSee===true) {
						return $.inArray("UNSEEN", d.selectedProf.activeSt) > -1;
					}
					if (toResolve===true) {
						return $.inArray("UNSEEN", d.selectedProf.activeSt) === -1 && $.inArray("TO_RESOLVE", d.selectedProf.activeSt) > -1;
					}
					return false;
				}
			};
		};
		function resetFirsts() {
			var firstUnseenLab = $scope.labs.all.filterFastFirst(filterDataManuel(true,false));
			$scope.labs.firstUnseen= firstUnseenLab.length>0 ? firstUnseenLab[0].uid : -1;
			var firstToResolveLab = $scope.labs.all.filterFastFirst(filterDataManuel(false,true));
			$scope.labs.firstToResolve=firstToResolveLab.length>0 ? firstToResolveLab[0].uid : -1;
			$scope.labs.first = [$scope.labs.firstUnseen, $scope.labs.firstToResolve];

			var firstUnseenDoc = $scope.docs.all.filterFastFirst(filterDataManuel(true,false));
			$scope.docs.firstUnseen=firstUnseenDoc.length>0 ? firstUnseenDoc[0].uid : -1;
			var firstToResolveDoc = $scope.docs.all.filterFastFirst(filterDataManuel(false,true));
			$scope.docs.firstToResolve=firstToResolveDoc.length>0 ? firstToResolveDoc[0].uid : -1;
			$scope.docs.first=[$scope.docs.firstUnseen, $scope.docs.firstToResolve];
		}

		// call by force reload ou si aucun ids, après un call pour dashboard counts
		var update = function(){
			model.review().mergedDataFiltered = [];
			model.review().mergedData = [];
			updateDocList();
			updateLabList();
		};

		function refreshUi() {
			model.review().mergedDataFiltered = model.review().mergedData.filterFast(filterData).sort(sortData);
			resetFirsts();
			model.actUpdated(true);
		}

		$scope.toggleShowLab = function() {
			var dts = $scope.showOptions.docShowLab;
			model.prefSettings('docShowLab', !dts);
			var loadedData = false;
			if (!dts && ($stateParams.ids_lab_see_temp!=null || $stateParams.ids_lab_regl_temp!=null)) {
				update();
				$stateParams.ids_lab_see_temp = null; $stateParams.ids_lab_regl_temp=null;
				loadedData = true;
			}
			if (loadedData==false) {
				refreshUi();
			}
		};
		$scope.toggleShowDoc = function(){
			var dts = $scope.showOptions.docShowDoc;
			model.prefSettings('docShowDoc', !dts);
			var loadedData = false;
			if (!dts && ($stateParams.ids_doc_see_temp!=null || $stateParams.ids_doc_regl_temp!=null)) {
				update();
				$stateParams.ids_doc_see_temp = null; $stateParams.ids_doc_regl_temp=null;
				loadedData = true;
			}
			if (loadedData==false) {
				refreshUi();
			}
		};
		$scope.toggleToSee = function(){
			model.prefSettings('docToSee', !$scope.showOptions.docToSee);
			refreshUi();
		};
		$scope.toggleToResolve = function(){
			model.prefSettings('docToResolve', !$scope.showOptions.docToResolve);
			refreshUi();
		};

		$scope.showDynamicLength = function(t) {
			if (t==='docs') {
				return $scope.docs.all.filterLength(filterData);
			} else if (t==='labs') {
				return $scope.labs.all.filterLength(filterData);
			}
		};

		$scope.notSearching = function() {
			return angular.isUndefined($scope.searchTextRegExp);
		};

		$scope.searchUpdated = function(v) {
			if (v && v.length>2) {
				var x = v.split(' '); var len = x.length;
				$scope.searchTextRegExp = [];
				for(var i=0;i<len;i++) {
					$scope.searchTextRegExp.push(new RegExp(x[i], 'i'));
				}
			} else {
				delete $scope.searchTextRegExp;
			}
			model.review().mergedDataFiltered = model.review().mergedData.filterFast(filterData);
			model.actUpdated(true);
		};

		// *** les filtres selon searchText. Ces fonctions sont évaluée dans tous les filtres, sauf en post update qui calcule les length
		function matchInArray(string) {
			if ($scope.searchTextRegExp) {
				var len = $scope.searchTextRegExp.length, i=0, found=false;
				for (; i < len; i++) {
					if (!$scope.searchTextRegExp[i].test(string)) {
						return false;
					}
				}
				return true;
			}
			return true;
		}

		var filterSearchText = function(l) {
			var b = true;
			if ($scope.searchTextRegExp) {
				if ('CLaboFile'===l.className || 'CLaboResultsProfessionnal'===l.className) {
					b = matchInArray(l.date+'~'+l.req+'~'+model.getPatIdTitle(l.patient));
				} else if ('CPatientImage'===l.className || 'CBasePatientImage'===l.className) {
					var lbls = "";
					if (l.labels) {
						for (var i2 = 0; i2 < l.labels.length; i2++) {
							lbls += l.labels[i2].n + '~';
						}
					}
					b = matchInArray(l.date+'~'+lbls+'~'+l.scanUserName+'~'+l.name+'~'+model.getPatIdTitle(l.patient));
				}
			}
			return b;
		};

		var sortDate = function(a, b) {
			var d1 = '9999-99-99';	// pour tri adéquat si compare with datetime. Et si deja dt = pas grave.
			var d2 = '9999-99-99';
			if (a.date) {
				d1 = a.date.length===10 ? a.date + ' 00:00':a.date;
			}
			if (b.date) {
				d2 = b.date.length===10 ? b.date + ' 00:00':b.date;
			}
		    if (d1 > d2) {
		        return 1;
		    }
		    if (d2 > d1) {
		        return -1;
		    }
		    return a.id>b.id ? 1 : -1;	// inverse du l'id si date ==
		};

		// tri unseen / to revolve, date asc
		var sortData = function(a, b) {
			// tri labo en premier
			if ('CLaboFile'===a.className || 'CLaboResultsProfessionnal'===a.className) {
				if ('CPatientImage'===b.className || 'CBasePatientImage'===b.className) {
					return -1;
				}
			} else if ('CPatientImage'===a.className || 'CBasePatientImage'===a.className) {
				if ('CLaboFile'===b.className || 'CLaboResultsProfessionnal'===b.className) {
					return 1;
				}
			}

			// unseen en premier, puis date asc.
			if (a.selectedProf && b.selectedProf) {
				var au = $.inArray("UNSEEN",  a.selectedProf.activeSt) > -1;
				var bu = $.inArray("UNSEEN",  b.selectedProf.activeSt) > -1;
				if (au===true && bu===true) {
					return sortDate(a,b);
				} else if (au===true && bu===false) {
					return -1;
				}
				var ar = $.inArray("TO_RESOLVE",  a.selectedProf.activeSt) > -1;
				var br = $.inArray("TO_RESOLVE",  b.selectedProf.activeSt) > -1;
				if (ar===true && br===true) {
					return sortDate(a,b);
				} else if (ar===true && br===false) {
					return 1;
				} else if (ar===false && br===true) {	// ne devrait pas arriver ici...
					return -1;
				}
			}
		};

		$scope.searchResolved = false;
		$.extend($scope, DocAccessor.utils);
		if ($scope.quickViewData==undefined) {
			$scope.quickViewData = {};			
		}

		function getCurrentAct(){
			if(model.review().currReviewType === 'l'){
				return model.review().currLab ;
			}else if(model.review().currReviewType === 'd'){
				return model.review().currDoc;
			}
		}

		var curract = getCurrentAct();
		if(curract != undefined){
			$scope.quickViewData.qvActData = curract;
		}

		// nom de methode ne doit pas changer car est utilisée pour ng-if (hover lab et doc)
		$scope.selectLabDoc = function(act){
			if($scope.quickViewData &&
				$scope.quickViewData.qvActData &&
				$scope.quickViewData.qvActData.onChangeActivity){
				$scope.quickViewData.qvActData.onChangeActivity();
			}
			if (model.review().currLab) {
				$( "#" +  model.review().currLab.uid).removeClass("selected");
			}
			if (model.review().currDoc) {
				$( "#" +  model.review().currDoc.uid).removeClass("selected");
			}
			QValidation.closeContext($filter('translate')('documentUnsavedChanges')).then(function(successful){
				if(successful){
					if ('CLaboFile'===act.className || 'CLaboResultsProfessionnal'===act.className) {
						model.review().currReviewType = 'l';
						model.review().currLab = act;
						$scope.quickViewData.qvActData = act;
					} else if ('CPatientImage'===act.className || 'CBasePatientImage'===act.className) {
						model.review().currReviewType = 'd';
						model.review().currDoc = act;
						$scope.quickViewData.qvActData = act;
					}
					//model.chgdItem(true);
					$( "#" +  act.uid).addClass("selected");
					// model.actUpdated(true);	// impact+++ le refresh si bcp de items. chgdItem n'affecte que la class selected, donc bcp moins de refres quand change d'item
				}
			});
		};
		$scope.actOptions = {verbose: false, fct:$scope.selectLabDoc};
		function gotToNext(doc){
			if(model.prefSettings('labodoc_savenext')){
				var currentElement = document.getElementById(doc.uid);
				var elementsWithCategClass = document.getElementsByClassName('act-div');
				
				var currentIndex = Array.prototype.indexOf.call(elementsWithCategClass, currentElement);
				
				if (currentIndex < elementsWithCategClass.length - 1) {
					var nextElement = elementsWithCategClass[currentIndex + 1];
					$timeout(function(){
						angular.element(nextElement).click();
					}, 0)
				} else {
				//   console.log("Current element is the last one'");
				}
			}
		}
		$scope.labsViewerOptions = {
			gotToNext:gotToNext
		}
		$scope.docsViewerOptions = {
			gotToNext:gotToNext
		}
		$scope.isActive = function(doc){
			var isLab = doc.className === "CBaseLaboResultsProfessionnal" || doc.className === "CLaboResultsProfessionnal";
			if(model.review().currReviewType === model.review().currReviewTypes.doc && !isLab){
				return angular.isDefined(model.review().currDoc) && model.review().currDoc.id === doc.id;
			}else if(model.review().currReviewType === model.review().currReviewTypes.lab && isLab){
				return angular.isDefined(model.review().currLabo) && model.review().currLabo.id === doc.id;
			}
			else
				return false;
		};

		function loadData(d, t, ot) {
			$scope[t].loaded = 1;
			$scope[t].all = d.sort(sortData);
			if ($scope[ot].loaded===1) {
				model.review().mergedData = _.union(d, $scope[ot].all).sort(sortData);
				model.review().mergedDataFiltered = model.review().mergedData.filterFast(filterData);
			} else {
				model.review().mergedData = $scope[t].all;
				model.review().mergedDataFiltered = model.review().mergedData.filterFast(filterData);
			}
			resetFirsts();
			model.actUpdated(true);
		}

		// called by update but not from watch notification
		function updateLabList(){
			// avec check $scope.isModeWithIds===false car je ne veux pas qu'une notification fasse perdre les ids selectionnés
			var idProf = model.currentLaboDocMd ? model.currentLaboDocMd().id: undefined;
			if (model.dayData(idProf) && model.dayData(idProf).cnts) {
				var dSee = _.clone(model.dayData(idProf).cnts.lab_see_id ? model.dayData(idProf).cnts.lab_see_id : []);
				var dRegl = _.clone(model.dayData(idProf).cnts.lab_regl_id ? model.dayData(idProf).cnts.lab_regl_id : []);
				var ids = $.merge(dSee, dRegl);
				if (ids.length>0) {
					$scope.labs.loaded = 2;
					var idsString = ids.toString();
					var lstCache = model.labCached(idProf, idsString);
					if (lstCache) {
						loadData(lstCache, 'labs', 'docs');
					} else {
						LabAccessor.byIds({ids:ids, idProf:idProf}, function(res){
							model.labCached(idProf, idsString, res.data);
							loadData(res.data, 'labs', 'docs');
						});
					}
				} else {
					loadData([], 'labs', 'docs');
					$scope.labs.loaded = 1;
				}
			}
		};

		// called by update and direct from watch notification
		function updateDocList(){
			// avec check $scope.isModeWithIds===false car je ne veux pas qu'une notification fasse perdre les ids selectionnés
			var idProf = model.currentLaboDocMd() ? model.currentLaboDocMd().id: undefined;
			if (model.dayData(idProf) && model.dayData(idProf).cnts) {
				var dSee = _.clone(model.dayData(idProf).cnts.doc_see_id ? model.dayData(idProf).cnts.doc_see_id : []);
				var dRegl = _.clone(model.dayData(idProf).cnts.doc_regl_id ? model.dayData(idProf).cnts.doc_regl_id : []);
				var ids = $.merge(dSee, dRegl);
				if (ids.length>0) {
					$scope.docs.loaded = 2;
					var idsString = ids.toString();
					var lstCache = model.docCached(idProf, idsString);
					if (lstCache) {
						loadData(lstCache, 'docs', 'labs');
					} else {
						DocAccessor.byIds({ids:ids, idProf:idProf}, function(res){
							model.docCached(idProf, idsString, res.data);
							loadData(res.data, 'docs', 'labs');
						});
					}
				} else {
					loadData([], 'docs', 'labs');
					$scope.docs.loaded = 1;
				}
			}
		};

		// v = les id, t = le type de data (docs ou labs)
		function updateIndividually(v, t) {
			if (v && v.length>0) {
				var idProf = model.currentLaboDocMd() ? model.currentLaboDocMd().id: model.user().profil.id;
				$scope[t].loaded = 1;
				model.review().mergedDataFiltered.length = 0;
				model.review().mergedData.length = 0;
				model.actUpdated(true);
				$scope[t].all.length = 0;
				if ('docs'===t) {
					var idsString = v.toString();
					var lstCache = model.docCached(idProf, idsString);
					if (lstCache) {
						$scope[t].all = lstCache.sort(sortData);
						model.review().mergedData = $scope[t].all;
						model.review().mergedDataFiltered = model.review().mergedData.filterFast(filterData);
						resetFirsts();
						$scope[t].loaded = 1;
						model.actUpdated(true);
					} else {
						DocAccessor.byIds({ids:v, idProf:idProf}, function(res){
							model.docCached(idProf, idsString, res.data);
							$scope[t].all = res.data.sort(sortData);
							model.review().mergedData = $scope[t].all;
							model.review().mergedDataFiltered = model.review().mergedData.filterFast(filterData);
							resetFirsts();
							$scope[t].loaded = 1;
							model.actUpdated(true);
						}, function() {
							// console.log("DocAccessor.byIds fail");
							$scope[t].loaded = 1;
						});
					}
				} else if ('labs'===t) {
					var idsString = v.toString();
					var lstCache = model.labCached(idProf, idsString);
					if (lstCache) {
						$scope[t].all = lstCache.sort(sortData);
						model.review().mergedData = $scope[t].all;
						model.review().mergedDataFiltered = model.review().mergedData.filterFast(filterData);
						resetFirsts();
						$scope[t].loaded = 1;
						model.actUpdated(true);
					} else {
						LabAccessor.byIds({ids:v, idProf:idProf}, function(res){
							model.labCached(idProf, idsString, res.data);
							$scope[t].all = res.data.sort(sortData);
							model.review().mergedData = $scope[t].all;
							model.review().mergedDataFiltered = model.review().mergedData.filterFast(filterData);
							resetFirsts();
							$scope[t].loaded = 1;
							model.actUpdated(true);
						}, function() {
							// console.log("LabAccessor.byIds fail");
							$scope[t].loaded = 1;
						});
					}
				}
			} else {
				$scope[t].loaded = 1;
			}
		}

		// param possible: ids_lab_see, ids_lab_regl, ids_doc_see, ids_doc_regl - aussi les _temp si ids non loadés.
		if ($stateParams.ids_lab_see != null || $stateParams.ids_lab_regl != null || $stateParams.ids_doc_see != null || $stateParams.ids_doc_regl != null) {
			// pour activer le bon filtre selon les données passées.
			model.currentLaboDocMd(model.user().profil);

			$scope.showOptions.docShowLab = $stateParams.ids_lab_see != null || $stateParams.ids_lab_regl != null;
			model.prefSettings('docShowLab', $scope.showOptions.docShowLab);
			$scope.showOptions.docShowDoc = $stateParams.ids_doc_see != null || $stateParams.ids_doc_regl != null;
			model.prefSettings('docShowDoc', $scope.showOptions.docShowDoc);
			$scope.showOptions.docToSee = $stateParams.ids_lab_see != null || $stateParams.ids_doc_see != null;
			model.prefSettings('docToSee', $scope.showOptions.docToSee);
			$scope.showOptions.docToResolve = $stateParams.ids_lab_regl != null || $stateParams.ids_doc_regl != null
			model.prefSettings('docToResolve', $scope.showOptions.docToResolve);

			model.review().mergedDataFiltered = [];
			model.review().mergedData = [];
			if ($stateParams.ids_lab_see != null || $stateParams.ids_lab_regl != null) {
				var mergedLabs = _.clone($stateParams.ids_lab_see != null ? $stateParams.ids_lab_see : $stateParams.ids_lab_see_temp);
				mergedLabs = $.merge(mergedLabs, _.clone($stateParams.ids_lab_regl != null ? $stateParams.ids_lab_regl : $stateParams.ids_lab_regl_temp));
				if (mergedLabs.length>0) {
					updateIndividually(mergedLabs, 'labs');
				}
			}

			if ($stateParams.ids_doc_see!=null || $stateParams.ids_doc_regl!=null) {
				var mergedDocs = _.clone($stateParams.ids_doc_see != null ? $stateParams.ids_doc_see : $stateParams.ids_doc_see_temp);
				mergedDocs = $.merge(mergedDocs, _.clone($stateParams.ids_doc_regl != null ? $stateParams.ids_doc_regl : $stateParams.ids_doc_regl_temp));
				if (mergedDocs.length>0) {
					updateIndividually(mergedDocs, 'docs');
				}
			}
			cleanupIds();
		} else if (model.currentLaboDocMd() && model.dayData(model.currentLaboDocMd().id) && model.dayData(model.currentLaboDocMd().id).cnts &&
				(model.dayData(model.currentLaboDocMd().id).cnts.lab_see!=null || model.dayData(model.currentLaboDocMd().id).cnts.lab_regl!=null || model.dayData(model.currentLaboDocMd().id).cnts.doc_see!=null || model.dayData(model.currentLaboDocMd().id).cnts.doc_regl!=null)) {
			update();
		} else {
			model.callDashBoardCount(update, false, model.currentLaboDocMd());// reloadData called after the return of data from counts.
		}

		function cleanupIds(){
			$state.go('.', {
				ids_lab_see: undefined,
				ids_lab_regl: undefined,
				ids_doc_see: undefined,
				ids_doc_regl: undefined,
			});
			delete $stateParams.ids_lab_see;
			delete $stateParams.ids_lab_regl;
			delete $stateParams.ids_doc_see;
			delete $stateParams.ids_doc_regl;
		}

		$scope.forceReload = function() {
			if (model.review().mergedDataFiltered) model.review().mergedDataFiltered.length = 0;
			if (model.review().mergedData) model.review().mergedData.length = 0;
			$scope['docs'].loaded = 2;
			$scope['labs'].loaded = 2;
			model.actUpdated(true);
			model.resetDashBoardCountInterval();
			model.callDashBoardCount(update, true, model.currentLaboDocMd());	// reloadData called after the return of data from counts.
		}
		$scope.forceReloadLabosDocsOnly = function() {
			if (model.review().mergedDataFiltered) model.review().mergedDataFiltered.length = 0;
			if (model.review().mergedData) model.review().mergedData.length = 0;
			$scope['docs'].loaded = 2;
			$scope['labs'].loaded = 2;
			model.actUpdated(true);
			// effacer la cache de ce prof
			var prof = model.currentLaboDocMd();
			model.labCached(prof.id, null);
			model.docCached(prof.id, null);
			model.callDashBoardLabosDocsCount(update, true, prof);	// reloadData called after the return of data from counts.
		}

//		$scope.$watch(model.labCntsUpdated().val, updateLabList);
//		$scope.$watch(model.docCntsUpdated().val, updateDocList);

	}]);
	
	
	
})();