(function () {
    var logger = angular.module('logger', []);

    logger.config(['$provide', function ($provide) {
        $provide.decorator('$log', ['$delegate', 'Logging', function ($delegate, Logging) {
            Logging.enabled = true;
            var methods = {
                error: function () {
                    if (Logging.enabled) {
                        $delegate.error.apply(null, arguments);
                        Logging.error.apply(null, arguments);
                    }
                },
                log: function () {
                    if (Logging.enabled) {
                        $delegate.log.apply(null, arguments);
                        Logging.log.apply(null, arguments);
                    }
                },
                info: function () {
                    if (Logging.enabled) {
                        $delegate.info.apply(null, arguments);
                        Logging.info.apply(null, arguments);
                    }
                },
                warn: function () {
                    if (Logging.enabled) {
                        $delegate.warn.apply(null, arguments);
                        Logging.warn.apply(null, arguments);
                    }
                }
            };
            return methods;
        }]);
    }]);

    logger.service('Logging', function ($injector) {
        var domain = getdomain();
        var service = {
            error: function () {
                self.type = 'SEVERE';
                log.apply(self, arguments);
            },
            warn: function () {
                self.type = 'WARNING';
                log.apply(self, arguments);
            },
            info: function () {
                self.type = 'INFO';
                log.apply(self, arguments);
            },
            log: function () {
                self.type = 'CONFIG';
                log.apply(self, arguments);
            },
            enabled: false,
            logs: [],
        };

        function processLog(v) {
            if (v[0] && v[0].stack) {
                return v[0].stack;
            } else {
                var vString = '';
                if(typeof v === 'object'){
                    vString = _.values(v).join(',\n');
                }else{
                    vString = JSON.stringify(v)
                }
                return callStack(vString);
            }
        }

        function callStack(s){
            var e = new Error(s);
            var esplit =  e.stack.split('\n');
            esplit.splice(1, 5);// remove logger.js stack calls( callStack->processLog->log->service.error)
            var ejoin = esplit.join('\n');
            return ejoin;
        }
        function getdomain(){
            var getUrl = window.location;
            var baseUrl = getUrl.protocol + "//" + getUrl.host ;
            return baseUrl;
        }

        var log = function () {
            if (!service.enabled) {
                return;
            }

            var args = "";
            if (typeof arguments == 'object') {
                args += processLog(arguments).replaceAll(domain, '');
            } else {
                arguments.forEach(function (arg) {
                    args += processLog(arg).replaceAll(domain, '');
                });
            };

            if (this.type == 'SEVERE') {
               addLog({ severity: this.type, trace: args, count: 1});
            }
        }

        function addLog(log){
            if(log && log.trace && service && service.logs){
                if(!service.timeout){
                    service.timeout = $injector.get("$timeout");
                }
                var lastIndex = service.logs.length - 1;
                if(lastIndex > -1 && service.logs[lastIndex].trace === log.trace){
                    service.logs[lastIndex].count++;
                }else{
                    service.logs.push(log)
                }
                activateSendLogs();
            }
        }

        var presaveTimer = {};
        function activateSendLogs(){
            // console.log("running");
            stopActivePresave();
            //To make sure that logs are always sent..
            //if an accumulation of more than 50 diffrent logs in less than a second or 100 logs of the same type
            //just send the log;
            if(mustSendLogs()){
                sendLogs();
            }else{
                presaveTimer.timeout = service.timeout(function(){
                    sendLogs();
                }, 1000);
            }
        }

        function mustSendLogs(){
            //To make sure that logs are always sent..
            //if an accumulation of more than 50 diffrent logs in less than a second or 100 logs of the same type
            //just send the log;
            return service && service.logs &&
            (service.logs.length > 50 || (service.logs.length > 0 && service.logs[service.logs.length-1].count > 100));
        }

        function stopActivePresave(){
            if(presaveTimer.timeout){
                service.timeout.cancel(presaveTimer.timeout);
            }
        }

        function sendLogs(){
            if(!service.http){
                service.http = $injector.get("$http");
            }
            service.http.post("/dashboard/debug/log", {logs: service.logs});
            service.logs = [];
        }

        return service;
    });
})();