module.exports = function(grunt){
    //Configuration
    grunt.initConfig({
        //Pass options to plugins, references to file, etc
        concat: {
            js: {
                src: [
                    'dashboard/resources/js/*.js',
                    '!dashboard/resources/js/eformInject.js',
                ],
                dest: 'dashboard/resources/build/scripts.js'
            },
            // css:{
            //     src:['dashboard/resources/css/*.css'],
            //     dest:['dashboard/resources/build/styles.css']
            // }
        },
        uglify:{
            build: {
                files: [{
                    src:'dashboard/resources/build/scripts.js',
                    dest: 'dashboard/resources/build/scripts.min.js'
                }]
            }
        }
    });
    
    //Load plugins
    grunt.loadNpmTasks('grunt-contrib-concat');
    grunt.loadNpmTasks('grunt-contrib-uglify');

    grunt.registerTask('concat-js', ['concat:js']);
};