/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEnumCrdsSousStatut;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEnumCrdsStatut;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CEncounter;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.CEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.medication.XMyHumanSubstanceAdministrationSite;
import ca.infodata.ofys.data.middle.dataobjects.medication.XMyOrderableDrugForm;
import ca.infodata.ofys.data.middle.dataobjects.medication.XMyRouteOfAdministration;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.ui.dashboard.models.CEnumWithValue;
import ca.infodata.ofys.ui.dashboard.models.CEnumWithValueParent;
import ca.infodata.ofys.ui.dashboard.models.CEnumWithValueShow;
import ca.infodata.ofys.util.EnumWithLongValue;
import ca.infodata.ofys.util.EnumWithShortValue;
import ca.infodata.ofys.util.EnumWithValue;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DayOfWeek;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.time.FastDateFormat;

public class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class.getName());
    public static final String FULL_DATE24TIME = "yyyy-MM-dd HH'h'mm";
    public static final String FULL_DATE24DOT_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String FULL_DATE = "yyyy-MM-dd";
    private static final AtomicInteger ai = new AtomicInteger(0);

    public static synchronized int getNewAtomicInteger() {
        return ai.incrementAndGet();
    }

    public static String getDateTimeFromLong(Long l) {
        if (l == null) {
            return null;
        }
        return FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm").format(new Date(l));
    }

    public static Long getDateTimeFromString(String l) {
        if (l == null) {
            return null;
        }
        try {
            return FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm").parse(l).getTime();
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date strToDate(String unparsedString, String format) {
        FastDateFormat formatter = FastDateFormat.getInstance((String)format);
        Date date = null;
        try {
            date = formatter.parse(unparsedString);
        }
        catch (Exception e) {
            System.out.println("Date parse failed" + unparsedString);
        }
        return date;
    }

    public static String IPToNullableHyStr(IPartialDate date) {
        if (null == date) {
            return null;
        }
        return date.formatHyphen();
    }

    public static String dateToStr(Date date, String format) {
        FastDateFormat formatter = FastDateFormat.getInstance((String)format);
        return formatter.format(date);
    }

    public static String longTodateStr(long date, String format) {
        FastDateFormat formatter = FastDateFormat.getInstance((String)format);
        return formatter.format(date);
    }

    public static LocalDate strToLocalDate(String stringDate, String format, boolean nullable) {
        if (stringDate == null || format == null) {
            if (nullable) {
                return null;
            }
            throw new NullPointerException("The parse date and the format string cannot be null");
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = formatter.parse(stringDate);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Date parse failed :  " + stringDate, e);
        }
        if (date != null) {
            return Utils.dateToLocalDate(date);
        }
        if (nullable) {
            return null;
        }
        throw new IllegalArgumentException("An error occurred while parsing the date \"" + stringDate + "\"");
    }

    public static LocalDate strToLocalDate(String stringDate, String format) {
        return Utils.strToLocalDate(stringDate, format, true);
    }

    public static LocalDate strToLocalDate(String stringDate) {
        return Utils.strToLocalDate(stringDate, FULL_DATE, true);
    }

    public static LocalDate dateToLocalDate(Date date) {
        Calendar docDate = null;
        docDate = Calendar.getInstance();
        docDate.setTime(date);
        return LocalDate.fromCalendar((Calendar)docDate);
    }

    public static <X extends EditableDataObject, C extends CEditableDataObject> List<C> clist(List<X> list, Class<C> conversionClass) {
        ArrayList<CEditableDataObject> x = new ArrayList<CEditableDataObject>();
        if (list != null) {
            try {
                for (int i = 0; i < list.size(); ++i) {
                    CEditableDataObject conv = (CEditableDataObject)conversionClass.newInstance();
                    CEditableDataObject result = conv.convertc(list.get(i));
                    x.add(result);
                }
            }
            catch (InstantiationException e) {
                logger.log(Level.SEVERE, "Failed to instantiate CObject while converting X object to C object", e);
            }
            catch (IllegalAccessException e) {
                logger.log(Level.SEVERE, "Failed to convert X obejct to C object", e);
                e.printStackTrace();
            }
        }
        return x;
    }

    public static <X, C extends CEditableDataObject> List<C> clistx(List<X> list, Class<C> conversionClass) {
        ArrayList<CEditableDataObject> x = new ArrayList<CEditableDataObject>();
        if (list != null) {
            try {
                for (int i = 0; i < list.size(); ++i) {
                    CEditableDataObject conv = (CEditableDataObject)conversionClass.newInstance();
                    conv.convertc(list.get(i));
                    x.add(conv);
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return x;
    }

    public static <T extends Enum> Map<String, Object> getEnumList(Class<T> obj) {
        return Utils.getEnumList(obj, false);
    }

    public static <T extends Enum> Map<String, Object> getEnumList(Class<T> obj, boolean useToString) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("className", obj.getSimpleName());
        for (Enum str : (Enum[])obj.getEnumConstants()) {
            String name;
            String no;
            if (str instanceof EnumWithValue) {
                no = ((EnumWithValue)str).getValue() + "";
                name = useToString ? str.toString() : str.name();
                m.put(no, name);
                continue;
            }
            if (str instanceof XMyRouteOfAdministration) {
                no = ((XMyRouteOfAdministration)str).getId() + "";
                name = ((XMyRouteOfAdministration)str).description();
                m.put(no, name);
                continue;
            }
            if (str instanceof XMyHumanSubstanceAdministrationSite) {
                no = ((XMyHumanSubstanceAdministrationSite)str).getId() + "";
                name = ((XMyHumanSubstanceAdministrationSite)str).description();
                m.put(no, name);
                continue;
            }
            if (!(str instanceof XMyOrderableDrugForm)) continue;
            no = ((XMyOrderableDrugForm)str).getId() + "";
            name = ((XMyOrderableDrugForm)str).description();
            String key = ((XMyOrderableDrugForm)str).name();
            m.put(no, new String[]{key, name});
        }
        return m;
    }

    public static <T extends Enum> Map<String, CEnumWithValue> getEnumListObj(Class<T> obj) {
        HashMap<String, CEnumWithValue> m = new HashMap<String, CEnumWithValue>();
        int i = 0;
        for (Enum str : (Enum[])obj.getEnumConstants()) {
            XEnumCrdsStatut x;
            if (str instanceof XCompletionProposalType) {
                m.put(str.name(), new CEnumWithValueShow(((EnumWithValue)str).getValue(), str.name(), str.toString(), ((XCompletionProposalType)str).showInPreferences));
            } else if (str instanceof EnumWithValue) {
                m.put(str.name(), new CEnumWithValue(((EnumWithValue)str).getValue(), str.name(), str.toString()));
            } else if (str instanceof XEnumCrdsStatut) {
                x = (XEnumCrdsStatut)str;
                if (x.searchable) {
                    m.put(str.name(), new CEnumWithValue(((EnumWithShortValue)str).getValue(), str.name(), str.toString()));
                }
            } else if (str instanceof XEnumCrdsSousStatut) {
                x = (XEnumCrdsSousStatut)str;
                if (x.searchable) {
                    m.put(str.name(), new CEnumWithValueParent(((EnumWithShortValue)str).getValue(), str.name(), str.toString(), ((XEnumCrdsSousStatut)str).parent));
                }
            } else if (str instanceof EnumWithShortValue) {
                m.put(str.name(), new CEnumWithValue(((EnumWithShortValue)str).getValue(), str.name(), str.toString()));
            } else if (str instanceof EnumWithLongValue) {
                m.put(str.name(), new CEnumWithValue(((EnumWithLongValue)str).getValue(), str.name(), str.toString()));
            } else if (str instanceof DayOfWeek) {
                m.put(str.name(), new CEnumWithValue(((DayOfWeek)str).id, str.name(), str.toString()));
            } else {
                m.put(str.name(), new CEnumWithValue(i, str.name(), str.toString()));
            }
            ++i;
        }
        return m;
    }

    public static boolean areSameDrug(CEncounter.Prescription xRx1, CEncounter.Prescription xRx2) {
        if (xRx1 == xRx2) {
            return true;
        }
        if (xRx1 == null || xRx2 == null) {
            return false;
        }
        String generic1 = null;
        String commercial1 = "";
        String generic2 = null;
        String commercial2 = "";
        if (xRx1.getStrength() != null && xRx2.getStrength() != null) {
            generic1 = xRx1.getBaseDrugName();
            generic2 = xRx2.getBaseDrugName();
            commercial1 = xRx1.getName();
            commercial2 = xRx2.getName();
        }
        return MiscUtil.areObjectsEquals((Object)StringUtils.toLowerCase(generic1), (Object)StringUtils.toLowerCase(generic2)) && MiscUtil.areObjectsEquals((Object)StringUtils.toLowerCase((String)commercial1), (Object)StringUtils.toLowerCase((String)commercial2));
    }

    public static MultiStatus ErrorMultiStatus(String errorMsg) {
        MultiStatus st = new MultiStatus();
        st.setSeverity(IStatus.Severity.ERROR);
        st.setMessage(errorMsg);
        return st;
    }
}

